<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayrollItem StructType
 * @subpackage Structs
 */
class PayrollItem extends Record
{
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The itemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The vendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $vendor;
    /**
     * The expenseAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expenseAccount;
    /**
     * The liabilityAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $liabilityAccount;
    /**
     * The employeePaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $employeePaid;
    /**
     * The accountCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountCategory;
    /**
     * The inactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inactive;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for PayrollItem
     * @uses PayrollItem::setSubsidiary()
     * @uses PayrollItem::setItemType()
     * @uses PayrollItem::setName()
     * @uses PayrollItem::setVendor()
     * @uses PayrollItem::setExpenseAccount()
     * @uses PayrollItem::setLiabilityAccount()
     * @uses PayrollItem::setEmployeePaid()
     * @uses PayrollItem::setAccountCategory()
     * @uses PayrollItem::setInactive()
     * @uses PayrollItem::setCustomFieldList()
     * @uses PayrollItem::setInternalId()
     * @uses PayrollItem::setExternalId()
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $itemType
     * @param string $name
     * @param \StructType\RecordRef $vendor
     * @param \StructType\RecordRef $expenseAccount
     * @param \StructType\RecordRef $liabilityAccount
     * @param bool $employeePaid
     * @param string $accountCategory
     * @param bool $inactive
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $subsidiary = null, \StructType\RecordRef $itemType = null, $name = null, \StructType\RecordRef $vendor = null, \StructType\RecordRef $expenseAccount = null, \StructType\RecordRef $liabilityAccount = null, $employeePaid = null, $accountCategory = null, $inactive = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setSubsidiary($subsidiary)
            ->setItemType($itemType)
            ->setName($name)
            ->setVendor($vendor)
            ->setExpenseAccount($expenseAccount)
            ->setLiabilityAccount($liabilityAccount)
            ->setEmployeePaid($employeePaid)
            ->setAccountCategory($accountCategory)
            ->setInactive($inactive)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\PayrollItem
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get itemType value
     * @return \StructType\RecordRef|null
     */
    public function getItemType()
    {
        return $this->itemType;
    }
    /**
     * Set itemType value
     * @param \StructType\RecordRef $itemType
     * @return \StructType\PayrollItem
     */
    public function setItemType(\StructType\RecordRef $itemType = null)
    {
        $this->itemType = $itemType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PayrollItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get vendor value
     * @return \StructType\RecordRef|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * Set vendor value
     * @param \StructType\RecordRef $vendor
     * @return \StructType\PayrollItem
     */
    public function setVendor(\StructType\RecordRef $vendor = null)
    {
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Get expenseAccount value
     * @return \StructType\RecordRef|null
     */
    public function getExpenseAccount()
    {
        return $this->expenseAccount;
    }
    /**
     * Set expenseAccount value
     * @param \StructType\RecordRef $expenseAccount
     * @return \StructType\PayrollItem
     */
    public function setExpenseAccount(\StructType\RecordRef $expenseAccount = null)
    {
        $this->expenseAccount = $expenseAccount;
        return $this;
    }
    /**
     * Get liabilityAccount value
     * @return \StructType\RecordRef|null
     */
    public function getLiabilityAccount()
    {
        return $this->liabilityAccount;
    }
    /**
     * Set liabilityAccount value
     * @param \StructType\RecordRef $liabilityAccount
     * @return \StructType\PayrollItem
     */
    public function setLiabilityAccount(\StructType\RecordRef $liabilityAccount = null)
    {
        $this->liabilityAccount = $liabilityAccount;
        return $this;
    }
    /**
     * Get employeePaid value
     * @return bool|null
     */
    public function getEmployeePaid()
    {
        return $this->employeePaid;
    }
    /**
     * Set employeePaid value
     * @param bool $employeePaid
     * @return \StructType\PayrollItem
     */
    public function setEmployeePaid($employeePaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($employeePaid) && !is_bool($employeePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($employeePaid, true), gettype($employeePaid)), __LINE__);
        }
        $this->employeePaid = $employeePaid;
        return $this;
    }
    /**
     * Get accountCategory value
     * @return string|null
     */
    public function getAccountCategory()
    {
        return $this->accountCategory;
    }
    /**
     * Set accountCategory value
     * @uses \EnumType\PayrollItemAccountCategory::valueIsValid()
     * @uses \EnumType\PayrollItemAccountCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountCategory
     * @return \StructType\PayrollItem
     */
    public function setAccountCategory($accountCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PayrollItemAccountCategory::valueIsValid($accountCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PayrollItemAccountCategory', is_array($accountCategory) ? implode(', ', $accountCategory) : var_export($accountCategory, true), implode(', ', \EnumType\PayrollItemAccountCategory::getValidValues())), __LINE__);
        }
        $this->accountCategory = $accountCategory;
        return $this;
    }
    /**
     * Get inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->inactive;
    }
    /**
     * Set inactive value
     * @param bool $inactive
     * @return \StructType\PayrollItem
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->inactive = $inactive;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\PayrollItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\PayrollItem
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\PayrollItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
