<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodSearchRowBasic StructType
 * @subpackage Structs
 */
class PaymentMethodSearchRowBasic extends SearchRowBasic
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $account;
    /**
     * The creditCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $creditCard;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isDebitCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isDebitCard;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * Constructor method for PaymentMethodSearchRowBasic
     * @uses PaymentMethodSearchRowBasic::setAccount()
     * @uses PaymentMethodSearchRowBasic::setCreditCard()
     * @uses PaymentMethodSearchRowBasic::setExternalId()
     * @uses PaymentMethodSearchRowBasic::setInternalId()
     * @uses PaymentMethodSearchRowBasic::setIsDebitCard()
     * @uses PaymentMethodSearchRowBasic::setIsInactive()
     * @uses PaymentMethodSearchRowBasic::setName()
     * @param \StructType\SearchColumnSelectField[] $account
     * @param \StructType\SearchColumnBooleanField[] $creditCard
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isDebitCard
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnStringField[] $name
     */
    public function __construct(array $account = array(), array $creditCard = array(), array $externalId = array(), array $internalId = array(), array $isDebitCard = array(), array $isInactive = array(), array $name = array())
    {
        $this
            ->setAccount($account)
            ->setCreditCard($creditCard)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setIsDebitCard($isDebitCard)
            ->setIsInactive($isInactive)
            ->setName($name);
    }
    /**
     * Get account value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentMethodSearchRowBasicAccountItem) {
            // validation for constraint: itemType
            if (!$paymentMethodSearchRowBasicAccountItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paymentMethodSearchRowBasicAccountItem) ? get_class($paymentMethodSearchRowBasicAccountItem) : sprintf('%s(%s)', gettype($paymentMethodSearchRowBasicAccountItem), var_export($paymentMethodSearchRowBasicAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $account
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Add item to account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function addToAccount(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->account[] = $item;
        return $this;
    }
    /**
     * Get creditCard value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getCreditCard()
    {
        return $this->creditCard;
    }
    /**
     * This method is responsible for validating the values passed to the setCreditCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreditCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreditCardForArrayConstraintsFromSetCreditCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentMethodSearchRowBasicCreditCardItem) {
            // validation for constraint: itemType
            if (!$paymentMethodSearchRowBasicCreditCardItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($paymentMethodSearchRowBasicCreditCardItem) ? get_class($paymentMethodSearchRowBasicCreditCardItem) : sprintf('%s(%s)', gettype($paymentMethodSearchRowBasicCreditCardItem), var_export($paymentMethodSearchRowBasicCreditCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The creditCard property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set creditCard value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $creditCard
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function setCreditCard(array $creditCard = array())
    {
        // validation for constraint: array
        if ('' !== ($creditCardArrayErrorMessage = self::validateCreditCardForArrayConstraintsFromSetCreditCard($creditCard))) {
            throw new \InvalidArgumentException($creditCardArrayErrorMessage, __LINE__);
        }
        $this->creditCard = $creditCard;
        return $this;
    }
    /**
     * Add item to creditCard value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function addToCreditCard(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The creditCard property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->creditCard[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentMethodSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$paymentMethodSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paymentMethodSearchRowBasicExternalIdItem) ? get_class($paymentMethodSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($paymentMethodSearchRowBasicExternalIdItem), var_export($paymentMethodSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentMethodSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$paymentMethodSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paymentMethodSearchRowBasicInternalIdItem) ? get_class($paymentMethodSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($paymentMethodSearchRowBasicInternalIdItem), var_export($paymentMethodSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isDebitCard value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsDebitCard()
    {
        return $this->isDebitCard;
    }
    /**
     * This method is responsible for validating the values passed to the setIsDebitCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsDebitCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsDebitCardForArrayConstraintsFromSetIsDebitCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentMethodSearchRowBasicIsDebitCardItem) {
            // validation for constraint: itemType
            if (!$paymentMethodSearchRowBasicIsDebitCardItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($paymentMethodSearchRowBasicIsDebitCardItem) ? get_class($paymentMethodSearchRowBasicIsDebitCardItem) : sprintf('%s(%s)', gettype($paymentMethodSearchRowBasicIsDebitCardItem), var_export($paymentMethodSearchRowBasicIsDebitCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isDebitCard property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isDebitCard value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isDebitCard
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function setIsDebitCard(array $isDebitCard = array())
    {
        // validation for constraint: array
        if ('' !== ($isDebitCardArrayErrorMessage = self::validateIsDebitCardForArrayConstraintsFromSetIsDebitCard($isDebitCard))) {
            throw new \InvalidArgumentException($isDebitCardArrayErrorMessage, __LINE__);
        }
        $this->isDebitCard = $isDebitCard;
        return $this;
    }
    /**
     * Add item to isDebitCard value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function addToIsDebitCard(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isDebitCard property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isDebitCard[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentMethodSearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$paymentMethodSearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($paymentMethodSearchRowBasicIsInactiveItem) ? get_class($paymentMethodSearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($paymentMethodSearchRowBasicIsInactiveItem), var_export($paymentMethodSearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentMethodSearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$paymentMethodSearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentMethodSearchRowBasicNameItem) ? get_class($paymentMethodSearchRowBasicNameItem) : sprintf('%s(%s)', gettype($paymentMethodSearchRowBasicNameItem), var_export($paymentMethodSearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentMethodSearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
}
