<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInstrumentSearchRowBasic StructType
 * @subpackage Structs
 */
class PaymentInstrumentSearchRowBasic extends SearchRowBasic
{
    /**
     * The cardBrand
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $cardBrand;
    /**
     * The cardExpDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $cardExpDate;
    /**
     * The cardLastFourDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $cardLastFourDigits;
    /**
     * The cardTokenCardBrand
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $cardTokenCardBrand;
    /**
     * The cardTokenCardExpDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $cardTokenCardExpDate;
    /**
     * The cardTokenExpDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $cardTokenExpDate;
    /**
     * The cardTokenNameOnCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $cardTokenNameOnCard;
    /**
     * The default
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $default;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $entity;
    /**
     * The generalTokenExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $generalTokenExpirationDate;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $isInactive;
    /**
     * The lastFourDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $lastFourDigits;
    /**
     * The mask
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $mask;
    /**
     * The nameOnCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $nameOnCard;
    /**
     * The paymentInstrumentStateType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $paymentInstrumentStateType;
    /**
     * The paymentInstrumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $paymentInstrumentType;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $paymentMethod;
    /**
     * The preserveOnFile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $preserveOnFile;
    /**
     * Constructor method for PaymentInstrumentSearchRowBasic
     * @uses PaymentInstrumentSearchRowBasic::setCardBrand()
     * @uses PaymentInstrumentSearchRowBasic::setCardExpDate()
     * @uses PaymentInstrumentSearchRowBasic::setCardLastFourDigits()
     * @uses PaymentInstrumentSearchRowBasic::setCardTokenCardBrand()
     * @uses PaymentInstrumentSearchRowBasic::setCardTokenCardExpDate()
     * @uses PaymentInstrumentSearchRowBasic::setCardTokenExpDate()
     * @uses PaymentInstrumentSearchRowBasic::setCardTokenNameOnCard()
     * @uses PaymentInstrumentSearchRowBasic::setDefault()
     * @uses PaymentInstrumentSearchRowBasic::setEntity()
     * @uses PaymentInstrumentSearchRowBasic::setGeneralTokenExpirationDate()
     * @uses PaymentInstrumentSearchRowBasic::setInternalId()
     * @uses PaymentInstrumentSearchRowBasic::setIsInactive()
     * @uses PaymentInstrumentSearchRowBasic::setLastFourDigits()
     * @uses PaymentInstrumentSearchRowBasic::setMask()
     * @uses PaymentInstrumentSearchRowBasic::setNameOnCard()
     * @uses PaymentInstrumentSearchRowBasic::setPaymentInstrumentStateType()
     * @uses PaymentInstrumentSearchRowBasic::setPaymentInstrumentType()
     * @uses PaymentInstrumentSearchRowBasic::setPaymentMethod()
     * @uses PaymentInstrumentSearchRowBasic::setPreserveOnFile()
     * @param \StructType\SearchColumnStringField[] $cardBrand
     * @param \StructType\SearchColumnDateField[] $cardExpDate
     * @param \StructType\SearchColumnStringField[] $cardLastFourDigits
     * @param \StructType\SearchColumnStringField[] $cardTokenCardBrand
     * @param \StructType\SearchColumnDateField[] $cardTokenCardExpDate
     * @param \StructType\SearchColumnDateField[] $cardTokenExpDate
     * @param \StructType\SearchColumnStringField[] $cardTokenNameOnCard
     * @param \StructType\SearchColumnStringField[] $default
     * @param \StructType\SearchColumnSelectField[] $entity
     * @param \StructType\SearchColumnDateField[] $generalTokenExpirationDate
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnStringField[] $isInactive
     * @param \StructType\SearchColumnStringField[] $lastFourDigits
     * @param \StructType\SearchColumnStringField[] $mask
     * @param \StructType\SearchColumnStringField[] $nameOnCard
     * @param \StructType\SearchColumnSelectField[] $paymentInstrumentStateType
     * @param \StructType\SearchColumnEnumSelectField[] $paymentInstrumentType
     * @param \StructType\SearchColumnSelectField[] $paymentMethod
     * @param \StructType\SearchColumnStringField[] $preserveOnFile
     */
    public function __construct(array $cardBrand = array(), array $cardExpDate = array(), array $cardLastFourDigits = array(), array $cardTokenCardBrand = array(), array $cardTokenCardExpDate = array(), array $cardTokenExpDate = array(), array $cardTokenNameOnCard = array(), array $default = array(), array $entity = array(), array $generalTokenExpirationDate = array(), array $internalId = array(), array $isInactive = array(), array $lastFourDigits = array(), array $mask = array(), array $nameOnCard = array(), array $paymentInstrumentStateType = array(), array $paymentInstrumentType = array(), array $paymentMethod = array(), array $preserveOnFile = array())
    {
        $this
            ->setCardBrand($cardBrand)
            ->setCardExpDate($cardExpDate)
            ->setCardLastFourDigits($cardLastFourDigits)
            ->setCardTokenCardBrand($cardTokenCardBrand)
            ->setCardTokenCardExpDate($cardTokenCardExpDate)
            ->setCardTokenExpDate($cardTokenExpDate)
            ->setCardTokenNameOnCard($cardTokenNameOnCard)
            ->setDefault($default)
            ->setEntity($entity)
            ->setGeneralTokenExpirationDate($generalTokenExpirationDate)
            ->setInternalId($internalId)
            ->setIsInactive($isInactive)
            ->setLastFourDigits($lastFourDigits)
            ->setMask($mask)
            ->setNameOnCard($nameOnCard)
            ->setPaymentInstrumentStateType($paymentInstrumentStateType)
            ->setPaymentInstrumentType($paymentInstrumentType)
            ->setPaymentMethod($paymentMethod)
            ->setPreserveOnFile($preserveOnFile);
    }
    /**
     * Get cardBrand value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCardBrand()
    {
        return $this->cardBrand;
    }
    /**
     * This method is responsible for validating the values passed to the setCardBrand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardBrand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardBrandForArrayConstraintsFromSetCardBrand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicCardBrandItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicCardBrandItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicCardBrandItem) ? get_class($paymentInstrumentSearchRowBasicCardBrandItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicCardBrandItem), var_export($paymentInstrumentSearchRowBasicCardBrandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cardBrand property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cardBrand value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $cardBrand
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setCardBrand(array $cardBrand = array())
    {
        // validation for constraint: array
        if ('' !== ($cardBrandArrayErrorMessage = self::validateCardBrandForArrayConstraintsFromSetCardBrand($cardBrand))) {
            throw new \InvalidArgumentException($cardBrandArrayErrorMessage, __LINE__);
        }
        $this->cardBrand = $cardBrand;
        return $this;
    }
    /**
     * Add item to cardBrand value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToCardBrand(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The cardBrand property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cardBrand[] = $item;
        return $this;
    }
    /**
     * Get cardExpDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getCardExpDate()
    {
        return $this->cardExpDate;
    }
    /**
     * This method is responsible for validating the values passed to the setCardExpDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardExpDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardExpDateForArrayConstraintsFromSetCardExpDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicCardExpDateItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicCardExpDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicCardExpDateItem) ? get_class($paymentInstrumentSearchRowBasicCardExpDateItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicCardExpDateItem), var_export($paymentInstrumentSearchRowBasicCardExpDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cardExpDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cardExpDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $cardExpDate
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setCardExpDate(array $cardExpDate = array())
    {
        // validation for constraint: array
        if ('' !== ($cardExpDateArrayErrorMessage = self::validateCardExpDateForArrayConstraintsFromSetCardExpDate($cardExpDate))) {
            throw new \InvalidArgumentException($cardExpDateArrayErrorMessage, __LINE__);
        }
        $this->cardExpDate = $cardExpDate;
        return $this;
    }
    /**
     * Add item to cardExpDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToCardExpDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The cardExpDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cardExpDate[] = $item;
        return $this;
    }
    /**
     * Get cardLastFourDigits value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCardLastFourDigits()
    {
        return $this->cardLastFourDigits;
    }
    /**
     * This method is responsible for validating the values passed to the setCardLastFourDigits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardLastFourDigits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardLastFourDigitsForArrayConstraintsFromSetCardLastFourDigits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicCardLastFourDigitsItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicCardLastFourDigitsItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicCardLastFourDigitsItem) ? get_class($paymentInstrumentSearchRowBasicCardLastFourDigitsItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicCardLastFourDigitsItem), var_export($paymentInstrumentSearchRowBasicCardLastFourDigitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cardLastFourDigits property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cardLastFourDigits value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $cardLastFourDigits
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setCardLastFourDigits(array $cardLastFourDigits = array())
    {
        // validation for constraint: array
        if ('' !== ($cardLastFourDigitsArrayErrorMessage = self::validateCardLastFourDigitsForArrayConstraintsFromSetCardLastFourDigits($cardLastFourDigits))) {
            throw new \InvalidArgumentException($cardLastFourDigitsArrayErrorMessage, __LINE__);
        }
        $this->cardLastFourDigits = $cardLastFourDigits;
        return $this;
    }
    /**
     * Add item to cardLastFourDigits value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToCardLastFourDigits(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The cardLastFourDigits property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cardLastFourDigits[] = $item;
        return $this;
    }
    /**
     * Get cardTokenCardBrand value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCardTokenCardBrand()
    {
        return $this->cardTokenCardBrand;
    }
    /**
     * This method is responsible for validating the values passed to the setCardTokenCardBrand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardTokenCardBrand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardTokenCardBrandForArrayConstraintsFromSetCardTokenCardBrand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicCardTokenCardBrandItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicCardTokenCardBrandItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicCardTokenCardBrandItem) ? get_class($paymentInstrumentSearchRowBasicCardTokenCardBrandItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicCardTokenCardBrandItem), var_export($paymentInstrumentSearchRowBasicCardTokenCardBrandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cardTokenCardBrand property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cardTokenCardBrand value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $cardTokenCardBrand
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setCardTokenCardBrand(array $cardTokenCardBrand = array())
    {
        // validation for constraint: array
        if ('' !== ($cardTokenCardBrandArrayErrorMessage = self::validateCardTokenCardBrandForArrayConstraintsFromSetCardTokenCardBrand($cardTokenCardBrand))) {
            throw new \InvalidArgumentException($cardTokenCardBrandArrayErrorMessage, __LINE__);
        }
        $this->cardTokenCardBrand = $cardTokenCardBrand;
        return $this;
    }
    /**
     * Add item to cardTokenCardBrand value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToCardTokenCardBrand(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The cardTokenCardBrand property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cardTokenCardBrand[] = $item;
        return $this;
    }
    /**
     * Get cardTokenCardExpDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getCardTokenCardExpDate()
    {
        return $this->cardTokenCardExpDate;
    }
    /**
     * This method is responsible for validating the values passed to the setCardTokenCardExpDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardTokenCardExpDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardTokenCardExpDateForArrayConstraintsFromSetCardTokenCardExpDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicCardTokenCardExpDateItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicCardTokenCardExpDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicCardTokenCardExpDateItem) ? get_class($paymentInstrumentSearchRowBasicCardTokenCardExpDateItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicCardTokenCardExpDateItem), var_export($paymentInstrumentSearchRowBasicCardTokenCardExpDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cardTokenCardExpDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cardTokenCardExpDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $cardTokenCardExpDate
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setCardTokenCardExpDate(array $cardTokenCardExpDate = array())
    {
        // validation for constraint: array
        if ('' !== ($cardTokenCardExpDateArrayErrorMessage = self::validateCardTokenCardExpDateForArrayConstraintsFromSetCardTokenCardExpDate($cardTokenCardExpDate))) {
            throw new \InvalidArgumentException($cardTokenCardExpDateArrayErrorMessage, __LINE__);
        }
        $this->cardTokenCardExpDate = $cardTokenCardExpDate;
        return $this;
    }
    /**
     * Add item to cardTokenCardExpDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToCardTokenCardExpDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The cardTokenCardExpDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cardTokenCardExpDate[] = $item;
        return $this;
    }
    /**
     * Get cardTokenExpDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getCardTokenExpDate()
    {
        return $this->cardTokenExpDate;
    }
    /**
     * This method is responsible for validating the values passed to the setCardTokenExpDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardTokenExpDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardTokenExpDateForArrayConstraintsFromSetCardTokenExpDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicCardTokenExpDateItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicCardTokenExpDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicCardTokenExpDateItem) ? get_class($paymentInstrumentSearchRowBasicCardTokenExpDateItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicCardTokenExpDateItem), var_export($paymentInstrumentSearchRowBasicCardTokenExpDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cardTokenExpDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cardTokenExpDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $cardTokenExpDate
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setCardTokenExpDate(array $cardTokenExpDate = array())
    {
        // validation for constraint: array
        if ('' !== ($cardTokenExpDateArrayErrorMessage = self::validateCardTokenExpDateForArrayConstraintsFromSetCardTokenExpDate($cardTokenExpDate))) {
            throw new \InvalidArgumentException($cardTokenExpDateArrayErrorMessage, __LINE__);
        }
        $this->cardTokenExpDate = $cardTokenExpDate;
        return $this;
    }
    /**
     * Add item to cardTokenExpDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToCardTokenExpDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The cardTokenExpDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cardTokenExpDate[] = $item;
        return $this;
    }
    /**
     * Get cardTokenNameOnCard value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCardTokenNameOnCard()
    {
        return $this->cardTokenNameOnCard;
    }
    /**
     * This method is responsible for validating the values passed to the setCardTokenNameOnCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardTokenNameOnCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardTokenNameOnCardForArrayConstraintsFromSetCardTokenNameOnCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicCardTokenNameOnCardItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicCardTokenNameOnCardItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicCardTokenNameOnCardItem) ? get_class($paymentInstrumentSearchRowBasicCardTokenNameOnCardItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicCardTokenNameOnCardItem), var_export($paymentInstrumentSearchRowBasicCardTokenNameOnCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cardTokenNameOnCard property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cardTokenNameOnCard value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $cardTokenNameOnCard
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setCardTokenNameOnCard(array $cardTokenNameOnCard = array())
    {
        // validation for constraint: array
        if ('' !== ($cardTokenNameOnCardArrayErrorMessage = self::validateCardTokenNameOnCardForArrayConstraintsFromSetCardTokenNameOnCard($cardTokenNameOnCard))) {
            throw new \InvalidArgumentException($cardTokenNameOnCardArrayErrorMessage, __LINE__);
        }
        $this->cardTokenNameOnCard = $cardTokenNameOnCard;
        return $this;
    }
    /**
     * Add item to cardTokenNameOnCard value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToCardTokenNameOnCard(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The cardTokenNameOnCard property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cardTokenNameOnCard[] = $item;
        return $this;
    }
    /**
     * Get default value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDefault()
    {
        return $this->default;
    }
    /**
     * This method is responsible for validating the values passed to the setDefault method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefault method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDefaultForArrayConstraintsFromSetDefault(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicDefaultItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicDefaultItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicDefaultItem) ? get_class($paymentInstrumentSearchRowBasicDefaultItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicDefaultItem), var_export($paymentInstrumentSearchRowBasicDefaultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The default property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set default value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $default
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setDefault(array $default = array())
    {
        // validation for constraint: array
        if ('' !== ($defaultArrayErrorMessage = self::validateDefaultForArrayConstraintsFromSetDefault($default))) {
            throw new \InvalidArgumentException($defaultArrayErrorMessage, __LINE__);
        }
        $this->default = $default;
        return $this;
    }
    /**
     * Add item to default value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToDefault(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The default property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->default[] = $item;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * This method is responsible for validating the values passed to the setEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEntityForArrayConstraintsFromSetEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicEntityItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicEntityItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicEntityItem) ? get_class($paymentInstrumentSearchRowBasicEntityItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicEntityItem), var_export($paymentInstrumentSearchRowBasicEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The entity property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set entity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $entity
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setEntity(array $entity = array())
    {
        // validation for constraint: array
        if ('' !== ($entityArrayErrorMessage = self::validateEntityForArrayConstraintsFromSetEntity($entity))) {
            throw new \InvalidArgumentException($entityArrayErrorMessage, __LINE__);
        }
        $this->entity = $entity;
        return $this;
    }
    /**
     * Add item to entity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToEntity(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The entity property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->entity[] = $item;
        return $this;
    }
    /**
     * Get generalTokenExpirationDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getGeneralTokenExpirationDate()
    {
        return $this->generalTokenExpirationDate;
    }
    /**
     * This method is responsible for validating the values passed to the setGeneralTokenExpirationDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneralTokenExpirationDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeneralTokenExpirationDateForArrayConstraintsFromSetGeneralTokenExpirationDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicGeneralTokenExpirationDateItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicGeneralTokenExpirationDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicGeneralTokenExpirationDateItem) ? get_class($paymentInstrumentSearchRowBasicGeneralTokenExpirationDateItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicGeneralTokenExpirationDateItem), var_export($paymentInstrumentSearchRowBasicGeneralTokenExpirationDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The generalTokenExpirationDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set generalTokenExpirationDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $generalTokenExpirationDate
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setGeneralTokenExpirationDate(array $generalTokenExpirationDate = array())
    {
        // validation for constraint: array
        if ('' !== ($generalTokenExpirationDateArrayErrorMessage = self::validateGeneralTokenExpirationDateForArrayConstraintsFromSetGeneralTokenExpirationDate($generalTokenExpirationDate))) {
            throw new \InvalidArgumentException($generalTokenExpirationDateArrayErrorMessage, __LINE__);
        }
        $this->generalTokenExpirationDate = $generalTokenExpirationDate;
        return $this;
    }
    /**
     * Add item to generalTokenExpirationDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToGeneralTokenExpirationDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The generalTokenExpirationDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->generalTokenExpirationDate[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicInternalIdItem) ? get_class($paymentInstrumentSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicInternalIdItem), var_export($paymentInstrumentSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicIsInactiveItem) ? get_class($paymentInstrumentSearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicIsInactiveItem), var_export($paymentInstrumentSearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $isInactive
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get lastFourDigits value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLastFourDigits()
    {
        return $this->lastFourDigits;
    }
    /**
     * This method is responsible for validating the values passed to the setLastFourDigits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastFourDigits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastFourDigitsForArrayConstraintsFromSetLastFourDigits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicLastFourDigitsItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicLastFourDigitsItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicLastFourDigitsItem) ? get_class($paymentInstrumentSearchRowBasicLastFourDigitsItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicLastFourDigitsItem), var_export($paymentInstrumentSearchRowBasicLastFourDigitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lastFourDigits property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lastFourDigits value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $lastFourDigits
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setLastFourDigits(array $lastFourDigits = array())
    {
        // validation for constraint: array
        if ('' !== ($lastFourDigitsArrayErrorMessage = self::validateLastFourDigitsForArrayConstraintsFromSetLastFourDigits($lastFourDigits))) {
            throw new \InvalidArgumentException($lastFourDigitsArrayErrorMessage, __LINE__);
        }
        $this->lastFourDigits = $lastFourDigits;
        return $this;
    }
    /**
     * Add item to lastFourDigits value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToLastFourDigits(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The lastFourDigits property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lastFourDigits[] = $item;
        return $this;
    }
    /**
     * Get mask value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getMask()
    {
        return $this->mask;
    }
    /**
     * This method is responsible for validating the values passed to the setMask method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMask method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMaskForArrayConstraintsFromSetMask(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicMaskItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicMaskItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicMaskItem) ? get_class($paymentInstrumentSearchRowBasicMaskItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicMaskItem), var_export($paymentInstrumentSearchRowBasicMaskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The mask property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set mask value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $mask
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setMask(array $mask = array())
    {
        // validation for constraint: array
        if ('' !== ($maskArrayErrorMessage = self::validateMaskForArrayConstraintsFromSetMask($mask))) {
            throw new \InvalidArgumentException($maskArrayErrorMessage, __LINE__);
        }
        $this->mask = $mask;
        return $this;
    }
    /**
     * Add item to mask value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToMask(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The mask property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->mask[] = $item;
        return $this;
    }
    /**
     * Get nameOnCard value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getNameOnCard()
    {
        return $this->nameOnCard;
    }
    /**
     * This method is responsible for validating the values passed to the setNameOnCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameOnCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameOnCardForArrayConstraintsFromSetNameOnCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicNameOnCardItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicNameOnCardItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicNameOnCardItem) ? get_class($paymentInstrumentSearchRowBasicNameOnCardItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicNameOnCardItem), var_export($paymentInstrumentSearchRowBasicNameOnCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nameOnCard property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nameOnCard value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $nameOnCard
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setNameOnCard(array $nameOnCard = array())
    {
        // validation for constraint: array
        if ('' !== ($nameOnCardArrayErrorMessage = self::validateNameOnCardForArrayConstraintsFromSetNameOnCard($nameOnCard))) {
            throw new \InvalidArgumentException($nameOnCardArrayErrorMessage, __LINE__);
        }
        $this->nameOnCard = $nameOnCard;
        return $this;
    }
    /**
     * Add item to nameOnCard value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToNameOnCard(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The nameOnCard property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nameOnCard[] = $item;
        return $this;
    }
    /**
     * Get paymentInstrumentStateType value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getPaymentInstrumentStateType()
    {
        return $this->paymentInstrumentStateType;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentInstrumentStateType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentInstrumentStateType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentInstrumentStateTypeForArrayConstraintsFromSetPaymentInstrumentStateType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicPaymentInstrumentStateTypeItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicPaymentInstrumentStateTypeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicPaymentInstrumentStateTypeItem) ? get_class($paymentInstrumentSearchRowBasicPaymentInstrumentStateTypeItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicPaymentInstrumentStateTypeItem), var_export($paymentInstrumentSearchRowBasicPaymentInstrumentStateTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paymentInstrumentStateType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paymentInstrumentStateType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $paymentInstrumentStateType
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setPaymentInstrumentStateType(array $paymentInstrumentStateType = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentInstrumentStateTypeArrayErrorMessage = self::validatePaymentInstrumentStateTypeForArrayConstraintsFromSetPaymentInstrumentStateType($paymentInstrumentStateType))) {
            throw new \InvalidArgumentException($paymentInstrumentStateTypeArrayErrorMessage, __LINE__);
        }
        $this->paymentInstrumentStateType = $paymentInstrumentStateType;
        return $this;
    }
    /**
     * Add item to paymentInstrumentStateType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToPaymentInstrumentStateType(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The paymentInstrumentStateType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->paymentInstrumentStateType[] = $item;
        return $this;
    }
    /**
     * Get paymentInstrumentType value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getPaymentInstrumentType()
    {
        return $this->paymentInstrumentType;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentInstrumentType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentInstrumentType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentInstrumentTypeForArrayConstraintsFromSetPaymentInstrumentType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicPaymentInstrumentTypeItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicPaymentInstrumentTypeItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicPaymentInstrumentTypeItem) ? get_class($paymentInstrumentSearchRowBasicPaymentInstrumentTypeItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicPaymentInstrumentTypeItem), var_export($paymentInstrumentSearchRowBasicPaymentInstrumentTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paymentInstrumentType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paymentInstrumentType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $paymentInstrumentType
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setPaymentInstrumentType(array $paymentInstrumentType = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentInstrumentTypeArrayErrorMessage = self::validatePaymentInstrumentTypeForArrayConstraintsFromSetPaymentInstrumentType($paymentInstrumentType))) {
            throw new \InvalidArgumentException($paymentInstrumentTypeArrayErrorMessage, __LINE__);
        }
        $this->paymentInstrumentType = $paymentInstrumentType;
        return $this;
    }
    /**
     * Add item to paymentInstrumentType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToPaymentInstrumentType(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The paymentInstrumentType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->paymentInstrumentType[] = $item;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMethod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMethodForArrayConstraintsFromSetPaymentMethod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicPaymentMethodItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicPaymentMethodItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicPaymentMethodItem) ? get_class($paymentInstrumentSearchRowBasicPaymentMethodItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicPaymentMethodItem), var_export($paymentInstrumentSearchRowBasicPaymentMethodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paymentMethod property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paymentMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $paymentMethod
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setPaymentMethod(array $paymentMethod = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMethodArrayErrorMessage = self::validatePaymentMethodForArrayConstraintsFromSetPaymentMethod($paymentMethod))) {
            throw new \InvalidArgumentException($paymentMethodArrayErrorMessage, __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Add item to paymentMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToPaymentMethod(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The paymentMethod property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->paymentMethod[] = $item;
        return $this;
    }
    /**
     * Get preserveOnFile value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPreserveOnFile()
    {
        return $this->preserveOnFile;
    }
    /**
     * This method is responsible for validating the values passed to the setPreserveOnFile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreserveOnFile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePreserveOnFileForArrayConstraintsFromSetPreserveOnFile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstrumentSearchRowBasicPreserveOnFileItem) {
            // validation for constraint: itemType
            if (!$paymentInstrumentSearchRowBasicPreserveOnFileItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($paymentInstrumentSearchRowBasicPreserveOnFileItem) ? get_class($paymentInstrumentSearchRowBasicPreserveOnFileItem) : sprintf('%s(%s)', gettype($paymentInstrumentSearchRowBasicPreserveOnFileItem), var_export($paymentInstrumentSearchRowBasicPreserveOnFileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The preserveOnFile property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set preserveOnFile value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $preserveOnFile
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function setPreserveOnFile(array $preserveOnFile = array())
    {
        // validation for constraint: array
        if ('' !== ($preserveOnFileArrayErrorMessage = self::validatePreserveOnFileForArrayConstraintsFromSetPreserveOnFile($preserveOnFile))) {
            throw new \InvalidArgumentException($preserveOnFileArrayErrorMessage, __LINE__);
        }
        $this->preserveOnFile = $preserveOnFile;
        return $this;
    }
    /**
     * Add item to preserveOnFile value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PaymentInstrumentSearchRowBasic
     */
    public function addToPreserveOnFile(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The preserveOnFile property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->preserveOnFile[] = $item;
        return $this;
    }
}
