<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCard StructType
 * @subpackage Structs
 */
class PaymentCard extends Record
{
    /**
     * The lastFourDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastFourDigits;
    /**
     * The issuerIdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issuerIdNumber;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The mask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mask;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentMethod;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The preserveOnFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $preserveOnFile;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDefault;
    /**
     * The cardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardNumber;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The cardBrand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardBrand;
    /**
     * The cardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardType;
    /**
     * The nameOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nameOnCard;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The validFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $validFromDate;
    /**
     * The issueNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issueNumber;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for PaymentCard
     * @uses PaymentCard::setLastFourDigits()
     * @uses PaymentCard::setIssuerIdNumber()
     * @uses PaymentCard::setEntity()
     * @uses PaymentCard::setMask()
     * @uses PaymentCard::setPaymentMethod()
     * @uses PaymentCard::setMemo()
     * @uses PaymentCard::setState()
     * @uses PaymentCard::setIsInactive()
     * @uses PaymentCard::setPreserveOnFile()
     * @uses PaymentCard::setIsDefault()
     * @uses PaymentCard::setCardNumber()
     * @uses PaymentCard::setExpirationDate()
     * @uses PaymentCard::setCardBrand()
     * @uses PaymentCard::setCardType()
     * @uses PaymentCard::setNameOnCard()
     * @uses PaymentCard::setStreet()
     * @uses PaymentCard::setZipCode()
     * @uses PaymentCard::setValidFromDate()
     * @uses PaymentCard::setIssueNumber()
     * @uses PaymentCard::setInternalId()
     * @uses PaymentCard::setExternalId()
     * @param string $lastFourDigits
     * @param string $issuerIdNumber
     * @param \StructType\RecordRef $entity
     * @param string $mask
     * @param \StructType\RecordRef $paymentMethod
     * @param string $memo
     * @param string $state
     * @param bool $isInactive
     * @param bool $preserveOnFile
     * @param bool $isDefault
     * @param string $cardNumber
     * @param string $expirationDate
     * @param string $cardBrand
     * @param string $cardType
     * @param string $nameOnCard
     * @param string $street
     * @param string $zipCode
     * @param string $validFromDate
     * @param string $issueNumber
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($lastFourDigits = null, $issuerIdNumber = null, \StructType\RecordRef $entity = null, $mask = null, \StructType\RecordRef $paymentMethod = null, $memo = null, $state = null, $isInactive = null, $preserveOnFile = null, $isDefault = null, $cardNumber = null, $expirationDate = null, $cardBrand = null, $cardType = null, $nameOnCard = null, $street = null, $zipCode = null, $validFromDate = null, $issueNumber = null, $internalId = null, $externalId = null)
    {
        $this
            ->setLastFourDigits($lastFourDigits)
            ->setIssuerIdNumber($issuerIdNumber)
            ->setEntity($entity)
            ->setMask($mask)
            ->setPaymentMethod($paymentMethod)
            ->setMemo($memo)
            ->setState($state)
            ->setIsInactive($isInactive)
            ->setPreserveOnFile($preserveOnFile)
            ->setIsDefault($isDefault)
            ->setCardNumber($cardNumber)
            ->setExpirationDate($expirationDate)
            ->setCardBrand($cardBrand)
            ->setCardType($cardType)
            ->setNameOnCard($nameOnCard)
            ->setStreet($street)
            ->setZipCode($zipCode)
            ->setValidFromDate($validFromDate)
            ->setIssueNumber($issueNumber)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get lastFourDigits value
     * @return string|null
     */
    public function getLastFourDigits()
    {
        return $this->lastFourDigits;
    }
    /**
     * Set lastFourDigits value
     * @param string $lastFourDigits
     * @return \StructType\PaymentCard
     */
    public function setLastFourDigits($lastFourDigits = null)
    {
        // validation for constraint: string
        if (!is_null($lastFourDigits) && !is_string($lastFourDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastFourDigits, true), gettype($lastFourDigits)), __LINE__);
        }
        $this->lastFourDigits = $lastFourDigits;
        return $this;
    }
    /**
     * Get issuerIdNumber value
     * @return string|null
     */
    public function getIssuerIdNumber()
    {
        return $this->issuerIdNumber;
    }
    /**
     * Set issuerIdNumber value
     * @param string $issuerIdNumber
     * @return \StructType\PaymentCard
     */
    public function setIssuerIdNumber($issuerIdNumber = null)
    {
        // validation for constraint: string
        if (!is_null($issuerIdNumber) && !is_string($issuerIdNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerIdNumber, true), gettype($issuerIdNumber)), __LINE__);
        }
        $this->issuerIdNumber = $issuerIdNumber;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\PaymentCard
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get mask value
     * @return string|null
     */
    public function getMask()
    {
        return $this->mask;
    }
    /**
     * Set mask value
     * @param string $mask
     * @return \StructType\PaymentCard
     */
    public function setMask($mask = null)
    {
        // validation for constraint: string
        if (!is_null($mask) && !is_string($mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mask, true), gettype($mask)), __LINE__);
        }
        $this->mask = $mask;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param \StructType\RecordRef $paymentMethod
     * @return \StructType\PaymentCard
     */
    public function setPaymentMethod(\StructType\RecordRef $paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\PaymentCard
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\PaymentInstrumentState::valueIsValid()
     * @uses \EnumType\PaymentInstrumentState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\PaymentCard
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentInstrumentState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentInstrumentState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \EnumType\PaymentInstrumentState::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\PaymentCard
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get preserveOnFile value
     * @return bool|null
     */
    public function getPreserveOnFile()
    {
        return $this->preserveOnFile;
    }
    /**
     * Set preserveOnFile value
     * @param bool $preserveOnFile
     * @return \StructType\PaymentCard
     */
    public function setPreserveOnFile($preserveOnFile = null)
    {
        // validation for constraint: boolean
        if (!is_null($preserveOnFile) && !is_bool($preserveOnFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preserveOnFile, true), gettype($preserveOnFile)), __LINE__);
        }
        $this->preserveOnFile = $preserveOnFile;
        return $this;
    }
    /**
     * Get isDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param bool $isDefault
     * @return \StructType\PaymentCard
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get cardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }
    /**
     * Set cardNumber value
     * @param string $cardNumber
     * @return \StructType\PaymentCard
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->cardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\PaymentCard
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get cardBrand value
     * @return string|null
     */
    public function getCardBrand()
    {
        return $this->cardBrand;
    }
    /**
     * Set cardBrand value
     * @uses \EnumType\PaymentCardBrand::valueIsValid()
     * @uses \EnumType\PaymentCardBrand::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardBrand
     * @return \StructType\PaymentCard
     */
    public function setCardBrand($cardBrand = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentCardBrand::valueIsValid($cardBrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentCardBrand', is_array($cardBrand) ? implode(', ', $cardBrand) : var_export($cardBrand, true), implode(', ', \EnumType\PaymentCardBrand::getValidValues())), __LINE__);
        }
        $this->cardBrand = $cardBrand;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @uses \EnumType\PaymentCardType::valueIsValid()
     * @uses \EnumType\PaymentCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardType
     * @return \StructType\PaymentCard
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentCardType::valueIsValid($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentCardType', is_array($cardType) ? implode(', ', $cardType) : var_export($cardType, true), implode(', ', \EnumType\PaymentCardType::getValidValues())), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get nameOnCard value
     * @return string|null
     */
    public function getNameOnCard()
    {
        return $this->nameOnCard;
    }
    /**
     * Set nameOnCard value
     * @param string $nameOnCard
     * @return \StructType\PaymentCard
     */
    public function setNameOnCard($nameOnCard = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnCard) && !is_string($nameOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOnCard, true), gettype($nameOnCard)), __LINE__);
        }
        $this->nameOnCard = $nameOnCard;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\PaymentCard
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \StructType\PaymentCard
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get validFromDate value
     * @return string|null
     */
    public function getValidFromDate()
    {
        return $this->validFromDate;
    }
    /**
     * Set validFromDate value
     * @param string $validFromDate
     * @return \StructType\PaymentCard
     */
    public function setValidFromDate($validFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($validFromDate) && !is_string($validFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromDate, true), gettype($validFromDate)), __LINE__);
        }
        $this->validFromDate = $validFromDate;
        return $this;
    }
    /**
     * Get issueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->issueNumber;
    }
    /**
     * Set issueNumber value
     * @param string $issueNumber
     * @return \StructType\PaymentCard
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueNumber, true), gettype($issueNumber)), __LINE__);
        }
        $this->issueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\PaymentCard
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\PaymentCard
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
