<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckSearchRowBasic StructType
 * @subpackage Structs
 */
class PaycheckSearchRowBasic extends SearchRowBasic
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $account;
    /**
     * The amendedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $amendedDate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $amount;
    /**
     * The batchNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $batchNumber;
    /**
     * The checkDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $checkDate;
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $employee;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The hasGLImpact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $hasGLImpact;
    /**
     * The hours
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $hours;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The payrollItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $payrollItem;
    /**
     * The payrollItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $payrollItemType;
    /**
     * The subjectWages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $subjectWages;
    /**
     * The taxableWages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $taxableWages;
    /**
     * Constructor method for PaycheckSearchRowBasic
     * @uses PaycheckSearchRowBasic::setAccount()
     * @uses PaycheckSearchRowBasic::setAmendedDate()
     * @uses PaycheckSearchRowBasic::setAmount()
     * @uses PaycheckSearchRowBasic::setBatchNumber()
     * @uses PaycheckSearchRowBasic::setCheckDate()
     * @uses PaycheckSearchRowBasic::setEmployee()
     * @uses PaycheckSearchRowBasic::setExternalId()
     * @uses PaycheckSearchRowBasic::setHasGLImpact()
     * @uses PaycheckSearchRowBasic::setHours()
     * @uses PaycheckSearchRowBasic::setInternalId()
     * @uses PaycheckSearchRowBasic::setPayrollItem()
     * @uses PaycheckSearchRowBasic::setPayrollItemType()
     * @uses PaycheckSearchRowBasic::setSubjectWages()
     * @uses PaycheckSearchRowBasic::setTaxableWages()
     * @param \StructType\SearchColumnSelectField[] $account
     * @param \StructType\SearchColumnDateField[] $amendedDate
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @param \StructType\SearchColumnLongField[] $batchNumber
     * @param \StructType\SearchColumnDateField[] $checkDate
     * @param \StructType\SearchColumnSelectField[] $employee
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnBooleanField[] $hasGLImpact
     * @param \StructType\SearchColumnDoubleField[] $hours
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $payrollItem
     * @param \StructType\SearchColumnSelectField[] $payrollItemType
     * @param \StructType\SearchColumnDoubleField[] $subjectWages
     * @param \StructType\SearchColumnDoubleField[] $taxableWages
     */
    public function __construct(array $account = array(), array $amendedDate = array(), array $amount = array(), array $batchNumber = array(), array $checkDate = array(), array $employee = array(), array $externalId = array(), array $hasGLImpact = array(), array $hours = array(), array $internalId = array(), array $payrollItem = array(), array $payrollItemType = array(), array $subjectWages = array(), array $taxableWages = array())
    {
        $this
            ->setAccount($account)
            ->setAmendedDate($amendedDate)
            ->setAmount($amount)
            ->setBatchNumber($batchNumber)
            ->setCheckDate($checkDate)
            ->setEmployee($employee)
            ->setExternalId($externalId)
            ->setHasGLImpact($hasGLImpact)
            ->setHours($hours)
            ->setInternalId($internalId)
            ->setPayrollItem($payrollItem)
            ->setPayrollItemType($payrollItemType)
            ->setSubjectWages($subjectWages)
            ->setTaxableWages($taxableWages);
    }
    /**
     * Get account value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicAccountItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicAccountItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicAccountItem) ? get_class($paycheckSearchRowBasicAccountItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicAccountItem), var_export($paycheckSearchRowBasicAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $account
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Add item to account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToAccount(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->account[] = $item;
        return $this;
    }
    /**
     * Get amendedDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getAmendedDate()
    {
        return $this->amendedDate;
    }
    /**
     * This method is responsible for validating the values passed to the setAmendedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmendedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmendedDateForArrayConstraintsFromSetAmendedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicAmendedDateItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicAmendedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicAmendedDateItem) ? get_class($paycheckSearchRowBasicAmendedDateItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicAmendedDateItem), var_export($paycheckSearchRowBasicAmendedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amendedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amendedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $amendedDate
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setAmendedDate(array $amendedDate = array())
    {
        // validation for constraint: array
        if ('' !== ($amendedDateArrayErrorMessage = self::validateAmendedDateForArrayConstraintsFromSetAmendedDate($amendedDate))) {
            throw new \InvalidArgumentException($amendedDateArrayErrorMessage, __LINE__);
        }
        $this->amendedDate = $amendedDate;
        return $this;
    }
    /**
     * Add item to amendedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToAmendedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The amendedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amendedDate[] = $item;
        return $this;
    }
    /**
     * Get amount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * This method is responsible for validating the values passed to the setAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmountForArrayConstraintsFromSetAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicAmountItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicAmountItem) ? get_class($paycheckSearchRowBasicAmountItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicAmountItem), var_export($paycheckSearchRowBasicAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setAmount(array $amount = array())
    {
        // validation for constraint: array
        if ('' !== ($amountArrayErrorMessage = self::validateAmountForArrayConstraintsFromSetAmount($amount))) {
            throw new \InvalidArgumentException($amountArrayErrorMessage, __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Add item to amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amount[] = $item;
        return $this;
    }
    /**
     * Get batchNumber value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getBatchNumber()
    {
        return $this->batchNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setBatchNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBatchNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBatchNumberForArrayConstraintsFromSetBatchNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicBatchNumberItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicBatchNumberItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicBatchNumberItem) ? get_class($paycheckSearchRowBasicBatchNumberItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicBatchNumberItem), var_export($paycheckSearchRowBasicBatchNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The batchNumber property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set batchNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $batchNumber
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setBatchNumber(array $batchNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($batchNumberArrayErrorMessage = self::validateBatchNumberForArrayConstraintsFromSetBatchNumber($batchNumber))) {
            throw new \InvalidArgumentException($batchNumberArrayErrorMessage, __LINE__);
        }
        $this->batchNumber = $batchNumber;
        return $this;
    }
    /**
     * Add item to batchNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToBatchNumber(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The batchNumber property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->batchNumber[] = $item;
        return $this;
    }
    /**
     * Get checkDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getCheckDate()
    {
        return $this->checkDate;
    }
    /**
     * This method is responsible for validating the values passed to the setCheckDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCheckDateForArrayConstraintsFromSetCheckDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicCheckDateItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicCheckDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicCheckDateItem) ? get_class($paycheckSearchRowBasicCheckDateItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicCheckDateItem), var_export($paycheckSearchRowBasicCheckDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The checkDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set checkDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $checkDate
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setCheckDate(array $checkDate = array())
    {
        // validation for constraint: array
        if ('' !== ($checkDateArrayErrorMessage = self::validateCheckDateForArrayConstraintsFromSetCheckDate($checkDate))) {
            throw new \InvalidArgumentException($checkDateArrayErrorMessage, __LINE__);
        }
        $this->checkDate = $checkDate;
        return $this;
    }
    /**
     * Add item to checkDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToCheckDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The checkDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->checkDate[] = $item;
        return $this;
    }
    /**
     * Get employee value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeForArrayConstraintsFromSetEmployee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicEmployeeItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicEmployeeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicEmployeeItem) ? get_class($paycheckSearchRowBasicEmployeeItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicEmployeeItem), var_export($paycheckSearchRowBasicEmployeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The employee property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set employee value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $employee
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setEmployee(array $employee = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeArrayErrorMessage = self::validateEmployeeForArrayConstraintsFromSetEmployee($employee))) {
            throw new \InvalidArgumentException($employeeArrayErrorMessage, __LINE__);
        }
        $this->employee = $employee;
        return $this;
    }
    /**
     * Add item to employee value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToEmployee(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The employee property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->employee[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicExternalIdItem) ? get_class($paycheckSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicExternalIdItem), var_export($paycheckSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get hasGLImpact value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getHasGLImpact()
    {
        return $this->hasGLImpact;
    }
    /**
     * This method is responsible for validating the values passed to the setHasGLImpact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHasGLImpact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHasGLImpactForArrayConstraintsFromSetHasGLImpact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicHasGLImpactItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicHasGLImpactItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicHasGLImpactItem) ? get_class($paycheckSearchRowBasicHasGLImpactItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicHasGLImpactItem), var_export($paycheckSearchRowBasicHasGLImpactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hasGLImpact property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hasGLImpact value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $hasGLImpact
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setHasGLImpact(array $hasGLImpact = array())
    {
        // validation for constraint: array
        if ('' !== ($hasGLImpactArrayErrorMessage = self::validateHasGLImpactForArrayConstraintsFromSetHasGLImpact($hasGLImpact))) {
            throw new \InvalidArgumentException($hasGLImpactArrayErrorMessage, __LINE__);
        }
        $this->hasGLImpact = $hasGLImpact;
        return $this;
    }
    /**
     * Add item to hasGLImpact value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToHasGLImpact(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The hasGLImpact property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hasGLImpact[] = $item;
        return $this;
    }
    /**
     * Get hours value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getHours()
    {
        return $this->hours;
    }
    /**
     * This method is responsible for validating the values passed to the setHours method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHours method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHoursForArrayConstraintsFromSetHours(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicHoursItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicHoursItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicHoursItem) ? get_class($paycheckSearchRowBasicHoursItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicHoursItem), var_export($paycheckSearchRowBasicHoursItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hours property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hours value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $hours
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setHours(array $hours = array())
    {
        // validation for constraint: array
        if ('' !== ($hoursArrayErrorMessage = self::validateHoursForArrayConstraintsFromSetHours($hours))) {
            throw new \InvalidArgumentException($hoursArrayErrorMessage, __LINE__);
        }
        $this->hours = $hours;
        return $this;
    }
    /**
     * Add item to hours value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToHours(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The hours property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hours[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicInternalIdItem) ? get_class($paycheckSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicInternalIdItem), var_export($paycheckSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get payrollItem value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getPayrollItem()
    {
        return $this->payrollItem;
    }
    /**
     * This method is responsible for validating the values passed to the setPayrollItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayrollItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayrollItemForArrayConstraintsFromSetPayrollItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicPayrollItemItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicPayrollItemItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicPayrollItemItem) ? get_class($paycheckSearchRowBasicPayrollItemItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicPayrollItemItem), var_export($paycheckSearchRowBasicPayrollItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The payrollItem property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set payrollItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $payrollItem
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setPayrollItem(array $payrollItem = array())
    {
        // validation for constraint: array
        if ('' !== ($payrollItemArrayErrorMessage = self::validatePayrollItemForArrayConstraintsFromSetPayrollItem($payrollItem))) {
            throw new \InvalidArgumentException($payrollItemArrayErrorMessage, __LINE__);
        }
        $this->payrollItem = $payrollItem;
        return $this;
    }
    /**
     * Add item to payrollItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToPayrollItem(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The payrollItem property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->payrollItem[] = $item;
        return $this;
    }
    /**
     * Get payrollItemType value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getPayrollItemType()
    {
        return $this->payrollItemType;
    }
    /**
     * This method is responsible for validating the values passed to the setPayrollItemType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayrollItemType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayrollItemTypeForArrayConstraintsFromSetPayrollItemType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicPayrollItemTypeItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicPayrollItemTypeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicPayrollItemTypeItem) ? get_class($paycheckSearchRowBasicPayrollItemTypeItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicPayrollItemTypeItem), var_export($paycheckSearchRowBasicPayrollItemTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The payrollItemType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set payrollItemType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $payrollItemType
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setPayrollItemType(array $payrollItemType = array())
    {
        // validation for constraint: array
        if ('' !== ($payrollItemTypeArrayErrorMessage = self::validatePayrollItemTypeForArrayConstraintsFromSetPayrollItemType($payrollItemType))) {
            throw new \InvalidArgumentException($payrollItemTypeArrayErrorMessage, __LINE__);
        }
        $this->payrollItemType = $payrollItemType;
        return $this;
    }
    /**
     * Add item to payrollItemType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToPayrollItemType(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The payrollItemType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->payrollItemType[] = $item;
        return $this;
    }
    /**
     * Get subjectWages value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getSubjectWages()
    {
        return $this->subjectWages;
    }
    /**
     * This method is responsible for validating the values passed to the setSubjectWages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubjectWages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubjectWagesForArrayConstraintsFromSetSubjectWages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicSubjectWagesItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicSubjectWagesItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicSubjectWagesItem) ? get_class($paycheckSearchRowBasicSubjectWagesItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicSubjectWagesItem), var_export($paycheckSearchRowBasicSubjectWagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subjectWages property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subjectWages value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $subjectWages
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setSubjectWages(array $subjectWages = array())
    {
        // validation for constraint: array
        if ('' !== ($subjectWagesArrayErrorMessage = self::validateSubjectWagesForArrayConstraintsFromSetSubjectWages($subjectWages))) {
            throw new \InvalidArgumentException($subjectWagesArrayErrorMessage, __LINE__);
        }
        $this->subjectWages = $subjectWages;
        return $this;
    }
    /**
     * Add item to subjectWages value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToSubjectWages(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The subjectWages property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subjectWages[] = $item;
        return $this;
    }
    /**
     * Get taxableWages value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getTaxableWages()
    {
        return $this->taxableWages;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxableWages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxableWages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxableWagesForArrayConstraintsFromSetTaxableWages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckSearchRowBasicTaxableWagesItem) {
            // validation for constraint: itemType
            if (!$paycheckSearchRowBasicTaxableWagesItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($paycheckSearchRowBasicTaxableWagesItem) ? get_class($paycheckSearchRowBasicTaxableWagesItem) : sprintf('%s(%s)', gettype($paycheckSearchRowBasicTaxableWagesItem), var_export($paycheckSearchRowBasicTaxableWagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxableWages property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxableWages value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $taxableWages
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function setTaxableWages(array $taxableWages = array())
    {
        // validation for constraint: array
        if ('' !== ($taxableWagesArrayErrorMessage = self::validateTaxableWagesForArrayConstraintsFromSetTaxableWages($taxableWages))) {
            throw new \InvalidArgumentException($taxableWagesArrayErrorMessage, __LINE__);
        }
        $this->taxableWages = $taxableWages;
        return $this;
    }
    /**
     * Add item to taxableWages value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\PaycheckSearchRowBasic
     */
    public function addToTaxableWages(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The taxableWages property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxableWages[] = $item;
        return $this;
    }
}
