<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckPayTimeList StructType
 * @subpackage Structs
 */
class PaycheckPayTimeList extends AbstractStructBase
{
    /**
     * The paycheckPayTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaycheckPayTime[]
     */
    public $paycheckPayTime;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PaycheckPayTimeList
     * @uses PaycheckPayTimeList::setPaycheckPayTime()
     * @uses PaycheckPayTimeList::setReplaceAll()
     * @param \StructType\PaycheckPayTime[] $paycheckPayTime
     * @param bool $replaceAll
     */
    public function __construct(array $paycheckPayTime = array(), $replaceAll = true)
    {
        $this
            ->setPaycheckPayTime($paycheckPayTime)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get paycheckPayTime value
     * @return \StructType\PaycheckPayTime[]|null
     */
    public function getPaycheckPayTime()
    {
        return $this->paycheckPayTime;
    }
    /**
     * This method is responsible for validating the values passed to the setPaycheckPayTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaycheckPayTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaycheckPayTimeForArrayConstraintsFromSetPaycheckPayTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckPayTimeListPaycheckPayTimeItem) {
            // validation for constraint: itemType
            if (!$paycheckPayTimeListPaycheckPayTimeItem instanceof \StructType\PaycheckPayTime) {
                $invalidValues[] = is_object($paycheckPayTimeListPaycheckPayTimeItem) ? get_class($paycheckPayTimeListPaycheckPayTimeItem) : sprintf('%s(%s)', gettype($paycheckPayTimeListPaycheckPayTimeItem), var_export($paycheckPayTimeListPaycheckPayTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paycheckPayTime property can only contain items of type \StructType\PaycheckPayTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paycheckPayTime value
     * @throws \InvalidArgumentException
     * @param \StructType\PaycheckPayTime[] $paycheckPayTime
     * @return \StructType\PaycheckPayTimeList
     */
    public function setPaycheckPayTime(array $paycheckPayTime = array())
    {
        // validation for constraint: array
        if ('' !== ($paycheckPayTimeArrayErrorMessage = self::validatePaycheckPayTimeForArrayConstraintsFromSetPaycheckPayTime($paycheckPayTime))) {
            throw new \InvalidArgumentException($paycheckPayTimeArrayErrorMessage, __LINE__);
        }
        $this->paycheckPayTime = $paycheckPayTime;
        return $this;
    }
    /**
     * Add item to paycheckPayTime value
     * @throws \InvalidArgumentException
     * @param \StructType\PaycheckPayTime $item
     * @return \StructType\PaycheckPayTimeList
     */
    public function addToPaycheckPayTime(\StructType\PaycheckPayTime $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaycheckPayTime) {
            throw new \InvalidArgumentException(sprintf('The paycheckPayTime property can only contain items of type \StructType\PaycheckPayTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->paycheckPayTime[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PaycheckPayTimeList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
