<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckPayTaxList StructType
 * @subpackage Structs
 */
class PaycheckPayTaxList extends AbstractStructBase
{
    /**
     * The paycheckPayTax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaycheckPayTax[]
     */
    public $paycheckPayTax;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PaycheckPayTaxList
     * @uses PaycheckPayTaxList::setPaycheckPayTax()
     * @uses PaycheckPayTaxList::setReplaceAll()
     * @param \StructType\PaycheckPayTax[] $paycheckPayTax
     * @param bool $replaceAll
     */
    public function __construct(array $paycheckPayTax = array(), $replaceAll = true)
    {
        $this
            ->setPaycheckPayTax($paycheckPayTax)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get paycheckPayTax value
     * @return \StructType\PaycheckPayTax[]|null
     */
    public function getPaycheckPayTax()
    {
        return $this->paycheckPayTax;
    }
    /**
     * This method is responsible for validating the values passed to the setPaycheckPayTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaycheckPayTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaycheckPayTaxForArrayConstraintsFromSetPaycheckPayTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paycheckPayTaxListPaycheckPayTaxItem) {
            // validation for constraint: itemType
            if (!$paycheckPayTaxListPaycheckPayTaxItem instanceof \StructType\PaycheckPayTax) {
                $invalidValues[] = is_object($paycheckPayTaxListPaycheckPayTaxItem) ? get_class($paycheckPayTaxListPaycheckPayTaxItem) : sprintf('%s(%s)', gettype($paycheckPayTaxListPaycheckPayTaxItem), var_export($paycheckPayTaxListPaycheckPayTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paycheckPayTax property can only contain items of type \StructType\PaycheckPayTax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paycheckPayTax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaycheckPayTax[] $paycheckPayTax
     * @return \StructType\PaycheckPayTaxList
     */
    public function setPaycheckPayTax(array $paycheckPayTax = array())
    {
        // validation for constraint: array
        if ('' !== ($paycheckPayTaxArrayErrorMessage = self::validatePaycheckPayTaxForArrayConstraintsFromSetPaycheckPayTax($paycheckPayTax))) {
            throw new \InvalidArgumentException($paycheckPayTaxArrayErrorMessage, __LINE__);
        }
        $this->paycheckPayTax = $paycheckPayTax;
        return $this;
    }
    /**
     * Add item to paycheckPayTax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaycheckPayTax $item
     * @return \StructType\PaycheckPayTaxList
     */
    public function addToPaycheckPayTax(\StructType\PaycheckPayTax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaycheckPayTax) {
            throw new \InvalidArgumentException(sprintf('The paycheckPayTax property can only contain items of type \StructType\PaycheckPayTax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->paycheckPayTax[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PaycheckPayTaxList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
