<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckPaySummary StructType
 * @subpackage Structs
 */
class PaycheckPaySummary extends AbstractStructBase
{
    /**
     * The payItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payItem;
    /**
     * The payItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payItemType;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The ytdAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ytdAmount;
    /**
     * Constructor method for PaycheckPaySummary
     * @uses PaycheckPaySummary::setPayItem()
     * @uses PaycheckPaySummary::setPayItemType()
     * @uses PaycheckPaySummary::setAmount()
     * @uses PaycheckPaySummary::setYtdAmount()
     * @param string $payItem
     * @param string $payItemType
     * @param float $amount
     * @param float $ytdAmount
     */
    public function __construct($payItem = null, $payItemType = null, $amount = null, $ytdAmount = null)
    {
        $this
            ->setPayItem($payItem)
            ->setPayItemType($payItemType)
            ->setAmount($amount)
            ->setYtdAmount($ytdAmount);
    }
    /**
     * Get payItem value
     * @return string|null
     */
    public function getPayItem()
    {
        return $this->payItem;
    }
    /**
     * Set payItem value
     * @param string $payItem
     * @return \StructType\PaycheckPaySummary
     */
    public function setPayItem($payItem = null)
    {
        // validation for constraint: string
        if (!is_null($payItem) && !is_string($payItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payItem, true), gettype($payItem)), __LINE__);
        }
        $this->payItem = $payItem;
        return $this;
    }
    /**
     * Get payItemType value
     * @return string|null
     */
    public function getPayItemType()
    {
        return $this->payItemType;
    }
    /**
     * Set payItemType value
     * @param string $payItemType
     * @return \StructType\PaycheckPaySummary
     */
    public function setPayItemType($payItemType = null)
    {
        // validation for constraint: string
        if (!is_null($payItemType) && !is_string($payItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payItemType, true), gettype($payItemType)), __LINE__);
        }
        $this->payItemType = $payItemType;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PaycheckPaySummary
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get ytdAmount value
     * @return float|null
     */
    public function getYtdAmount()
    {
        return $this->ytdAmount;
    }
    /**
     * Set ytdAmount value
     * @param float $ytdAmount
     * @return \StructType\PaycheckPaySummary
     */
    public function setYtdAmount($ytdAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ytdAmount) && !(is_float($ytdAmount) || is_numeric($ytdAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ytdAmount, true), gettype($ytdAmount)), __LINE__);
        }
        $this->ytdAmount = $ytdAmount;
        return $this;
    }
}
