<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckPayExp StructType
 * @subpackage Structs
 */
class PaycheckPayExp extends AbstractStructBase
{
    /**
     * The apply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $apply;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The origDoc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $origDoc;
    /**
     * The transaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transaction;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for PaycheckPayExp
     * @uses PaycheckPayExp::setApply()
     * @uses PaycheckPayExp::setLine()
     * @uses PaycheckPayExp::setOrigDoc()
     * @uses PaycheckPayExp::setTransaction()
     * @uses PaycheckPayExp::setAmount()
     * @param bool $apply
     * @param int $line
     * @param int $origDoc
     * @param string $transaction
     * @param float $amount
     */
    public function __construct($apply = null, $line = null, $origDoc = null, $transaction = null, $amount = null)
    {
        $this
            ->setApply($apply)
            ->setLine($line)
            ->setOrigDoc($origDoc)
            ->setTransaction($transaction)
            ->setAmount($amount);
    }
    /**
     * Get apply value
     * @return bool|null
     */
    public function getApply()
    {
        return $this->apply;
    }
    /**
     * Set apply value
     * @param bool $apply
     * @return \StructType\PaycheckPayExp
     */
    public function setApply($apply = null)
    {
        // validation for constraint: boolean
        if (!is_null($apply) && !is_bool($apply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($apply, true), gettype($apply)), __LINE__);
        }
        $this->apply = $apply;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\PaycheckPayExp
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get origDoc value
     * @return int|null
     */
    public function getOrigDoc()
    {
        return $this->origDoc;
    }
    /**
     * Set origDoc value
     * @param int $origDoc
     * @return \StructType\PaycheckPayExp
     */
    public function setOrigDoc($origDoc = null)
    {
        // validation for constraint: int
        if (!is_null($origDoc) && !(is_int($origDoc) || ctype_digit($origDoc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($origDoc, true), gettype($origDoc)), __LINE__);
        }
        $this->origDoc = $origDoc;
        return $this;
    }
    /**
     * Get transaction value
     * @return string|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @param string $transaction
     * @return \StructType\PaycheckPayExp
     */
    public function setTransaction($transaction = null)
    {
        // validation for constraint: string
        if (!is_null($transaction) && !is_string($transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction, true), gettype($transaction)), __LINE__);
        }
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PaycheckPayExp
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
