<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckPayEarn StructType
 * @subpackage Structs
 */
class PaycheckPayEarn extends AbstractStructBase
{
    /**
     * The payItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payItem;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $count;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The serviceItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $serviceItem;
    /**
     * The grossAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmount;
    /**
     * The manualEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $manualEntry;
    /**
     * Constructor method for PaycheckPayEarn
     * @uses PaycheckPayEarn::setPayItem()
     * @uses PaycheckPayEarn::setLine()
     * @uses PaycheckPayEarn::setCount()
     * @uses PaycheckPayEarn::setRate()
     * @uses PaycheckPayEarn::setServiceItem()
     * @uses PaycheckPayEarn::setGrossAmount()
     * @uses PaycheckPayEarn::setManualEntry()
     * @param \StructType\RecordRef $payItem
     * @param int $line
     * @param float $count
     * @param string $rate
     * @param \StructType\RecordRef $serviceItem
     * @param float $grossAmount
     * @param bool $manualEntry
     */
    public function __construct(\StructType\RecordRef $payItem = null, $line = null, $count = null, $rate = null, \StructType\RecordRef $serviceItem = null, $grossAmount = null, $manualEntry = null)
    {
        $this
            ->setPayItem($payItem)
            ->setLine($line)
            ->setCount($count)
            ->setRate($rate)
            ->setServiceItem($serviceItem)
            ->setGrossAmount($grossAmount)
            ->setManualEntry($manualEntry);
    }
    /**
     * Get payItem value
     * @return \StructType\RecordRef|null
     */
    public function getPayItem()
    {
        return $this->payItem;
    }
    /**
     * Set payItem value
     * @param \StructType\RecordRef $payItem
     * @return \StructType\PaycheckPayEarn
     */
    public function setPayItem(\StructType\RecordRef $payItem = null)
    {
        $this->payItem = $payItem;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\PaycheckPayEarn
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get count value
     * @return float|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param float $count
     * @return \StructType\PaycheckPayEarn
     */
    public function setCount($count = null)
    {
        // validation for constraint: float
        if (!is_null($count) && !(is_float($count) || is_numeric($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\PaycheckPayEarn
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get serviceItem value
     * @return \StructType\RecordRef|null
     */
    public function getServiceItem()
    {
        return $this->serviceItem;
    }
    /**
     * Set serviceItem value
     * @param \StructType\RecordRef $serviceItem
     * @return \StructType\PaycheckPayEarn
     */
    public function setServiceItem(\StructType\RecordRef $serviceItem = null)
    {
        $this->serviceItem = $serviceItem;
        return $this;
    }
    /**
     * Get grossAmount value
     * @return float|null
     */
    public function getGrossAmount()
    {
        return $this->grossAmount;
    }
    /**
     * Set grossAmount value
     * @param float $grossAmount
     * @return \StructType\PaycheckPayEarn
     */
    public function setGrossAmount($grossAmount = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmount) && !(is_float($grossAmount) || is_numeric($grossAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmount, true), gettype($grossAmount)), __LINE__);
        }
        $this->grossAmount = $grossAmount;
        return $this;
    }
    /**
     * Get manualEntry value
     * @return bool|null
     */
    public function getManualEntry()
    {
        return $this->manualEntry;
    }
    /**
     * Set manualEntry value
     * @param bool $manualEntry
     * @return \StructType\PaycheckPayEarn
     */
    public function setManualEntry($manualEntry = null)
    {
        // validation for constraint: boolean
        if (!is_null($manualEntry) && !is_bool($manualEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manualEntry, true), gettype($manualEntry)), __LINE__);
        }
        $this->manualEntry = $manualEntry;
        return $this;
    }
}
