<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerTaxRegistration StructType
 * @subpackage Structs
 */
class PartnerTaxRegistration extends AbstractStructBase
{
    /**
     * The nexusCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nexusCountry;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $address;
    /**
     * The taxRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxRegistrationNumber;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * Constructor method for PartnerTaxRegistration
     * @uses PartnerTaxRegistration::setNexusCountry()
     * @uses PartnerTaxRegistration::setNexus()
     * @uses PartnerTaxRegistration::setAddress()
     * @uses PartnerTaxRegistration::setTaxRegistrationNumber()
     * @uses PartnerTaxRegistration::setId()
     * @param string $nexusCountry
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $address
     * @param string $taxRegistrationNumber
     * @param int $id
     */
    public function __construct($nexusCountry = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $address = null, $taxRegistrationNumber = null, $id = null)
    {
        $this
            ->setNexusCountry($nexusCountry)
            ->setNexus($nexus)
            ->setAddress($address)
            ->setTaxRegistrationNumber($taxRegistrationNumber)
            ->setId($id);
    }
    /**
     * Get nexusCountry value
     * @return string|null
     */
    public function getNexusCountry()
    {
        return $this->nexusCountry;
    }
    /**
     * Set nexusCountry value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nexusCountry
     * @return \StructType\PartnerTaxRegistration
     */
    public function setNexusCountry($nexusCountry = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($nexusCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($nexusCountry) ? implode(', ', $nexusCountry) : var_export($nexusCountry, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->nexusCountry = $nexusCountry;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\PartnerTaxRegistration
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\RecordRef|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\RecordRef $address
     * @return \StructType\PartnerTaxRegistration
     */
    public function setAddress(\StructType\RecordRef $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get taxRegistrationNumber value
     * @return string|null
     */
    public function getTaxRegistrationNumber()
    {
        return $this->taxRegistrationNumber;
    }
    /**
     * Set taxRegistrationNumber value
     * @param string $taxRegistrationNumber
     * @return \StructType\PartnerTaxRegistration
     */
    public function setTaxRegistrationNumber($taxRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxRegistrationNumber) && !is_string($taxRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxRegistrationNumber, true), gettype($taxRegistrationNumber)), __LINE__);
        }
        $this->taxRegistrationNumber = $taxRegistrationNumber;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\PartnerTaxRegistration
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
}
