<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerPromoCodeList StructType
 * @subpackage Structs
 */
class PartnerPromoCodeList extends AbstractStructBase
{
    /**
     * The promoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PartnerPromoCode[]
     */
    public $promoCode;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PartnerPromoCodeList
     * @uses PartnerPromoCodeList::setPromoCode()
     * @uses PartnerPromoCodeList::setReplaceAll()
     * @param \StructType\PartnerPromoCode[] $promoCode
     * @param bool $replaceAll
     */
    public function __construct(array $promoCode = array(), $replaceAll = true)
    {
        $this
            ->setPromoCode($promoCode)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get promoCode value
     * @return \StructType\PartnerPromoCode[]|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromoCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromoCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromoCodeForArrayConstraintsFromSetPromoCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partnerPromoCodeListPromoCodeItem) {
            // validation for constraint: itemType
            if (!$partnerPromoCodeListPromoCodeItem instanceof \StructType\PartnerPromoCode) {
                $invalidValues[] = is_object($partnerPromoCodeListPromoCodeItem) ? get_class($partnerPromoCodeListPromoCodeItem) : sprintf('%s(%s)', gettype($partnerPromoCodeListPromoCodeItem), var_export($partnerPromoCodeListPromoCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The promoCode property can only contain items of type \StructType\PartnerPromoCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set promoCode value
     * @throws \InvalidArgumentException
     * @param \StructType\PartnerPromoCode[] $promoCode
     * @return \StructType\PartnerPromoCodeList
     */
    public function setPromoCode(array $promoCode = array())
    {
        // validation for constraint: array
        if ('' !== ($promoCodeArrayErrorMessage = self::validatePromoCodeForArrayConstraintsFromSetPromoCode($promoCode))) {
            throw new \InvalidArgumentException($promoCodeArrayErrorMessage, __LINE__);
        }
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Add item to promoCode value
     * @throws \InvalidArgumentException
     * @param \StructType\PartnerPromoCode $item
     * @return \StructType\PartnerPromoCodeList
     */
    public function addToPromoCode(\StructType\PartnerPromoCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartnerPromoCode) {
            throw new \InvalidArgumentException(sprintf('The promoCode property can only contain items of type \StructType\PartnerPromoCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->promoCode[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PartnerPromoCodeList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
