<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Partner StructType
 * Meta information extracted from the WSDL
 * - type: listRel:Partner
 * @subpackage Structs
 */
class Partner extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The entityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $entityId;
    /**
     * The altName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altName;
    /**
     * The partnerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $partnerCode;
    /**
     * The isPerson
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPerson;
    /**
     * The phoneticName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phoneticName;
    /**
     * The salutation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salutation;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The companyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $companyName;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The defaultAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $defaultAddress;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The dateCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateCreated;
    /**
     * The taxRegistrationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartnerTaxRegistrationList
     */
    public $taxRegistrationList;
    /**
     * The globalSubscriptionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $globalSubscriptionStatus;
    /**
     * The referringUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $referringUrl;
    /**
     * The roleList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $roleList;
    /**
     * The categoryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CategoryList
     */
    public $categoryList;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The printOnCheckAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $printOnCheckAs;
    /**
     * The taxIdNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxIdNum;
    /**
     * The vatRegNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNumber;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The bcn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bcn;
    /**
     * The image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $image;
    /**
     * The taxFractionUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxFractionUnit;
    /**
     * The emailPreference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailPreference;
    /**
     * The defaultTaxReg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $defaultTaxReg;
    /**
     * The taxRounding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxRounding;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The homePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $homePhone;
    /**
     * The mobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mobilePhone;
    /**
     * The altEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altEmail;
    /**
     * The giveAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $giveAccess;
    /**
     * The accessRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $accessRole;
    /**
     * The sendEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sendEmail;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The password2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password2;
    /**
     * The requirePwdChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $requirePwdChange;
    /**
     * The subPartnerLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $subPartnerLogin;
    /**
     * The loginAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $loginAs;
    /**
     * The eligibleForCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $eligibleForCommission;
    /**
     * The contactRolesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactAccessRolesList
     */
    public $contactRolesList;
    /**
     * The promoCodeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartnerPromoCodeList
     */
    public $promoCodeList;
    /**
     * The addressbookList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartnerAddressbookList
     */
    public $addressbookList;
    /**
     * The subscriptionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubscriptionsList
     */
    public $subscriptionsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Partner
     * @uses Partner::setCustomForm()
     * @uses Partner::setEntityId()
     * @uses Partner::setAltName()
     * @uses Partner::setPartnerCode()
     * @uses Partner::setIsPerson()
     * @uses Partner::setPhoneticName()
     * @uses Partner::setSalutation()
     * @uses Partner::setFirstName()
     * @uses Partner::setMiddleName()
     * @uses Partner::setLastName()
     * @uses Partner::setCompanyName()
     * @uses Partner::setParent()
     * @uses Partner::setPhone()
     * @uses Partner::setFax()
     * @uses Partner::setEmail()
     * @uses Partner::setUrl()
     * @uses Partner::setDefaultAddress()
     * @uses Partner::setIsInactive()
     * @uses Partner::setLastModifiedDate()
     * @uses Partner::setDateCreated()
     * @uses Partner::setTaxRegistrationList()
     * @uses Partner::setGlobalSubscriptionStatus()
     * @uses Partner::setReferringUrl()
     * @uses Partner::setRoleList()
     * @uses Partner::setCategoryList()
     * @uses Partner::setTitle()
     * @uses Partner::setPrintOnCheckAs()
     * @uses Partner::setTaxIdNum()
     * @uses Partner::setVatRegNumber()
     * @uses Partner::setComments()
     * @uses Partner::setBcn()
     * @uses Partner::setImage()
     * @uses Partner::setTaxFractionUnit()
     * @uses Partner::setEmailPreference()
     * @uses Partner::setDefaultTaxReg()
     * @uses Partner::setTaxRounding()
     * @uses Partner::setDepartment()
     * @uses Partner::setLocation()
     * @uses Partner::setClass()
     * @uses Partner::setSubsidiary()
     * @uses Partner::setHomePhone()
     * @uses Partner::setMobilePhone()
     * @uses Partner::setAltEmail()
     * @uses Partner::setGiveAccess()
     * @uses Partner::setAccessRole()
     * @uses Partner::setSendEmail()
     * @uses Partner::setPassword()
     * @uses Partner::setPassword2()
     * @uses Partner::setRequirePwdChange()
     * @uses Partner::setSubPartnerLogin()
     * @uses Partner::setLoginAs()
     * @uses Partner::setEligibleForCommission()
     * @uses Partner::setContactRolesList()
     * @uses Partner::setPromoCodeList()
     * @uses Partner::setAddressbookList()
     * @uses Partner::setSubscriptionsList()
     * @uses Partner::setCustomFieldList()
     * @uses Partner::setInternalId()
     * @uses Partner::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $entityId
     * @param string $altName
     * @param string $partnerCode
     * @param bool $isPerson
     * @param string $phoneticName
     * @param string $salutation
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $companyName
     * @param \StructType\RecordRef $parent
     * @param string $phone
     * @param string $fax
     * @param string $email
     * @param string $url
     * @param string $defaultAddress
     * @param bool $isInactive
     * @param string $lastModifiedDate
     * @param string $dateCreated
     * @param \StructType\PartnerTaxRegistrationList $taxRegistrationList
     * @param string $globalSubscriptionStatus
     * @param string $referringUrl
     * @param \StructType\RecordRefList $roleList
     * @param \StructType\CategoryList $categoryList
     * @param string $title
     * @param string $printOnCheckAs
     * @param string $taxIdNum
     * @param string $vatRegNumber
     * @param string $comments
     * @param string $bcn
     * @param \StructType\RecordRef $image
     * @param string $taxFractionUnit
     * @param string $emailPreference
     * @param \StructType\RecordRef $defaultTaxReg
     * @param string $taxRounding
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $subsidiary
     * @param string $homePhone
     * @param string $mobilePhone
     * @param string $altEmail
     * @param bool $giveAccess
     * @param \StructType\RecordRef $accessRole
     * @param bool $sendEmail
     * @param string $password
     * @param string $password2
     * @param bool $requirePwdChange
     * @param bool $subPartnerLogin
     * @param string $loginAs
     * @param bool $eligibleForCommission
     * @param \StructType\ContactAccessRolesList $contactRolesList
     * @param \StructType\PartnerPromoCodeList $promoCodeList
     * @param \StructType\PartnerAddressbookList $addressbookList
     * @param \StructType\SubscriptionsList $subscriptionsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $entityId = null, $altName = null, $partnerCode = null, $isPerson = null, $phoneticName = null, $salutation = null, $firstName = null, $middleName = null, $lastName = null, $companyName = null, \StructType\RecordRef $parent = null, $phone = null, $fax = null, $email = null, $url = null, $defaultAddress = null, $isInactive = null, $lastModifiedDate = null, $dateCreated = null, \StructType\PartnerTaxRegistrationList $taxRegistrationList = null, $globalSubscriptionStatus = null, $referringUrl = null, \StructType\RecordRefList $roleList = null, \StructType\CategoryList $categoryList = null, $title = null, $printOnCheckAs = null, $taxIdNum = null, $vatRegNumber = null, $comments = null, $bcn = null, \StructType\RecordRef $image = null, $taxFractionUnit = null, $emailPreference = null, \StructType\RecordRef $defaultTaxReg = null, $taxRounding = null, \StructType\RecordRef $department = null, \StructType\RecordRef $location = null, \StructType\RecordRef $class = null, \StructType\RecordRef $subsidiary = null, $homePhone = null, $mobilePhone = null, $altEmail = null, $giveAccess = null, \StructType\RecordRef $accessRole = null, $sendEmail = null, $password = null, $password2 = null, $requirePwdChange = null, $subPartnerLogin = null, $loginAs = null, $eligibleForCommission = null, \StructType\ContactAccessRolesList $contactRolesList = null, \StructType\PartnerPromoCodeList $promoCodeList = null, \StructType\PartnerAddressbookList $addressbookList = null, \StructType\SubscriptionsList $subscriptionsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setEntityId($entityId)
            ->setAltName($altName)
            ->setPartnerCode($partnerCode)
            ->setIsPerson($isPerson)
            ->setPhoneticName($phoneticName)
            ->setSalutation($salutation)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setCompanyName($companyName)
            ->setParent($parent)
            ->setPhone($phone)
            ->setFax($fax)
            ->setEmail($email)
            ->setUrl($url)
            ->setDefaultAddress($defaultAddress)
            ->setIsInactive($isInactive)
            ->setLastModifiedDate($lastModifiedDate)
            ->setDateCreated($dateCreated)
            ->setTaxRegistrationList($taxRegistrationList)
            ->setGlobalSubscriptionStatus($globalSubscriptionStatus)
            ->setReferringUrl($referringUrl)
            ->setRoleList($roleList)
            ->setCategoryList($categoryList)
            ->setTitle($title)
            ->setPrintOnCheckAs($printOnCheckAs)
            ->setTaxIdNum($taxIdNum)
            ->setVatRegNumber($vatRegNumber)
            ->setComments($comments)
            ->setBcn($bcn)
            ->setImage($image)
            ->setTaxFractionUnit($taxFractionUnit)
            ->setEmailPreference($emailPreference)
            ->setDefaultTaxReg($defaultTaxReg)
            ->setTaxRounding($taxRounding)
            ->setDepartment($department)
            ->setLocation($location)
            ->setClass($class)
            ->setSubsidiary($subsidiary)
            ->setHomePhone($homePhone)
            ->setMobilePhone($mobilePhone)
            ->setAltEmail($altEmail)
            ->setGiveAccess($giveAccess)
            ->setAccessRole($accessRole)
            ->setSendEmail($sendEmail)
            ->setPassword($password)
            ->setPassword2($password2)
            ->setRequirePwdChange($requirePwdChange)
            ->setSubPartnerLogin($subPartnerLogin)
            ->setLoginAs($loginAs)
            ->setEligibleForCommission($eligibleForCommission)
            ->setContactRolesList($contactRolesList)
            ->setPromoCodeList($promoCodeList)
            ->setAddressbookList($addressbookList)
            ->setSubscriptionsList($subscriptionsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Partner
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get entityId value
     * @return string|null
     */
    public function getEntityId()
    {
        return $this->entityId;
    }
    /**
     * Set entityId value
     * @param string $entityId
     * @return \StructType\Partner
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->entityId = $entityId;
        return $this;
    }
    /**
     * Get altName value
     * @return string|null
     */
    public function getAltName()
    {
        return $this->altName;
    }
    /**
     * Set altName value
     * @param string $altName
     * @return \StructType\Partner
     */
    public function setAltName($altName = null)
    {
        // validation for constraint: string
        if (!is_null($altName) && !is_string($altName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altName, true), gettype($altName)), __LINE__);
        }
        $this->altName = $altName;
        return $this;
    }
    /**
     * Get partnerCode value
     * @return string|null
     */
    public function getPartnerCode()
    {
        return $this->partnerCode;
    }
    /**
     * Set partnerCode value
     * @param string $partnerCode
     * @return \StructType\Partner
     */
    public function setPartnerCode($partnerCode = null)
    {
        // validation for constraint: string
        if (!is_null($partnerCode) && !is_string($partnerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerCode, true), gettype($partnerCode)), __LINE__);
        }
        $this->partnerCode = $partnerCode;
        return $this;
    }
    /**
     * Get isPerson value
     * @return bool|null
     */
    public function getIsPerson()
    {
        return $this->isPerson;
    }
    /**
     * Set isPerson value
     * @param bool $isPerson
     * @return \StructType\Partner
     */
    public function setIsPerson($isPerson = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPerson) && !is_bool($isPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPerson, true), gettype($isPerson)), __LINE__);
        }
        $this->isPerson = $isPerson;
        return $this;
    }
    /**
     * Get phoneticName value
     * @return string|null
     */
    public function getPhoneticName()
    {
        return $this->phoneticName;
    }
    /**
     * Set phoneticName value
     * @param string $phoneticName
     * @return \StructType\Partner
     */
    public function setPhoneticName($phoneticName = null)
    {
        // validation for constraint: string
        if (!is_null($phoneticName) && !is_string($phoneticName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneticName, true), gettype($phoneticName)), __LINE__);
        }
        $this->phoneticName = $phoneticName;
        return $this;
    }
    /**
     * Get salutation value
     * @return string|null
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\Partner
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Partner
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\Partner
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\Partner
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get companyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }
    /**
     * Set companyName value
     * @param string $companyName
     * @return \StructType\Partner
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->companyName = $companyName;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\Partner
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Partner
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Partner
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Partner
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\Partner
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get defaultAddress value
     * @return string|null
     */
    public function getDefaultAddress()
    {
        return $this->defaultAddress;
    }
    /**
     * Set defaultAddress value
     * @param string $defaultAddress
     * @return \StructType\Partner
     */
    public function setDefaultAddress($defaultAddress = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddress) && !is_string($defaultAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddress, true), gettype($defaultAddress)), __LINE__);
        }
        $this->defaultAddress = $defaultAddress;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Partner
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Partner
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get dateCreated value
     * @return string|null
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
    /**
     * Set dateCreated value
     * @param string $dateCreated
     * @return \StructType\Partner
     */
    public function setDateCreated($dateCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreated) && !is_string($dateCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreated, true), gettype($dateCreated)), __LINE__);
        }
        $this->dateCreated = $dateCreated;
        return $this;
    }
    /**
     * Get taxRegistrationList value
     * @return \StructType\PartnerTaxRegistrationList|null
     */
    public function getTaxRegistrationList()
    {
        return $this->taxRegistrationList;
    }
    /**
     * Set taxRegistrationList value
     * @param \StructType\PartnerTaxRegistrationList $taxRegistrationList
     * @return \StructType\Partner
     */
    public function setTaxRegistrationList(\StructType\PartnerTaxRegistrationList $taxRegistrationList = null)
    {
        $this->taxRegistrationList = $taxRegistrationList;
        return $this;
    }
    /**
     * Get globalSubscriptionStatus value
     * @return string|null
     */
    public function getGlobalSubscriptionStatus()
    {
        return $this->globalSubscriptionStatus;
    }
    /**
     * Set globalSubscriptionStatus value
     * @uses \EnumType\GlobalSubscriptionStatus::valueIsValid()
     * @uses \EnumType\GlobalSubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $globalSubscriptionStatus
     * @return \StructType\Partner
     */
    public function setGlobalSubscriptionStatus($globalSubscriptionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GlobalSubscriptionStatus::valueIsValid($globalSubscriptionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GlobalSubscriptionStatus', is_array($globalSubscriptionStatus) ? implode(', ', $globalSubscriptionStatus) : var_export($globalSubscriptionStatus, true), implode(', ', \EnumType\GlobalSubscriptionStatus::getValidValues())), __LINE__);
        }
        $this->globalSubscriptionStatus = $globalSubscriptionStatus;
        return $this;
    }
    /**
     * Get referringUrl value
     * @return string|null
     */
    public function getReferringUrl()
    {
        return $this->referringUrl;
    }
    /**
     * Set referringUrl value
     * @param string $referringUrl
     * @return \StructType\Partner
     */
    public function setReferringUrl($referringUrl = null)
    {
        // validation for constraint: string
        if (!is_null($referringUrl) && !is_string($referringUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referringUrl, true), gettype($referringUrl)), __LINE__);
        }
        $this->referringUrl = $referringUrl;
        return $this;
    }
    /**
     * Get roleList value
     * @return \StructType\RecordRefList|null
     */
    public function getRoleList()
    {
        return $this->roleList;
    }
    /**
     * Set roleList value
     * @param \StructType\RecordRefList $roleList
     * @return \StructType\Partner
     */
    public function setRoleList(\StructType\RecordRefList $roleList = null)
    {
        $this->roleList = $roleList;
        return $this;
    }
    /**
     * Get categoryList value
     * @return \StructType\CategoryList|null
     */
    public function getCategoryList()
    {
        return $this->categoryList;
    }
    /**
     * Set categoryList value
     * @param \StructType\CategoryList $categoryList
     * @return \StructType\Partner
     */
    public function setCategoryList(\StructType\CategoryList $categoryList = null)
    {
        $this->categoryList = $categoryList;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Partner
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get printOnCheckAs value
     * @return string|null
     */
    public function getPrintOnCheckAs()
    {
        return $this->printOnCheckAs;
    }
    /**
     * Set printOnCheckAs value
     * @param string $printOnCheckAs
     * @return \StructType\Partner
     */
    public function setPrintOnCheckAs($printOnCheckAs = null)
    {
        // validation for constraint: string
        if (!is_null($printOnCheckAs) && !is_string($printOnCheckAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printOnCheckAs, true), gettype($printOnCheckAs)), __LINE__);
        }
        $this->printOnCheckAs = $printOnCheckAs;
        return $this;
    }
    /**
     * Get taxIdNum value
     * @return string|null
     */
    public function getTaxIdNum()
    {
        return $this->taxIdNum;
    }
    /**
     * Set taxIdNum value
     * @param string $taxIdNum
     * @return \StructType\Partner
     */
    public function setTaxIdNum($taxIdNum = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdNum) && !is_string($taxIdNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdNum, true), gettype($taxIdNum)), __LINE__);
        }
        $this->taxIdNum = $taxIdNum;
        return $this;
    }
    /**
     * Get vatRegNumber value
     * @return string|null
     */
    public function getVatRegNumber()
    {
        return $this->vatRegNumber;
    }
    /**
     * Set vatRegNumber value
     * @param string $vatRegNumber
     * @return \StructType\Partner
     */
    public function setVatRegNumber($vatRegNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNumber) && !is_string($vatRegNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNumber, true), gettype($vatRegNumber)), __LINE__);
        }
        $this->vatRegNumber = $vatRegNumber;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\Partner
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get bcn value
     * @return string|null
     */
    public function getBcn()
    {
        return $this->bcn;
    }
    /**
     * Set bcn value
     * @param string $bcn
     * @return \StructType\Partner
     */
    public function setBcn($bcn = null)
    {
        // validation for constraint: string
        if (!is_null($bcn) && !is_string($bcn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bcn, true), gettype($bcn)), __LINE__);
        }
        $this->bcn = $bcn;
        return $this;
    }
    /**
     * Get image value
     * @return \StructType\RecordRef|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param \StructType\RecordRef $image
     * @return \StructType\Partner
     */
    public function setImage(\StructType\RecordRef $image = null)
    {
        $this->image = $image;
        return $this;
    }
    /**
     * Get taxFractionUnit value
     * @return string|null
     */
    public function getTaxFractionUnit()
    {
        return $this->taxFractionUnit;
    }
    /**
     * Set taxFractionUnit value
     * @uses \EnumType\TaxFractionUnit::valueIsValid()
     * @uses \EnumType\TaxFractionUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxFractionUnit
     * @return \StructType\Partner
     */
    public function setTaxFractionUnit($taxFractionUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxFractionUnit::valueIsValid($taxFractionUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxFractionUnit', is_array($taxFractionUnit) ? implode(', ', $taxFractionUnit) : var_export($taxFractionUnit, true), implode(', ', \EnumType\TaxFractionUnit::getValidValues())), __LINE__);
        }
        $this->taxFractionUnit = $taxFractionUnit;
        return $this;
    }
    /**
     * Get emailPreference value
     * @return string|null
     */
    public function getEmailPreference()
    {
        return $this->emailPreference;
    }
    /**
     * Set emailPreference value
     * @uses \EnumType\EmailPreference::valueIsValid()
     * @uses \EnumType\EmailPreference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emailPreference
     * @return \StructType\Partner
     */
    public function setEmailPreference($emailPreference = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmailPreference::valueIsValid($emailPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmailPreference', is_array($emailPreference) ? implode(', ', $emailPreference) : var_export($emailPreference, true), implode(', ', \EnumType\EmailPreference::getValidValues())), __LINE__);
        }
        $this->emailPreference = $emailPreference;
        return $this;
    }
    /**
     * Get defaultTaxReg value
     * @return \StructType\RecordRef|null
     */
    public function getDefaultTaxReg()
    {
        return $this->defaultTaxReg;
    }
    /**
     * Set defaultTaxReg value
     * @param \StructType\RecordRef $defaultTaxReg
     * @return \StructType\Partner
     */
    public function setDefaultTaxReg(\StructType\RecordRef $defaultTaxReg = null)
    {
        $this->defaultTaxReg = $defaultTaxReg;
        return $this;
    }
    /**
     * Get taxRounding value
     * @return string|null
     */
    public function getTaxRounding()
    {
        return $this->taxRounding;
    }
    /**
     * Set taxRounding value
     * @uses \EnumType\TaxRounding::valueIsValid()
     * @uses \EnumType\TaxRounding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxRounding
     * @return \StructType\Partner
     */
    public function setTaxRounding($taxRounding = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxRounding::valueIsValid($taxRounding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxRounding', is_array($taxRounding) ? implode(', ', $taxRounding) : var_export($taxRounding, true), implode(', ', \EnumType\TaxRounding::getValidValues())), __LINE__);
        }
        $this->taxRounding = $taxRounding;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Partner
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Partner
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Partner
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\Partner
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get homePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->homePhone;
    }
    /**
     * Set homePhone value
     * @param string $homePhone
     * @return \StructType\Partner
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        $this->homePhone = $homePhone;
        return $this;
    }
    /**
     * Get mobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->mobilePhone;
    }
    /**
     * Set mobilePhone value
     * @param string $mobilePhone
     * @return \StructType\Partner
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->mobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get altEmail value
     * @return string|null
     */
    public function getAltEmail()
    {
        return $this->altEmail;
    }
    /**
     * Set altEmail value
     * @param string $altEmail
     * @return \StructType\Partner
     */
    public function setAltEmail($altEmail = null)
    {
        // validation for constraint: string
        if (!is_null($altEmail) && !is_string($altEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altEmail, true), gettype($altEmail)), __LINE__);
        }
        $this->altEmail = $altEmail;
        return $this;
    }
    /**
     * Get giveAccess value
     * @return bool|null
     */
    public function getGiveAccess()
    {
        return $this->giveAccess;
    }
    /**
     * Set giveAccess value
     * @param bool $giveAccess
     * @return \StructType\Partner
     */
    public function setGiveAccess($giveAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($giveAccess) && !is_bool($giveAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($giveAccess, true), gettype($giveAccess)), __LINE__);
        }
        $this->giveAccess = $giveAccess;
        return $this;
    }
    /**
     * Get accessRole value
     * @return \StructType\RecordRef|null
     */
    public function getAccessRole()
    {
        return $this->accessRole;
    }
    /**
     * Set accessRole value
     * @param \StructType\RecordRef $accessRole
     * @return \StructType\Partner
     */
    public function setAccessRole(\StructType\RecordRef $accessRole = null)
    {
        $this->accessRole = $accessRole;
        return $this;
    }
    /**
     * Get sendEmail value
     * @return bool|null
     */
    public function getSendEmail()
    {
        return $this->sendEmail;
    }
    /**
     * Set sendEmail value
     * @param bool $sendEmail
     * @return \StructType\Partner
     */
    public function setSendEmail($sendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmail) && !is_bool($sendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmail, true), gettype($sendEmail)), __LINE__);
        }
        $this->sendEmail = $sendEmail;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\Partner
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get password2 value
     * @return string|null
     */
    public function getPassword2()
    {
        return $this->password2;
    }
    /**
     * Set password2 value
     * @param string $password2
     * @return \StructType\Partner
     */
    public function setPassword2($password2 = null)
    {
        // validation for constraint: string
        if (!is_null($password2) && !is_string($password2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password2, true), gettype($password2)), __LINE__);
        }
        $this->password2 = $password2;
        return $this;
    }
    /**
     * Get requirePwdChange value
     * @return bool|null
     */
    public function getRequirePwdChange()
    {
        return $this->requirePwdChange;
    }
    /**
     * Set requirePwdChange value
     * @param bool $requirePwdChange
     * @return \StructType\Partner
     */
    public function setRequirePwdChange($requirePwdChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($requirePwdChange) && !is_bool($requirePwdChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requirePwdChange, true), gettype($requirePwdChange)), __LINE__);
        }
        $this->requirePwdChange = $requirePwdChange;
        return $this;
    }
    /**
     * Get subPartnerLogin value
     * @return bool|null
     */
    public function getSubPartnerLogin()
    {
        return $this->subPartnerLogin;
    }
    /**
     * Set subPartnerLogin value
     * @param bool $subPartnerLogin
     * @return \StructType\Partner
     */
    public function setSubPartnerLogin($subPartnerLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($subPartnerLogin) && !is_bool($subPartnerLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subPartnerLogin, true), gettype($subPartnerLogin)), __LINE__);
        }
        $this->subPartnerLogin = $subPartnerLogin;
        return $this;
    }
    /**
     * Get loginAs value
     * @return string|null
     */
    public function getLoginAs()
    {
        return $this->loginAs;
    }
    /**
     * Set loginAs value
     * @param string $loginAs
     * @return \StructType\Partner
     */
    public function setLoginAs($loginAs = null)
    {
        // validation for constraint: string
        if (!is_null($loginAs) && !is_string($loginAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginAs, true), gettype($loginAs)), __LINE__);
        }
        $this->loginAs = $loginAs;
        return $this;
    }
    /**
     * Get eligibleForCommission value
     * @return bool|null
     */
    public function getEligibleForCommission()
    {
        return $this->eligibleForCommission;
    }
    /**
     * Set eligibleForCommission value
     * @param bool $eligibleForCommission
     * @return \StructType\Partner
     */
    public function setEligibleForCommission($eligibleForCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($eligibleForCommission) && !is_bool($eligibleForCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eligibleForCommission, true), gettype($eligibleForCommission)), __LINE__);
        }
        $this->eligibleForCommission = $eligibleForCommission;
        return $this;
    }
    /**
     * Get contactRolesList value
     * @return \StructType\ContactAccessRolesList|null
     */
    public function getContactRolesList()
    {
        return $this->contactRolesList;
    }
    /**
     * Set contactRolesList value
     * @param \StructType\ContactAccessRolesList $contactRolesList
     * @return \StructType\Partner
     */
    public function setContactRolesList(\StructType\ContactAccessRolesList $contactRolesList = null)
    {
        $this->contactRolesList = $contactRolesList;
        return $this;
    }
    /**
     * Get promoCodeList value
     * @return \StructType\PartnerPromoCodeList|null
     */
    public function getPromoCodeList()
    {
        return $this->promoCodeList;
    }
    /**
     * Set promoCodeList value
     * @param \StructType\PartnerPromoCodeList $promoCodeList
     * @return \StructType\Partner
     */
    public function setPromoCodeList(\StructType\PartnerPromoCodeList $promoCodeList = null)
    {
        $this->promoCodeList = $promoCodeList;
        return $this;
    }
    /**
     * Get addressbookList value
     * @return \StructType\PartnerAddressbookList|null
     */
    public function getAddressbookList()
    {
        return $this->addressbookList;
    }
    /**
     * Set addressbookList value
     * @param \StructType\PartnerAddressbookList $addressbookList
     * @return \StructType\Partner
     */
    public function setAddressbookList(\StructType\PartnerAddressbookList $addressbookList = null)
    {
        $this->addressbookList = $addressbookList;
        return $this;
    }
    /**
     * Get subscriptionsList value
     * @return \StructType\SubscriptionsList|null
     */
    public function getSubscriptionsList()
    {
        return $this->subscriptionsList;
    }
    /**
     * Set subscriptionsList value
     * @param \StructType\SubscriptionsList $subscriptionsList
     * @return \StructType\Partner
     */
    public function setSubscriptionsList(\StructType\SubscriptionsList $subscriptionsList = null)
    {
        $this->subscriptionsList = $subscriptionsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Partner
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Partner
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Partner
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
