<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunitySearchAdvanced StructType
 * @subpackage Structs
 */
class OpportunitySearchAdvanced extends SearchRecord
{
    /**
     * The criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpportunitySearch
     */
    public $criteria;
    /**
     * The columns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpportunitySearchRow
     */
    public $columns;
    /**
     * The savedSearchId
     * @var string
     */
    public $savedSearchId;
    /**
     * The savedSearchScriptId
     * @var string
     */
    public $savedSearchScriptId;
    /**
     * Constructor method for OpportunitySearchAdvanced
     * @uses OpportunitySearchAdvanced::setCriteria()
     * @uses OpportunitySearchAdvanced::setColumns()
     * @uses OpportunitySearchAdvanced::setSavedSearchId()
     * @uses OpportunitySearchAdvanced::setSavedSearchScriptId()
     * @param \StructType\OpportunitySearch $criteria
     * @param \StructType\OpportunitySearchRow $columns
     * @param string $savedSearchId
     * @param string $savedSearchScriptId
     */
    public function __construct(\StructType\OpportunitySearch $criteria = null, \StructType\OpportunitySearchRow $columns = null, $savedSearchId = null, $savedSearchScriptId = null)
    {
        $this
            ->setCriteria($criteria)
            ->setColumns($columns)
            ->setSavedSearchId($savedSearchId)
            ->setSavedSearchScriptId($savedSearchScriptId);
    }
    /**
     * Get criteria value
     * @return \StructType\OpportunitySearch|null
     */
    public function getCriteria()
    {
        return $this->criteria;
    }
    /**
     * Set criteria value
     * @param \StructType\OpportunitySearch $criteria
     * @return \StructType\OpportunitySearchAdvanced
     */
    public function setCriteria(\StructType\OpportunitySearch $criteria = null)
    {
        $this->criteria = $criteria;
        return $this;
    }
    /**
     * Get columns value
     * @return \StructType\OpportunitySearchRow|null
     */
    public function getColumns()
    {
        return $this->columns;
    }
    /**
     * Set columns value
     * @param \StructType\OpportunitySearchRow $columns
     * @return \StructType\OpportunitySearchAdvanced
     */
    public function setColumns(\StructType\OpportunitySearchRow $columns = null)
    {
        $this->columns = $columns;
        return $this;
    }
    /**
     * Get savedSearchId value
     * @return string|null
     */
    public function getSavedSearchId()
    {
        return $this->savedSearchId;
    }
    /**
     * Set savedSearchId value
     * @param string $savedSearchId
     * @return \StructType\OpportunitySearchAdvanced
     */
    public function setSavedSearchId($savedSearchId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchId) && !is_string($savedSearchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchId, true), gettype($savedSearchId)), __LINE__);
        }
        $this->savedSearchId = $savedSearchId;
        return $this;
    }
    /**
     * Get savedSearchScriptId value
     * @return string|null
     */
    public function getSavedSearchScriptId()
    {
        return $this->savedSearchScriptId;
    }
    /**
     * Set savedSearchScriptId value
     * @param string $savedSearchScriptId
     * @return \StructType\OpportunitySearchAdvanced
     */
    public function setSavedSearchScriptId($savedSearchScriptId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchScriptId) && !is_string($savedSearchScriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchScriptId, true), gettype($savedSearchScriptId)), __LINE__);
        }
        $this->savedSearchScriptId = $savedSearchScriptId;
        return $this;
    }
}
