<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunitySalesTeamList StructType
 * @subpackage Structs
 */
class OpportunitySalesTeamList extends AbstractStructBase
{
    /**
     * The salesTeam
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OpportunitySalesTeam[]
     */
    public $salesTeam;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for OpportunitySalesTeamList
     * @uses OpportunitySalesTeamList::setSalesTeam()
     * @uses OpportunitySalesTeamList::setReplaceAll()
     * @param \StructType\OpportunitySalesTeam[] $salesTeam
     * @param bool $replaceAll
     */
    public function __construct(array $salesTeam = array(), $replaceAll = true)
    {
        $this
            ->setSalesTeam($salesTeam)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get salesTeam value
     * @return \StructType\OpportunitySalesTeam[]|null
     */
    public function getSalesTeam()
    {
        return $this->salesTeam;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesTeam method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesTeam method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesTeamForArrayConstraintsFromSetSalesTeam(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $opportunitySalesTeamListSalesTeamItem) {
            // validation for constraint: itemType
            if (!$opportunitySalesTeamListSalesTeamItem instanceof \StructType\OpportunitySalesTeam) {
                $invalidValues[] = is_object($opportunitySalesTeamListSalesTeamItem) ? get_class($opportunitySalesTeamListSalesTeamItem) : sprintf('%s(%s)', gettype($opportunitySalesTeamListSalesTeamItem), var_export($opportunitySalesTeamListSalesTeamItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The salesTeam property can only contain items of type \StructType\OpportunitySalesTeam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunitySalesTeam[] $salesTeam
     * @return \StructType\OpportunitySalesTeamList
     */
    public function setSalesTeam(array $salesTeam = array())
    {
        // validation for constraint: array
        if ('' !== ($salesTeamArrayErrorMessage = self::validateSalesTeamForArrayConstraintsFromSetSalesTeam($salesTeam))) {
            throw new \InvalidArgumentException($salesTeamArrayErrorMessage, __LINE__);
        }
        $this->salesTeam = $salesTeam;
        return $this;
    }
    /**
     * Add item to salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunitySalesTeam $item
     * @return \StructType\OpportunitySalesTeamList
     */
    public function addToSalesTeam(\StructType\OpportunitySalesTeam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpportunitySalesTeam) {
            throw new \InvalidArgumentException(sprintf('The salesTeam property can only contain items of type \StructType\OpportunitySalesTeam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->salesTeam[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\OpportunitySalesTeamList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
