<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunityCompetitorsList StructType
 * @subpackage Structs
 */
class OpportunityCompetitorsList extends AbstractStructBase
{
    /**
     * The competitors
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OpportunityCompetitors[]
     */
    public $competitors;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for OpportunityCompetitorsList
     * @uses OpportunityCompetitorsList::setCompetitors()
     * @uses OpportunityCompetitorsList::setReplaceAll()
     * @param \StructType\OpportunityCompetitors[] $competitors
     * @param bool $replaceAll
     */
    public function __construct(array $competitors = array(), $replaceAll = true)
    {
        $this
            ->setCompetitors($competitors)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get competitors value
     * @return \StructType\OpportunityCompetitors[]|null
     */
    public function getCompetitors()
    {
        return $this->competitors;
    }
    /**
     * This method is responsible for validating the values passed to the setCompetitors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompetitors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompetitorsForArrayConstraintsFromSetCompetitors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $opportunityCompetitorsListCompetitorsItem) {
            // validation for constraint: itemType
            if (!$opportunityCompetitorsListCompetitorsItem instanceof \StructType\OpportunityCompetitors) {
                $invalidValues[] = is_object($opportunityCompetitorsListCompetitorsItem) ? get_class($opportunityCompetitorsListCompetitorsItem) : sprintf('%s(%s)', gettype($opportunityCompetitorsListCompetitorsItem), var_export($opportunityCompetitorsListCompetitorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The competitors property can only contain items of type \StructType\OpportunityCompetitors, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set competitors value
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunityCompetitors[] $competitors
     * @return \StructType\OpportunityCompetitorsList
     */
    public function setCompetitors(array $competitors = array())
    {
        // validation for constraint: array
        if ('' !== ($competitorsArrayErrorMessage = self::validateCompetitorsForArrayConstraintsFromSetCompetitors($competitors))) {
            throw new \InvalidArgumentException($competitorsArrayErrorMessage, __LINE__);
        }
        $this->competitors = $competitors;
        return $this;
    }
    /**
     * Add item to competitors value
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunityCompetitors $item
     * @return \StructType\OpportunityCompetitorsList
     */
    public function addToCompetitors(\StructType\OpportunityCompetitors $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpportunityCompetitors) {
            throw new \InvalidArgumentException(sprintf('The competitors property can only contain items of type \StructType\OpportunityCompetitors, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->competitors[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\OpportunityCompetitorsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
