<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonInventoryPurchaseItem StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:NonInventoryPurchaseItem
 * @subpackage Structs
 */
class NonInventoryPurchaseItem extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The purchaseDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $purchaseDescription;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The costUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costUnits;
    /**
     * The expenseAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expenseAccount;
    /**
     * The issueProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueProduct;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The matrixType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixType;
    /**
     * The unitsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $unitsType;
    /**
     * The purchaseUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseUnit;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The upcCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upcCode;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The vendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorName;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The matrixItemNameTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixItemNameTemplate;
    /**
     * The availableToPartners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableToPartners;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The taxSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxSchedule;
    /**
     * The deferralAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deferralAccount;
    /**
     * The amortizationTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $amortizationTemplate;
    /**
     * The residual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $residual;
    /**
     * The amortizationPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amortizationPeriod;
    /**
     * The isFulfillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFulfillable;
    /**
     * The generateAccruals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $generateAccruals;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemAccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The costCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $costCategory;
    /**
     * The purchaseOrderQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantity;
    /**
     * The purchaseOrderAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderAmount;
    /**
     * The purchaseOrderQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantityDiff;
    /**
     * The receiptQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantity;
    /**
     * The receiptAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptAmount;
    /**
     * The receiptQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantityDiff;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The itemOptionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemOptionsList
     */
    public $itemOptionsList;
    /**
     * The matrixOptionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MatrixOptionList
     */
    public $matrixOptionList;
    /**
     * The itemVendorList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemVendorList
     */
    public $itemVendorList;
    /**
     * The purchaseTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseTaxCode;
    /**
     * The salesTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesTaxCode;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TranslationList
     */
    public $translationsList;
    /**
     * The vendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $vendor;
    /**
     * The hierarchyVersionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NonInventoryPurchaseItemHierarchyVersionsList
     */
    public $hierarchyVersionsList;
    /**
     * The consumptionUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $consumptionUnit;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for NonInventoryPurchaseItem
     * @uses NonInventoryPurchaseItem::setCreatedDate()
     * @uses NonInventoryPurchaseItem::setLastModifiedDate()
     * @uses NonInventoryPurchaseItem::setPurchaseDescription()
     * @uses NonInventoryPurchaseItem::setCost()
     * @uses NonInventoryPurchaseItem::setCostUnits()
     * @uses NonInventoryPurchaseItem::setExpenseAccount()
     * @uses NonInventoryPurchaseItem::setIssueProduct()
     * @uses NonInventoryPurchaseItem::setIsTaxable()
     * @uses NonInventoryPurchaseItem::setMatrixType()
     * @uses NonInventoryPurchaseItem::setUnitsType()
     * @uses NonInventoryPurchaseItem::setPurchaseUnit()
     * @uses NonInventoryPurchaseItem::setCustomForm()
     * @uses NonInventoryPurchaseItem::setItemId()
     * @uses NonInventoryPurchaseItem::setUpcCode()
     * @uses NonInventoryPurchaseItem::setDisplayName()
     * @uses NonInventoryPurchaseItem::setIncludeChildren()
     * @uses NonInventoryPurchaseItem::setVendorName()
     * @uses NonInventoryPurchaseItem::setParent()
     * @uses NonInventoryPurchaseItem::setIsInactive()
     * @uses NonInventoryPurchaseItem::setMatrixItemNameTemplate()
     * @uses NonInventoryPurchaseItem::setAvailableToPartners()
     * @uses NonInventoryPurchaseItem::setDepartment()
     * @uses NonInventoryPurchaseItem::setClass()
     * @uses NonInventoryPurchaseItem::setLocation()
     * @uses NonInventoryPurchaseItem::setSubsidiaryList()
     * @uses NonInventoryPurchaseItem::setTaxSchedule()
     * @uses NonInventoryPurchaseItem::setDeferralAccount()
     * @uses NonInventoryPurchaseItem::setAmortizationTemplate()
     * @uses NonInventoryPurchaseItem::setResidual()
     * @uses NonInventoryPurchaseItem::setAmortizationPeriod()
     * @uses NonInventoryPurchaseItem::setIsFulfillable()
     * @uses NonInventoryPurchaseItem::setGenerateAccruals()
     * @uses NonInventoryPurchaseItem::setAccountingBookDetailList()
     * @uses NonInventoryPurchaseItem::setCostCategory()
     * @uses NonInventoryPurchaseItem::setPurchaseOrderQuantity()
     * @uses NonInventoryPurchaseItem::setPurchaseOrderAmount()
     * @uses NonInventoryPurchaseItem::setPurchaseOrderQuantityDiff()
     * @uses NonInventoryPurchaseItem::setReceiptQuantity()
     * @uses NonInventoryPurchaseItem::setReceiptAmount()
     * @uses NonInventoryPurchaseItem::setReceiptQuantityDiff()
     * @uses NonInventoryPurchaseItem::setCurrency()
     * @uses NonInventoryPurchaseItem::setItemOptionsList()
     * @uses NonInventoryPurchaseItem::setMatrixOptionList()
     * @uses NonInventoryPurchaseItem::setItemVendorList()
     * @uses NonInventoryPurchaseItem::setPurchaseTaxCode()
     * @uses NonInventoryPurchaseItem::setSalesTaxCode()
     * @uses NonInventoryPurchaseItem::setTranslationsList()
     * @uses NonInventoryPurchaseItem::setVendor()
     * @uses NonInventoryPurchaseItem::setHierarchyVersionsList()
     * @uses NonInventoryPurchaseItem::setConsumptionUnit()
     * @uses NonInventoryPurchaseItem::setCustomFieldList()
     * @uses NonInventoryPurchaseItem::setInternalId()
     * @uses NonInventoryPurchaseItem::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $purchaseDescription
     * @param float $cost
     * @param string $costUnits
     * @param \StructType\RecordRef $expenseAccount
     * @param \StructType\RecordRef $issueProduct
     * @param bool $isTaxable
     * @param string $matrixType
     * @param \StructType\RecordRef $unitsType
     * @param \StructType\RecordRef $purchaseUnit
     * @param \StructType\RecordRef $customForm
     * @param string $itemId
     * @param string $upcCode
     * @param string $displayName
     * @param bool $includeChildren
     * @param string $vendorName
     * @param \StructType\RecordRef $parent
     * @param bool $isInactive
     * @param string $matrixItemNameTemplate
     * @param bool $availableToPartners
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRefList $subsidiaryList
     * @param \StructType\RecordRef $taxSchedule
     * @param \StructType\RecordRef $deferralAccount
     * @param \StructType\RecordRef $amortizationTemplate
     * @param string $residual
     * @param int $amortizationPeriod
     * @param bool $isFulfillable
     * @param bool $generateAccruals
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @param \StructType\RecordRef $costCategory
     * @param float $purchaseOrderQuantity
     * @param float $purchaseOrderAmount
     * @param float $purchaseOrderQuantityDiff
     * @param float $receiptQuantity
     * @param float $receiptAmount
     * @param float $receiptQuantityDiff
     * @param string $currency
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @param \StructType\ItemVendorList $itemVendorList
     * @param \StructType\RecordRef $purchaseTaxCode
     * @param \StructType\RecordRef $salesTaxCode
     * @param \StructType\TranslationList $translationsList
     * @param \StructType\RecordRef $vendor
     * @param \StructType\NonInventoryPurchaseItemHierarchyVersionsList $hierarchyVersionsList
     * @param \StructType\RecordRef $consumptionUnit
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, $purchaseDescription = null, $cost = null, $costUnits = null, \StructType\RecordRef $expenseAccount = null, \StructType\RecordRef $issueProduct = null, $isTaxable = null, $matrixType = null, \StructType\RecordRef $unitsType = null, \StructType\RecordRef $purchaseUnit = null, \StructType\RecordRef $customForm = null, $itemId = null, $upcCode = null, $displayName = null, $includeChildren = null, $vendorName = null, \StructType\RecordRef $parent = null, $isInactive = null, $matrixItemNameTemplate = null, $availableToPartners = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRefList $subsidiaryList = null, \StructType\RecordRef $taxSchedule = null, \StructType\RecordRef $deferralAccount = null, \StructType\RecordRef $amortizationTemplate = null, $residual = null, $amortizationPeriod = null, $isFulfillable = null, $generateAccruals = null, \StructType\ItemAccountingBookDetailList $accountingBookDetailList = null, \StructType\RecordRef $costCategory = null, $purchaseOrderQuantity = null, $purchaseOrderAmount = null, $purchaseOrderQuantityDiff = null, $receiptQuantity = null, $receiptAmount = null, $receiptQuantityDiff = null, $currency = null, \StructType\ItemOptionsList $itemOptionsList = null, \StructType\MatrixOptionList $matrixOptionList = null, \StructType\ItemVendorList $itemVendorList = null, \StructType\RecordRef $purchaseTaxCode = null, \StructType\RecordRef $salesTaxCode = null, \StructType\TranslationList $translationsList = null, \StructType\RecordRef $vendor = null, \StructType\NonInventoryPurchaseItemHierarchyVersionsList $hierarchyVersionsList = null, \StructType\RecordRef $consumptionUnit = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setPurchaseDescription($purchaseDescription)
            ->setCost($cost)
            ->setCostUnits($costUnits)
            ->setExpenseAccount($expenseAccount)
            ->setIssueProduct($issueProduct)
            ->setIsTaxable($isTaxable)
            ->setMatrixType($matrixType)
            ->setUnitsType($unitsType)
            ->setPurchaseUnit($purchaseUnit)
            ->setCustomForm($customForm)
            ->setItemId($itemId)
            ->setUpcCode($upcCode)
            ->setDisplayName($displayName)
            ->setIncludeChildren($includeChildren)
            ->setVendorName($vendorName)
            ->setParent($parent)
            ->setIsInactive($isInactive)
            ->setMatrixItemNameTemplate($matrixItemNameTemplate)
            ->setAvailableToPartners($availableToPartners)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setSubsidiaryList($subsidiaryList)
            ->setTaxSchedule($taxSchedule)
            ->setDeferralAccount($deferralAccount)
            ->setAmortizationTemplate($amortizationTemplate)
            ->setResidual($residual)
            ->setAmortizationPeriod($amortizationPeriod)
            ->setIsFulfillable($isFulfillable)
            ->setGenerateAccruals($generateAccruals)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCostCategory($costCategory)
            ->setPurchaseOrderQuantity($purchaseOrderQuantity)
            ->setPurchaseOrderAmount($purchaseOrderAmount)
            ->setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff)
            ->setReceiptQuantity($receiptQuantity)
            ->setReceiptAmount($receiptAmount)
            ->setReceiptQuantityDiff($receiptQuantityDiff)
            ->setCurrency($currency)
            ->setItemOptionsList($itemOptionsList)
            ->setMatrixOptionList($matrixOptionList)
            ->setItemVendorList($itemVendorList)
            ->setPurchaseTaxCode($purchaseTaxCode)
            ->setSalesTaxCode($salesTaxCode)
            ->setTranslationsList($translationsList)
            ->setVendor($vendor)
            ->setHierarchyVersionsList($hierarchyVersionsList)
            ->setConsumptionUnit($consumptionUnit)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get purchaseDescription value
     * @return string|null
     */
    public function getPurchaseDescription()
    {
        return $this->purchaseDescription;
    }
    /**
     * Set purchaseDescription value
     * @param string $purchaseDescription
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setPurchaseDescription($purchaseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseDescription) && !is_string($purchaseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseDescription, true), gettype($purchaseDescription)), __LINE__);
        }
        $this->purchaseDescription = $purchaseDescription;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get costUnits value
     * @return string|null
     */
    public function getCostUnits()
    {
        return $this->costUnits;
    }
    /**
     * Set costUnits value
     * @param string $costUnits
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setCostUnits($costUnits = null)
    {
        // validation for constraint: string
        if (!is_null($costUnits) && !is_string($costUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costUnits, true), gettype($costUnits)), __LINE__);
        }
        $this->costUnits = $costUnits;
        return $this;
    }
    /**
     * Get expenseAccount value
     * @return \StructType\RecordRef|null
     */
    public function getExpenseAccount()
    {
        return $this->expenseAccount;
    }
    /**
     * Set expenseAccount value
     * @param \StructType\RecordRef $expenseAccount
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setExpenseAccount(\StructType\RecordRef $expenseAccount = null)
    {
        $this->expenseAccount = $expenseAccount;
        return $this;
    }
    /**
     * Get issueProduct value
     * @return \StructType\RecordRef|null
     */
    public function getIssueProduct()
    {
        return $this->issueProduct;
    }
    /**
     * Set issueProduct value
     * @param \StructType\RecordRef $issueProduct
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setIssueProduct(\StructType\RecordRef $issueProduct = null)
    {
        $this->issueProduct = $issueProduct;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get matrixType value
     * @return string|null
     */
    public function getMatrixType()
    {
        return $this->matrixType;
    }
    /**
     * Set matrixType value
     * @uses \EnumType\ItemMatrixType::valueIsValid()
     * @uses \EnumType\ItemMatrixType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $matrixType
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setMatrixType($matrixType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemMatrixType::valueIsValid($matrixType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemMatrixType', is_array($matrixType) ? implode(', ', $matrixType) : var_export($matrixType, true), implode(', ', \EnumType\ItemMatrixType::getValidValues())), __LINE__);
        }
        $this->matrixType = $matrixType;
        return $this;
    }
    /**
     * Get unitsType value
     * @return \StructType\RecordRef|null
     */
    public function getUnitsType()
    {
        return $this->unitsType;
    }
    /**
     * Set unitsType value
     * @param \StructType\RecordRef $unitsType
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setUnitsType(\StructType\RecordRef $unitsType = null)
    {
        $this->unitsType = $unitsType;
        return $this;
    }
    /**
     * Get purchaseUnit value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseUnit()
    {
        return $this->purchaseUnit;
    }
    /**
     * Set purchaseUnit value
     * @param \StructType\RecordRef $purchaseUnit
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setPurchaseUnit(\StructType\RecordRef $purchaseUnit = null)
    {
        $this->purchaseUnit = $purchaseUnit;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get upcCode value
     * @return string|null
     */
    public function getUpcCode()
    {
        return $this->upcCode;
    }
    /**
     * Set upcCode value
     * @param string $upcCode
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setUpcCode($upcCode = null)
    {
        // validation for constraint: string
        if (!is_null($upcCode) && !is_string($upcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upcCode, true), gettype($upcCode)), __LINE__);
        }
        $this->upcCode = $upcCode;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get vendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->vendorName;
    }
    /**
     * Set vendorName value
     * @param string $vendorName
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->vendorName = $vendorName;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get matrixItemNameTemplate value
     * @return string|null
     */
    public function getMatrixItemNameTemplate()
    {
        return $this->matrixItemNameTemplate;
    }
    /**
     * Set matrixItemNameTemplate value
     * @param string $matrixItemNameTemplate
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setMatrixItemNameTemplate($matrixItemNameTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($matrixItemNameTemplate) && !is_string($matrixItemNameTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matrixItemNameTemplate, true), gettype($matrixItemNameTemplate)), __LINE__);
        }
        $this->matrixItemNameTemplate = $matrixItemNameTemplate;
        return $this;
    }
    /**
     * Get availableToPartners value
     * @return bool|null
     */
    public function getAvailableToPartners()
    {
        return $this->availableToPartners;
    }
    /**
     * Set availableToPartners value
     * @param bool $availableToPartners
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setAvailableToPartners($availableToPartners = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToPartners) && !is_bool($availableToPartners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToPartners, true), gettype($availableToPartners)), __LINE__);
        }
        $this->availableToPartners = $availableToPartners;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get taxSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getTaxSchedule()
    {
        return $this->taxSchedule;
    }
    /**
     * Set taxSchedule value
     * @param \StructType\RecordRef $taxSchedule
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setTaxSchedule(\StructType\RecordRef $taxSchedule = null)
    {
        $this->taxSchedule = $taxSchedule;
        return $this;
    }
    /**
     * Get deferralAccount value
     * @return \StructType\RecordRef|null
     */
    public function getDeferralAccount()
    {
        return $this->deferralAccount;
    }
    /**
     * Set deferralAccount value
     * @param \StructType\RecordRef $deferralAccount
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setDeferralAccount(\StructType\RecordRef $deferralAccount = null)
    {
        $this->deferralAccount = $deferralAccount;
        return $this;
    }
    /**
     * Get amortizationTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getAmortizationTemplate()
    {
        return $this->amortizationTemplate;
    }
    /**
     * Set amortizationTemplate value
     * @param \StructType\RecordRef $amortizationTemplate
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setAmortizationTemplate(\StructType\RecordRef $amortizationTemplate = null)
    {
        $this->amortizationTemplate = $amortizationTemplate;
        return $this;
    }
    /**
     * Get residual value
     * @return string|null
     */
    public function getResidual()
    {
        return $this->residual;
    }
    /**
     * Set residual value
     * @param string $residual
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setResidual($residual = null)
    {
        // validation for constraint: string
        if (!is_null($residual) && !is_string($residual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residual, true), gettype($residual)), __LINE__);
        }
        $this->residual = $residual;
        return $this;
    }
    /**
     * Get amortizationPeriod value
     * @return int|null
     */
    public function getAmortizationPeriod()
    {
        return $this->amortizationPeriod;
    }
    /**
     * Set amortizationPeriod value
     * @param int $amortizationPeriod
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setAmortizationPeriod($amortizationPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($amortizationPeriod) && !(is_int($amortizationPeriod) || ctype_digit($amortizationPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amortizationPeriod, true), gettype($amortizationPeriod)), __LINE__);
        }
        $this->amortizationPeriod = $amortizationPeriod;
        return $this;
    }
    /**
     * Get isFulfillable value
     * @return bool|null
     */
    public function getIsFulfillable()
    {
        return $this->isFulfillable;
    }
    /**
     * Set isFulfillable value
     * @param bool $isFulfillable
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setIsFulfillable($isFulfillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFulfillable) && !is_bool($isFulfillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFulfillable, true), gettype($isFulfillable)), __LINE__);
        }
        $this->isFulfillable = $isFulfillable;
        return $this;
    }
    /**
     * Get generateAccruals value
     * @return bool|null
     */
    public function getGenerateAccruals()
    {
        return $this->generateAccruals;
    }
    /**
     * Set generateAccruals value
     * @param bool $generateAccruals
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setGenerateAccruals($generateAccruals = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateAccruals) && !is_bool($generateAccruals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateAccruals, true), gettype($generateAccruals)), __LINE__);
        }
        $this->generateAccruals = $generateAccruals;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\ItemAccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setAccountingBookDetailList(\StructType\ItemAccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get costCategory value
     * @return \StructType\RecordRef|null
     */
    public function getCostCategory()
    {
        return $this->costCategory;
    }
    /**
     * Set costCategory value
     * @param \StructType\RecordRef $costCategory
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setCostCategory(\StructType\RecordRef $costCategory = null)
    {
        $this->costCategory = $costCategory;
        return $this;
    }
    /**
     * Get purchaseOrderQuantity value
     * @return float|null
     */
    public function getPurchaseOrderQuantity()
    {
        return $this->purchaseOrderQuantity;
    }
    /**
     * Set purchaseOrderQuantity value
     * @param float $purchaseOrderQuantity
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setPurchaseOrderQuantity($purchaseOrderQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantity) && !(is_float($purchaseOrderQuantity) || is_numeric($purchaseOrderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantity, true), gettype($purchaseOrderQuantity)), __LINE__);
        }
        $this->purchaseOrderQuantity = $purchaseOrderQuantity;
        return $this;
    }
    /**
     * Get purchaseOrderAmount value
     * @return float|null
     */
    public function getPurchaseOrderAmount()
    {
        return $this->purchaseOrderAmount;
    }
    /**
     * Set purchaseOrderAmount value
     * @param float $purchaseOrderAmount
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setPurchaseOrderAmount($purchaseOrderAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderAmount) && !(is_float($purchaseOrderAmount) || is_numeric($purchaseOrderAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderAmount, true), gettype($purchaseOrderAmount)), __LINE__);
        }
        $this->purchaseOrderAmount = $purchaseOrderAmount;
        return $this;
    }
    /**
     * Get purchaseOrderQuantityDiff value
     * @return float|null
     */
    public function getPurchaseOrderQuantityDiff()
    {
        return $this->purchaseOrderQuantityDiff;
    }
    /**
     * Set purchaseOrderQuantityDiff value
     * @param float $purchaseOrderQuantityDiff
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantityDiff) && !(is_float($purchaseOrderQuantityDiff) || is_numeric($purchaseOrderQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantityDiff, true), gettype($purchaseOrderQuantityDiff)), __LINE__);
        }
        $this->purchaseOrderQuantityDiff = $purchaseOrderQuantityDiff;
        return $this;
    }
    /**
     * Get receiptQuantity value
     * @return float|null
     */
    public function getReceiptQuantity()
    {
        return $this->receiptQuantity;
    }
    /**
     * Set receiptQuantity value
     * @param float $receiptQuantity
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setReceiptQuantity($receiptQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantity) && !(is_float($receiptQuantity) || is_numeric($receiptQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantity, true), gettype($receiptQuantity)), __LINE__);
        }
        $this->receiptQuantity = $receiptQuantity;
        return $this;
    }
    /**
     * Get receiptAmount value
     * @return float|null
     */
    public function getReceiptAmount()
    {
        return $this->receiptAmount;
    }
    /**
     * Set receiptAmount value
     * @param float $receiptAmount
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setReceiptAmount($receiptAmount = null)
    {
        // validation for constraint: float
        if (!is_null($receiptAmount) && !(is_float($receiptAmount) || is_numeric($receiptAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptAmount, true), gettype($receiptAmount)), __LINE__);
        }
        $this->receiptAmount = $receiptAmount;
        return $this;
    }
    /**
     * Get receiptQuantityDiff value
     * @return float|null
     */
    public function getReceiptQuantityDiff()
    {
        return $this->receiptQuantityDiff;
    }
    /**
     * Set receiptQuantityDiff value
     * @param float $receiptQuantityDiff
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setReceiptQuantityDiff($receiptQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantityDiff) && !(is_float($receiptQuantityDiff) || is_numeric($receiptQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantityDiff, true), gettype($receiptQuantityDiff)), __LINE__);
        }
        $this->receiptQuantityDiff = $receiptQuantityDiff;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get itemOptionsList value
     * @return \StructType\ItemOptionsList|null
     */
    public function getItemOptionsList()
    {
        return $this->itemOptionsList;
    }
    /**
     * Set itemOptionsList value
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setItemOptionsList(\StructType\ItemOptionsList $itemOptionsList = null)
    {
        $this->itemOptionsList = $itemOptionsList;
        return $this;
    }
    /**
     * Get matrixOptionList value
     * @return \StructType\MatrixOptionList|null
     */
    public function getMatrixOptionList()
    {
        return $this->matrixOptionList;
    }
    /**
     * Set matrixOptionList value
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setMatrixOptionList(\StructType\MatrixOptionList $matrixOptionList = null)
    {
        $this->matrixOptionList = $matrixOptionList;
        return $this;
    }
    /**
     * Get itemVendorList value
     * @return \StructType\ItemVendorList|null
     */
    public function getItemVendorList()
    {
        return $this->itemVendorList;
    }
    /**
     * Set itemVendorList value
     * @param \StructType\ItemVendorList $itemVendorList
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setItemVendorList(\StructType\ItemVendorList $itemVendorList = null)
    {
        $this->itemVendorList = $itemVendorList;
        return $this;
    }
    /**
     * Get purchaseTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseTaxCode()
    {
        return $this->purchaseTaxCode;
    }
    /**
     * Set purchaseTaxCode value
     * @param \StructType\RecordRef $purchaseTaxCode
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setPurchaseTaxCode(\StructType\RecordRef $purchaseTaxCode = null)
    {
        $this->purchaseTaxCode = $purchaseTaxCode;
        return $this;
    }
    /**
     * Get salesTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getSalesTaxCode()
    {
        return $this->salesTaxCode;
    }
    /**
     * Set salesTaxCode value
     * @param \StructType\RecordRef $salesTaxCode
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setSalesTaxCode(\StructType\RecordRef $salesTaxCode = null)
    {
        $this->salesTaxCode = $salesTaxCode;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\TranslationList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\TranslationList $translationsList
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setTranslationsList(\StructType\TranslationList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get vendor value
     * @return \StructType\RecordRef|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * Set vendor value
     * @param \StructType\RecordRef $vendor
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setVendor(\StructType\RecordRef $vendor = null)
    {
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Get hierarchyVersionsList value
     * @return \StructType\NonInventoryPurchaseItemHierarchyVersionsList|null
     */
    public function getHierarchyVersionsList()
    {
        return $this->hierarchyVersionsList;
    }
    /**
     * Set hierarchyVersionsList value
     * @param \StructType\NonInventoryPurchaseItemHierarchyVersionsList $hierarchyVersionsList
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setHierarchyVersionsList(\StructType\NonInventoryPurchaseItemHierarchyVersionsList $hierarchyVersionsList = null)
    {
        $this->hierarchyVersionsList = $hierarchyVersionsList;
        return $this;
    }
    /**
     * Get consumptionUnit value
     * @return \StructType\RecordRef|null
     */
    public function getConsumptionUnit()
    {
        return $this->consumptionUnit;
    }
    /**
     * Set consumptionUnit value
     * @param \StructType\RecordRef $consumptionUnit
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setConsumptionUnit(\StructType\RecordRef $consumptionUnit = null)
    {
        $this->consumptionUnit = $consumptionUnit;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\NonInventoryPurchaseItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
