<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManufacturingRoutingRoutingComponent StructType
 * @subpackage Structs
 */
class ManufacturingRoutingRoutingComponent extends AbstractStructBase
{
    /**
     * The itemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemName;
    /**
     * The revision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revision;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The yield
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $yield;
    /**
     * The bomQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $bomQuantity;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $units;
    /**
     * The operationDisplayText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $operationDisplayText;
    /**
     * The operationSequenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationSequenceNumber;
    /**
     * The component
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $component;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $item;
    /**
     * Constructor method for ManufacturingRoutingRoutingComponent
     * @uses ManufacturingRoutingRoutingComponent::setItemName()
     * @uses ManufacturingRoutingRoutingComponent::setRevision()
     * @uses ManufacturingRoutingRoutingComponent::setDescription()
     * @uses ManufacturingRoutingRoutingComponent::setYield()
     * @uses ManufacturingRoutingRoutingComponent::setBomQuantity()
     * @uses ManufacturingRoutingRoutingComponent::setQuantity()
     * @uses ManufacturingRoutingRoutingComponent::setUnits()
     * @uses ManufacturingRoutingRoutingComponent::setOperationDisplayText()
     * @uses ManufacturingRoutingRoutingComponent::setOperationSequenceNumber()
     * @uses ManufacturingRoutingRoutingComponent::setComponent()
     * @uses ManufacturingRoutingRoutingComponent::setItem()
     * @param string $itemName
     * @param string $revision
     * @param string $description
     * @param float $yield
     * @param float $bomQuantity
     * @param float $quantity
     * @param string $units
     * @param \StructType\RecordRef $operationDisplayText
     * @param int $operationSequenceNumber
     * @param string $component
     * @param string $item
     */
    public function __construct($itemName = null, $revision = null, $description = null, $yield = null, $bomQuantity = null, $quantity = null, $units = null, \StructType\RecordRef $operationDisplayText = null, $operationSequenceNumber = null, $component = null, $item = null)
    {
        $this
            ->setItemName($itemName)
            ->setRevision($revision)
            ->setDescription($description)
            ->setYield($yield)
            ->setBomQuantity($bomQuantity)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setOperationDisplayText($operationDisplayText)
            ->setOperationSequenceNumber($operationSequenceNumber)
            ->setComponent($component)
            ->setItem($item);
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get revision value
     * @return string|null
     */
    public function getRevision()
    {
        return $this->revision;
    }
    /**
     * Set revision value
     * @param string $revision
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setRevision($revision = null)
    {
        // validation for constraint: string
        if (!is_null($revision) && !is_string($revision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revision, true), gettype($revision)), __LINE__);
        }
        $this->revision = $revision;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get yield value
     * @return float|null
     */
    public function getYield()
    {
        return $this->yield;
    }
    /**
     * Set yield value
     * @param float $yield
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setYield($yield = null)
    {
        // validation for constraint: float
        if (!is_null($yield) && !(is_float($yield) || is_numeric($yield))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($yield, true), gettype($yield)), __LINE__);
        }
        $this->yield = $yield;
        return $this;
    }
    /**
     * Get bomQuantity value
     * @return float|null
     */
    public function getBomQuantity()
    {
        return $this->bomQuantity;
    }
    /**
     * Set bomQuantity value
     * @param float $bomQuantity
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setBomQuantity($bomQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($bomQuantity) && !(is_float($bomQuantity) || is_numeric($bomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bomQuantity, true), gettype($bomQuantity)), __LINE__);
        }
        $this->bomQuantity = $bomQuantity;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return string|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param string $units
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setUnits($units = null)
    {
        // validation for constraint: string
        if (!is_null($units) && !is_string($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($units, true), gettype($units)), __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Get operationDisplayText value
     * @return \StructType\RecordRef|null
     */
    public function getOperationDisplayText()
    {
        return $this->operationDisplayText;
    }
    /**
     * Set operationDisplayText value
     * @param \StructType\RecordRef $operationDisplayText
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setOperationDisplayText(\StructType\RecordRef $operationDisplayText = null)
    {
        $this->operationDisplayText = $operationDisplayText;
        return $this;
    }
    /**
     * Get operationSequenceNumber value
     * @return int|null
     */
    public function getOperationSequenceNumber()
    {
        return $this->operationSequenceNumber;
    }
    /**
     * Set operationSequenceNumber value
     * @param int $operationSequenceNumber
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setOperationSequenceNumber($operationSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($operationSequenceNumber) && !(is_int($operationSequenceNumber) || ctype_digit($operationSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationSequenceNumber, true), gettype($operationSequenceNumber)), __LINE__);
        }
        $this->operationSequenceNumber = $operationSequenceNumber;
        return $this;
    }
    /**
     * Get component value
     * @return string|null
     */
    public function getComponent()
    {
        return $this->component;
    }
    /**
     * Set component value
     * @param string $component
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setComponent($component = null)
    {
        // validation for constraint: string
        if (!is_null($component) && !is_string($component)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($component, true), gettype($component)), __LINE__);
        }
        $this->component = $component;
        return $this;
    }
    /**
     * Get item value
     * @return string|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param string $item
     * @return \StructType\ManufacturingRoutingRoutingComponent
     */
    public function setItem($item = null)
    {
        // validation for constraint: string
        if (!is_null($item) && !is_string($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item, true), gettype($item)), __LINE__);
        }
        $this->item = $item;
        return $this;
    }
}
