<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManufacturingRouting StructType
 * @subpackage Structs
 */
class ManufacturingRouting extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The billOfMaterials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billOfMaterials;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The locationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $locationList;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDefault;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The autoCalculateLag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $autoCalculateLag;
    /**
     * The routingStepList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ManufacturingRoutingRoutingStepList
     */
    public $routingStepList;
    /**
     * The routingComponentList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ManufacturingRoutingRoutingComponentList
     */
    public $routingComponentList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ManufacturingRouting
     * @uses ManufacturingRouting::setCustomForm()
     * @uses ManufacturingRouting::setBillOfMaterials()
     * @uses ManufacturingRouting::setSubsidiary()
     * @uses ManufacturingRouting::setItem()
     * @uses ManufacturingRouting::setLocationList()
     * @uses ManufacturingRouting::setName()
     * @uses ManufacturingRouting::setMemo()
     * @uses ManufacturingRouting::setIsDefault()
     * @uses ManufacturingRouting::setIsInactive()
     * @uses ManufacturingRouting::setAutoCalculateLag()
     * @uses ManufacturingRouting::setRoutingStepList()
     * @uses ManufacturingRouting::setRoutingComponentList()
     * @uses ManufacturingRouting::setCustomFieldList()
     * @uses ManufacturingRouting::setInternalId()
     * @uses ManufacturingRouting::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $billOfMaterials
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRefList $locationList
     * @param string $name
     * @param string $memo
     * @param bool $isDefault
     * @param bool $isInactive
     * @param bool $autoCalculateLag
     * @param \StructType\ManufacturingRoutingRoutingStepList $routingStepList
     * @param \StructType\ManufacturingRoutingRoutingComponentList $routingComponentList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, \StructType\RecordRef $billOfMaterials = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $item = null, \StructType\RecordRefList $locationList = null, $name = null, $memo = null, $isDefault = null, $isInactive = null, $autoCalculateLag = null, \StructType\ManufacturingRoutingRoutingStepList $routingStepList = null, \StructType\ManufacturingRoutingRoutingComponentList $routingComponentList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setBillOfMaterials($billOfMaterials)
            ->setSubsidiary($subsidiary)
            ->setItem($item)
            ->setLocationList($locationList)
            ->setName($name)
            ->setMemo($memo)
            ->setIsDefault($isDefault)
            ->setIsInactive($isInactive)
            ->setAutoCalculateLag($autoCalculateLag)
            ->setRoutingStepList($routingStepList)
            ->setRoutingComponentList($routingComponentList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ManufacturingRouting
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get billOfMaterials value
     * @return \StructType\RecordRef|null
     */
    public function getBillOfMaterials()
    {
        return $this->billOfMaterials;
    }
    /**
     * Set billOfMaterials value
     * @param \StructType\RecordRef $billOfMaterials
     * @return \StructType\ManufacturingRouting
     */
    public function setBillOfMaterials(\StructType\RecordRef $billOfMaterials = null)
    {
        $this->billOfMaterials = $billOfMaterials;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\ManufacturingRouting
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\ManufacturingRouting
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get locationList value
     * @return \StructType\RecordRefList|null
     */
    public function getLocationList()
    {
        return $this->locationList;
    }
    /**
     * Set locationList value
     * @param \StructType\RecordRefList $locationList
     * @return \StructType\ManufacturingRouting
     */
    public function setLocationList(\StructType\RecordRefList $locationList = null)
    {
        $this->locationList = $locationList;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ManufacturingRouting
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\ManufacturingRouting
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get isDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param bool $isDefault
     * @return \StructType\ManufacturingRouting
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\ManufacturingRouting
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get autoCalculateLag value
     * @return bool|null
     */
    public function getAutoCalculateLag()
    {
        return $this->autoCalculateLag;
    }
    /**
     * Set autoCalculateLag value
     * @param bool $autoCalculateLag
     * @return \StructType\ManufacturingRouting
     */
    public function setAutoCalculateLag($autoCalculateLag = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoCalculateLag) && !is_bool($autoCalculateLag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoCalculateLag, true), gettype($autoCalculateLag)), __LINE__);
        }
        $this->autoCalculateLag = $autoCalculateLag;
        return $this;
    }
    /**
     * Get routingStepList value
     * @return \StructType\ManufacturingRoutingRoutingStepList|null
     */
    public function getRoutingStepList()
    {
        return $this->routingStepList;
    }
    /**
     * Set routingStepList value
     * @param \StructType\ManufacturingRoutingRoutingStepList $routingStepList
     * @return \StructType\ManufacturingRouting
     */
    public function setRoutingStepList(\StructType\ManufacturingRoutingRoutingStepList $routingStepList = null)
    {
        $this->routingStepList = $routingStepList;
        return $this;
    }
    /**
     * Get routingComponentList value
     * @return \StructType\ManufacturingRoutingRoutingComponentList|null
     */
    public function getRoutingComponentList()
    {
        return $this->routingComponentList;
    }
    /**
     * Set routingComponentList value
     * @param \StructType\ManufacturingRoutingRoutingComponentList $routingComponentList
     * @return \StructType\ManufacturingRouting
     */
    public function setRoutingComponentList(\StructType\ManufacturingRoutingRoutingComponentList $routingComponentList = null)
    {
        $this->routingComponentList = $routingComponentList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ManufacturingRouting
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ManufacturingRouting
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ManufacturingRouting
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
