<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManufacturingOperationTask StructType
 * @subpackage Structs
 */
class ManufacturingOperationTask extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The manufacturingWorkCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $manufacturingWorkCenter;
    /**
     * The manufacturingCostTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $manufacturingCostTemplate;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The operationSequence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationSequence;
    /**
     * The workOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $workOrder;
    /**
     * The order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $order;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The estimatedWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedWork;
    /**
     * The actualWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $actualWork;
    /**
     * The remainingWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $remainingWork;
    /**
     * The inputQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $inputQuantity;
    /**
     * The completedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $completedQuantity;
    /**
     * The setupTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $setupTime;
    /**
     * The runRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $runRate;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The autoCalculateLag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $autoCalculateLag;
    /**
     * The machineResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $machineResources;
    /**
     * The laborResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $laborResources;
    /**
     * The costDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ManufacturingCostDetailList
     */
    public $costDetailList;
    /**
     * The predecessorList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ManufacturingOperationTaskPredecessorList
     */
    public $predecessorList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ManufacturingOperationTask
     * @uses ManufacturingOperationTask::setCustomForm()
     * @uses ManufacturingOperationTask::setManufacturingWorkCenter()
     * @uses ManufacturingOperationTask::setManufacturingCostTemplate()
     * @uses ManufacturingOperationTask::setTitle()
     * @uses ManufacturingOperationTask::setOperationSequence()
     * @uses ManufacturingOperationTask::setWorkOrder()
     * @uses ManufacturingOperationTask::setOrder()
     * @uses ManufacturingOperationTask::setStatus()
     * @uses ManufacturingOperationTask::setMessage()
     * @uses ManufacturingOperationTask::setEstimatedWork()
     * @uses ManufacturingOperationTask::setActualWork()
     * @uses ManufacturingOperationTask::setRemainingWork()
     * @uses ManufacturingOperationTask::setInputQuantity()
     * @uses ManufacturingOperationTask::setCompletedQuantity()
     * @uses ManufacturingOperationTask::setSetupTime()
     * @uses ManufacturingOperationTask::setRunRate()
     * @uses ManufacturingOperationTask::setStartDate()
     * @uses ManufacturingOperationTask::setEndDate()
     * @uses ManufacturingOperationTask::setAutoCalculateLag()
     * @uses ManufacturingOperationTask::setMachineResources()
     * @uses ManufacturingOperationTask::setLaborResources()
     * @uses ManufacturingOperationTask::setCostDetailList()
     * @uses ManufacturingOperationTask::setPredecessorList()
     * @uses ManufacturingOperationTask::setCustomFieldList()
     * @uses ManufacturingOperationTask::setInternalId()
     * @uses ManufacturingOperationTask::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $manufacturingWorkCenter
     * @param \StructType\RecordRef $manufacturingCostTemplate
     * @param string $title
     * @param int $operationSequence
     * @param \StructType\RecordRef $workOrder
     * @param \StructType\RecordRef $order
     * @param string $status
     * @param string $message
     * @param float $estimatedWork
     * @param float $actualWork
     * @param float $remainingWork
     * @param float $inputQuantity
     * @param float $completedQuantity
     * @param float $setupTime
     * @param float $runRate
     * @param string $startDate
     * @param string $endDate
     * @param bool $autoCalculateLag
     * @param float $machineResources
     * @param float $laborResources
     * @param \StructType\ManufacturingCostDetailList $costDetailList
     * @param \StructType\ManufacturingOperationTaskPredecessorList $predecessorList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, \StructType\RecordRef $manufacturingWorkCenter = null, \StructType\RecordRef $manufacturingCostTemplate = null, $title = null, $operationSequence = null, \StructType\RecordRef $workOrder = null, \StructType\RecordRef $order = null, $status = null, $message = null, $estimatedWork = null, $actualWork = null, $remainingWork = null, $inputQuantity = null, $completedQuantity = null, $setupTime = null, $runRate = null, $startDate = null, $endDate = null, $autoCalculateLag = null, $machineResources = null, $laborResources = null, \StructType\ManufacturingCostDetailList $costDetailList = null, \StructType\ManufacturingOperationTaskPredecessorList $predecessorList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setManufacturingWorkCenter($manufacturingWorkCenter)
            ->setManufacturingCostTemplate($manufacturingCostTemplate)
            ->setTitle($title)
            ->setOperationSequence($operationSequence)
            ->setWorkOrder($workOrder)
            ->setOrder($order)
            ->setStatus($status)
            ->setMessage($message)
            ->setEstimatedWork($estimatedWork)
            ->setActualWork($actualWork)
            ->setRemainingWork($remainingWork)
            ->setInputQuantity($inputQuantity)
            ->setCompletedQuantity($completedQuantity)
            ->setSetupTime($setupTime)
            ->setRunRate($runRate)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setAutoCalculateLag($autoCalculateLag)
            ->setMachineResources($machineResources)
            ->setLaborResources($laborResources)
            ->setCostDetailList($costDetailList)
            ->setPredecessorList($predecessorList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ManufacturingOperationTask
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get manufacturingWorkCenter value
     * @return \StructType\RecordRef|null
     */
    public function getManufacturingWorkCenter()
    {
        return $this->manufacturingWorkCenter;
    }
    /**
     * Set manufacturingWorkCenter value
     * @param \StructType\RecordRef $manufacturingWorkCenter
     * @return \StructType\ManufacturingOperationTask
     */
    public function setManufacturingWorkCenter(\StructType\RecordRef $manufacturingWorkCenter = null)
    {
        $this->manufacturingWorkCenter = $manufacturingWorkCenter;
        return $this;
    }
    /**
     * Get manufacturingCostTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getManufacturingCostTemplate()
    {
        return $this->manufacturingCostTemplate;
    }
    /**
     * Set manufacturingCostTemplate value
     * @param \StructType\RecordRef $manufacturingCostTemplate
     * @return \StructType\ManufacturingOperationTask
     */
    public function setManufacturingCostTemplate(\StructType\RecordRef $manufacturingCostTemplate = null)
    {
        $this->manufacturingCostTemplate = $manufacturingCostTemplate;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\ManufacturingOperationTask
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get operationSequence value
     * @return int|null
     */
    public function getOperationSequence()
    {
        return $this->operationSequence;
    }
    /**
     * Set operationSequence value
     * @param int $operationSequence
     * @return \StructType\ManufacturingOperationTask
     */
    public function setOperationSequence($operationSequence = null)
    {
        // validation for constraint: int
        if (!is_null($operationSequence) && !(is_int($operationSequence) || ctype_digit($operationSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationSequence, true), gettype($operationSequence)), __LINE__);
        }
        $this->operationSequence = $operationSequence;
        return $this;
    }
    /**
     * Get workOrder value
     * @return \StructType\RecordRef|null
     */
    public function getWorkOrder()
    {
        return $this->workOrder;
    }
    /**
     * Set workOrder value
     * @param \StructType\RecordRef $workOrder
     * @return \StructType\ManufacturingOperationTask
     */
    public function setWorkOrder(\StructType\RecordRef $workOrder = null)
    {
        $this->workOrder = $workOrder;
        return $this;
    }
    /**
     * Get order value
     * @return \StructType\RecordRef|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param \StructType\RecordRef $order
     * @return \StructType\ManufacturingOperationTask
     */
    public function setOrder(\StructType\RecordRef $order = null)
    {
        $this->order = $order;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ManufacturingOperationTaskStatus::valueIsValid()
     * @uses \EnumType\ManufacturingOperationTaskStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ManufacturingOperationTask
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ManufacturingOperationTaskStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ManufacturingOperationTaskStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ManufacturingOperationTaskStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\ManufacturingOperationTask
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get estimatedWork value
     * @return float|null
     */
    public function getEstimatedWork()
    {
        return $this->estimatedWork;
    }
    /**
     * Set estimatedWork value
     * @param float $estimatedWork
     * @return \StructType\ManufacturingOperationTask
     */
    public function setEstimatedWork($estimatedWork = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedWork) && !(is_float($estimatedWork) || is_numeric($estimatedWork))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedWork, true), gettype($estimatedWork)), __LINE__);
        }
        $this->estimatedWork = $estimatedWork;
        return $this;
    }
    /**
     * Get actualWork value
     * @return float|null
     */
    public function getActualWork()
    {
        return $this->actualWork;
    }
    /**
     * Set actualWork value
     * @param float $actualWork
     * @return \StructType\ManufacturingOperationTask
     */
    public function setActualWork($actualWork = null)
    {
        // validation for constraint: float
        if (!is_null($actualWork) && !(is_float($actualWork) || is_numeric($actualWork))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actualWork, true), gettype($actualWork)), __LINE__);
        }
        $this->actualWork = $actualWork;
        return $this;
    }
    /**
     * Get remainingWork value
     * @return float|null
     */
    public function getRemainingWork()
    {
        return $this->remainingWork;
    }
    /**
     * Set remainingWork value
     * @param float $remainingWork
     * @return \StructType\ManufacturingOperationTask
     */
    public function setRemainingWork($remainingWork = null)
    {
        // validation for constraint: float
        if (!is_null($remainingWork) && !(is_float($remainingWork) || is_numeric($remainingWork))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remainingWork, true), gettype($remainingWork)), __LINE__);
        }
        $this->remainingWork = $remainingWork;
        return $this;
    }
    /**
     * Get inputQuantity value
     * @return float|null
     */
    public function getInputQuantity()
    {
        return $this->inputQuantity;
    }
    /**
     * Set inputQuantity value
     * @param float $inputQuantity
     * @return \StructType\ManufacturingOperationTask
     */
    public function setInputQuantity($inputQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($inputQuantity) && !(is_float($inputQuantity) || is_numeric($inputQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inputQuantity, true), gettype($inputQuantity)), __LINE__);
        }
        $this->inputQuantity = $inputQuantity;
        return $this;
    }
    /**
     * Get completedQuantity value
     * @return float|null
     */
    public function getCompletedQuantity()
    {
        return $this->completedQuantity;
    }
    /**
     * Set completedQuantity value
     * @param float $completedQuantity
     * @return \StructType\ManufacturingOperationTask
     */
    public function setCompletedQuantity($completedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($completedQuantity) && !(is_float($completedQuantity) || is_numeric($completedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($completedQuantity, true), gettype($completedQuantity)), __LINE__);
        }
        $this->completedQuantity = $completedQuantity;
        return $this;
    }
    /**
     * Get setupTime value
     * @return float|null
     */
    public function getSetupTime()
    {
        return $this->setupTime;
    }
    /**
     * Set setupTime value
     * @param float $setupTime
     * @return \StructType\ManufacturingOperationTask
     */
    public function setSetupTime($setupTime = null)
    {
        // validation for constraint: float
        if (!is_null($setupTime) && !(is_float($setupTime) || is_numeric($setupTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($setupTime, true), gettype($setupTime)), __LINE__);
        }
        $this->setupTime = $setupTime;
        return $this;
    }
    /**
     * Get runRate value
     * @return float|null
     */
    public function getRunRate()
    {
        return $this->runRate;
    }
    /**
     * Set runRate value
     * @param float $runRate
     * @return \StructType\ManufacturingOperationTask
     */
    public function setRunRate($runRate = null)
    {
        // validation for constraint: float
        if (!is_null($runRate) && !(is_float($runRate) || is_numeric($runRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($runRate, true), gettype($runRate)), __LINE__);
        }
        $this->runRate = $runRate;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ManufacturingOperationTask
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ManufacturingOperationTask
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get autoCalculateLag value
     * @return bool|null
     */
    public function getAutoCalculateLag()
    {
        return $this->autoCalculateLag;
    }
    /**
     * Set autoCalculateLag value
     * @param bool $autoCalculateLag
     * @return \StructType\ManufacturingOperationTask
     */
    public function setAutoCalculateLag($autoCalculateLag = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoCalculateLag) && !is_bool($autoCalculateLag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoCalculateLag, true), gettype($autoCalculateLag)), __LINE__);
        }
        $this->autoCalculateLag = $autoCalculateLag;
        return $this;
    }
    /**
     * Get machineResources value
     * @return float|null
     */
    public function getMachineResources()
    {
        return $this->machineResources;
    }
    /**
     * Set machineResources value
     * @param float $machineResources
     * @return \StructType\ManufacturingOperationTask
     */
    public function setMachineResources($machineResources = null)
    {
        // validation for constraint: float
        if (!is_null($machineResources) && !(is_float($machineResources) || is_numeric($machineResources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($machineResources, true), gettype($machineResources)), __LINE__);
        }
        $this->machineResources = $machineResources;
        return $this;
    }
    /**
     * Get laborResources value
     * @return float|null
     */
    public function getLaborResources()
    {
        return $this->laborResources;
    }
    /**
     * Set laborResources value
     * @param float $laborResources
     * @return \StructType\ManufacturingOperationTask
     */
    public function setLaborResources($laborResources = null)
    {
        // validation for constraint: float
        if (!is_null($laborResources) && !(is_float($laborResources) || is_numeric($laborResources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laborResources, true), gettype($laborResources)), __LINE__);
        }
        $this->laborResources = $laborResources;
        return $this;
    }
    /**
     * Get costDetailList value
     * @return \StructType\ManufacturingCostDetailList|null
     */
    public function getCostDetailList()
    {
        return $this->costDetailList;
    }
    /**
     * Set costDetailList value
     * @param \StructType\ManufacturingCostDetailList $costDetailList
     * @return \StructType\ManufacturingOperationTask
     */
    public function setCostDetailList(\StructType\ManufacturingCostDetailList $costDetailList = null)
    {
        $this->costDetailList = $costDetailList;
        return $this;
    }
    /**
     * Get predecessorList value
     * @return \StructType\ManufacturingOperationTaskPredecessorList|null
     */
    public function getPredecessorList()
    {
        return $this->predecessorList;
    }
    /**
     * Set predecessorList value
     * @param \StructType\ManufacturingOperationTaskPredecessorList $predecessorList
     * @return \StructType\ManufacturingOperationTask
     */
    public function setPredecessorList(\StructType\ManufacturingOperationTaskPredecessorList $predecessorList = null)
    {
        $this->predecessorList = $predecessorList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ManufacturingOperationTask
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ManufacturingOperationTask
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ManufacturingOperationTask
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
