<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManufacturingCostDetail StructType
 * @subpackage Structs
 */
class ManufacturingCostDetail extends AbstractStructBase
{
    /**
     * The costCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $costCategory;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The fixedRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fixedRate;
    /**
     * The runRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $runRate;
    /**
     * Constructor method for ManufacturingCostDetail
     * @uses ManufacturingCostDetail::setCostCategory()
     * @uses ManufacturingCostDetail::setItem()
     * @uses ManufacturingCostDetail::setFixedRate()
     * @uses ManufacturingCostDetail::setRunRate()
     * @param \StructType\RecordRef $costCategory
     * @param \StructType\RecordRef $item
     * @param float $fixedRate
     * @param float $runRate
     */
    public function __construct(\StructType\RecordRef $costCategory = null, \StructType\RecordRef $item = null, $fixedRate = null, $runRate = null)
    {
        $this
            ->setCostCategory($costCategory)
            ->setItem($item)
            ->setFixedRate($fixedRate)
            ->setRunRate($runRate);
    }
    /**
     * Get costCategory value
     * @return \StructType\RecordRef|null
     */
    public function getCostCategory()
    {
        return $this->costCategory;
    }
    /**
     * Set costCategory value
     * @param \StructType\RecordRef $costCategory
     * @return \StructType\ManufacturingCostDetail
     */
    public function setCostCategory(\StructType\RecordRef $costCategory = null)
    {
        $this->costCategory = $costCategory;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\ManufacturingCostDetail
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get fixedRate value
     * @return float|null
     */
    public function getFixedRate()
    {
        return $this->fixedRate;
    }
    /**
     * Set fixedRate value
     * @param float $fixedRate
     * @return \StructType\ManufacturingCostDetail
     */
    public function setFixedRate($fixedRate = null)
    {
        // validation for constraint: float
        if (!is_null($fixedRate) && !(is_float($fixedRate) || is_numeric($fixedRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedRate, true), gettype($fixedRate)), __LINE__);
        }
        $this->fixedRate = $fixedRate;
        return $this;
    }
    /**
     * Get runRate value
     * @return float|null
     */
    public function getRunRate()
    {
        return $this->runRate;
    }
    /**
     * Set runRate value
     * @param float $runRate
     * @return \StructType\ManufacturingCostDetail
     */
    public function setRunRate($runRate = null)
    {
        // validation for constraint: float
        if (!is_null($runRate) && !(is_float($runRate) || is_numeric($runRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($runRate, true), gettype($runRate)), __LINE__);
        }
        $this->runRate = $runRate;
        return $this;
    }
}
