<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LotNumberedInventoryItemNumbers StructType
 * @subpackage Structs
 */
class LotNumberedInventoryItemNumbers extends AbstractStructBase
{
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $serialNumber;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * Constructor method for LotNumberedInventoryItemNumbers
     * @uses LotNumberedInventoryItemNumbers::setSerialNumber()
     * @uses LotNumberedInventoryItemNumbers::setQuantityOnHand()
     * @uses LotNumberedInventoryItemNumbers::setExpirationDate()
     * @param \StructType\RecordRef $serialNumber
     * @param float $quantityOnHand
     * @param string $expirationDate
     */
    public function __construct(\StructType\RecordRef $serialNumber = null, $quantityOnHand = null, $expirationDate = null)
    {
        $this
            ->setSerialNumber($serialNumber)
            ->setQuantityOnHand($quantityOnHand)
            ->setExpirationDate($expirationDate);
    }
    /**
     * Get serialNumber value
     * @return \StructType\RecordRef|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param \StructType\RecordRef $serialNumber
     * @return \StructType\LotNumberedInventoryItemNumbers
     */
    public function setSerialNumber(\StructType\RecordRef $serialNumber = null)
    {
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\LotNumberedInventoryItemNumbers
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\LotNumberedInventoryItemNumbers
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
}
