<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationBusinessHoursList StructType
 * @subpackage Structs
 */
class LocationBusinessHoursList extends AbstractStructBase
{
    /**
     * The locationBusinessHours
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationBusinessHours[]
     */
    public $locationBusinessHours;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for LocationBusinessHoursList
     * @uses LocationBusinessHoursList::setLocationBusinessHours()
     * @uses LocationBusinessHoursList::setReplaceAll()
     * @param \StructType\LocationBusinessHours[] $locationBusinessHours
     * @param bool $replaceAll
     */
    public function __construct(array $locationBusinessHours = array(), $replaceAll = true)
    {
        $this
            ->setLocationBusinessHours($locationBusinessHours)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get locationBusinessHours value
     * @return \StructType\LocationBusinessHours[]|null
     */
    public function getLocationBusinessHours()
    {
        return $this->locationBusinessHours;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationBusinessHours method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationBusinessHours method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationBusinessHoursForArrayConstraintsFromSetLocationBusinessHours(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationBusinessHoursListLocationBusinessHoursItem) {
            // validation for constraint: itemType
            if (!$locationBusinessHoursListLocationBusinessHoursItem instanceof \StructType\LocationBusinessHours) {
                $invalidValues[] = is_object($locationBusinessHoursListLocationBusinessHoursItem) ? get_class($locationBusinessHoursListLocationBusinessHoursItem) : sprintf('%s(%s)', gettype($locationBusinessHoursListLocationBusinessHoursItem), var_export($locationBusinessHoursListLocationBusinessHoursItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The locationBusinessHours property can only contain items of type \StructType\LocationBusinessHours, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set locationBusinessHours value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationBusinessHours[] $locationBusinessHours
     * @return \StructType\LocationBusinessHoursList
     */
    public function setLocationBusinessHours(array $locationBusinessHours = array())
    {
        // validation for constraint: array
        if ('' !== ($locationBusinessHoursArrayErrorMessage = self::validateLocationBusinessHoursForArrayConstraintsFromSetLocationBusinessHours($locationBusinessHours))) {
            throw new \InvalidArgumentException($locationBusinessHoursArrayErrorMessage, __LINE__);
        }
        $this->locationBusinessHours = $locationBusinessHours;
        return $this;
    }
    /**
     * Add item to locationBusinessHours value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationBusinessHours $item
     * @return \StructType\LocationBusinessHoursList
     */
    public function addToLocationBusinessHours(\StructType\LocationBusinessHours $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationBusinessHours) {
            throw new \InvalidArgumentException(sprintf('The locationBusinessHours property can only contain items of type \StructType\LocationBusinessHours, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->locationBusinessHours[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\LocationBusinessHoursList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
