<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:Location
 * @subpackage Structs
 */
class Location extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The tranPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranPrefix;
    /**
     * The mainAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $mainAddress;
    /**
     * The returnAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $returnAddress;
    /**
     * The locationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locationType;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $longitude;
    /**
     * The logo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $logo;
    /**
     * The useBins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useBins;
    /**
     * The makeInventoryAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $makeInventoryAvailable;
    /**
     * The makeInventoryAvailableStore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $makeInventoryAvailableStore;
    /**
     * The geolocationMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $geolocationMethod;
    /**
     * The autoAssignmentRegionSetting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $autoAssignmentRegionSetting;
    /**
     * The nextPickupCutOffTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nextPickupCutOffTime;
    /**
     * The bufferStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bufferStock;
    /**
     * The allowStorePickup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowStorePickup;
    /**
     * The storePickupBufferStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $storePickupBufferStock;
    /**
     * The dailyShippingCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dailyShippingCapacity;
    /**
     * The totalShippingCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalShippingCapacity;
    /**
     * The includeLocationRegionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationRegionsList
     */
    public $includeLocationRegionsList;
    /**
     * The excludeLocationRegionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationRegionsList
     */
    public $excludeLocationRegionsList;
    /**
     * The businessHoursList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationBusinessHoursList
     */
    public $businessHoursList;
    /**
     * The classTranslationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ClassTranslationList
     */
    public $classTranslationList;
    /**
     * The includeInControlTower
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeInControlTower;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Location
     * @uses Location::setName()
     * @uses Location::setParent()
     * @uses Location::setIncludeChildren()
     * @uses Location::setSubsidiaryList()
     * @uses Location::setIsInactive()
     * @uses Location::setTranPrefix()
     * @uses Location::setMainAddress()
     * @uses Location::setReturnAddress()
     * @uses Location::setLocationType()
     * @uses Location::setTimeZone()
     * @uses Location::setLatitude()
     * @uses Location::setLongitude()
     * @uses Location::setLogo()
     * @uses Location::setUseBins()
     * @uses Location::setMakeInventoryAvailable()
     * @uses Location::setMakeInventoryAvailableStore()
     * @uses Location::setGeolocationMethod()
     * @uses Location::setAutoAssignmentRegionSetting()
     * @uses Location::setNextPickupCutOffTime()
     * @uses Location::setBufferStock()
     * @uses Location::setAllowStorePickup()
     * @uses Location::setStorePickupBufferStock()
     * @uses Location::setDailyShippingCapacity()
     * @uses Location::setTotalShippingCapacity()
     * @uses Location::setIncludeLocationRegionsList()
     * @uses Location::setExcludeLocationRegionsList()
     * @uses Location::setBusinessHoursList()
     * @uses Location::setClassTranslationList()
     * @uses Location::setIncludeInControlTower()
     * @uses Location::setCustomFieldList()
     * @uses Location::setInternalId()
     * @uses Location::setExternalId()
     * @param string $name
     * @param \StructType\RecordRef $parent
     * @param bool $includeChildren
     * @param \StructType\RecordRefList $subsidiaryList
     * @param bool $isInactive
     * @param string $tranPrefix
     * @param \StructType\Address $mainAddress
     * @param \StructType\Address $returnAddress
     * @param string $locationType
     * @param string $timeZone
     * @param float $latitude
     * @param float $longitude
     * @param \StructType\RecordRef $logo
     * @param bool $useBins
     * @param bool $makeInventoryAvailable
     * @param bool $makeInventoryAvailableStore
     * @param string $geolocationMethod
     * @param string $autoAssignmentRegionSetting
     * @param string $nextPickupCutOffTime
     * @param int $bufferStock
     * @param bool $allowStorePickup
     * @param float $storePickupBufferStock
     * @param int $dailyShippingCapacity
     * @param int $totalShippingCapacity
     * @param \StructType\LocationRegionsList $includeLocationRegionsList
     * @param \StructType\LocationRegionsList $excludeLocationRegionsList
     * @param \StructType\LocationBusinessHoursList $businessHoursList
     * @param \StructType\ClassTranslationList $classTranslationList
     * @param bool $includeInControlTower
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, \StructType\RecordRef $parent = null, $includeChildren = null, \StructType\RecordRefList $subsidiaryList = null, $isInactive = null, $tranPrefix = null, \StructType\Address $mainAddress = null, \StructType\Address $returnAddress = null, $locationType = null, $timeZone = null, $latitude = null, $longitude = null, \StructType\RecordRef $logo = null, $useBins = null, $makeInventoryAvailable = null, $makeInventoryAvailableStore = null, $geolocationMethod = null, $autoAssignmentRegionSetting = null, $nextPickupCutOffTime = null, $bufferStock = null, $allowStorePickup = null, $storePickupBufferStock = null, $dailyShippingCapacity = null, $totalShippingCapacity = null, \StructType\LocationRegionsList $includeLocationRegionsList = null, \StructType\LocationRegionsList $excludeLocationRegionsList = null, \StructType\LocationBusinessHoursList $businessHoursList = null, \StructType\ClassTranslationList $classTranslationList = null, $includeInControlTower = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setParent($parent)
            ->setIncludeChildren($includeChildren)
            ->setSubsidiaryList($subsidiaryList)
            ->setIsInactive($isInactive)
            ->setTranPrefix($tranPrefix)
            ->setMainAddress($mainAddress)
            ->setReturnAddress($returnAddress)
            ->setLocationType($locationType)
            ->setTimeZone($timeZone)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setLogo($logo)
            ->setUseBins($useBins)
            ->setMakeInventoryAvailable($makeInventoryAvailable)
            ->setMakeInventoryAvailableStore($makeInventoryAvailableStore)
            ->setGeolocationMethod($geolocationMethod)
            ->setAutoAssignmentRegionSetting($autoAssignmentRegionSetting)
            ->setNextPickupCutOffTime($nextPickupCutOffTime)
            ->setBufferStock($bufferStock)
            ->setAllowStorePickup($allowStorePickup)
            ->setStorePickupBufferStock($storePickupBufferStock)
            ->setDailyShippingCapacity($dailyShippingCapacity)
            ->setTotalShippingCapacity($totalShippingCapacity)
            ->setIncludeLocationRegionsList($includeLocationRegionsList)
            ->setExcludeLocationRegionsList($excludeLocationRegionsList)
            ->setBusinessHoursList($businessHoursList)
            ->setClassTranslationList($classTranslationList)
            ->setIncludeInControlTower($includeInControlTower)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Location
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\Location
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\Location
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\Location
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Location
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get tranPrefix value
     * @return string|null
     */
    public function getTranPrefix()
    {
        return $this->tranPrefix;
    }
    /**
     * Set tranPrefix value
     * @param string $tranPrefix
     * @return \StructType\Location
     */
    public function setTranPrefix($tranPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($tranPrefix) && !is_string($tranPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranPrefix, true), gettype($tranPrefix)), __LINE__);
        }
        $this->tranPrefix = $tranPrefix;
        return $this;
    }
    /**
     * Get mainAddress value
     * @return \StructType\Address|null
     */
    public function getMainAddress()
    {
        return $this->mainAddress;
    }
    /**
     * Set mainAddress value
     * @param \StructType\Address $mainAddress
     * @return \StructType\Location
     */
    public function setMainAddress(\StructType\Address $mainAddress = null)
    {
        $this->mainAddress = $mainAddress;
        return $this;
    }
    /**
     * Get returnAddress value
     * @return \StructType\Address|null
     */
    public function getReturnAddress()
    {
        return $this->returnAddress;
    }
    /**
     * Set returnAddress value
     * @param \StructType\Address $returnAddress
     * @return \StructType\Location
     */
    public function setReturnAddress(\StructType\Address $returnAddress = null)
    {
        $this->returnAddress = $returnAddress;
        return $this;
    }
    /**
     * Get locationType value
     * @return string|null
     */
    public function getLocationType()
    {
        return $this->locationType;
    }
    /**
     * Set locationType value
     * @uses \EnumType\LocationType::valueIsValid()
     * @uses \EnumType\LocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locationType
     * @return \StructType\Location
     */
    public function setLocationType($locationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationType::valueIsValid($locationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LocationType', is_array($locationType) ? implode(', ', $locationType) : var_export($locationType, true), implode(', ', \EnumType\LocationType::getValidValues())), __LINE__);
        }
        $this->locationType = $locationType;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \EnumType\LocationTimeZone::valueIsValid()
     * @uses \EnumType\LocationTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \StructType\Location
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LocationTimeZone', is_array($timeZone) ? implode(', ', $timeZone) : var_export($timeZone, true), implode(', ', \EnumType\LocationTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\Location
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\Location
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get logo value
     * @return \StructType\RecordRef|null
     */
    public function getLogo()
    {
        return $this->logo;
    }
    /**
     * Set logo value
     * @param \StructType\RecordRef $logo
     * @return \StructType\Location
     */
    public function setLogo(\StructType\RecordRef $logo = null)
    {
        $this->logo = $logo;
        return $this;
    }
    /**
     * Get useBins value
     * @return bool|null
     */
    public function getUseBins()
    {
        return $this->useBins;
    }
    /**
     * Set useBins value
     * @param bool $useBins
     * @return \StructType\Location
     */
    public function setUseBins($useBins = null)
    {
        // validation for constraint: boolean
        if (!is_null($useBins) && !is_bool($useBins)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useBins, true), gettype($useBins)), __LINE__);
        }
        $this->useBins = $useBins;
        return $this;
    }
    /**
     * Get makeInventoryAvailable value
     * @return bool|null
     */
    public function getMakeInventoryAvailable()
    {
        return $this->makeInventoryAvailable;
    }
    /**
     * Set makeInventoryAvailable value
     * @param bool $makeInventoryAvailable
     * @return \StructType\Location
     */
    public function setMakeInventoryAvailable($makeInventoryAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($makeInventoryAvailable) && !is_bool($makeInventoryAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($makeInventoryAvailable, true), gettype($makeInventoryAvailable)), __LINE__);
        }
        $this->makeInventoryAvailable = $makeInventoryAvailable;
        return $this;
    }
    /**
     * Get makeInventoryAvailableStore value
     * @return bool|null
     */
    public function getMakeInventoryAvailableStore()
    {
        return $this->makeInventoryAvailableStore;
    }
    /**
     * Set makeInventoryAvailableStore value
     * @param bool $makeInventoryAvailableStore
     * @return \StructType\Location
     */
    public function setMakeInventoryAvailableStore($makeInventoryAvailableStore = null)
    {
        // validation for constraint: boolean
        if (!is_null($makeInventoryAvailableStore) && !is_bool($makeInventoryAvailableStore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($makeInventoryAvailableStore, true), gettype($makeInventoryAvailableStore)), __LINE__);
        }
        $this->makeInventoryAvailableStore = $makeInventoryAvailableStore;
        return $this;
    }
    /**
     * Get geolocationMethod value
     * @return string|null
     */
    public function getGeolocationMethod()
    {
        return $this->geolocationMethod;
    }
    /**
     * Set geolocationMethod value
     * @uses \EnumType\LocationGeolocationMethod::valueIsValid()
     * @uses \EnumType\LocationGeolocationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geolocationMethod
     * @return \StructType\Location
     */
    public function setGeolocationMethod($geolocationMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationGeolocationMethod::valueIsValid($geolocationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LocationGeolocationMethod', is_array($geolocationMethod) ? implode(', ', $geolocationMethod) : var_export($geolocationMethod, true), implode(', ', \EnumType\LocationGeolocationMethod::getValidValues())), __LINE__);
        }
        $this->geolocationMethod = $geolocationMethod;
        return $this;
    }
    /**
     * Get autoAssignmentRegionSetting value
     * @return string|null
     */
    public function getAutoAssignmentRegionSetting()
    {
        return $this->autoAssignmentRegionSetting;
    }
    /**
     * Set autoAssignmentRegionSetting value
     * @uses \EnumType\LocationAutoAssignmentRegionSetting::valueIsValid()
     * @uses \EnumType\LocationAutoAssignmentRegionSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoAssignmentRegionSetting
     * @return \StructType\Location
     */
    public function setAutoAssignmentRegionSetting($autoAssignmentRegionSetting = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationAutoAssignmentRegionSetting::valueIsValid($autoAssignmentRegionSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LocationAutoAssignmentRegionSetting', is_array($autoAssignmentRegionSetting) ? implode(', ', $autoAssignmentRegionSetting) : var_export($autoAssignmentRegionSetting, true), implode(', ', \EnumType\LocationAutoAssignmentRegionSetting::getValidValues())), __LINE__);
        }
        $this->autoAssignmentRegionSetting = $autoAssignmentRegionSetting;
        return $this;
    }
    /**
     * Get nextPickupCutOffTime value
     * @return string|null
     */
    public function getNextPickupCutOffTime()
    {
        return $this->nextPickupCutOffTime;
    }
    /**
     * Set nextPickupCutOffTime value
     * @param string $nextPickupCutOffTime
     * @return \StructType\Location
     */
    public function setNextPickupCutOffTime($nextPickupCutOffTime = null)
    {
        // validation for constraint: string
        if (!is_null($nextPickupCutOffTime) && !is_string($nextPickupCutOffTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextPickupCutOffTime, true), gettype($nextPickupCutOffTime)), __LINE__);
        }
        $this->nextPickupCutOffTime = $nextPickupCutOffTime;
        return $this;
    }
    /**
     * Get bufferStock value
     * @return int|null
     */
    public function getBufferStock()
    {
        return $this->bufferStock;
    }
    /**
     * Set bufferStock value
     * @param int $bufferStock
     * @return \StructType\Location
     */
    public function setBufferStock($bufferStock = null)
    {
        // validation for constraint: int
        if (!is_null($bufferStock) && !(is_int($bufferStock) || ctype_digit($bufferStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bufferStock, true), gettype($bufferStock)), __LINE__);
        }
        $this->bufferStock = $bufferStock;
        return $this;
    }
    /**
     * Get allowStorePickup value
     * @return bool|null
     */
    public function getAllowStorePickup()
    {
        return $this->allowStorePickup;
    }
    /**
     * Set allowStorePickup value
     * @param bool $allowStorePickup
     * @return \StructType\Location
     */
    public function setAllowStorePickup($allowStorePickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowStorePickup) && !is_bool($allowStorePickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowStorePickup, true), gettype($allowStorePickup)), __LINE__);
        }
        $this->allowStorePickup = $allowStorePickup;
        return $this;
    }
    /**
     * Get storePickupBufferStock value
     * @return float|null
     */
    public function getStorePickupBufferStock()
    {
        return $this->storePickupBufferStock;
    }
    /**
     * Set storePickupBufferStock value
     * @param float $storePickupBufferStock
     * @return \StructType\Location
     */
    public function setStorePickupBufferStock($storePickupBufferStock = null)
    {
        // validation for constraint: float
        if (!is_null($storePickupBufferStock) && !(is_float($storePickupBufferStock) || is_numeric($storePickupBufferStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($storePickupBufferStock, true), gettype($storePickupBufferStock)), __LINE__);
        }
        $this->storePickupBufferStock = $storePickupBufferStock;
        return $this;
    }
    /**
     * Get dailyShippingCapacity value
     * @return int|null
     */
    public function getDailyShippingCapacity()
    {
        return $this->dailyShippingCapacity;
    }
    /**
     * Set dailyShippingCapacity value
     * @param int $dailyShippingCapacity
     * @return \StructType\Location
     */
    public function setDailyShippingCapacity($dailyShippingCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($dailyShippingCapacity) && !(is_int($dailyShippingCapacity) || ctype_digit($dailyShippingCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dailyShippingCapacity, true), gettype($dailyShippingCapacity)), __LINE__);
        }
        $this->dailyShippingCapacity = $dailyShippingCapacity;
        return $this;
    }
    /**
     * Get totalShippingCapacity value
     * @return int|null
     */
    public function getTotalShippingCapacity()
    {
        return $this->totalShippingCapacity;
    }
    /**
     * Set totalShippingCapacity value
     * @param int $totalShippingCapacity
     * @return \StructType\Location
     */
    public function setTotalShippingCapacity($totalShippingCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($totalShippingCapacity) && !(is_int($totalShippingCapacity) || ctype_digit($totalShippingCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalShippingCapacity, true), gettype($totalShippingCapacity)), __LINE__);
        }
        $this->totalShippingCapacity = $totalShippingCapacity;
        return $this;
    }
    /**
     * Get includeLocationRegionsList value
     * @return \StructType\LocationRegionsList|null
     */
    public function getIncludeLocationRegionsList()
    {
        return $this->includeLocationRegionsList;
    }
    /**
     * Set includeLocationRegionsList value
     * @param \StructType\LocationRegionsList $includeLocationRegionsList
     * @return \StructType\Location
     */
    public function setIncludeLocationRegionsList(\StructType\LocationRegionsList $includeLocationRegionsList = null)
    {
        $this->includeLocationRegionsList = $includeLocationRegionsList;
        return $this;
    }
    /**
     * Get excludeLocationRegionsList value
     * @return \StructType\LocationRegionsList|null
     */
    public function getExcludeLocationRegionsList()
    {
        return $this->excludeLocationRegionsList;
    }
    /**
     * Set excludeLocationRegionsList value
     * @param \StructType\LocationRegionsList $excludeLocationRegionsList
     * @return \StructType\Location
     */
    public function setExcludeLocationRegionsList(\StructType\LocationRegionsList $excludeLocationRegionsList = null)
    {
        $this->excludeLocationRegionsList = $excludeLocationRegionsList;
        return $this;
    }
    /**
     * Get businessHoursList value
     * @return \StructType\LocationBusinessHoursList|null
     */
    public function getBusinessHoursList()
    {
        return $this->businessHoursList;
    }
    /**
     * Set businessHoursList value
     * @param \StructType\LocationBusinessHoursList $businessHoursList
     * @return \StructType\Location
     */
    public function setBusinessHoursList(\StructType\LocationBusinessHoursList $businessHoursList = null)
    {
        $this->businessHoursList = $businessHoursList;
        return $this;
    }
    /**
     * Get classTranslationList value
     * @return \StructType\ClassTranslationList|null
     */
    public function getClassTranslationList()
    {
        return $this->classTranslationList;
    }
    /**
     * Set classTranslationList value
     * @param \StructType\ClassTranslationList $classTranslationList
     * @return \StructType\Location
     */
    public function setClassTranslationList(\StructType\ClassTranslationList $classTranslationList = null)
    {
        $this->classTranslationList = $classTranslationList;
        return $this;
    }
    /**
     * Get includeInControlTower value
     * @return bool|null
     */
    public function getIncludeInControlTower()
    {
        return $this->includeInControlTower;
    }
    /**
     * Set includeInControlTower value
     * @param bool $includeInControlTower
     * @return \StructType\Location
     */
    public function setIncludeInControlTower($includeInControlTower = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInControlTower) && !is_bool($includeInControlTower)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInControlTower, true), gettype($includeInControlTower)), __LINE__);
        }
        $this->includeInControlTower = $includeInControlTower;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Location
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Location
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Location
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
