<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguageValueList StructType
 * @subpackage Structs
 */
class LanguageValueList extends AbstractStructBase
{
    /**
     * The languageValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LanguageValue[]
     */
    public $languageValue;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for LanguageValueList
     * @uses LanguageValueList::setLanguageValue()
     * @uses LanguageValueList::setReplaceAll()
     * @param \StructType\LanguageValue[] $languageValue
     * @param bool $replaceAll
     */
    public function __construct(array $languageValue = array(), $replaceAll = true)
    {
        $this
            ->setLanguageValue($languageValue)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get languageValue value
     * @return \StructType\LanguageValue[]|null
     */
    public function getLanguageValue()
    {
        return $this->languageValue;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguageValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguageValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageValueForArrayConstraintsFromSetLanguageValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $languageValueListLanguageValueItem) {
            // validation for constraint: itemType
            if (!$languageValueListLanguageValueItem instanceof \StructType\LanguageValue) {
                $invalidValues[] = is_object($languageValueListLanguageValueItem) ? get_class($languageValueListLanguageValueItem) : sprintf('%s(%s)', gettype($languageValueListLanguageValueItem), var_export($languageValueListLanguageValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The languageValue property can only contain items of type \StructType\LanguageValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set languageValue value
     * @throws \InvalidArgumentException
     * @param \StructType\LanguageValue[] $languageValue
     * @return \StructType\LanguageValueList
     */
    public function setLanguageValue(array $languageValue = array())
    {
        // validation for constraint: array
        if ('' !== ($languageValueArrayErrorMessage = self::validateLanguageValueForArrayConstraintsFromSetLanguageValue($languageValue))) {
            throw new \InvalidArgumentException($languageValueArrayErrorMessage, __LINE__);
        }
        $this->languageValue = $languageValue;
        return $this;
    }
    /**
     * Add item to languageValue value
     * @throws \InvalidArgumentException
     * @param \StructType\LanguageValue $item
     * @return \StructType\LanguageValueList
     */
    public function addToLanguageValue(\StructType\LanguageValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LanguageValue) {
            throw new \InvalidArgumentException(sprintf('The languageValue property can only contain items of type \StructType\LanguageValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->languageValue[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\LanguageValueList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
