<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LandedCostSummary StructType
 * @subpackage Structs
 */
class LandedCostSummary extends AbstractStructBase
{
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The transaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transaction;
    /**
     * Constructor method for LandedCostSummary
     * @uses LandedCostSummary::setCategory()
     * @uses LandedCostSummary::setAmount()
     * @uses LandedCostSummary::setSource()
     * @uses LandedCostSummary::setTransaction()
     * @param \StructType\RecordRef $category
     * @param float $amount
     * @param string $source
     * @param \StructType\RecordRef $transaction
     */
    public function __construct(\StructType\RecordRef $category = null, $amount = null, $source = null, \StructType\RecordRef $transaction = null)
    {
        $this
            ->setCategory($category)
            ->setAmount($amount)
            ->setSource($source)
            ->setTransaction($transaction);
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\LandedCostSummary
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\LandedCostSummary
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @uses \EnumType\LandedCostSource::valueIsValid()
     * @uses \EnumType\LandedCostSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\LandedCostSummary
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LandedCostSource::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LandedCostSource', is_array($source) ? implode(', ', $source) : var_export($source, true), implode(', ', \EnumType\LandedCostSource::getValidValues())), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get transaction value
     * @return \StructType\RecordRef|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @param \StructType\RecordRef $transaction
     * @return \StructType\LandedCostSummary
     */
    public function setTransaction(\StructType\RecordRef $transaction = null)
    {
        $this->transaction = $transaction;
        return $this;
    }
}
