<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LandedCostDataList StructType
 * @subpackage Structs
 */
class LandedCostDataList extends AbstractStructBase
{
    /**
     * The landedCostData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LandedCostData[]
     */
    public $landedCostData;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for LandedCostDataList
     * @uses LandedCostDataList::setLandedCostData()
     * @uses LandedCostDataList::setReplaceAll()
     * @param \StructType\LandedCostData[] $landedCostData
     * @param bool $replaceAll
     */
    public function __construct(array $landedCostData = array(), $replaceAll = false)
    {
        $this
            ->setLandedCostData($landedCostData)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get landedCostData value
     * @return \StructType\LandedCostData[]|null
     */
    public function getLandedCostData()
    {
        return $this->landedCostData;
    }
    /**
     * This method is responsible for validating the values passed to the setLandedCostData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandedCostData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandedCostDataForArrayConstraintsFromSetLandedCostData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $landedCostDataListLandedCostDataItem) {
            // validation for constraint: itemType
            if (!$landedCostDataListLandedCostDataItem instanceof \StructType\LandedCostData) {
                $invalidValues[] = is_object($landedCostDataListLandedCostDataItem) ? get_class($landedCostDataListLandedCostDataItem) : sprintf('%s(%s)', gettype($landedCostDataListLandedCostDataItem), var_export($landedCostDataListLandedCostDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landedCostData property can only contain items of type \StructType\LandedCostData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landedCostData value
     * @throws \InvalidArgumentException
     * @param \StructType\LandedCostData[] $landedCostData
     * @return \StructType\LandedCostDataList
     */
    public function setLandedCostData(array $landedCostData = array())
    {
        // validation for constraint: array
        if ('' !== ($landedCostDataArrayErrorMessage = self::validateLandedCostDataForArrayConstraintsFromSetLandedCostData($landedCostData))) {
            throw new \InvalidArgumentException($landedCostDataArrayErrorMessage, __LINE__);
        }
        $this->landedCostData = $landedCostData;
        return $this;
    }
    /**
     * Add item to landedCostData value
     * @throws \InvalidArgumentException
     * @param \StructType\LandedCostData $item
     * @return \StructType\LandedCostDataList
     */
    public function addToLandedCostData(\StructType\LandedCostData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LandedCostData) {
            throw new \InvalidArgumentException(sprintf('The landedCostData property can only contain items of type \StructType\LandedCostData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landedCostData[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\LandedCostDataList
     */
    public function setReplaceAll($replaceAll = false)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
