<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitItem StructType
 * @subpackage Structs
 */
class KitItem extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The upcCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upcCode;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The printItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $printItems;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The isGcoCompliant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isGcoCompliant;
    /**
     * The offerSupport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $offerSupport;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The availableToPartners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableToPartners;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The incomeAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incomeAccount;
    /**
     * The taxSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxSchedule;
    /**
     * The shippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingCost;
    /**
     * The handlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingCost;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deferRevRec;
    /**
     * The revenueRecognitionRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueRecognitionRule;
    /**
     * The revRecForecastRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecForecastRule;
    /**
     * The revenueAllocationGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueAllocationGroup;
    /**
     * The createRevenuePlansOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createRevenuePlansOn;
    /**
     * The directRevenuePosting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $directRevenuePosting;
    /**
     * The contingentRevenueHandling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $contingentRevenueHandling;
    /**
     * The revReclassFXAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revReclassFXAccount;
    /**
     * The salesTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesTaxCode;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * The weightUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $weightUnit;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The deferredRevenueAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deferredRevenueAccount;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The stockDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stockDescription;
    /**
     * The producer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $producer;
    /**
     * The manufacturer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufacturer;
    /**
     * The mpn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mpn;
    /**
     * The multManufactureAddr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $multManufactureAddr;
    /**
     * The manufactureraddr1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufactureraddr1;
    /**
     * The manufacturerCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerCity;
    /**
     * The manufacturerState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerState;
    /**
     * The manufacturerZip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerZip;
    /**
     * The countryOfManufacture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryOfManufacture;
    /**
     * The defaultItemShipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $defaultItemShipMethod;
    /**
     * The itemCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemCarrier;
    /**
     * The itemShipMethodList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $itemShipMethodList;
    /**
     * The manufacturerTaxId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerTaxId;
    /**
     * The scheduleBNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scheduleBNumber;
    /**
     * The scheduleBQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $scheduleBQuantity;
    /**
     * The scheduleBCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $scheduleBCode;
    /**
     * The manufacturerTariff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerTariff;
    /**
     * The preferenceCriterion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $preferenceCriterion;
    /**
     * The issueProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueProduct;
    /**
     * The minimumQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $minimumQuantity;
    /**
     * The enforceMinQtyInternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enforceMinQtyInternally;
    /**
     * The maximumQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maximumQuantity;
    /**
     * The softDescriptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $softDescriptor;
    /**
     * The isFulfillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFulfillable;
    /**
     * The pricesIncludeTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $pricesIncludeTax;
    /**
     * The quantityPricingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $quantityPricingSchedule;
    /**
     * The useMarginalRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useMarginalRates;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The isHazmatItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isHazmatItem;
    /**
     * The hazmatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hazmatId;
    /**
     * The hazmatShippingName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hazmatShippingName;
    /**
     * The hazmatHazardClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hazmatHazardClass;
    /**
     * The hazmatPackingGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hazmatPackingGroup;
    /**
     * The hazmatItemUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hazmatItemUnits;
    /**
     * The hazmatItemUnitsQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $hazmatItemUnitsQty;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The overallQuantityPricingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $overallQuantityPricingType;
    /**
     * The pricingGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $pricingGroup;
    /**
     * The vsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoePrice;
    /**
     * The vsoeSopGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeSopGroup;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The itemRevenueCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemRevenueCategory;
    /**
     * The shipIndividually
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $shipIndividually;
    /**
     * The shipPackage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipPackage;
    /**
     * The storeDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDisplayName;
    /**
     * The storeDisplayThumbnail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeDisplayThumbnail;
    /**
     * The outOfStockMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outOfStockMessage;
    /**
     * The storeDisplayImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeDisplayImage;
    /**
     * The storeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDescription;
    /**
     * The storeDetailedDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDetailedDescription;
    /**
     * The storeItemTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeItemTemplate;
    /**
     * The pageTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageTitle;
    /**
     * The urlComponent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $urlComponent;
    /**
     * The metaTagHtml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $metaTagHtml;
    /**
     * The excludeFromSitemap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeFromSitemap;
    /**
     * The sitemapPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sitemapPriority;
    /**
     * The searchKeywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchKeywords;
    /**
     * The itemOptionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemOptionsList
     */
    public $itemOptionsList;
    /**
     * The isDonationItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDonationItem;
    /**
     * The showDefaultDonationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showDefaultDonationAmount;
    /**
     * The maxDonationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $maxDonationAmount;
    /**
     * The dontShowPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $dontShowPrice;
    /**
     * The noPriceMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $noPriceMessage;
    /**
     * The shoppingDotComCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shoppingDotComCategory;
    /**
     * The shopzillaCategoryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shopzillaCategoryId;
    /**
     * The outOfStockBehavior
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outOfStockBehavior;
    /**
     * The nexTagCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nexTagCategory;
    /**
     * The productFeedList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProductFeedList
     */
    public $productFeedList;
    /**
     * The relatedItemsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relatedItemsDescription;
    /**
     * The onSpecial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $onSpecial;
    /**
     * The specialsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specialsDescription;
    /**
     * The featuredDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $featuredDescription;
    /**
     * The pricingMatrix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingMatrix
     */
    public $pricingMatrix;
    /**
     * The siteCategoryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SiteCategoryList
     */
    public $siteCategoryList;
    /**
     * The memberList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemMemberList
     */
    public $memberList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemAccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TranslationList
     */
    public $translationsList;
    /**
     * The presentationItemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PresentationItemList
     */
    public $presentationItemList;
    /**
     * The hierarchyVersionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\KitItemHierarchyVersionsList
     */
    public $hierarchyVersionsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for KitItem
     * @uses KitItem::setCreatedDate()
     * @uses KitItem::setLastModifiedDate()
     * @uses KitItem::setCustomForm()
     * @uses KitItem::setItemId()
     * @uses KitItem::setUpcCode()
     * @uses KitItem::setDisplayName()
     * @uses KitItem::setParent()
     * @uses KitItem::setPrintItems()
     * @uses KitItem::setIsOnline()
     * @uses KitItem::setIsGcoCompliant()
     * @uses KitItem::setOfferSupport()
     * @uses KitItem::setIsInactive()
     * @uses KitItem::setAvailableToPartners()
     * @uses KitItem::setDepartment()
     * @uses KitItem::setSubsidiaryList()
     * @uses KitItem::setClass()
     * @uses KitItem::setIncludeChildren()
     * @uses KitItem::setLocation()
     * @uses KitItem::setDescription()
     * @uses KitItem::setIncomeAccount()
     * @uses KitItem::setTaxSchedule()
     * @uses KitItem::setShippingCost()
     * @uses KitItem::setHandlingCost()
     * @uses KitItem::setIsTaxable()
     * @uses KitItem::setDeferRevRec()
     * @uses KitItem::setRevenueRecognitionRule()
     * @uses KitItem::setRevRecForecastRule()
     * @uses KitItem::setRevenueAllocationGroup()
     * @uses KitItem::setCreateRevenuePlansOn()
     * @uses KitItem::setDirectRevenuePosting()
     * @uses KitItem::setContingentRevenueHandling()
     * @uses KitItem::setRevReclassFXAccount()
     * @uses KitItem::setSalesTaxCode()
     * @uses KitItem::setWeight()
     * @uses KitItem::setWeightUnit()
     * @uses KitItem::setRate()
     * @uses KitItem::setBillingSchedule()
     * @uses KitItem::setDeferredRevenueAccount()
     * @uses KitItem::setRevRecSchedule()
     * @uses KitItem::setStockDescription()
     * @uses KitItem::setProducer()
     * @uses KitItem::setManufacturer()
     * @uses KitItem::setMpn()
     * @uses KitItem::setMultManufactureAddr()
     * @uses KitItem::setManufactureraddr1()
     * @uses KitItem::setManufacturerCity()
     * @uses KitItem::setManufacturerState()
     * @uses KitItem::setManufacturerZip()
     * @uses KitItem::setCountryOfManufacture()
     * @uses KitItem::setDefaultItemShipMethod()
     * @uses KitItem::setItemCarrier()
     * @uses KitItem::setItemShipMethodList()
     * @uses KitItem::setManufacturerTaxId()
     * @uses KitItem::setScheduleBNumber()
     * @uses KitItem::setScheduleBQuantity()
     * @uses KitItem::setScheduleBCode()
     * @uses KitItem::setManufacturerTariff()
     * @uses KitItem::setPreferenceCriterion()
     * @uses KitItem::setIssueProduct()
     * @uses KitItem::setMinimumQuantity()
     * @uses KitItem::setEnforceMinQtyInternally()
     * @uses KitItem::setMaximumQuantity()
     * @uses KitItem::setSoftDescriptor()
     * @uses KitItem::setIsFulfillable()
     * @uses KitItem::setPricesIncludeTax()
     * @uses KitItem::setQuantityPricingSchedule()
     * @uses KitItem::setUseMarginalRates()
     * @uses KitItem::setCostEstimateType()
     * @uses KitItem::setIsHazmatItem()
     * @uses KitItem::setHazmatId()
     * @uses KitItem::setHazmatShippingName()
     * @uses KitItem::setHazmatHazardClass()
     * @uses KitItem::setHazmatPackingGroup()
     * @uses KitItem::setHazmatItemUnits()
     * @uses KitItem::setHazmatItemUnitsQty()
     * @uses KitItem::setCostEstimate()
     * @uses KitItem::setOverallQuantityPricingType()
     * @uses KitItem::setPricingGroup()
     * @uses KitItem::setVsoePrice()
     * @uses KitItem::setVsoeSopGroup()
     * @uses KitItem::setVsoeDeferral()
     * @uses KitItem::setVsoePermitDiscount()
     * @uses KitItem::setVsoeDelivered()
     * @uses KitItem::setItemRevenueCategory()
     * @uses KitItem::setShipIndividually()
     * @uses KitItem::setShipPackage()
     * @uses KitItem::setStoreDisplayName()
     * @uses KitItem::setStoreDisplayThumbnail()
     * @uses KitItem::setOutOfStockMessage()
     * @uses KitItem::setStoreDisplayImage()
     * @uses KitItem::setStoreDescription()
     * @uses KitItem::setStoreDetailedDescription()
     * @uses KitItem::setStoreItemTemplate()
     * @uses KitItem::setPageTitle()
     * @uses KitItem::setUrlComponent()
     * @uses KitItem::setMetaTagHtml()
     * @uses KitItem::setExcludeFromSitemap()
     * @uses KitItem::setSitemapPriority()
     * @uses KitItem::setSearchKeywords()
     * @uses KitItem::setItemOptionsList()
     * @uses KitItem::setIsDonationItem()
     * @uses KitItem::setShowDefaultDonationAmount()
     * @uses KitItem::setMaxDonationAmount()
     * @uses KitItem::setDontShowPrice()
     * @uses KitItem::setNoPriceMessage()
     * @uses KitItem::setShoppingDotComCategory()
     * @uses KitItem::setShopzillaCategoryId()
     * @uses KitItem::setOutOfStockBehavior()
     * @uses KitItem::setNexTagCategory()
     * @uses KitItem::setProductFeedList()
     * @uses KitItem::setRelatedItemsDescription()
     * @uses KitItem::setOnSpecial()
     * @uses KitItem::setSpecialsDescription()
     * @uses KitItem::setFeaturedDescription()
     * @uses KitItem::setPricingMatrix()
     * @uses KitItem::setSiteCategoryList()
     * @uses KitItem::setMemberList()
     * @uses KitItem::setAccountingBookDetailList()
     * @uses KitItem::setTranslationsList()
     * @uses KitItem::setPresentationItemList()
     * @uses KitItem::setHierarchyVersionsList()
     * @uses KitItem::setCustomFieldList()
     * @uses KitItem::setInternalId()
     * @uses KitItem::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param string $itemId
     * @param string $upcCode
     * @param string $displayName
     * @param \StructType\RecordRef $parent
     * @param bool $printItems
     * @param bool $isOnline
     * @param bool $isGcoCompliant
     * @param bool $offerSupport
     * @param bool $isInactive
     * @param bool $availableToPartners
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRefList $subsidiaryList
     * @param \StructType\RecordRef $class
     * @param bool $includeChildren
     * @param \StructType\RecordRef $location
     * @param string $description
     * @param \StructType\RecordRef $incomeAccount
     * @param \StructType\RecordRef $taxSchedule
     * @param float $shippingCost
     * @param float $handlingCost
     * @param bool $isTaxable
     * @param bool $deferRevRec
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @param \StructType\RecordRef $revRecForecastRule
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @param bool $directRevenuePosting
     * @param bool $contingentRevenueHandling
     * @param \StructType\RecordRef $revReclassFXAccount
     * @param \StructType\RecordRef $salesTaxCode
     * @param float $weight
     * @param \StructType\RecordRef $weightUnit
     * @param float $rate
     * @param \StructType\RecordRef $billingSchedule
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @param \StructType\RecordRef $revRecSchedule
     * @param string $stockDescription
     * @param bool $producer
     * @param string $manufacturer
     * @param string $mpn
     * @param bool $multManufactureAddr
     * @param string $manufactureraddr1
     * @param string $manufacturerCity
     * @param string $manufacturerState
     * @param string $manufacturerZip
     * @param string $countryOfManufacture
     * @param \StructType\RecordRef $defaultItemShipMethod
     * @param string $itemCarrier
     * @param \StructType\RecordRefList $itemShipMethodList
     * @param string $manufacturerTaxId
     * @param string $scheduleBNumber
     * @param int $scheduleBQuantity
     * @param \StructType\RecordRef $scheduleBCode
     * @param string $manufacturerTariff
     * @param string $preferenceCriterion
     * @param \StructType\RecordRef $issueProduct
     * @param int $minimumQuantity
     * @param bool $enforceMinQtyInternally
     * @param int $maximumQuantity
     * @param \StructType\RecordRef $softDescriptor
     * @param bool $isFulfillable
     * @param bool $pricesIncludeTax
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @param bool $useMarginalRates
     * @param string $costEstimateType
     * @param bool $isHazmatItem
     * @param string $hazmatId
     * @param string $hazmatShippingName
     * @param string $hazmatHazardClass
     * @param string $hazmatPackingGroup
     * @param string $hazmatItemUnits
     * @param float $hazmatItemUnitsQty
     * @param float $costEstimate
     * @param string $overallQuantityPricingType
     * @param \StructType\RecordRef $pricingGroup
     * @param float $vsoePrice
     * @param string $vsoeSopGroup
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param \StructType\RecordRef $itemRevenueCategory
     * @param bool $shipIndividually
     * @param \StructType\RecordRef $shipPackage
     * @param string $storeDisplayName
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @param string $outOfStockMessage
     * @param \StructType\RecordRef $storeDisplayImage
     * @param string $storeDescription
     * @param string $storeDetailedDescription
     * @param \StructType\RecordRef $storeItemTemplate
     * @param string $pageTitle
     * @param string $urlComponent
     * @param string $metaTagHtml
     * @param bool $excludeFromSitemap
     * @param string $sitemapPriority
     * @param string $searchKeywords
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @param bool $isDonationItem
     * @param bool $showDefaultDonationAmount
     * @param float $maxDonationAmount
     * @param bool $dontShowPrice
     * @param string $noPriceMessage
     * @param string $shoppingDotComCategory
     * @param int $shopzillaCategoryId
     * @param string $outOfStockBehavior
     * @param string $nexTagCategory
     * @param \StructType\ProductFeedList $productFeedList
     * @param string $relatedItemsDescription
     * @param bool $onSpecial
     * @param string $specialsDescription
     * @param string $featuredDescription
     * @param \StructType\PricingMatrix $pricingMatrix
     * @param \StructType\SiteCategoryList $siteCategoryList
     * @param \StructType\ItemMemberList $memberList
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @param \StructType\TranslationList $translationsList
     * @param \StructType\PresentationItemList $presentationItemList
     * @param \StructType\KitItemHierarchyVersionsList $hierarchyVersionsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, $itemId = null, $upcCode = null, $displayName = null, \StructType\RecordRef $parent = null, $printItems = null, $isOnline = null, $isGcoCompliant = null, $offerSupport = null, $isInactive = null, $availableToPartners = null, \StructType\RecordRef $department = null, \StructType\RecordRefList $subsidiaryList = null, \StructType\RecordRef $class = null, $includeChildren = null, \StructType\RecordRef $location = null, $description = null, \StructType\RecordRef $incomeAccount = null, \StructType\RecordRef $taxSchedule = null, $shippingCost = null, $handlingCost = null, $isTaxable = null, $deferRevRec = null, \StructType\RecordRef $revenueRecognitionRule = null, \StructType\RecordRef $revRecForecastRule = null, \StructType\RecordRef $revenueAllocationGroup = null, \StructType\RecordRef $createRevenuePlansOn = null, $directRevenuePosting = null, $contingentRevenueHandling = null, \StructType\RecordRef $revReclassFXAccount = null, \StructType\RecordRef $salesTaxCode = null, $weight = null, \StructType\RecordRef $weightUnit = null, $rate = null, \StructType\RecordRef $billingSchedule = null, \StructType\RecordRef $deferredRevenueAccount = null, \StructType\RecordRef $revRecSchedule = null, $stockDescription = null, $producer = null, $manufacturer = null, $mpn = null, $multManufactureAddr = null, $manufactureraddr1 = null, $manufacturerCity = null, $manufacturerState = null, $manufacturerZip = null, $countryOfManufacture = null, \StructType\RecordRef $defaultItemShipMethod = null, $itemCarrier = null, \StructType\RecordRefList $itemShipMethodList = null, $manufacturerTaxId = null, $scheduleBNumber = null, $scheduleBQuantity = null, \StructType\RecordRef $scheduleBCode = null, $manufacturerTariff = null, $preferenceCriterion = null, \StructType\RecordRef $issueProduct = null, $minimumQuantity = null, $enforceMinQtyInternally = null, $maximumQuantity = null, \StructType\RecordRef $softDescriptor = null, $isFulfillable = null, $pricesIncludeTax = null, \StructType\RecordRef $quantityPricingSchedule = null, $useMarginalRates = null, $costEstimateType = null, $isHazmatItem = null, $hazmatId = null, $hazmatShippingName = null, $hazmatHazardClass = null, $hazmatPackingGroup = null, $hazmatItemUnits = null, $hazmatItemUnitsQty = null, $costEstimate = null, $overallQuantityPricingType = null, \StructType\RecordRef $pricingGroup = null, $vsoePrice = null, $vsoeSopGroup = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, \StructType\RecordRef $itemRevenueCategory = null, $shipIndividually = null, \StructType\RecordRef $shipPackage = null, $storeDisplayName = null, \StructType\RecordRef $storeDisplayThumbnail = null, $outOfStockMessage = null, \StructType\RecordRef $storeDisplayImage = null, $storeDescription = null, $storeDetailedDescription = null, \StructType\RecordRef $storeItemTemplate = null, $pageTitle = null, $urlComponent = null, $metaTagHtml = null, $excludeFromSitemap = null, $sitemapPriority = null, $searchKeywords = null, \StructType\ItemOptionsList $itemOptionsList = null, $isDonationItem = null, $showDefaultDonationAmount = null, $maxDonationAmount = null, $dontShowPrice = null, $noPriceMessage = null, $shoppingDotComCategory = null, $shopzillaCategoryId = null, $outOfStockBehavior = null, $nexTagCategory = null, \StructType\ProductFeedList $productFeedList = null, $relatedItemsDescription = null, $onSpecial = null, $specialsDescription = null, $featuredDescription = null, \StructType\PricingMatrix $pricingMatrix = null, \StructType\SiteCategoryList $siteCategoryList = null, \StructType\ItemMemberList $memberList = null, \StructType\ItemAccountingBookDetailList $accountingBookDetailList = null, \StructType\TranslationList $translationsList = null, \StructType\PresentationItemList $presentationItemList = null, \StructType\KitItemHierarchyVersionsList $hierarchyVersionsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setItemId($itemId)
            ->setUpcCode($upcCode)
            ->setDisplayName($displayName)
            ->setParent($parent)
            ->setPrintItems($printItems)
            ->setIsOnline($isOnline)
            ->setIsGcoCompliant($isGcoCompliant)
            ->setOfferSupport($offerSupport)
            ->setIsInactive($isInactive)
            ->setAvailableToPartners($availableToPartners)
            ->setDepartment($department)
            ->setSubsidiaryList($subsidiaryList)
            ->setClass($class)
            ->setIncludeChildren($includeChildren)
            ->setLocation($location)
            ->setDescription($description)
            ->setIncomeAccount($incomeAccount)
            ->setTaxSchedule($taxSchedule)
            ->setShippingCost($shippingCost)
            ->setHandlingCost($handlingCost)
            ->setIsTaxable($isTaxable)
            ->setDeferRevRec($deferRevRec)
            ->setRevenueRecognitionRule($revenueRecognitionRule)
            ->setRevRecForecastRule($revRecForecastRule)
            ->setRevenueAllocationGroup($revenueAllocationGroup)
            ->setCreateRevenuePlansOn($createRevenuePlansOn)
            ->setDirectRevenuePosting($directRevenuePosting)
            ->setContingentRevenueHandling($contingentRevenueHandling)
            ->setRevReclassFXAccount($revReclassFXAccount)
            ->setSalesTaxCode($salesTaxCode)
            ->setWeight($weight)
            ->setWeightUnit($weightUnit)
            ->setRate($rate)
            ->setBillingSchedule($billingSchedule)
            ->setDeferredRevenueAccount($deferredRevenueAccount)
            ->setRevRecSchedule($revRecSchedule)
            ->setStockDescription($stockDescription)
            ->setProducer($producer)
            ->setManufacturer($manufacturer)
            ->setMpn($mpn)
            ->setMultManufactureAddr($multManufactureAddr)
            ->setManufactureraddr1($manufactureraddr1)
            ->setManufacturerCity($manufacturerCity)
            ->setManufacturerState($manufacturerState)
            ->setManufacturerZip($manufacturerZip)
            ->setCountryOfManufacture($countryOfManufacture)
            ->setDefaultItemShipMethod($defaultItemShipMethod)
            ->setItemCarrier($itemCarrier)
            ->setItemShipMethodList($itemShipMethodList)
            ->setManufacturerTaxId($manufacturerTaxId)
            ->setScheduleBNumber($scheduleBNumber)
            ->setScheduleBQuantity($scheduleBQuantity)
            ->setScheduleBCode($scheduleBCode)
            ->setManufacturerTariff($manufacturerTariff)
            ->setPreferenceCriterion($preferenceCriterion)
            ->setIssueProduct($issueProduct)
            ->setMinimumQuantity($minimumQuantity)
            ->setEnforceMinQtyInternally($enforceMinQtyInternally)
            ->setMaximumQuantity($maximumQuantity)
            ->setSoftDescriptor($softDescriptor)
            ->setIsFulfillable($isFulfillable)
            ->setPricesIncludeTax($pricesIncludeTax)
            ->setQuantityPricingSchedule($quantityPricingSchedule)
            ->setUseMarginalRates($useMarginalRates)
            ->setCostEstimateType($costEstimateType)
            ->setIsHazmatItem($isHazmatItem)
            ->setHazmatId($hazmatId)
            ->setHazmatShippingName($hazmatShippingName)
            ->setHazmatHazardClass($hazmatHazardClass)
            ->setHazmatPackingGroup($hazmatPackingGroup)
            ->setHazmatItemUnits($hazmatItemUnits)
            ->setHazmatItemUnitsQty($hazmatItemUnitsQty)
            ->setCostEstimate($costEstimate)
            ->setOverallQuantityPricingType($overallQuantityPricingType)
            ->setPricingGroup($pricingGroup)
            ->setVsoePrice($vsoePrice)
            ->setVsoeSopGroup($vsoeSopGroup)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setItemRevenueCategory($itemRevenueCategory)
            ->setShipIndividually($shipIndividually)
            ->setShipPackage($shipPackage)
            ->setStoreDisplayName($storeDisplayName)
            ->setStoreDisplayThumbnail($storeDisplayThumbnail)
            ->setOutOfStockMessage($outOfStockMessage)
            ->setStoreDisplayImage($storeDisplayImage)
            ->setStoreDescription($storeDescription)
            ->setStoreDetailedDescription($storeDetailedDescription)
            ->setStoreItemTemplate($storeItemTemplate)
            ->setPageTitle($pageTitle)
            ->setUrlComponent($urlComponent)
            ->setMetaTagHtml($metaTagHtml)
            ->setExcludeFromSitemap($excludeFromSitemap)
            ->setSitemapPriority($sitemapPriority)
            ->setSearchKeywords($searchKeywords)
            ->setItemOptionsList($itemOptionsList)
            ->setIsDonationItem($isDonationItem)
            ->setShowDefaultDonationAmount($showDefaultDonationAmount)
            ->setMaxDonationAmount($maxDonationAmount)
            ->setDontShowPrice($dontShowPrice)
            ->setNoPriceMessage($noPriceMessage)
            ->setShoppingDotComCategory($shoppingDotComCategory)
            ->setShopzillaCategoryId($shopzillaCategoryId)
            ->setOutOfStockBehavior($outOfStockBehavior)
            ->setNexTagCategory($nexTagCategory)
            ->setProductFeedList($productFeedList)
            ->setRelatedItemsDescription($relatedItemsDescription)
            ->setOnSpecial($onSpecial)
            ->setSpecialsDescription($specialsDescription)
            ->setFeaturedDescription($featuredDescription)
            ->setPricingMatrix($pricingMatrix)
            ->setSiteCategoryList($siteCategoryList)
            ->setMemberList($memberList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setTranslationsList($translationsList)
            ->setPresentationItemList($presentationItemList)
            ->setHierarchyVersionsList($hierarchyVersionsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\KitItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\KitItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\KitItem
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\KitItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get upcCode value
     * @return string|null
     */
    public function getUpcCode()
    {
        return $this->upcCode;
    }
    /**
     * Set upcCode value
     * @param string $upcCode
     * @return \StructType\KitItem
     */
    public function setUpcCode($upcCode = null)
    {
        // validation for constraint: string
        if (!is_null($upcCode) && !is_string($upcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upcCode, true), gettype($upcCode)), __LINE__);
        }
        $this->upcCode = $upcCode;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\KitItem
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\KitItem
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get printItems value
     * @return bool|null
     */
    public function getPrintItems()
    {
        return $this->printItems;
    }
    /**
     * Set printItems value
     * @param bool $printItems
     * @return \StructType\KitItem
     */
    public function setPrintItems($printItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($printItems) && !is_bool($printItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printItems, true), gettype($printItems)), __LINE__);
        }
        $this->printItems = $printItems;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\KitItem
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get isGcoCompliant value
     * @return bool|null
     */
    public function getIsGcoCompliant()
    {
        return $this->isGcoCompliant;
    }
    /**
     * Set isGcoCompliant value
     * @param bool $isGcoCompliant
     * @return \StructType\KitItem
     */
    public function setIsGcoCompliant($isGcoCompliant = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGcoCompliant) && !is_bool($isGcoCompliant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGcoCompliant, true), gettype($isGcoCompliant)), __LINE__);
        }
        $this->isGcoCompliant = $isGcoCompliant;
        return $this;
    }
    /**
     * Get offerSupport value
     * @return bool|null
     */
    public function getOfferSupport()
    {
        return $this->offerSupport;
    }
    /**
     * Set offerSupport value
     * @param bool $offerSupport
     * @return \StructType\KitItem
     */
    public function setOfferSupport($offerSupport = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerSupport) && !is_bool($offerSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerSupport, true), gettype($offerSupport)), __LINE__);
        }
        $this->offerSupport = $offerSupport;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\KitItem
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get availableToPartners value
     * @return bool|null
     */
    public function getAvailableToPartners()
    {
        return $this->availableToPartners;
    }
    /**
     * Set availableToPartners value
     * @param bool $availableToPartners
     * @return \StructType\KitItem
     */
    public function setAvailableToPartners($availableToPartners = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToPartners) && !is_bool($availableToPartners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToPartners, true), gettype($availableToPartners)), __LINE__);
        }
        $this->availableToPartners = $availableToPartners;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\KitItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\KitItem
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\KitItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\KitItem
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\KitItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\KitItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get incomeAccount value
     * @return \StructType\RecordRef|null
     */
    public function getIncomeAccount()
    {
        return $this->incomeAccount;
    }
    /**
     * Set incomeAccount value
     * @param \StructType\RecordRef $incomeAccount
     * @return \StructType\KitItem
     */
    public function setIncomeAccount(\StructType\RecordRef $incomeAccount = null)
    {
        $this->incomeAccount = $incomeAccount;
        return $this;
    }
    /**
     * Get taxSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getTaxSchedule()
    {
        return $this->taxSchedule;
    }
    /**
     * Set taxSchedule value
     * @param \StructType\RecordRef $taxSchedule
     * @return \StructType\KitItem
     */
    public function setTaxSchedule(\StructType\RecordRef $taxSchedule = null)
    {
        $this->taxSchedule = $taxSchedule;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \StructType\KitItem
     */
    public function setShippingCost($shippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCost) && !(is_float($shippingCost) || is_numeric($shippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCost, true), gettype($shippingCost)), __LINE__);
        }
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get handlingCost value
     * @return float|null
     */
    public function getHandlingCost()
    {
        return $this->handlingCost;
    }
    /**
     * Set handlingCost value
     * @param float $handlingCost
     * @return \StructType\KitItem
     */
    public function setHandlingCost($handlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($handlingCost) && !(is_float($handlingCost) || is_numeric($handlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingCost, true), gettype($handlingCost)), __LINE__);
        }
        $this->handlingCost = $handlingCost;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\KitItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return bool|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * Set deferRevRec value
     * @param bool $deferRevRec
     * @return \StructType\KitItem
     */
    public function setDeferRevRec($deferRevRec = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferRevRec) && !is_bool($deferRevRec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferRevRec, true), gettype($deferRevRec)), __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Get revenueRecognitionRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueRecognitionRule()
    {
        return $this->revenueRecognitionRule;
    }
    /**
     * Set revenueRecognitionRule value
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @return \StructType\KitItem
     */
    public function setRevenueRecognitionRule(\StructType\RecordRef $revenueRecognitionRule = null)
    {
        $this->revenueRecognitionRule = $revenueRecognitionRule;
        return $this;
    }
    /**
     * Get revRecForecastRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecForecastRule()
    {
        return $this->revRecForecastRule;
    }
    /**
     * Set revRecForecastRule value
     * @param \StructType\RecordRef $revRecForecastRule
     * @return \StructType\KitItem
     */
    public function setRevRecForecastRule(\StructType\RecordRef $revRecForecastRule = null)
    {
        $this->revRecForecastRule = $revRecForecastRule;
        return $this;
    }
    /**
     * Get revenueAllocationGroup value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueAllocationGroup()
    {
        return $this->revenueAllocationGroup;
    }
    /**
     * Set revenueAllocationGroup value
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @return \StructType\KitItem
     */
    public function setRevenueAllocationGroup(\StructType\RecordRef $revenueAllocationGroup = null)
    {
        $this->revenueAllocationGroup = $revenueAllocationGroup;
        return $this;
    }
    /**
     * Get createRevenuePlansOn value
     * @return \StructType\RecordRef|null
     */
    public function getCreateRevenuePlansOn()
    {
        return $this->createRevenuePlansOn;
    }
    /**
     * Set createRevenuePlansOn value
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @return \StructType\KitItem
     */
    public function setCreateRevenuePlansOn(\StructType\RecordRef $createRevenuePlansOn = null)
    {
        $this->createRevenuePlansOn = $createRevenuePlansOn;
        return $this;
    }
    /**
     * Get directRevenuePosting value
     * @return bool|null
     */
    public function getDirectRevenuePosting()
    {
        return $this->directRevenuePosting;
    }
    /**
     * Set directRevenuePosting value
     * @param bool $directRevenuePosting
     * @return \StructType\KitItem
     */
    public function setDirectRevenuePosting($directRevenuePosting = null)
    {
        // validation for constraint: boolean
        if (!is_null($directRevenuePosting) && !is_bool($directRevenuePosting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directRevenuePosting, true), gettype($directRevenuePosting)), __LINE__);
        }
        $this->directRevenuePosting = $directRevenuePosting;
        return $this;
    }
    /**
     * Get contingentRevenueHandling value
     * @return bool|null
     */
    public function getContingentRevenueHandling()
    {
        return $this->contingentRevenueHandling;
    }
    /**
     * Set contingentRevenueHandling value
     * @param bool $contingentRevenueHandling
     * @return \StructType\KitItem
     */
    public function setContingentRevenueHandling($contingentRevenueHandling = null)
    {
        // validation for constraint: boolean
        if (!is_null($contingentRevenueHandling) && !is_bool($contingentRevenueHandling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contingentRevenueHandling, true), gettype($contingentRevenueHandling)), __LINE__);
        }
        $this->contingentRevenueHandling = $contingentRevenueHandling;
        return $this;
    }
    /**
     * Get revReclassFXAccount value
     * @return \StructType\RecordRef|null
     */
    public function getRevReclassFXAccount()
    {
        return $this->revReclassFXAccount;
    }
    /**
     * Set revReclassFXAccount value
     * @param \StructType\RecordRef $revReclassFXAccount
     * @return \StructType\KitItem
     */
    public function setRevReclassFXAccount(\StructType\RecordRef $revReclassFXAccount = null)
    {
        $this->revReclassFXAccount = $revReclassFXAccount;
        return $this;
    }
    /**
     * Get salesTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getSalesTaxCode()
    {
        return $this->salesTaxCode;
    }
    /**
     * Set salesTaxCode value
     * @param \StructType\RecordRef $salesTaxCode
     * @return \StructType\KitItem
     */
    public function setSalesTaxCode(\StructType\RecordRef $salesTaxCode = null)
    {
        $this->salesTaxCode = $salesTaxCode;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\KitItem
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get weightUnit value
     * @return \StructType\RecordRef|null
     */
    public function getWeightUnit()
    {
        return $this->weightUnit;
    }
    /**
     * Set weightUnit value
     * @param \StructType\RecordRef $weightUnit
     * @return \StructType\KitItem
     */
    public function setWeightUnit(\StructType\RecordRef $weightUnit = null)
    {
        $this->weightUnit = $weightUnit;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\KitItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\KitItem
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get deferredRevenueAccount value
     * @return \StructType\RecordRef|null
     */
    public function getDeferredRevenueAccount()
    {
        return $this->deferredRevenueAccount;
    }
    /**
     * Set deferredRevenueAccount value
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @return \StructType\KitItem
     */
    public function setDeferredRevenueAccount(\StructType\RecordRef $deferredRevenueAccount = null)
    {
        $this->deferredRevenueAccount = $deferredRevenueAccount;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\KitItem
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get stockDescription value
     * @return string|null
     */
    public function getStockDescription()
    {
        return $this->stockDescription;
    }
    /**
     * Set stockDescription value
     * @param string $stockDescription
     * @return \StructType\KitItem
     */
    public function setStockDescription($stockDescription = null)
    {
        // validation for constraint: string
        if (!is_null($stockDescription) && !is_string($stockDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockDescription, true), gettype($stockDescription)), __LINE__);
        }
        $this->stockDescription = $stockDescription;
        return $this;
    }
    /**
     * Get producer value
     * @return bool|null
     */
    public function getProducer()
    {
        return $this->producer;
    }
    /**
     * Set producer value
     * @param bool $producer
     * @return \StructType\KitItem
     */
    public function setProducer($producer = null)
    {
        // validation for constraint: boolean
        if (!is_null($producer) && !is_bool($producer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($producer, true), gettype($producer)), __LINE__);
        }
        $this->producer = $producer;
        return $this;
    }
    /**
     * Get manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param string $manufacturer
     * @return \StructType\KitItem
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer, true), gettype($manufacturer)), __LINE__);
        }
        $this->manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get mpn value
     * @return string|null
     */
    public function getMpn()
    {
        return $this->mpn;
    }
    /**
     * Set mpn value
     * @param string $mpn
     * @return \StructType\KitItem
     */
    public function setMpn($mpn = null)
    {
        // validation for constraint: string
        if (!is_null($mpn) && !is_string($mpn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpn, true), gettype($mpn)), __LINE__);
        }
        $this->mpn = $mpn;
        return $this;
    }
    /**
     * Get multManufactureAddr value
     * @return bool|null
     */
    public function getMultManufactureAddr()
    {
        return $this->multManufactureAddr;
    }
    /**
     * Set multManufactureAddr value
     * @param bool $multManufactureAddr
     * @return \StructType\KitItem
     */
    public function setMultManufactureAddr($multManufactureAddr = null)
    {
        // validation for constraint: boolean
        if (!is_null($multManufactureAddr) && !is_bool($multManufactureAddr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multManufactureAddr, true), gettype($multManufactureAddr)), __LINE__);
        }
        $this->multManufactureAddr = $multManufactureAddr;
        return $this;
    }
    /**
     * Get manufactureraddr1 value
     * @return string|null
     */
    public function getManufactureraddr1()
    {
        return $this->manufactureraddr1;
    }
    /**
     * Set manufactureraddr1 value
     * @param string $manufactureraddr1
     * @return \StructType\KitItem
     */
    public function setManufactureraddr1($manufactureraddr1 = null)
    {
        // validation for constraint: string
        if (!is_null($manufactureraddr1) && !is_string($manufactureraddr1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufactureraddr1, true), gettype($manufactureraddr1)), __LINE__);
        }
        $this->manufactureraddr1 = $manufactureraddr1;
        return $this;
    }
    /**
     * Get manufacturerCity value
     * @return string|null
     */
    public function getManufacturerCity()
    {
        return $this->manufacturerCity;
    }
    /**
     * Set manufacturerCity value
     * @param string $manufacturerCity
     * @return \StructType\KitItem
     */
    public function setManufacturerCity($manufacturerCity = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerCity) && !is_string($manufacturerCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerCity, true), gettype($manufacturerCity)), __LINE__);
        }
        $this->manufacturerCity = $manufacturerCity;
        return $this;
    }
    /**
     * Get manufacturerState value
     * @return string|null
     */
    public function getManufacturerState()
    {
        return $this->manufacturerState;
    }
    /**
     * Set manufacturerState value
     * @param string $manufacturerState
     * @return \StructType\KitItem
     */
    public function setManufacturerState($manufacturerState = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerState) && !is_string($manufacturerState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerState, true), gettype($manufacturerState)), __LINE__);
        }
        $this->manufacturerState = $manufacturerState;
        return $this;
    }
    /**
     * Get manufacturerZip value
     * @return string|null
     */
    public function getManufacturerZip()
    {
        return $this->manufacturerZip;
    }
    /**
     * Set manufacturerZip value
     * @param string $manufacturerZip
     * @return \StructType\KitItem
     */
    public function setManufacturerZip($manufacturerZip = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerZip) && !is_string($manufacturerZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerZip, true), gettype($manufacturerZip)), __LINE__);
        }
        $this->manufacturerZip = $manufacturerZip;
        return $this;
    }
    /**
     * Get countryOfManufacture value
     * @return string|null
     */
    public function getCountryOfManufacture()
    {
        return $this->countryOfManufacture;
    }
    /**
     * Set countryOfManufacture value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryOfManufacture
     * @return \StructType\KitItem
     */
    public function setCountryOfManufacture($countryOfManufacture = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($countryOfManufacture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($countryOfManufacture) ? implode(', ', $countryOfManufacture) : var_export($countryOfManufacture, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->countryOfManufacture = $countryOfManufacture;
        return $this;
    }
    /**
     * Get defaultItemShipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getDefaultItemShipMethod()
    {
        return $this->defaultItemShipMethod;
    }
    /**
     * Set defaultItemShipMethod value
     * @param \StructType\RecordRef $defaultItemShipMethod
     * @return \StructType\KitItem
     */
    public function setDefaultItemShipMethod(\StructType\RecordRef $defaultItemShipMethod = null)
    {
        $this->defaultItemShipMethod = $defaultItemShipMethod;
        return $this;
    }
    /**
     * Get itemCarrier value
     * @return string|null
     */
    public function getItemCarrier()
    {
        return $this->itemCarrier;
    }
    /**
     * Set itemCarrier value
     * @uses \EnumType\ShippingCarrier::valueIsValid()
     * @uses \EnumType\ShippingCarrier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemCarrier
     * @return \StructType\KitItem
     */
    public function setItemCarrier($itemCarrier = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ShippingCarrier::valueIsValid($itemCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ShippingCarrier', is_array($itemCarrier) ? implode(', ', $itemCarrier) : var_export($itemCarrier, true), implode(', ', \EnumType\ShippingCarrier::getValidValues())), __LINE__);
        }
        $this->itemCarrier = $itemCarrier;
        return $this;
    }
    /**
     * Get itemShipMethodList value
     * @return \StructType\RecordRefList|null
     */
    public function getItemShipMethodList()
    {
        return $this->itemShipMethodList;
    }
    /**
     * Set itemShipMethodList value
     * @param \StructType\RecordRefList $itemShipMethodList
     * @return \StructType\KitItem
     */
    public function setItemShipMethodList(\StructType\RecordRefList $itemShipMethodList = null)
    {
        $this->itemShipMethodList = $itemShipMethodList;
        return $this;
    }
    /**
     * Get manufacturerTaxId value
     * @return string|null
     */
    public function getManufacturerTaxId()
    {
        return $this->manufacturerTaxId;
    }
    /**
     * Set manufacturerTaxId value
     * @param string $manufacturerTaxId
     * @return \StructType\KitItem
     */
    public function setManufacturerTaxId($manufacturerTaxId = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerTaxId) && !is_string($manufacturerTaxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerTaxId, true), gettype($manufacturerTaxId)), __LINE__);
        }
        $this->manufacturerTaxId = $manufacturerTaxId;
        return $this;
    }
    /**
     * Get scheduleBNumber value
     * @return string|null
     */
    public function getScheduleBNumber()
    {
        return $this->scheduleBNumber;
    }
    /**
     * Set scheduleBNumber value
     * @param string $scheduleBNumber
     * @return \StructType\KitItem
     */
    public function setScheduleBNumber($scheduleBNumber = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleBNumber) && !is_string($scheduleBNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleBNumber, true), gettype($scheduleBNumber)), __LINE__);
        }
        $this->scheduleBNumber = $scheduleBNumber;
        return $this;
    }
    /**
     * Get scheduleBQuantity value
     * @return int|null
     */
    public function getScheduleBQuantity()
    {
        return $this->scheduleBQuantity;
    }
    /**
     * Set scheduleBQuantity value
     * @param int $scheduleBQuantity
     * @return \StructType\KitItem
     */
    public function setScheduleBQuantity($scheduleBQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($scheduleBQuantity) && !(is_int($scheduleBQuantity) || ctype_digit($scheduleBQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scheduleBQuantity, true), gettype($scheduleBQuantity)), __LINE__);
        }
        $this->scheduleBQuantity = $scheduleBQuantity;
        return $this;
    }
    /**
     * Get scheduleBCode value
     * @return \StructType\RecordRef|null
     */
    public function getScheduleBCode()
    {
        return $this->scheduleBCode;
    }
    /**
     * Set scheduleBCode value
     * @param \StructType\RecordRef $scheduleBCode
     * @return \StructType\KitItem
     */
    public function setScheduleBCode(\StructType\RecordRef $scheduleBCode = null)
    {
        $this->scheduleBCode = $scheduleBCode;
        return $this;
    }
    /**
     * Get manufacturerTariff value
     * @return string|null
     */
    public function getManufacturerTariff()
    {
        return $this->manufacturerTariff;
    }
    /**
     * Set manufacturerTariff value
     * @param string $manufacturerTariff
     * @return \StructType\KitItem
     */
    public function setManufacturerTariff($manufacturerTariff = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerTariff) && !is_string($manufacturerTariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerTariff, true), gettype($manufacturerTariff)), __LINE__);
        }
        $this->manufacturerTariff = $manufacturerTariff;
        return $this;
    }
    /**
     * Get preferenceCriterion value
     * @return string|null
     */
    public function getPreferenceCriterion()
    {
        return $this->preferenceCriterion;
    }
    /**
     * Set preferenceCriterion value
     * @uses \EnumType\ItemPreferenceCriterion::valueIsValid()
     * @uses \EnumType\ItemPreferenceCriterion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferenceCriterion
     * @return \StructType\KitItem
     */
    public function setPreferenceCriterion($preferenceCriterion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemPreferenceCriterion::valueIsValid($preferenceCriterion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemPreferenceCriterion', is_array($preferenceCriterion) ? implode(', ', $preferenceCriterion) : var_export($preferenceCriterion, true), implode(', ', \EnumType\ItemPreferenceCriterion::getValidValues())), __LINE__);
        }
        $this->preferenceCriterion = $preferenceCriterion;
        return $this;
    }
    /**
     * Get issueProduct value
     * @return \StructType\RecordRef|null
     */
    public function getIssueProduct()
    {
        return $this->issueProduct;
    }
    /**
     * Set issueProduct value
     * @param \StructType\RecordRef $issueProduct
     * @return \StructType\KitItem
     */
    public function setIssueProduct(\StructType\RecordRef $issueProduct = null)
    {
        $this->issueProduct = $issueProduct;
        return $this;
    }
    /**
     * Get minimumQuantity value
     * @return int|null
     */
    public function getMinimumQuantity()
    {
        return $this->minimumQuantity;
    }
    /**
     * Set minimumQuantity value
     * @param int $minimumQuantity
     * @return \StructType\KitItem
     */
    public function setMinimumQuantity($minimumQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($minimumQuantity) && !(is_int($minimumQuantity) || ctype_digit($minimumQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumQuantity, true), gettype($minimumQuantity)), __LINE__);
        }
        $this->minimumQuantity = $minimumQuantity;
        return $this;
    }
    /**
     * Get enforceMinQtyInternally value
     * @return bool|null
     */
    public function getEnforceMinQtyInternally()
    {
        return $this->enforceMinQtyInternally;
    }
    /**
     * Set enforceMinQtyInternally value
     * @param bool $enforceMinQtyInternally
     * @return \StructType\KitItem
     */
    public function setEnforceMinQtyInternally($enforceMinQtyInternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceMinQtyInternally) && !is_bool($enforceMinQtyInternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enforceMinQtyInternally, true), gettype($enforceMinQtyInternally)), __LINE__);
        }
        $this->enforceMinQtyInternally = $enforceMinQtyInternally;
        return $this;
    }
    /**
     * Get maximumQuantity value
     * @return int|null
     */
    public function getMaximumQuantity()
    {
        return $this->maximumQuantity;
    }
    /**
     * Set maximumQuantity value
     * @param int $maximumQuantity
     * @return \StructType\KitItem
     */
    public function setMaximumQuantity($maximumQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maximumQuantity) && !(is_int($maximumQuantity) || ctype_digit($maximumQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumQuantity, true), gettype($maximumQuantity)), __LINE__);
        }
        $this->maximumQuantity = $maximumQuantity;
        return $this;
    }
    /**
     * Get softDescriptor value
     * @return \StructType\RecordRef|null
     */
    public function getSoftDescriptor()
    {
        return $this->softDescriptor;
    }
    /**
     * Set softDescriptor value
     * @param \StructType\RecordRef $softDescriptor
     * @return \StructType\KitItem
     */
    public function setSoftDescriptor(\StructType\RecordRef $softDescriptor = null)
    {
        $this->softDescriptor = $softDescriptor;
        return $this;
    }
    /**
     * Get isFulfillable value
     * @return bool|null
     */
    public function getIsFulfillable()
    {
        return $this->isFulfillable;
    }
    /**
     * Set isFulfillable value
     * @param bool $isFulfillable
     * @return \StructType\KitItem
     */
    public function setIsFulfillable($isFulfillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFulfillable) && !is_bool($isFulfillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFulfillable, true), gettype($isFulfillable)), __LINE__);
        }
        $this->isFulfillable = $isFulfillable;
        return $this;
    }
    /**
     * Get pricesIncludeTax value
     * @return bool|null
     */
    public function getPricesIncludeTax()
    {
        return $this->pricesIncludeTax;
    }
    /**
     * Set pricesIncludeTax value
     * @param bool $pricesIncludeTax
     * @return \StructType\KitItem
     */
    public function setPricesIncludeTax($pricesIncludeTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($pricesIncludeTax) && !is_bool($pricesIncludeTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pricesIncludeTax, true), gettype($pricesIncludeTax)), __LINE__);
        }
        $this->pricesIncludeTax = $pricesIncludeTax;
        return $this;
    }
    /**
     * Get quantityPricingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getQuantityPricingSchedule()
    {
        return $this->quantityPricingSchedule;
    }
    /**
     * Set quantityPricingSchedule value
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @return \StructType\KitItem
     */
    public function setQuantityPricingSchedule(\StructType\RecordRef $quantityPricingSchedule = null)
    {
        $this->quantityPricingSchedule = $quantityPricingSchedule;
        return $this;
    }
    /**
     * Get useMarginalRates value
     * @return bool|null
     */
    public function getUseMarginalRates()
    {
        return $this->useMarginalRates;
    }
    /**
     * Set useMarginalRates value
     * @param bool $useMarginalRates
     * @return \StructType\KitItem
     */
    public function setUseMarginalRates($useMarginalRates = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMarginalRates) && !is_bool($useMarginalRates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useMarginalRates, true), gettype($useMarginalRates)), __LINE__);
        }
        $this->useMarginalRates = $useMarginalRates;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\KitItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get isHazmatItem value
     * @return bool|null
     */
    public function getIsHazmatItem()
    {
        return $this->isHazmatItem;
    }
    /**
     * Set isHazmatItem value
     * @param bool $isHazmatItem
     * @return \StructType\KitItem
     */
    public function setIsHazmatItem($isHazmatItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHazmatItem) && !is_bool($isHazmatItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHazmatItem, true), gettype($isHazmatItem)), __LINE__);
        }
        $this->isHazmatItem = $isHazmatItem;
        return $this;
    }
    /**
     * Get hazmatId value
     * @return string|null
     */
    public function getHazmatId()
    {
        return $this->hazmatId;
    }
    /**
     * Set hazmatId value
     * @param string $hazmatId
     * @return \StructType\KitItem
     */
    public function setHazmatId($hazmatId = null)
    {
        // validation for constraint: string
        if (!is_null($hazmatId) && !is_string($hazmatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hazmatId, true), gettype($hazmatId)), __LINE__);
        }
        $this->hazmatId = $hazmatId;
        return $this;
    }
    /**
     * Get hazmatShippingName value
     * @return string|null
     */
    public function getHazmatShippingName()
    {
        return $this->hazmatShippingName;
    }
    /**
     * Set hazmatShippingName value
     * @param string $hazmatShippingName
     * @return \StructType\KitItem
     */
    public function setHazmatShippingName($hazmatShippingName = null)
    {
        // validation for constraint: string
        if (!is_null($hazmatShippingName) && !is_string($hazmatShippingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hazmatShippingName, true), gettype($hazmatShippingName)), __LINE__);
        }
        $this->hazmatShippingName = $hazmatShippingName;
        return $this;
    }
    /**
     * Get hazmatHazardClass value
     * @return string|null
     */
    public function getHazmatHazardClass()
    {
        return $this->hazmatHazardClass;
    }
    /**
     * Set hazmatHazardClass value
     * @param string $hazmatHazardClass
     * @return \StructType\KitItem
     */
    public function setHazmatHazardClass($hazmatHazardClass = null)
    {
        // validation for constraint: string
        if (!is_null($hazmatHazardClass) && !is_string($hazmatHazardClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hazmatHazardClass, true), gettype($hazmatHazardClass)), __LINE__);
        }
        $this->hazmatHazardClass = $hazmatHazardClass;
        return $this;
    }
    /**
     * Get hazmatPackingGroup value
     * @return string|null
     */
    public function getHazmatPackingGroup()
    {
        return $this->hazmatPackingGroup;
    }
    /**
     * Set hazmatPackingGroup value
     * @uses \EnumType\HazmatPackingGroup::valueIsValid()
     * @uses \EnumType\HazmatPackingGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hazmatPackingGroup
     * @return \StructType\KitItem
     */
    public function setHazmatPackingGroup($hazmatPackingGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HazmatPackingGroup::valueIsValid($hazmatPackingGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HazmatPackingGroup', is_array($hazmatPackingGroup) ? implode(', ', $hazmatPackingGroup) : var_export($hazmatPackingGroup, true), implode(', ', \EnumType\HazmatPackingGroup::getValidValues())), __LINE__);
        }
        $this->hazmatPackingGroup = $hazmatPackingGroup;
        return $this;
    }
    /**
     * Get hazmatItemUnits value
     * @return string|null
     */
    public function getHazmatItemUnits()
    {
        return $this->hazmatItemUnits;
    }
    /**
     * Set hazmatItemUnits value
     * @param string $hazmatItemUnits
     * @return \StructType\KitItem
     */
    public function setHazmatItemUnits($hazmatItemUnits = null)
    {
        // validation for constraint: string
        if (!is_null($hazmatItemUnits) && !is_string($hazmatItemUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hazmatItemUnits, true), gettype($hazmatItemUnits)), __LINE__);
        }
        $this->hazmatItemUnits = $hazmatItemUnits;
        return $this;
    }
    /**
     * Get hazmatItemUnitsQty value
     * @return float|null
     */
    public function getHazmatItemUnitsQty()
    {
        return $this->hazmatItemUnitsQty;
    }
    /**
     * Set hazmatItemUnitsQty value
     * @param float $hazmatItemUnitsQty
     * @return \StructType\KitItem
     */
    public function setHazmatItemUnitsQty($hazmatItemUnitsQty = null)
    {
        // validation for constraint: float
        if (!is_null($hazmatItemUnitsQty) && !(is_float($hazmatItemUnitsQty) || is_numeric($hazmatItemUnitsQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hazmatItemUnitsQty, true), gettype($hazmatItemUnitsQty)), __LINE__);
        }
        $this->hazmatItemUnitsQty = $hazmatItemUnitsQty;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\KitItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get overallQuantityPricingType value
     * @return string|null
     */
    public function getOverallQuantityPricingType()
    {
        return $this->overallQuantityPricingType;
    }
    /**
     * Set overallQuantityPricingType value
     * @uses \EnumType\ItemOverallQuantityPricingType::valueIsValid()
     * @uses \EnumType\ItemOverallQuantityPricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overallQuantityPricingType
     * @return \StructType\KitItem
     */
    public function setOverallQuantityPricingType($overallQuantityPricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOverallQuantityPricingType::valueIsValid($overallQuantityPricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemOverallQuantityPricingType', is_array($overallQuantityPricingType) ? implode(', ', $overallQuantityPricingType) : var_export($overallQuantityPricingType, true), implode(', ', \EnumType\ItemOverallQuantityPricingType::getValidValues())), __LINE__);
        }
        $this->overallQuantityPricingType = $overallQuantityPricingType;
        return $this;
    }
    /**
     * Get pricingGroup value
     * @return \StructType\RecordRef|null
     */
    public function getPricingGroup()
    {
        return $this->pricingGroup;
    }
    /**
     * Set pricingGroup value
     * @param \StructType\RecordRef $pricingGroup
     * @return \StructType\KitItem
     */
    public function setPricingGroup(\StructType\RecordRef $pricingGroup = null)
    {
        $this->pricingGroup = $pricingGroup;
        return $this;
    }
    /**
     * Get vsoePrice value
     * @return float|null
     */
    public function getVsoePrice()
    {
        return $this->vsoePrice;
    }
    /**
     * Set vsoePrice value
     * @param float $vsoePrice
     * @return \StructType\KitItem
     */
    public function setVsoePrice($vsoePrice = null)
    {
        // validation for constraint: float
        if (!is_null($vsoePrice) && !(is_float($vsoePrice) || is_numeric($vsoePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoePrice, true), gettype($vsoePrice)), __LINE__);
        }
        $this->vsoePrice = $vsoePrice;
        return $this;
    }
    /**
     * Get vsoeSopGroup value
     * @return string|null
     */
    public function getVsoeSopGroup()
    {
        return $this->vsoeSopGroup;
    }
    /**
     * Set vsoeSopGroup value
     * @uses \EnumType\VsoeSopGroup::valueIsValid()
     * @uses \EnumType\VsoeSopGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeSopGroup
     * @return \StructType\KitItem
     */
    public function setVsoeSopGroup($vsoeSopGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeSopGroup::valueIsValid($vsoeSopGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeSopGroup', is_array($vsoeSopGroup) ? implode(', ', $vsoeSopGroup) : var_export($vsoeSopGroup, true), implode(', ', \EnumType\VsoeSopGroup::getValidValues())), __LINE__);
        }
        $this->vsoeSopGroup = $vsoeSopGroup;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\KitItem
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\KitItem
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\KitItem
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get itemRevenueCategory value
     * @return \StructType\RecordRef|null
     */
    public function getItemRevenueCategory()
    {
        return $this->itemRevenueCategory;
    }
    /**
     * Set itemRevenueCategory value
     * @param \StructType\RecordRef $itemRevenueCategory
     * @return \StructType\KitItem
     */
    public function setItemRevenueCategory(\StructType\RecordRef $itemRevenueCategory = null)
    {
        $this->itemRevenueCategory = $itemRevenueCategory;
        return $this;
    }
    /**
     * Get shipIndividually value
     * @return bool|null
     */
    public function getShipIndividually()
    {
        return $this->shipIndividually;
    }
    /**
     * Set shipIndividually value
     * @param bool $shipIndividually
     * @return \StructType\KitItem
     */
    public function setShipIndividually($shipIndividually = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipIndividually) && !is_bool($shipIndividually)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipIndividually, true), gettype($shipIndividually)), __LINE__);
        }
        $this->shipIndividually = $shipIndividually;
        return $this;
    }
    /**
     * Get shipPackage value
     * @return \StructType\RecordRef|null
     */
    public function getShipPackage()
    {
        return $this->shipPackage;
    }
    /**
     * Set shipPackage value
     * @param \StructType\RecordRef $shipPackage
     * @return \StructType\KitItem
     */
    public function setShipPackage(\StructType\RecordRef $shipPackage = null)
    {
        $this->shipPackage = $shipPackage;
        return $this;
    }
    /**
     * Get storeDisplayName value
     * @return string|null
     */
    public function getStoreDisplayName()
    {
        return $this->storeDisplayName;
    }
    /**
     * Set storeDisplayName value
     * @param string $storeDisplayName
     * @return \StructType\KitItem
     */
    public function setStoreDisplayName($storeDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($storeDisplayName) && !is_string($storeDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDisplayName, true), gettype($storeDisplayName)), __LINE__);
        }
        $this->storeDisplayName = $storeDisplayName;
        return $this;
    }
    /**
     * Get storeDisplayThumbnail value
     * @return \StructType\RecordRef|null
     */
    public function getStoreDisplayThumbnail()
    {
        return $this->storeDisplayThumbnail;
    }
    /**
     * Set storeDisplayThumbnail value
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @return \StructType\KitItem
     */
    public function setStoreDisplayThumbnail(\StructType\RecordRef $storeDisplayThumbnail = null)
    {
        $this->storeDisplayThumbnail = $storeDisplayThumbnail;
        return $this;
    }
    /**
     * Get outOfStockMessage value
     * @return string|null
     */
    public function getOutOfStockMessage()
    {
        return $this->outOfStockMessage;
    }
    /**
     * Set outOfStockMessage value
     * @param string $outOfStockMessage
     * @return \StructType\KitItem
     */
    public function setOutOfStockMessage($outOfStockMessage = null)
    {
        // validation for constraint: string
        if (!is_null($outOfStockMessage) && !is_string($outOfStockMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outOfStockMessage, true), gettype($outOfStockMessage)), __LINE__);
        }
        $this->outOfStockMessage = $outOfStockMessage;
        return $this;
    }
    /**
     * Get storeDisplayImage value
     * @return \StructType\RecordRef|null
     */
    public function getStoreDisplayImage()
    {
        return $this->storeDisplayImage;
    }
    /**
     * Set storeDisplayImage value
     * @param \StructType\RecordRef $storeDisplayImage
     * @return \StructType\KitItem
     */
    public function setStoreDisplayImage(\StructType\RecordRef $storeDisplayImage = null)
    {
        $this->storeDisplayImage = $storeDisplayImage;
        return $this;
    }
    /**
     * Get storeDescription value
     * @return string|null
     */
    public function getStoreDescription()
    {
        return $this->storeDescription;
    }
    /**
     * Set storeDescription value
     * @param string $storeDescription
     * @return \StructType\KitItem
     */
    public function setStoreDescription($storeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($storeDescription) && !is_string($storeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDescription, true), gettype($storeDescription)), __LINE__);
        }
        $this->storeDescription = $storeDescription;
        return $this;
    }
    /**
     * Get storeDetailedDescription value
     * @return string|null
     */
    public function getStoreDetailedDescription()
    {
        return $this->storeDetailedDescription;
    }
    /**
     * Set storeDetailedDescription value
     * @param string $storeDetailedDescription
     * @return \StructType\KitItem
     */
    public function setStoreDetailedDescription($storeDetailedDescription = null)
    {
        // validation for constraint: string
        if (!is_null($storeDetailedDescription) && !is_string($storeDetailedDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDetailedDescription, true), gettype($storeDetailedDescription)), __LINE__);
        }
        $this->storeDetailedDescription = $storeDetailedDescription;
        return $this;
    }
    /**
     * Get storeItemTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getStoreItemTemplate()
    {
        return $this->storeItemTemplate;
    }
    /**
     * Set storeItemTemplate value
     * @param \StructType\RecordRef $storeItemTemplate
     * @return \StructType\KitItem
     */
    public function setStoreItemTemplate(\StructType\RecordRef $storeItemTemplate = null)
    {
        $this->storeItemTemplate = $storeItemTemplate;
        return $this;
    }
    /**
     * Get pageTitle value
     * @return string|null
     */
    public function getPageTitle()
    {
        return $this->pageTitle;
    }
    /**
     * Set pageTitle value
     * @param string $pageTitle
     * @return \StructType\KitItem
     */
    public function setPageTitle($pageTitle = null)
    {
        // validation for constraint: string
        if (!is_null($pageTitle) && !is_string($pageTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageTitle, true), gettype($pageTitle)), __LINE__);
        }
        $this->pageTitle = $pageTitle;
        return $this;
    }
    /**
     * Get urlComponent value
     * @return string|null
     */
    public function getUrlComponent()
    {
        return $this->urlComponent;
    }
    /**
     * Set urlComponent value
     * @param string $urlComponent
     * @return \StructType\KitItem
     */
    public function setUrlComponent($urlComponent = null)
    {
        // validation for constraint: string
        if (!is_null($urlComponent) && !is_string($urlComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlComponent, true), gettype($urlComponent)), __LINE__);
        }
        $this->urlComponent = $urlComponent;
        return $this;
    }
    /**
     * Get metaTagHtml value
     * @return string|null
     */
    public function getMetaTagHtml()
    {
        return $this->metaTagHtml;
    }
    /**
     * Set metaTagHtml value
     * @param string $metaTagHtml
     * @return \StructType\KitItem
     */
    public function setMetaTagHtml($metaTagHtml = null)
    {
        // validation for constraint: string
        if (!is_null($metaTagHtml) && !is_string($metaTagHtml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metaTagHtml, true), gettype($metaTagHtml)), __LINE__);
        }
        $this->metaTagHtml = $metaTagHtml;
        return $this;
    }
    /**
     * Get excludeFromSitemap value
     * @return bool|null
     */
    public function getExcludeFromSitemap()
    {
        return $this->excludeFromSitemap;
    }
    /**
     * Set excludeFromSitemap value
     * @param bool $excludeFromSitemap
     * @return \StructType\KitItem
     */
    public function setExcludeFromSitemap($excludeFromSitemap = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromSitemap) && !is_bool($excludeFromSitemap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromSitemap, true), gettype($excludeFromSitemap)), __LINE__);
        }
        $this->excludeFromSitemap = $excludeFromSitemap;
        return $this;
    }
    /**
     * Get sitemapPriority value
     * @return string|null
     */
    public function getSitemapPriority()
    {
        return $this->sitemapPriority;
    }
    /**
     * Set sitemapPriority value
     * @uses \EnumType\SitemapPriority::valueIsValid()
     * @uses \EnumType\SitemapPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sitemapPriority
     * @return \StructType\KitItem
     */
    public function setSitemapPriority($sitemapPriority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SitemapPriority::valueIsValid($sitemapPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SitemapPriority', is_array($sitemapPriority) ? implode(', ', $sitemapPriority) : var_export($sitemapPriority, true), implode(', ', \EnumType\SitemapPriority::getValidValues())), __LINE__);
        }
        $this->sitemapPriority = $sitemapPriority;
        return $this;
    }
    /**
     * Get searchKeywords value
     * @return string|null
     */
    public function getSearchKeywords()
    {
        return $this->searchKeywords;
    }
    /**
     * Set searchKeywords value
     * @param string $searchKeywords
     * @return \StructType\KitItem
     */
    public function setSearchKeywords($searchKeywords = null)
    {
        // validation for constraint: string
        if (!is_null($searchKeywords) && !is_string($searchKeywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchKeywords, true), gettype($searchKeywords)), __LINE__);
        }
        $this->searchKeywords = $searchKeywords;
        return $this;
    }
    /**
     * Get itemOptionsList value
     * @return \StructType\ItemOptionsList|null
     */
    public function getItemOptionsList()
    {
        return $this->itemOptionsList;
    }
    /**
     * Set itemOptionsList value
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @return \StructType\KitItem
     */
    public function setItemOptionsList(\StructType\ItemOptionsList $itemOptionsList = null)
    {
        $this->itemOptionsList = $itemOptionsList;
        return $this;
    }
    /**
     * Get isDonationItem value
     * @return bool|null
     */
    public function getIsDonationItem()
    {
        return $this->isDonationItem;
    }
    /**
     * Set isDonationItem value
     * @param bool $isDonationItem
     * @return \StructType\KitItem
     */
    public function setIsDonationItem($isDonationItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDonationItem) && !is_bool($isDonationItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDonationItem, true), gettype($isDonationItem)), __LINE__);
        }
        $this->isDonationItem = $isDonationItem;
        return $this;
    }
    /**
     * Get showDefaultDonationAmount value
     * @return bool|null
     */
    public function getShowDefaultDonationAmount()
    {
        return $this->showDefaultDonationAmount;
    }
    /**
     * Set showDefaultDonationAmount value
     * @param bool $showDefaultDonationAmount
     * @return \StructType\KitItem
     */
    public function setShowDefaultDonationAmount($showDefaultDonationAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($showDefaultDonationAmount) && !is_bool($showDefaultDonationAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showDefaultDonationAmount, true), gettype($showDefaultDonationAmount)), __LINE__);
        }
        $this->showDefaultDonationAmount = $showDefaultDonationAmount;
        return $this;
    }
    /**
     * Get maxDonationAmount value
     * @return float|null
     */
    public function getMaxDonationAmount()
    {
        return $this->maxDonationAmount;
    }
    /**
     * Set maxDonationAmount value
     * @param float $maxDonationAmount
     * @return \StructType\KitItem
     */
    public function setMaxDonationAmount($maxDonationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($maxDonationAmount) && !(is_float($maxDonationAmount) || is_numeric($maxDonationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxDonationAmount, true), gettype($maxDonationAmount)), __LINE__);
        }
        $this->maxDonationAmount = $maxDonationAmount;
        return $this;
    }
    /**
     * Get dontShowPrice value
     * @return bool|null
     */
    public function getDontShowPrice()
    {
        return $this->dontShowPrice;
    }
    /**
     * Set dontShowPrice value
     * @param bool $dontShowPrice
     * @return \StructType\KitItem
     */
    public function setDontShowPrice($dontShowPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($dontShowPrice) && !is_bool($dontShowPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dontShowPrice, true), gettype($dontShowPrice)), __LINE__);
        }
        $this->dontShowPrice = $dontShowPrice;
        return $this;
    }
    /**
     * Get noPriceMessage value
     * @return string|null
     */
    public function getNoPriceMessage()
    {
        return $this->noPriceMessage;
    }
    /**
     * Set noPriceMessage value
     * @param string $noPriceMessage
     * @return \StructType\KitItem
     */
    public function setNoPriceMessage($noPriceMessage = null)
    {
        // validation for constraint: string
        if (!is_null($noPriceMessage) && !is_string($noPriceMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noPriceMessage, true), gettype($noPriceMessage)), __LINE__);
        }
        $this->noPriceMessage = $noPriceMessage;
        return $this;
    }
    /**
     * Get shoppingDotComCategory value
     * @return string|null
     */
    public function getShoppingDotComCategory()
    {
        return $this->shoppingDotComCategory;
    }
    /**
     * Set shoppingDotComCategory value
     * @param string $shoppingDotComCategory
     * @return \StructType\KitItem
     */
    public function setShoppingDotComCategory($shoppingDotComCategory = null)
    {
        // validation for constraint: string
        if (!is_null($shoppingDotComCategory) && !is_string($shoppingDotComCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shoppingDotComCategory, true), gettype($shoppingDotComCategory)), __LINE__);
        }
        $this->shoppingDotComCategory = $shoppingDotComCategory;
        return $this;
    }
    /**
     * Get shopzillaCategoryId value
     * @return int|null
     */
    public function getShopzillaCategoryId()
    {
        return $this->shopzillaCategoryId;
    }
    /**
     * Set shopzillaCategoryId value
     * @param int $shopzillaCategoryId
     * @return \StructType\KitItem
     */
    public function setShopzillaCategoryId($shopzillaCategoryId = null)
    {
        // validation for constraint: int
        if (!is_null($shopzillaCategoryId) && !(is_int($shopzillaCategoryId) || ctype_digit($shopzillaCategoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shopzillaCategoryId, true), gettype($shopzillaCategoryId)), __LINE__);
        }
        $this->shopzillaCategoryId = $shopzillaCategoryId;
        return $this;
    }
    /**
     * Get outOfStockBehavior value
     * @return string|null
     */
    public function getOutOfStockBehavior()
    {
        return $this->outOfStockBehavior;
    }
    /**
     * Set outOfStockBehavior value
     * @uses \EnumType\ItemOutOfStockBehavior::valueIsValid()
     * @uses \EnumType\ItemOutOfStockBehavior::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outOfStockBehavior
     * @return \StructType\KitItem
     */
    public function setOutOfStockBehavior($outOfStockBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOutOfStockBehavior::valueIsValid($outOfStockBehavior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemOutOfStockBehavior', is_array($outOfStockBehavior) ? implode(', ', $outOfStockBehavior) : var_export($outOfStockBehavior, true), implode(', ', \EnumType\ItemOutOfStockBehavior::getValidValues())), __LINE__);
        }
        $this->outOfStockBehavior = $outOfStockBehavior;
        return $this;
    }
    /**
     * Get nexTagCategory value
     * @return string|null
     */
    public function getNexTagCategory()
    {
        return $this->nexTagCategory;
    }
    /**
     * Set nexTagCategory value
     * @param string $nexTagCategory
     * @return \StructType\KitItem
     */
    public function setNexTagCategory($nexTagCategory = null)
    {
        // validation for constraint: string
        if (!is_null($nexTagCategory) && !is_string($nexTagCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nexTagCategory, true), gettype($nexTagCategory)), __LINE__);
        }
        $this->nexTagCategory = $nexTagCategory;
        return $this;
    }
    /**
     * Get productFeedList value
     * @return \StructType\ProductFeedList|null
     */
    public function getProductFeedList()
    {
        return $this->productFeedList;
    }
    /**
     * Set productFeedList value
     * @param \StructType\ProductFeedList $productFeedList
     * @return \StructType\KitItem
     */
    public function setProductFeedList(\StructType\ProductFeedList $productFeedList = null)
    {
        $this->productFeedList = $productFeedList;
        return $this;
    }
    /**
     * Get relatedItemsDescription value
     * @return string|null
     */
    public function getRelatedItemsDescription()
    {
        return $this->relatedItemsDescription;
    }
    /**
     * Set relatedItemsDescription value
     * @param string $relatedItemsDescription
     * @return \StructType\KitItem
     */
    public function setRelatedItemsDescription($relatedItemsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($relatedItemsDescription) && !is_string($relatedItemsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedItemsDescription, true), gettype($relatedItemsDescription)), __LINE__);
        }
        $this->relatedItemsDescription = $relatedItemsDescription;
        return $this;
    }
    /**
     * Get onSpecial value
     * @return bool|null
     */
    public function getOnSpecial()
    {
        return $this->onSpecial;
    }
    /**
     * Set onSpecial value
     * @param bool $onSpecial
     * @return \StructType\KitItem
     */
    public function setOnSpecial($onSpecial = null)
    {
        // validation for constraint: boolean
        if (!is_null($onSpecial) && !is_bool($onSpecial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onSpecial, true), gettype($onSpecial)), __LINE__);
        }
        $this->onSpecial = $onSpecial;
        return $this;
    }
    /**
     * Get specialsDescription value
     * @return string|null
     */
    public function getSpecialsDescription()
    {
        return $this->specialsDescription;
    }
    /**
     * Set specialsDescription value
     * @param string $specialsDescription
     * @return \StructType\KitItem
     */
    public function setSpecialsDescription($specialsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($specialsDescription) && !is_string($specialsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialsDescription, true), gettype($specialsDescription)), __LINE__);
        }
        $this->specialsDescription = $specialsDescription;
        return $this;
    }
    /**
     * Get featuredDescription value
     * @return string|null
     */
    public function getFeaturedDescription()
    {
        return $this->featuredDescription;
    }
    /**
     * Set featuredDescription value
     * @param string $featuredDescription
     * @return \StructType\KitItem
     */
    public function setFeaturedDescription($featuredDescription = null)
    {
        // validation for constraint: string
        if (!is_null($featuredDescription) && !is_string($featuredDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featuredDescription, true), gettype($featuredDescription)), __LINE__);
        }
        $this->featuredDescription = $featuredDescription;
        return $this;
    }
    /**
     * Get pricingMatrix value
     * @return \StructType\PricingMatrix|null
     */
    public function getPricingMatrix()
    {
        return $this->pricingMatrix;
    }
    /**
     * Set pricingMatrix value
     * @param \StructType\PricingMatrix $pricingMatrix
     * @return \StructType\KitItem
     */
    public function setPricingMatrix(\StructType\PricingMatrix $pricingMatrix = null)
    {
        $this->pricingMatrix = $pricingMatrix;
        return $this;
    }
    /**
     * Get siteCategoryList value
     * @return \StructType\SiteCategoryList|null
     */
    public function getSiteCategoryList()
    {
        return $this->siteCategoryList;
    }
    /**
     * Set siteCategoryList value
     * @param \StructType\SiteCategoryList $siteCategoryList
     * @return \StructType\KitItem
     */
    public function setSiteCategoryList(\StructType\SiteCategoryList $siteCategoryList = null)
    {
        $this->siteCategoryList = $siteCategoryList;
        return $this;
    }
    /**
     * Get memberList value
     * @return \StructType\ItemMemberList|null
     */
    public function getMemberList()
    {
        return $this->memberList;
    }
    /**
     * Set memberList value
     * @param \StructType\ItemMemberList $memberList
     * @return \StructType\KitItem
     */
    public function setMemberList(\StructType\ItemMemberList $memberList = null)
    {
        $this->memberList = $memberList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\ItemAccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @return \StructType\KitItem
     */
    public function setAccountingBookDetailList(\StructType\ItemAccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\TranslationList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\TranslationList $translationsList
     * @return \StructType\KitItem
     */
    public function setTranslationsList(\StructType\TranslationList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get presentationItemList value
     * @return \StructType\PresentationItemList|null
     */
    public function getPresentationItemList()
    {
        return $this->presentationItemList;
    }
    /**
     * Set presentationItemList value
     * @param \StructType\PresentationItemList $presentationItemList
     * @return \StructType\KitItem
     */
    public function setPresentationItemList(\StructType\PresentationItemList $presentationItemList = null)
    {
        $this->presentationItemList = $presentationItemList;
        return $this;
    }
    /**
     * Get hierarchyVersionsList value
     * @return \StructType\KitItemHierarchyVersionsList|null
     */
    public function getHierarchyVersionsList()
    {
        return $this->hierarchyVersionsList;
    }
    /**
     * Set hierarchyVersionsList value
     * @param \StructType\KitItemHierarchyVersionsList $hierarchyVersionsList
     * @return \StructType\KitItem
     */
    public function setHierarchyVersionsList(\StructType\KitItemHierarchyVersionsList $hierarchyVersionsList = null)
    {
        $this->hierarchyVersionsList = $hierarchyVersionsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\KitItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\KitItem
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\KitItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
