<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobSearch StructType
 * @subpackage Structs
 */
class JobSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobSearchBasic
     */
    public $basic;
    /**
     * The billingAccountJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingAccountSearchBasic
     */
    public $billingAccountJoin;
    /**
     * The billingScheduleJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingScheduleSearchBasic
     */
    public $billingScheduleJoin;
    /**
     * The contactPrimaryJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactSearchBasic
     */
    public $contactPrimaryJoin;
    /**
     * The customerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerSearchBasic
     */
    public $customerJoin;
    /**
     * The projectManagerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $projectManagerJoin;
    /**
     * The projectTaskJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskSearchBasic
     */
    public $projectTaskJoin;
    /**
     * The resourceAllocationJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResourceAllocationSearchBasic
     */
    public $resourceAllocationJoin;
    /**
     * The taskJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaskSearchBasic
     */
    public $taskJoin;
    /**
     * The timeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeBillSearchBasic
     */
    public $timeJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for JobSearch
     * @uses JobSearch::setBasic()
     * @uses JobSearch::setBillingAccountJoin()
     * @uses JobSearch::setBillingScheduleJoin()
     * @uses JobSearch::setContactPrimaryJoin()
     * @uses JobSearch::setCustomerJoin()
     * @uses JobSearch::setProjectManagerJoin()
     * @uses JobSearch::setProjectTaskJoin()
     * @uses JobSearch::setResourceAllocationJoin()
     * @uses JobSearch::setTaskJoin()
     * @uses JobSearch::setTimeJoin()
     * @uses JobSearch::setCustomSearchJoin()
     * @param \StructType\JobSearchBasic $basic
     * @param \StructType\BillingAccountSearchBasic $billingAccountJoin
     * @param \StructType\BillingScheduleSearchBasic $billingScheduleJoin
     * @param \StructType\ContactSearchBasic $contactPrimaryJoin
     * @param \StructType\CustomerSearchBasic $customerJoin
     * @param \StructType\EmployeeSearchBasic $projectManagerJoin
     * @param \StructType\ProjectTaskSearchBasic $projectTaskJoin
     * @param \StructType\ResourceAllocationSearchBasic $resourceAllocationJoin
     * @param \StructType\TaskSearchBasic $taskJoin
     * @param \StructType\TimeBillSearchBasic $timeJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\JobSearchBasic $basic = null, \StructType\BillingAccountSearchBasic $billingAccountJoin = null, \StructType\BillingScheduleSearchBasic $billingScheduleJoin = null, \StructType\ContactSearchBasic $contactPrimaryJoin = null, \StructType\CustomerSearchBasic $customerJoin = null, \StructType\EmployeeSearchBasic $projectManagerJoin = null, \StructType\ProjectTaskSearchBasic $projectTaskJoin = null, \StructType\ResourceAllocationSearchBasic $resourceAllocationJoin = null, \StructType\TaskSearchBasic $taskJoin = null, \StructType\TimeBillSearchBasic $timeJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setBillingAccountJoin($billingAccountJoin)
            ->setBillingScheduleJoin($billingScheduleJoin)
            ->setContactPrimaryJoin($contactPrimaryJoin)
            ->setCustomerJoin($customerJoin)
            ->setProjectManagerJoin($projectManagerJoin)
            ->setProjectTaskJoin($projectTaskJoin)
            ->setResourceAllocationJoin($resourceAllocationJoin)
            ->setTaskJoin($taskJoin)
            ->setTimeJoin($timeJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\JobSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\JobSearchBasic $basic
     * @return \StructType\JobSearch
     */
    public function setBasic(\StructType\JobSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get billingAccountJoin value
     * @return \StructType\BillingAccountSearchBasic|null
     */
    public function getBillingAccountJoin()
    {
        return $this->billingAccountJoin;
    }
    /**
     * Set billingAccountJoin value
     * @param \StructType\BillingAccountSearchBasic $billingAccountJoin
     * @return \StructType\JobSearch
     */
    public function setBillingAccountJoin(\StructType\BillingAccountSearchBasic $billingAccountJoin = null)
    {
        $this->billingAccountJoin = $billingAccountJoin;
        return $this;
    }
    /**
     * Get billingScheduleJoin value
     * @return \StructType\BillingScheduleSearchBasic|null
     */
    public function getBillingScheduleJoin()
    {
        return $this->billingScheduleJoin;
    }
    /**
     * Set billingScheduleJoin value
     * @param \StructType\BillingScheduleSearchBasic $billingScheduleJoin
     * @return \StructType\JobSearch
     */
    public function setBillingScheduleJoin(\StructType\BillingScheduleSearchBasic $billingScheduleJoin = null)
    {
        $this->billingScheduleJoin = $billingScheduleJoin;
        return $this;
    }
    /**
     * Get contactPrimaryJoin value
     * @return \StructType\ContactSearchBasic|null
     */
    public function getContactPrimaryJoin()
    {
        return $this->contactPrimaryJoin;
    }
    /**
     * Set contactPrimaryJoin value
     * @param \StructType\ContactSearchBasic $contactPrimaryJoin
     * @return \StructType\JobSearch
     */
    public function setContactPrimaryJoin(\StructType\ContactSearchBasic $contactPrimaryJoin = null)
    {
        $this->contactPrimaryJoin = $contactPrimaryJoin;
        return $this;
    }
    /**
     * Get customerJoin value
     * @return \StructType\CustomerSearchBasic|null
     */
    public function getCustomerJoin()
    {
        return $this->customerJoin;
    }
    /**
     * Set customerJoin value
     * @param \StructType\CustomerSearchBasic $customerJoin
     * @return \StructType\JobSearch
     */
    public function setCustomerJoin(\StructType\CustomerSearchBasic $customerJoin = null)
    {
        $this->customerJoin = $customerJoin;
        return $this;
    }
    /**
     * Get projectManagerJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getProjectManagerJoin()
    {
        return $this->projectManagerJoin;
    }
    /**
     * Set projectManagerJoin value
     * @param \StructType\EmployeeSearchBasic $projectManagerJoin
     * @return \StructType\JobSearch
     */
    public function setProjectManagerJoin(\StructType\EmployeeSearchBasic $projectManagerJoin = null)
    {
        $this->projectManagerJoin = $projectManagerJoin;
        return $this;
    }
    /**
     * Get projectTaskJoin value
     * @return \StructType\ProjectTaskSearchBasic|null
     */
    public function getProjectTaskJoin()
    {
        return $this->projectTaskJoin;
    }
    /**
     * Set projectTaskJoin value
     * @param \StructType\ProjectTaskSearchBasic $projectTaskJoin
     * @return \StructType\JobSearch
     */
    public function setProjectTaskJoin(\StructType\ProjectTaskSearchBasic $projectTaskJoin = null)
    {
        $this->projectTaskJoin = $projectTaskJoin;
        return $this;
    }
    /**
     * Get resourceAllocationJoin value
     * @return \StructType\ResourceAllocationSearchBasic|null
     */
    public function getResourceAllocationJoin()
    {
        return $this->resourceAllocationJoin;
    }
    /**
     * Set resourceAllocationJoin value
     * @param \StructType\ResourceAllocationSearchBasic $resourceAllocationJoin
     * @return \StructType\JobSearch
     */
    public function setResourceAllocationJoin(\StructType\ResourceAllocationSearchBasic $resourceAllocationJoin = null)
    {
        $this->resourceAllocationJoin = $resourceAllocationJoin;
        return $this;
    }
    /**
     * Get taskJoin value
     * @return \StructType\TaskSearchBasic|null
     */
    public function getTaskJoin()
    {
        return $this->taskJoin;
    }
    /**
     * Set taskJoin value
     * @param \StructType\TaskSearchBasic $taskJoin
     * @return \StructType\JobSearch
     */
    public function setTaskJoin(\StructType\TaskSearchBasic $taskJoin = null)
    {
        $this->taskJoin = $taskJoin;
        return $this;
    }
    /**
     * Get timeJoin value
     * @return \StructType\TimeBillSearchBasic|null
     */
    public function getTimeJoin()
    {
        return $this->timeJoin;
    }
    /**
     * Set timeJoin value
     * @param \StructType\TimeBillSearchBasic $timeJoin
     * @return \StructType\JobSearch
     */
    public function setTimeJoin(\StructType\TimeBillSearchBasic $timeJoin = null)
    {
        $this->timeJoin = $timeJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jobSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$jobSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($jobSearchCustomSearchJoinItem) ? get_class($jobSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($jobSearchCustomSearchJoinItem), var_export($jobSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\JobSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\JobSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
