<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobResourcesList StructType
 * @subpackage Structs
 */
class JobResourcesList extends AbstractStructBase
{
    /**
     * The jobResources
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JobResources[]
     */
    public $jobResources;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for JobResourcesList
     * @uses JobResourcesList::setJobResources()
     * @uses JobResourcesList::setReplaceAll()
     * @param \StructType\JobResources[] $jobResources
     * @param bool $replaceAll
     */
    public function __construct(array $jobResources = array(), $replaceAll = true)
    {
        $this
            ->setJobResources($jobResources)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get jobResources value
     * @return \StructType\JobResources[]|null
     */
    public function getJobResources()
    {
        return $this->jobResources;
    }
    /**
     * This method is responsible for validating the values passed to the setJobResources method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJobResources method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJobResourcesForArrayConstraintsFromSetJobResources(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jobResourcesListJobResourcesItem) {
            // validation for constraint: itemType
            if (!$jobResourcesListJobResourcesItem instanceof \StructType\JobResources) {
                $invalidValues[] = is_object($jobResourcesListJobResourcesItem) ? get_class($jobResourcesListJobResourcesItem) : sprintf('%s(%s)', gettype($jobResourcesListJobResourcesItem), var_export($jobResourcesListJobResourcesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The jobResources property can only contain items of type \StructType\JobResources, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set jobResources value
     * @throws \InvalidArgumentException
     * @param \StructType\JobResources[] $jobResources
     * @return \StructType\JobResourcesList
     */
    public function setJobResources(array $jobResources = array())
    {
        // validation for constraint: array
        if ('' !== ($jobResourcesArrayErrorMessage = self::validateJobResourcesForArrayConstraintsFromSetJobResources($jobResources))) {
            throw new \InvalidArgumentException($jobResourcesArrayErrorMessage, __LINE__);
        }
        $this->jobResources = $jobResources;
        return $this;
    }
    /**
     * Add item to jobResources value
     * @throws \InvalidArgumentException
     * @param \StructType\JobResources $item
     * @return \StructType\JobResourcesList
     */
    public function addToJobResources(\StructType\JobResources $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobResources) {
            throw new \InvalidArgumentException(sprintf('The jobResources property can only contain items of type \StructType\JobResources, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->jobResources[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\JobResourcesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
