<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobPlStatement StructType
 * @subpackage Structs
 */
class JobPlStatement extends AbstractStructBase
{
    /**
     * The costCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costCategory;
    /**
     * The revenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $revenue;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The profit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $profit;
    /**
     * The margin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $margin;
    /**
     * Constructor method for JobPlStatement
     * @uses JobPlStatement::setCostCategory()
     * @uses JobPlStatement::setRevenue()
     * @uses JobPlStatement::setCost()
     * @uses JobPlStatement::setProfit()
     * @uses JobPlStatement::setMargin()
     * @param string $costCategory
     * @param float $revenue
     * @param float $cost
     * @param float $profit
     * @param float $margin
     */
    public function __construct($costCategory = null, $revenue = null, $cost = null, $profit = null, $margin = null)
    {
        $this
            ->setCostCategory($costCategory)
            ->setRevenue($revenue)
            ->setCost($cost)
            ->setProfit($profit)
            ->setMargin($margin);
    }
    /**
     * Get costCategory value
     * @return string|null
     */
    public function getCostCategory()
    {
        return $this->costCategory;
    }
    /**
     * Set costCategory value
     * @param string $costCategory
     * @return \StructType\JobPlStatement
     */
    public function setCostCategory($costCategory = null)
    {
        // validation for constraint: string
        if (!is_null($costCategory) && !is_string($costCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCategory, true), gettype($costCategory)), __LINE__);
        }
        $this->costCategory = $costCategory;
        return $this;
    }
    /**
     * Get revenue value
     * @return float|null
     */
    public function getRevenue()
    {
        return $this->revenue;
    }
    /**
     * Set revenue value
     * @param float $revenue
     * @return \StructType\JobPlStatement
     */
    public function setRevenue($revenue = null)
    {
        // validation for constraint: float
        if (!is_null($revenue) && !(is_float($revenue) || is_numeric($revenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($revenue, true), gettype($revenue)), __LINE__);
        }
        $this->revenue = $revenue;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\JobPlStatement
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get profit value
     * @return float|null
     */
    public function getProfit()
    {
        return $this->profit;
    }
    /**
     * Set profit value
     * @param float $profit
     * @return \StructType\JobPlStatement
     */
    public function setProfit($profit = null)
    {
        // validation for constraint: float
        if (!is_null($profit) && !(is_float($profit) || is_numeric($profit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($profit, true), gettype($profit)), __LINE__);
        }
        $this->profit = $profit;
        return $this;
    }
    /**
     * Get margin value
     * @return float|null
     */
    public function getMargin()
    {
        return $this->margin;
    }
    /**
     * Set margin value
     * @param float $margin
     * @return \StructType\JobPlStatement
     */
    public function setMargin($margin = null)
    {
        // validation for constraint: float
        if (!is_null($margin) && !(is_float($margin) || is_numeric($margin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($margin, true), gettype($margin)), __LINE__);
        }
        $this->margin = $margin;
        return $this;
    }
}
