<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobPercentCompleteOverride StructType
 * @subpackage Structs
 */
class JobPercentCompleteOverride extends AbstractStructBase
{
    /**
     * The period
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $period;
    /**
     * The percent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percent;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * Constructor method for JobPercentCompleteOverride
     * @uses JobPercentCompleteOverride::setPeriod()
     * @uses JobPercentCompleteOverride::setPercent()
     * @uses JobPercentCompleteOverride::setComments()
     * @param \StructType\RecordRef $period
     * @param float $percent
     * @param string $comments
     */
    public function __construct(\StructType\RecordRef $period = null, $percent = null, $comments = null)
    {
        $this
            ->setPeriod($period)
            ->setPercent($percent)
            ->setComments($comments);
    }
    /**
     * Get period value
     * @return \StructType\RecordRef|null
     */
    public function getPeriod()
    {
        return $this->period;
    }
    /**
     * Set period value
     * @param \StructType\RecordRef $period
     * @return \StructType\JobPercentCompleteOverride
     */
    public function setPeriod(\StructType\RecordRef $period = null)
    {
        $this->period = $period;
        return $this;
    }
    /**
     * Get percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->percent;
    }
    /**
     * Set percent value
     * @param float $percent
     * @return \StructType\JobPercentCompleteOverride
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->percent = $percent;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\JobPercentCompleteOverride
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
}
