<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobMilestonesList StructType
 * @subpackage Structs
 */
class JobMilestonesList extends AbstractStructBase
{
    /**
     * The milestones
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JobMilestones[]
     */
    public $milestones;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for JobMilestonesList
     * @uses JobMilestonesList::setMilestones()
     * @uses JobMilestonesList::setReplaceAll()
     * @param \StructType\JobMilestones[] $milestones
     * @param bool $replaceAll
     */
    public function __construct(array $milestones = array(), $replaceAll = true)
    {
        $this
            ->setMilestones($milestones)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get milestones value
     * @return \StructType\JobMilestones[]|null
     */
    public function getMilestones()
    {
        return $this->milestones;
    }
    /**
     * This method is responsible for validating the values passed to the setMilestones method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMilestones method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMilestonesForArrayConstraintsFromSetMilestones(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jobMilestonesListMilestonesItem) {
            // validation for constraint: itemType
            if (!$jobMilestonesListMilestonesItem instanceof \StructType\JobMilestones) {
                $invalidValues[] = is_object($jobMilestonesListMilestonesItem) ? get_class($jobMilestonesListMilestonesItem) : sprintf('%s(%s)', gettype($jobMilestonesListMilestonesItem), var_export($jobMilestonesListMilestonesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The milestones property can only contain items of type \StructType\JobMilestones, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set milestones value
     * @throws \InvalidArgumentException
     * @param \StructType\JobMilestones[] $milestones
     * @return \StructType\JobMilestonesList
     */
    public function setMilestones(array $milestones = array())
    {
        // validation for constraint: array
        if ('' !== ($milestonesArrayErrorMessage = self::validateMilestonesForArrayConstraintsFromSetMilestones($milestones))) {
            throw new \InvalidArgumentException($milestonesArrayErrorMessage, __LINE__);
        }
        $this->milestones = $milestones;
        return $this;
    }
    /**
     * Add item to milestones value
     * @throws \InvalidArgumentException
     * @param \StructType\JobMilestones $item
     * @return \StructType\JobMilestonesList
     */
    public function addToMilestones(\StructType\JobMilestones $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobMilestones) {
            throw new \InvalidArgumentException(sprintf('The milestones property can only contain items of type \StructType\JobMilestones, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->milestones[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\JobMilestonesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
