<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobCreditCardsList StructType
 * @subpackage Structs
 */
class JobCreditCardsList extends AbstractStructBase
{
    /**
     * The creditCards
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JobCreditCards[]
     */
    public $creditCards;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for JobCreditCardsList
     * @uses JobCreditCardsList::setCreditCards()
     * @uses JobCreditCardsList::setReplaceAll()
     * @param \StructType\JobCreditCards[] $creditCards
     * @param bool $replaceAll
     */
    public function __construct(array $creditCards = array(), $replaceAll = true)
    {
        $this
            ->setCreditCards($creditCards)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get creditCards value
     * @return \StructType\JobCreditCards[]|null
     */
    public function getCreditCards()
    {
        return $this->creditCards;
    }
    /**
     * This method is responsible for validating the values passed to the setCreditCards method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreditCards method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreditCardsForArrayConstraintsFromSetCreditCards(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jobCreditCardsListCreditCardsItem) {
            // validation for constraint: itemType
            if (!$jobCreditCardsListCreditCardsItem instanceof \StructType\JobCreditCards) {
                $invalidValues[] = is_object($jobCreditCardsListCreditCardsItem) ? get_class($jobCreditCardsListCreditCardsItem) : sprintf('%s(%s)', gettype($jobCreditCardsListCreditCardsItem), var_export($jobCreditCardsListCreditCardsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The creditCards property can only contain items of type \StructType\JobCreditCards, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set creditCards value
     * @throws \InvalidArgumentException
     * @param \StructType\JobCreditCards[] $creditCards
     * @return \StructType\JobCreditCardsList
     */
    public function setCreditCards(array $creditCards = array())
    {
        // validation for constraint: array
        if ('' !== ($creditCardsArrayErrorMessage = self::validateCreditCardsForArrayConstraintsFromSetCreditCards($creditCards))) {
            throw new \InvalidArgumentException($creditCardsArrayErrorMessage, __LINE__);
        }
        $this->creditCards = $creditCards;
        return $this;
    }
    /**
     * Add item to creditCards value
     * @throws \InvalidArgumentException
     * @param \StructType\JobCreditCards $item
     * @return \StructType\JobCreditCardsList
     */
    public function addToCreditCards(\StructType\JobCreditCards $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobCreditCards) {
            throw new \InvalidArgumentException(sprintf('The creditCards property can only contain items of type \StructType\JobCreditCards, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->creditCards[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\JobCreditCardsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
