<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobCreditCards StructType
 * @subpackage Structs
 */
class JobCreditCards extends AbstractStructBase
{
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalId;
    /**
     * The ccNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccNumber;
    /**
     * The ccExpireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccExpireDate;
    /**
     * The ccName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccName;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentMethod;
    /**
     * The ccMemo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccMemo;
    /**
     * The ccDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccDefault;
    /**
     * The debitCardIssueNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $debitCardIssueNo;
    /**
     * The validFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $validFrom;
    /**
     * Constructor method for JobCreditCards
     * @uses JobCreditCards::setInternalId()
     * @uses JobCreditCards::setCcNumber()
     * @uses JobCreditCards::setCcExpireDate()
     * @uses JobCreditCards::setCcName()
     * @uses JobCreditCards::setPaymentMethod()
     * @uses JobCreditCards::setCcMemo()
     * @uses JobCreditCards::setCcDefault()
     * @uses JobCreditCards::setDebitCardIssueNo()
     * @uses JobCreditCards::setValidFrom()
     * @param string $internalId
     * @param string $ccNumber
     * @param string $ccExpireDate
     * @param string $ccName
     * @param \StructType\RecordRef $paymentMethod
     * @param string $ccMemo
     * @param bool $ccDefault
     * @param string $debitCardIssueNo
     * @param string $validFrom
     */
    public function __construct($internalId = null, $ccNumber = null, $ccExpireDate = null, $ccName = null, \StructType\RecordRef $paymentMethod = null, $ccMemo = null, $ccDefault = null, $debitCardIssueNo = null, $validFrom = null)
    {
        $this
            ->setInternalId($internalId)
            ->setCcNumber($ccNumber)
            ->setCcExpireDate($ccExpireDate)
            ->setCcName($ccName)
            ->setPaymentMethod($paymentMethod)
            ->setCcMemo($ccMemo)
            ->setCcDefault($ccDefault)
            ->setDebitCardIssueNo($debitCardIssueNo)
            ->setValidFrom($validFrom);
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\JobCreditCards
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get ccNumber value
     * @return string|null
     */
    public function getCcNumber()
    {
        return $this->ccNumber;
    }
    /**
     * Set ccNumber value
     * @param string $ccNumber
     * @return \StructType\JobCreditCards
     */
    public function setCcNumber($ccNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ccNumber) && !is_string($ccNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccNumber, true), gettype($ccNumber)), __LINE__);
        }
        $this->ccNumber = $ccNumber;
        return $this;
    }
    /**
     * Get ccExpireDate value
     * @return string|null
     */
    public function getCcExpireDate()
    {
        return $this->ccExpireDate;
    }
    /**
     * Set ccExpireDate value
     * @param string $ccExpireDate
     * @return \StructType\JobCreditCards
     */
    public function setCcExpireDate($ccExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($ccExpireDate) && !is_string($ccExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccExpireDate, true), gettype($ccExpireDate)), __LINE__);
        }
        $this->ccExpireDate = $ccExpireDate;
        return $this;
    }
    /**
     * Get ccName value
     * @return string|null
     */
    public function getCcName()
    {
        return $this->ccName;
    }
    /**
     * Set ccName value
     * @param string $ccName
     * @return \StructType\JobCreditCards
     */
    public function setCcName($ccName = null)
    {
        // validation for constraint: string
        if (!is_null($ccName) && !is_string($ccName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccName, true), gettype($ccName)), __LINE__);
        }
        $this->ccName = $ccName;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param \StructType\RecordRef $paymentMethod
     * @return \StructType\JobCreditCards
     */
    public function setPaymentMethod(\StructType\RecordRef $paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get ccMemo value
     * @return string|null
     */
    public function getCcMemo()
    {
        return $this->ccMemo;
    }
    /**
     * Set ccMemo value
     * @param string $ccMemo
     * @return \StructType\JobCreditCards
     */
    public function setCcMemo($ccMemo = null)
    {
        // validation for constraint: string
        if (!is_null($ccMemo) && !is_string($ccMemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccMemo, true), gettype($ccMemo)), __LINE__);
        }
        $this->ccMemo = $ccMemo;
        return $this;
    }
    /**
     * Get ccDefault value
     * @return bool|null
     */
    public function getCcDefault()
    {
        return $this->ccDefault;
    }
    /**
     * Set ccDefault value
     * @param bool $ccDefault
     * @return \StructType\JobCreditCards
     */
    public function setCcDefault($ccDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccDefault) && !is_bool($ccDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccDefault, true), gettype($ccDefault)), __LINE__);
        }
        $this->ccDefault = $ccDefault;
        return $this;
    }
    /**
     * Get debitCardIssueNo value
     * @return string|null
     */
    public function getDebitCardIssueNo()
    {
        return $this->debitCardIssueNo;
    }
    /**
     * Set debitCardIssueNo value
     * @param string $debitCardIssueNo
     * @return \StructType\JobCreditCards
     */
    public function setDebitCardIssueNo($debitCardIssueNo = null)
    {
        // validation for constraint: string
        if (!is_null($debitCardIssueNo) && !is_string($debitCardIssueNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debitCardIssueNo, true), gettype($debitCardIssueNo)), __LINE__);
        }
        $this->debitCardIssueNo = $debitCardIssueNo;
        return $this;
    }
    /**
     * Get validFrom value
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->validFrom;
    }
    /**
     * Set validFrom value
     * @param string $validFrom
     * @return \StructType\JobCreditCards
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->validFrom = $validFrom;
        return $this;
    }
}
