<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job StructType
 * Meta information extracted from the WSDL
 * - type: listRel:Job
 * @subpackage Structs
 */
class Job extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The entityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $entityId;
    /**
     * The altName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altName;
    /**
     * The companyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $companyName;
    /**
     * The phoneticName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phoneticName;
    /**
     * The entityStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityStatus;
    /**
     * The defaultAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $defaultAddress;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The percentCompleteOverrideList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobPercentCompleteOverrideList
     */
    public $percentCompleteOverrideList;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The billPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $billPay;
    /**
     * The dateCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateCreated;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The workplace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $workplace;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $language;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The accountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The fxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fxRate;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The altPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altPhone;
    /**
     * The calculatedEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calculatedEndDate;
    /**
     * The calculatedEndDateBaseline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calculatedEndDateBaseline;
    /**
     * The startDateBaseline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDateBaseline;
    /**
     * The projectedEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $projectedEndDate;
    /**
     * The projectedEndDateBaseline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $projectedEndDateBaseline;
    /**
     * The lastBaselineDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastBaselineDate;
    /**
     * The jobType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $jobType;
    /**
     * The percentComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentComplete;
    /**
     * The estimatedCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedCost;
    /**
     * The estimatedRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedRevenue;
    /**
     * The estimatedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $estimatedTime;
    /**
     * The estimatedTimeOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $estimatedTimeOverride;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The emailPreference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailPreference;
    /**
     * The openingBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $openingBalance;
    /**
     * The openingBalanceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openingBalanceDate;
    /**
     * The openingBalanceAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $openingBalanceAccount;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The jobBillingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $jobBillingType;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The jobItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $jobItem;
    /**
     * The percentTimeComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentTimeComplete;
    /**
     * The actualTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $actualTime;
    /**
     * The allowTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowTime;
    /**
     * The timeRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $timeRemaining;
    /**
     * The limitTimeToAssignees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $limitTimeToAssignees;
    /**
     * The estimatedLaborCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedLaborCost;
    /**
     * The estimatedLaborCostBaseline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedLaborCostBaseline;
    /**
     * The estimateRevRecTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $estimateRevRecTemplate;
    /**
     * The revRecForecastRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecForecastRule;
    /**
     * The usePercentCompleteOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $usePercentCompleteOverride;
    /**
     * The estimatedLaborRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedLaborRevenue;
    /**
     * The estimatedGrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedGrossProfit;
    /**
     * The estimatedGrossProfitPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedGrossProfitPercent;
    /**
     * The projectExpenseType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $projectExpenseType;
    /**
     * The applyProjectExpenseTypeToAll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $applyProjectExpenseTypeToAll;
    /**
     * The allowAllResourcesForTasks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowAllResourcesForTasks;
    /**
     * The jobPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $jobPrice;
    /**
     * The isUtilizedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isUtilizedTime;
    /**
     * The isProductiveTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isProductiveTime;
    /**
     * The isExemptTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isExemptTime;
    /**
     * The materializeTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $materializeTime;
    /**
     * The allowExpenses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowExpenses;
    /**
     * The allocatePayrollExpenses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allocatePayrollExpenses;
    /**
     * The includeCrmTasksInTotals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeCrmTasksInTotals;
    /**
     * The globalSubscriptionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $globalSubscriptionStatus;
    /**
     * The jobResourcesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobResourcesList
     */
    public $jobResourcesList;
    /**
     * The plStatementList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobPlStatementList
     */
    public $plStatementList;
    /**
     * The addressbookList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobAddressbookList
     */
    public $addressbookList;
    /**
     * The milestonesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobMilestonesList
     */
    public $milestonesList;
    /**
     * The creditCardsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobCreditCardsList
     */
    public $creditCardsList;
    /**
     * The timeApproval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $timeApproval;
    /**
     * The plannedWork
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $plannedWork;
    /**
     * The plannedWorkBaseline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $plannedWorkBaseline;
    /**
     * The billingRateCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingRateCard;
    /**
     * The createChargeRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $createChargeRule;
    /**
     * The sourceServiceItemFromRateCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sourceServiceItemFromRateCard;
    /**
     * The projectManager
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $projectManager;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Job
     * @uses Job::setCustomForm()
     * @uses Job::setEntityId()
     * @uses Job::setAltName()
     * @uses Job::setCompanyName()
     * @uses Job::setPhoneticName()
     * @uses Job::setEntityStatus()
     * @uses Job::setDefaultAddress()
     * @uses Job::setParent()
     * @uses Job::setIsInactive()
     * @uses Job::setPercentCompleteOverrideList()
     * @uses Job::setLastModifiedDate()
     * @uses Job::setBillPay()
     * @uses Job::setDateCreated()
     * @uses Job::setCategory()
     * @uses Job::setWorkplace()
     * @uses Job::setLanguage()
     * @uses Job::setComments()
     * @uses Job::setAccountNumber()
     * @uses Job::setCurrency()
     * @uses Job::setFxRate()
     * @uses Job::setStartDate()
     * @uses Job::setEndDate()
     * @uses Job::setPhone()
     * @uses Job::setAltPhone()
     * @uses Job::setCalculatedEndDate()
     * @uses Job::setCalculatedEndDateBaseline()
     * @uses Job::setStartDateBaseline()
     * @uses Job::setProjectedEndDate()
     * @uses Job::setProjectedEndDateBaseline()
     * @uses Job::setLastBaselineDate()
     * @uses Job::setJobType()
     * @uses Job::setPercentComplete()
     * @uses Job::setEstimatedCost()
     * @uses Job::setEstimatedRevenue()
     * @uses Job::setEstimatedTime()
     * @uses Job::setEstimatedTimeOverride()
     * @uses Job::setFax()
     * @uses Job::setEmail()
     * @uses Job::setEmailPreference()
     * @uses Job::setOpeningBalance()
     * @uses Job::setOpeningBalanceDate()
     * @uses Job::setOpeningBalanceAccount()
     * @uses Job::setSubsidiary()
     * @uses Job::setJobBillingType()
     * @uses Job::setBillingSchedule()
     * @uses Job::setJobItem()
     * @uses Job::setPercentTimeComplete()
     * @uses Job::setActualTime()
     * @uses Job::setAllowTime()
     * @uses Job::setTimeRemaining()
     * @uses Job::setLimitTimeToAssignees()
     * @uses Job::setEstimatedLaborCost()
     * @uses Job::setEstimatedLaborCostBaseline()
     * @uses Job::setEstimateRevRecTemplate()
     * @uses Job::setRevRecForecastRule()
     * @uses Job::setUsePercentCompleteOverride()
     * @uses Job::setEstimatedLaborRevenue()
     * @uses Job::setEstimatedGrossProfit()
     * @uses Job::setEstimatedGrossProfitPercent()
     * @uses Job::setProjectExpenseType()
     * @uses Job::setApplyProjectExpenseTypeToAll()
     * @uses Job::setAllowAllResourcesForTasks()
     * @uses Job::setJobPrice()
     * @uses Job::setIsUtilizedTime()
     * @uses Job::setIsProductiveTime()
     * @uses Job::setIsExemptTime()
     * @uses Job::setMaterializeTime()
     * @uses Job::setAllowExpenses()
     * @uses Job::setAllocatePayrollExpenses()
     * @uses Job::setIncludeCrmTasksInTotals()
     * @uses Job::setGlobalSubscriptionStatus()
     * @uses Job::setJobResourcesList()
     * @uses Job::setPlStatementList()
     * @uses Job::setAddressbookList()
     * @uses Job::setMilestonesList()
     * @uses Job::setCreditCardsList()
     * @uses Job::setTimeApproval()
     * @uses Job::setPlannedWork()
     * @uses Job::setPlannedWorkBaseline()
     * @uses Job::setBillingRateCard()
     * @uses Job::setCreateChargeRule()
     * @uses Job::setSourceServiceItemFromRateCard()
     * @uses Job::setProjectManager()
     * @uses Job::setCustomFieldList()
     * @uses Job::setInternalId()
     * @uses Job::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $entityId
     * @param string $altName
     * @param string $companyName
     * @param string $phoneticName
     * @param \StructType\RecordRef $entityStatus
     * @param string $defaultAddress
     * @param \StructType\RecordRef $parent
     * @param bool $isInactive
     * @param \StructType\JobPercentCompleteOverrideList $percentCompleteOverrideList
     * @param string $lastModifiedDate
     * @param bool $billPay
     * @param string $dateCreated
     * @param \StructType\RecordRef $category
     * @param \StructType\RecordRef $workplace
     * @param \StructType\RecordRef $language
     * @param string $comments
     * @param string $accountNumber
     * @param \StructType\RecordRef $currency
     * @param float $fxRate
     * @param string $startDate
     * @param string $endDate
     * @param string $phone
     * @param string $altPhone
     * @param string $calculatedEndDate
     * @param string $calculatedEndDateBaseline
     * @param string $startDateBaseline
     * @param string $projectedEndDate
     * @param string $projectedEndDateBaseline
     * @param string $lastBaselineDate
     * @param \StructType\RecordRef $jobType
     * @param float $percentComplete
     * @param float $estimatedCost
     * @param float $estimatedRevenue
     * @param \StructType\Duration $estimatedTime
     * @param \StructType\Duration $estimatedTimeOverride
     * @param string $fax
     * @param string $email
     * @param string $emailPreference
     * @param float $openingBalance
     * @param string $openingBalanceDate
     * @param \StructType\RecordRef $openingBalanceAccount
     * @param \StructType\RecordRef $subsidiary
     * @param string $jobBillingType
     * @param \StructType\RecordRef $billingSchedule
     * @param \StructType\RecordRef $jobItem
     * @param float $percentTimeComplete
     * @param \StructType\Duration $actualTime
     * @param bool $allowTime
     * @param \StructType\Duration $timeRemaining
     * @param bool $limitTimeToAssignees
     * @param float $estimatedLaborCost
     * @param float $estimatedLaborCostBaseline
     * @param \StructType\RecordRef $estimateRevRecTemplate
     * @param \StructType\RecordRef $revRecForecastRule
     * @param bool $usePercentCompleteOverride
     * @param float $estimatedLaborRevenue
     * @param float $estimatedGrossProfit
     * @param float $estimatedGrossProfitPercent
     * @param \StructType\RecordRef $projectExpenseType
     * @param bool $applyProjectExpenseTypeToAll
     * @param bool $allowAllResourcesForTasks
     * @param float $jobPrice
     * @param bool $isUtilizedTime
     * @param bool $isProductiveTime
     * @param bool $isExemptTime
     * @param bool $materializeTime
     * @param bool $allowExpenses
     * @param bool $allocatePayrollExpenses
     * @param bool $includeCrmTasksInTotals
     * @param string $globalSubscriptionStatus
     * @param \StructType\JobResourcesList $jobResourcesList
     * @param \StructType\JobPlStatementList $plStatementList
     * @param \StructType\JobAddressbookList $addressbookList
     * @param \StructType\JobMilestonesList $milestonesList
     * @param \StructType\JobCreditCardsList $creditCardsList
     * @param \StructType\RecordRef $timeApproval
     * @param \StructType\Duration $plannedWork
     * @param \StructType\Duration $plannedWorkBaseline
     * @param \StructType\RecordRef $billingRateCard
     * @param bool $createChargeRule
     * @param bool $sourceServiceItemFromRateCard
     * @param \StructType\RecordRef $projectManager
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $entityId = null, $altName = null, $companyName = null, $phoneticName = null, \StructType\RecordRef $entityStatus = null, $defaultAddress = null, \StructType\RecordRef $parent = null, $isInactive = null, \StructType\JobPercentCompleteOverrideList $percentCompleteOverrideList = null, $lastModifiedDate = null, $billPay = null, $dateCreated = null, \StructType\RecordRef $category = null, \StructType\RecordRef $workplace = null, \StructType\RecordRef $language = null, $comments = null, $accountNumber = null, \StructType\RecordRef $currency = null, $fxRate = null, $startDate = null, $endDate = null, $phone = null, $altPhone = null, $calculatedEndDate = null, $calculatedEndDateBaseline = null, $startDateBaseline = null, $projectedEndDate = null, $projectedEndDateBaseline = null, $lastBaselineDate = null, \StructType\RecordRef $jobType = null, $percentComplete = null, $estimatedCost = null, $estimatedRevenue = null, \StructType\Duration $estimatedTime = null, \StructType\Duration $estimatedTimeOverride = null, $fax = null, $email = null, $emailPreference = null, $openingBalance = null, $openingBalanceDate = null, \StructType\RecordRef $openingBalanceAccount = null, \StructType\RecordRef $subsidiary = null, $jobBillingType = null, \StructType\RecordRef $billingSchedule = null, \StructType\RecordRef $jobItem = null, $percentTimeComplete = null, \StructType\Duration $actualTime = null, $allowTime = null, \StructType\Duration $timeRemaining = null, $limitTimeToAssignees = null, $estimatedLaborCost = null, $estimatedLaborCostBaseline = null, \StructType\RecordRef $estimateRevRecTemplate = null, \StructType\RecordRef $revRecForecastRule = null, $usePercentCompleteOverride = null, $estimatedLaborRevenue = null, $estimatedGrossProfit = null, $estimatedGrossProfitPercent = null, \StructType\RecordRef $projectExpenseType = null, $applyProjectExpenseTypeToAll = null, $allowAllResourcesForTasks = null, $jobPrice = null, $isUtilizedTime = null, $isProductiveTime = null, $isExemptTime = null, $materializeTime = null, $allowExpenses = null, $allocatePayrollExpenses = null, $includeCrmTasksInTotals = null, $globalSubscriptionStatus = null, \StructType\JobResourcesList $jobResourcesList = null, \StructType\JobPlStatementList $plStatementList = null, \StructType\JobAddressbookList $addressbookList = null, \StructType\JobMilestonesList $milestonesList = null, \StructType\JobCreditCardsList $creditCardsList = null, \StructType\RecordRef $timeApproval = null, \StructType\Duration $plannedWork = null, \StructType\Duration $plannedWorkBaseline = null, \StructType\RecordRef $billingRateCard = null, $createChargeRule = null, $sourceServiceItemFromRateCard = null, \StructType\RecordRef $projectManager = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setEntityId($entityId)
            ->setAltName($altName)
            ->setCompanyName($companyName)
            ->setPhoneticName($phoneticName)
            ->setEntityStatus($entityStatus)
            ->setDefaultAddress($defaultAddress)
            ->setParent($parent)
            ->setIsInactive($isInactive)
            ->setPercentCompleteOverrideList($percentCompleteOverrideList)
            ->setLastModifiedDate($lastModifiedDate)
            ->setBillPay($billPay)
            ->setDateCreated($dateCreated)
            ->setCategory($category)
            ->setWorkplace($workplace)
            ->setLanguage($language)
            ->setComments($comments)
            ->setAccountNumber($accountNumber)
            ->setCurrency($currency)
            ->setFxRate($fxRate)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setPhone($phone)
            ->setAltPhone($altPhone)
            ->setCalculatedEndDate($calculatedEndDate)
            ->setCalculatedEndDateBaseline($calculatedEndDateBaseline)
            ->setStartDateBaseline($startDateBaseline)
            ->setProjectedEndDate($projectedEndDate)
            ->setProjectedEndDateBaseline($projectedEndDateBaseline)
            ->setLastBaselineDate($lastBaselineDate)
            ->setJobType($jobType)
            ->setPercentComplete($percentComplete)
            ->setEstimatedCost($estimatedCost)
            ->setEstimatedRevenue($estimatedRevenue)
            ->setEstimatedTime($estimatedTime)
            ->setEstimatedTimeOverride($estimatedTimeOverride)
            ->setFax($fax)
            ->setEmail($email)
            ->setEmailPreference($emailPreference)
            ->setOpeningBalance($openingBalance)
            ->setOpeningBalanceDate($openingBalanceDate)
            ->setOpeningBalanceAccount($openingBalanceAccount)
            ->setSubsidiary($subsidiary)
            ->setJobBillingType($jobBillingType)
            ->setBillingSchedule($billingSchedule)
            ->setJobItem($jobItem)
            ->setPercentTimeComplete($percentTimeComplete)
            ->setActualTime($actualTime)
            ->setAllowTime($allowTime)
            ->setTimeRemaining($timeRemaining)
            ->setLimitTimeToAssignees($limitTimeToAssignees)
            ->setEstimatedLaborCost($estimatedLaborCost)
            ->setEstimatedLaborCostBaseline($estimatedLaborCostBaseline)
            ->setEstimateRevRecTemplate($estimateRevRecTemplate)
            ->setRevRecForecastRule($revRecForecastRule)
            ->setUsePercentCompleteOverride($usePercentCompleteOverride)
            ->setEstimatedLaborRevenue($estimatedLaborRevenue)
            ->setEstimatedGrossProfit($estimatedGrossProfit)
            ->setEstimatedGrossProfitPercent($estimatedGrossProfitPercent)
            ->setProjectExpenseType($projectExpenseType)
            ->setApplyProjectExpenseTypeToAll($applyProjectExpenseTypeToAll)
            ->setAllowAllResourcesForTasks($allowAllResourcesForTasks)
            ->setJobPrice($jobPrice)
            ->setIsUtilizedTime($isUtilizedTime)
            ->setIsProductiveTime($isProductiveTime)
            ->setIsExemptTime($isExemptTime)
            ->setMaterializeTime($materializeTime)
            ->setAllowExpenses($allowExpenses)
            ->setAllocatePayrollExpenses($allocatePayrollExpenses)
            ->setIncludeCrmTasksInTotals($includeCrmTasksInTotals)
            ->setGlobalSubscriptionStatus($globalSubscriptionStatus)
            ->setJobResourcesList($jobResourcesList)
            ->setPlStatementList($plStatementList)
            ->setAddressbookList($addressbookList)
            ->setMilestonesList($milestonesList)
            ->setCreditCardsList($creditCardsList)
            ->setTimeApproval($timeApproval)
            ->setPlannedWork($plannedWork)
            ->setPlannedWorkBaseline($plannedWorkBaseline)
            ->setBillingRateCard($billingRateCard)
            ->setCreateChargeRule($createChargeRule)
            ->setSourceServiceItemFromRateCard($sourceServiceItemFromRateCard)
            ->setProjectManager($projectManager)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Job
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get entityId value
     * @return string|null
     */
    public function getEntityId()
    {
        return $this->entityId;
    }
    /**
     * Set entityId value
     * @param string $entityId
     * @return \StructType\Job
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->entityId = $entityId;
        return $this;
    }
    /**
     * Get altName value
     * @return string|null
     */
    public function getAltName()
    {
        return $this->altName;
    }
    /**
     * Set altName value
     * @param string $altName
     * @return \StructType\Job
     */
    public function setAltName($altName = null)
    {
        // validation for constraint: string
        if (!is_null($altName) && !is_string($altName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altName, true), gettype($altName)), __LINE__);
        }
        $this->altName = $altName;
        return $this;
    }
    /**
     * Get companyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }
    /**
     * Set companyName value
     * @param string $companyName
     * @return \StructType\Job
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->companyName = $companyName;
        return $this;
    }
    /**
     * Get phoneticName value
     * @return string|null
     */
    public function getPhoneticName()
    {
        return $this->phoneticName;
    }
    /**
     * Set phoneticName value
     * @param string $phoneticName
     * @return \StructType\Job
     */
    public function setPhoneticName($phoneticName = null)
    {
        // validation for constraint: string
        if (!is_null($phoneticName) && !is_string($phoneticName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneticName, true), gettype($phoneticName)), __LINE__);
        }
        $this->phoneticName = $phoneticName;
        return $this;
    }
    /**
     * Get entityStatus value
     * @return \StructType\RecordRef|null
     */
    public function getEntityStatus()
    {
        return $this->entityStatus;
    }
    /**
     * Set entityStatus value
     * @param \StructType\RecordRef $entityStatus
     * @return \StructType\Job
     */
    public function setEntityStatus(\StructType\RecordRef $entityStatus = null)
    {
        $this->entityStatus = $entityStatus;
        return $this;
    }
    /**
     * Get defaultAddress value
     * @return string|null
     */
    public function getDefaultAddress()
    {
        return $this->defaultAddress;
    }
    /**
     * Set defaultAddress value
     * @param string $defaultAddress
     * @return \StructType\Job
     */
    public function setDefaultAddress($defaultAddress = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddress) && !is_string($defaultAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddress, true), gettype($defaultAddress)), __LINE__);
        }
        $this->defaultAddress = $defaultAddress;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\Job
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Job
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get percentCompleteOverrideList value
     * @return \StructType\JobPercentCompleteOverrideList|null
     */
    public function getPercentCompleteOverrideList()
    {
        return $this->percentCompleteOverrideList;
    }
    /**
     * Set percentCompleteOverrideList value
     * @param \StructType\JobPercentCompleteOverrideList $percentCompleteOverrideList
     * @return \StructType\Job
     */
    public function setPercentCompleteOverrideList(\StructType\JobPercentCompleteOverrideList $percentCompleteOverrideList = null)
    {
        $this->percentCompleteOverrideList = $percentCompleteOverrideList;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Job
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get billPay value
     * @return bool|null
     */
    public function getBillPay()
    {
        return $this->billPay;
    }
    /**
     * Set billPay value
     * @param bool $billPay
     * @return \StructType\Job
     */
    public function setBillPay($billPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($billPay) && !is_bool($billPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billPay, true), gettype($billPay)), __LINE__);
        }
        $this->billPay = $billPay;
        return $this;
    }
    /**
     * Get dateCreated value
     * @return string|null
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
    /**
     * Set dateCreated value
     * @param string $dateCreated
     * @return \StructType\Job
     */
    public function setDateCreated($dateCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreated) && !is_string($dateCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreated, true), gettype($dateCreated)), __LINE__);
        }
        $this->dateCreated = $dateCreated;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\Job
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get workplace value
     * @return \StructType\RecordRef|null
     */
    public function getWorkplace()
    {
        return $this->workplace;
    }
    /**
     * Set workplace value
     * @param \StructType\RecordRef $workplace
     * @return \StructType\Job
     */
    public function setWorkplace(\StructType\RecordRef $workplace = null)
    {
        $this->workplace = $workplace;
        return $this;
    }
    /**
     * Get language value
     * @return \StructType\RecordRef|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param \StructType\RecordRef $language
     * @return \StructType\Job
     */
    public function setLanguage(\StructType\RecordRef $language = null)
    {
        $this->language = $language;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\Job
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\Job
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Job
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get fxRate value
     * @return float|null
     */
    public function getFxRate()
    {
        return $this->fxRate;
    }
    /**
     * Set fxRate value
     * @param float $fxRate
     * @return \StructType\Job
     */
    public function setFxRate($fxRate = null)
    {
        // validation for constraint: float
        if (!is_null($fxRate) && !(is_float($fxRate) || is_numeric($fxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fxRate, true), gettype($fxRate)), __LINE__);
        }
        $this->fxRate = $fxRate;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\Job
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\Job
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Job
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get altPhone value
     * @return string|null
     */
    public function getAltPhone()
    {
        return $this->altPhone;
    }
    /**
     * Set altPhone value
     * @param string $altPhone
     * @return \StructType\Job
     */
    public function setAltPhone($altPhone = null)
    {
        // validation for constraint: string
        if (!is_null($altPhone) && !is_string($altPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altPhone, true), gettype($altPhone)), __LINE__);
        }
        $this->altPhone = $altPhone;
        return $this;
    }
    /**
     * Get calculatedEndDate value
     * @return string|null
     */
    public function getCalculatedEndDate()
    {
        return $this->calculatedEndDate;
    }
    /**
     * Set calculatedEndDate value
     * @param string $calculatedEndDate
     * @return \StructType\Job
     */
    public function setCalculatedEndDate($calculatedEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($calculatedEndDate) && !is_string($calculatedEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calculatedEndDate, true), gettype($calculatedEndDate)), __LINE__);
        }
        $this->calculatedEndDate = $calculatedEndDate;
        return $this;
    }
    /**
     * Get calculatedEndDateBaseline value
     * @return string|null
     */
    public function getCalculatedEndDateBaseline()
    {
        return $this->calculatedEndDateBaseline;
    }
    /**
     * Set calculatedEndDateBaseline value
     * @param string $calculatedEndDateBaseline
     * @return \StructType\Job
     */
    public function setCalculatedEndDateBaseline($calculatedEndDateBaseline = null)
    {
        // validation for constraint: string
        if (!is_null($calculatedEndDateBaseline) && !is_string($calculatedEndDateBaseline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calculatedEndDateBaseline, true), gettype($calculatedEndDateBaseline)), __LINE__);
        }
        $this->calculatedEndDateBaseline = $calculatedEndDateBaseline;
        return $this;
    }
    /**
     * Get startDateBaseline value
     * @return string|null
     */
    public function getStartDateBaseline()
    {
        return $this->startDateBaseline;
    }
    /**
     * Set startDateBaseline value
     * @param string $startDateBaseline
     * @return \StructType\Job
     */
    public function setStartDateBaseline($startDateBaseline = null)
    {
        // validation for constraint: string
        if (!is_null($startDateBaseline) && !is_string($startDateBaseline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateBaseline, true), gettype($startDateBaseline)), __LINE__);
        }
        $this->startDateBaseline = $startDateBaseline;
        return $this;
    }
    /**
     * Get projectedEndDate value
     * @return string|null
     */
    public function getProjectedEndDate()
    {
        return $this->projectedEndDate;
    }
    /**
     * Set projectedEndDate value
     * @param string $projectedEndDate
     * @return \StructType\Job
     */
    public function setProjectedEndDate($projectedEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($projectedEndDate) && !is_string($projectedEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectedEndDate, true), gettype($projectedEndDate)), __LINE__);
        }
        $this->projectedEndDate = $projectedEndDate;
        return $this;
    }
    /**
     * Get projectedEndDateBaseline value
     * @return string|null
     */
    public function getProjectedEndDateBaseline()
    {
        return $this->projectedEndDateBaseline;
    }
    /**
     * Set projectedEndDateBaseline value
     * @param string $projectedEndDateBaseline
     * @return \StructType\Job
     */
    public function setProjectedEndDateBaseline($projectedEndDateBaseline = null)
    {
        // validation for constraint: string
        if (!is_null($projectedEndDateBaseline) && !is_string($projectedEndDateBaseline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectedEndDateBaseline, true), gettype($projectedEndDateBaseline)), __LINE__);
        }
        $this->projectedEndDateBaseline = $projectedEndDateBaseline;
        return $this;
    }
    /**
     * Get lastBaselineDate value
     * @return string|null
     */
    public function getLastBaselineDate()
    {
        return $this->lastBaselineDate;
    }
    /**
     * Set lastBaselineDate value
     * @param string $lastBaselineDate
     * @return \StructType\Job
     */
    public function setLastBaselineDate($lastBaselineDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastBaselineDate) && !is_string($lastBaselineDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastBaselineDate, true), gettype($lastBaselineDate)), __LINE__);
        }
        $this->lastBaselineDate = $lastBaselineDate;
        return $this;
    }
    /**
     * Get jobType value
     * @return \StructType\RecordRef|null
     */
    public function getJobType()
    {
        return $this->jobType;
    }
    /**
     * Set jobType value
     * @param \StructType\RecordRef $jobType
     * @return \StructType\Job
     */
    public function setJobType(\StructType\RecordRef $jobType = null)
    {
        $this->jobType = $jobType;
        return $this;
    }
    /**
     * Get percentComplete value
     * @return float|null
     */
    public function getPercentComplete()
    {
        return $this->percentComplete;
    }
    /**
     * Set percentComplete value
     * @param float $percentComplete
     * @return \StructType\Job
     */
    public function setPercentComplete($percentComplete = null)
    {
        // validation for constraint: float
        if (!is_null($percentComplete) && !(is_float($percentComplete) || is_numeric($percentComplete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentComplete, true), gettype($percentComplete)), __LINE__);
        }
        $this->percentComplete = $percentComplete;
        return $this;
    }
    /**
     * Get estimatedCost value
     * @return float|null
     */
    public function getEstimatedCost()
    {
        return $this->estimatedCost;
    }
    /**
     * Set estimatedCost value
     * @param float $estimatedCost
     * @return \StructType\Job
     */
    public function setEstimatedCost($estimatedCost = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedCost) && !(is_float($estimatedCost) || is_numeric($estimatedCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedCost, true), gettype($estimatedCost)), __LINE__);
        }
        $this->estimatedCost = $estimatedCost;
        return $this;
    }
    /**
     * Get estimatedRevenue value
     * @return float|null
     */
    public function getEstimatedRevenue()
    {
        return $this->estimatedRevenue;
    }
    /**
     * Set estimatedRevenue value
     * @param float $estimatedRevenue
     * @return \StructType\Job
     */
    public function setEstimatedRevenue($estimatedRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedRevenue) && !(is_float($estimatedRevenue) || is_numeric($estimatedRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedRevenue, true), gettype($estimatedRevenue)), __LINE__);
        }
        $this->estimatedRevenue = $estimatedRevenue;
        return $this;
    }
    /**
     * Get estimatedTime value
     * @return \StructType\Duration|null
     */
    public function getEstimatedTime()
    {
        return $this->estimatedTime;
    }
    /**
     * Set estimatedTime value
     * @param \StructType\Duration $estimatedTime
     * @return \StructType\Job
     */
    public function setEstimatedTime(\StructType\Duration $estimatedTime = null)
    {
        $this->estimatedTime = $estimatedTime;
        return $this;
    }
    /**
     * Get estimatedTimeOverride value
     * @return \StructType\Duration|null
     */
    public function getEstimatedTimeOverride()
    {
        return $this->estimatedTimeOverride;
    }
    /**
     * Set estimatedTimeOverride value
     * @param \StructType\Duration $estimatedTimeOverride
     * @return \StructType\Job
     */
    public function setEstimatedTimeOverride(\StructType\Duration $estimatedTimeOverride = null)
    {
        $this->estimatedTimeOverride = $estimatedTimeOverride;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Job
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Job
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get emailPreference value
     * @return string|null
     */
    public function getEmailPreference()
    {
        return $this->emailPreference;
    }
    /**
     * Set emailPreference value
     * @uses \EnumType\EmailPreference::valueIsValid()
     * @uses \EnumType\EmailPreference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emailPreference
     * @return \StructType\Job
     */
    public function setEmailPreference($emailPreference = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmailPreference::valueIsValid($emailPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmailPreference', is_array($emailPreference) ? implode(', ', $emailPreference) : var_export($emailPreference, true), implode(', ', \EnumType\EmailPreference::getValidValues())), __LINE__);
        }
        $this->emailPreference = $emailPreference;
        return $this;
    }
    /**
     * Get openingBalance value
     * @return float|null
     */
    public function getOpeningBalance()
    {
        return $this->openingBalance;
    }
    /**
     * Set openingBalance value
     * @param float $openingBalance
     * @return \StructType\Job
     */
    public function setOpeningBalance($openingBalance = null)
    {
        // validation for constraint: float
        if (!is_null($openingBalance) && !(is_float($openingBalance) || is_numeric($openingBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($openingBalance, true), gettype($openingBalance)), __LINE__);
        }
        $this->openingBalance = $openingBalance;
        return $this;
    }
    /**
     * Get openingBalanceDate value
     * @return string|null
     */
    public function getOpeningBalanceDate()
    {
        return $this->openingBalanceDate;
    }
    /**
     * Set openingBalanceDate value
     * @param string $openingBalanceDate
     * @return \StructType\Job
     */
    public function setOpeningBalanceDate($openingBalanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($openingBalanceDate) && !is_string($openingBalanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingBalanceDate, true), gettype($openingBalanceDate)), __LINE__);
        }
        $this->openingBalanceDate = $openingBalanceDate;
        return $this;
    }
    /**
     * Get openingBalanceAccount value
     * @return \StructType\RecordRef|null
     */
    public function getOpeningBalanceAccount()
    {
        return $this->openingBalanceAccount;
    }
    /**
     * Set openingBalanceAccount value
     * @param \StructType\RecordRef $openingBalanceAccount
     * @return \StructType\Job
     */
    public function setOpeningBalanceAccount(\StructType\RecordRef $openingBalanceAccount = null)
    {
        $this->openingBalanceAccount = $openingBalanceAccount;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\Job
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get jobBillingType value
     * @return string|null
     */
    public function getJobBillingType()
    {
        return $this->jobBillingType;
    }
    /**
     * Set jobBillingType value
     * @uses \EnumType\JobBillingType::valueIsValid()
     * @uses \EnumType\JobBillingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jobBillingType
     * @return \StructType\Job
     */
    public function setJobBillingType($jobBillingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JobBillingType::valueIsValid($jobBillingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JobBillingType', is_array($jobBillingType) ? implode(', ', $jobBillingType) : var_export($jobBillingType, true), implode(', ', \EnumType\JobBillingType::getValidValues())), __LINE__);
        }
        $this->jobBillingType = $jobBillingType;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\Job
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get jobItem value
     * @return \StructType\RecordRef|null
     */
    public function getJobItem()
    {
        return $this->jobItem;
    }
    /**
     * Set jobItem value
     * @param \StructType\RecordRef $jobItem
     * @return \StructType\Job
     */
    public function setJobItem(\StructType\RecordRef $jobItem = null)
    {
        $this->jobItem = $jobItem;
        return $this;
    }
    /**
     * Get percentTimeComplete value
     * @return float|null
     */
    public function getPercentTimeComplete()
    {
        return $this->percentTimeComplete;
    }
    /**
     * Set percentTimeComplete value
     * @param float $percentTimeComplete
     * @return \StructType\Job
     */
    public function setPercentTimeComplete($percentTimeComplete = null)
    {
        // validation for constraint: float
        if (!is_null($percentTimeComplete) && !(is_float($percentTimeComplete) || is_numeric($percentTimeComplete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentTimeComplete, true), gettype($percentTimeComplete)), __LINE__);
        }
        $this->percentTimeComplete = $percentTimeComplete;
        return $this;
    }
    /**
     * Get actualTime value
     * @return \StructType\Duration|null
     */
    public function getActualTime()
    {
        return $this->actualTime;
    }
    /**
     * Set actualTime value
     * @param \StructType\Duration $actualTime
     * @return \StructType\Job
     */
    public function setActualTime(\StructType\Duration $actualTime = null)
    {
        $this->actualTime = $actualTime;
        return $this;
    }
    /**
     * Get allowTime value
     * @return bool|null
     */
    public function getAllowTime()
    {
        return $this->allowTime;
    }
    /**
     * Set allowTime value
     * @param bool $allowTime
     * @return \StructType\Job
     */
    public function setAllowTime($allowTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowTime) && !is_bool($allowTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowTime, true), gettype($allowTime)), __LINE__);
        }
        $this->allowTime = $allowTime;
        return $this;
    }
    /**
     * Get timeRemaining value
     * @return \StructType\Duration|null
     */
    public function getTimeRemaining()
    {
        return $this->timeRemaining;
    }
    /**
     * Set timeRemaining value
     * @param \StructType\Duration $timeRemaining
     * @return \StructType\Job
     */
    public function setTimeRemaining(\StructType\Duration $timeRemaining = null)
    {
        $this->timeRemaining = $timeRemaining;
        return $this;
    }
    /**
     * Get limitTimeToAssignees value
     * @return bool|null
     */
    public function getLimitTimeToAssignees()
    {
        return $this->limitTimeToAssignees;
    }
    /**
     * Set limitTimeToAssignees value
     * @param bool $limitTimeToAssignees
     * @return \StructType\Job
     */
    public function setLimitTimeToAssignees($limitTimeToAssignees = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitTimeToAssignees) && !is_bool($limitTimeToAssignees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($limitTimeToAssignees, true), gettype($limitTimeToAssignees)), __LINE__);
        }
        $this->limitTimeToAssignees = $limitTimeToAssignees;
        return $this;
    }
    /**
     * Get estimatedLaborCost value
     * @return float|null
     */
    public function getEstimatedLaborCost()
    {
        return $this->estimatedLaborCost;
    }
    /**
     * Set estimatedLaborCost value
     * @param float $estimatedLaborCost
     * @return \StructType\Job
     */
    public function setEstimatedLaborCost($estimatedLaborCost = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedLaborCost) && !(is_float($estimatedLaborCost) || is_numeric($estimatedLaborCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedLaborCost, true), gettype($estimatedLaborCost)), __LINE__);
        }
        $this->estimatedLaborCost = $estimatedLaborCost;
        return $this;
    }
    /**
     * Get estimatedLaborCostBaseline value
     * @return float|null
     */
    public function getEstimatedLaborCostBaseline()
    {
        return $this->estimatedLaborCostBaseline;
    }
    /**
     * Set estimatedLaborCostBaseline value
     * @param float $estimatedLaborCostBaseline
     * @return \StructType\Job
     */
    public function setEstimatedLaborCostBaseline($estimatedLaborCostBaseline = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedLaborCostBaseline) && !(is_float($estimatedLaborCostBaseline) || is_numeric($estimatedLaborCostBaseline))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedLaborCostBaseline, true), gettype($estimatedLaborCostBaseline)), __LINE__);
        }
        $this->estimatedLaborCostBaseline = $estimatedLaborCostBaseline;
        return $this;
    }
    /**
     * Get estimateRevRecTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getEstimateRevRecTemplate()
    {
        return $this->estimateRevRecTemplate;
    }
    /**
     * Set estimateRevRecTemplate value
     * @param \StructType\RecordRef $estimateRevRecTemplate
     * @return \StructType\Job
     */
    public function setEstimateRevRecTemplate(\StructType\RecordRef $estimateRevRecTemplate = null)
    {
        $this->estimateRevRecTemplate = $estimateRevRecTemplate;
        return $this;
    }
    /**
     * Get revRecForecastRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecForecastRule()
    {
        return $this->revRecForecastRule;
    }
    /**
     * Set revRecForecastRule value
     * @param \StructType\RecordRef $revRecForecastRule
     * @return \StructType\Job
     */
    public function setRevRecForecastRule(\StructType\RecordRef $revRecForecastRule = null)
    {
        $this->revRecForecastRule = $revRecForecastRule;
        return $this;
    }
    /**
     * Get usePercentCompleteOverride value
     * @return bool|null
     */
    public function getUsePercentCompleteOverride()
    {
        return $this->usePercentCompleteOverride;
    }
    /**
     * Set usePercentCompleteOverride value
     * @param bool $usePercentCompleteOverride
     * @return \StructType\Job
     */
    public function setUsePercentCompleteOverride($usePercentCompleteOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePercentCompleteOverride) && !is_bool($usePercentCompleteOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePercentCompleteOverride, true), gettype($usePercentCompleteOverride)), __LINE__);
        }
        $this->usePercentCompleteOverride = $usePercentCompleteOverride;
        return $this;
    }
    /**
     * Get estimatedLaborRevenue value
     * @return float|null
     */
    public function getEstimatedLaborRevenue()
    {
        return $this->estimatedLaborRevenue;
    }
    /**
     * Set estimatedLaborRevenue value
     * @param float $estimatedLaborRevenue
     * @return \StructType\Job
     */
    public function setEstimatedLaborRevenue($estimatedLaborRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedLaborRevenue) && !(is_float($estimatedLaborRevenue) || is_numeric($estimatedLaborRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedLaborRevenue, true), gettype($estimatedLaborRevenue)), __LINE__);
        }
        $this->estimatedLaborRevenue = $estimatedLaborRevenue;
        return $this;
    }
    /**
     * Get estimatedGrossProfit value
     * @return float|null
     */
    public function getEstimatedGrossProfit()
    {
        return $this->estimatedGrossProfit;
    }
    /**
     * Set estimatedGrossProfit value
     * @param float $estimatedGrossProfit
     * @return \StructType\Job
     */
    public function setEstimatedGrossProfit($estimatedGrossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedGrossProfit) && !(is_float($estimatedGrossProfit) || is_numeric($estimatedGrossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedGrossProfit, true), gettype($estimatedGrossProfit)), __LINE__);
        }
        $this->estimatedGrossProfit = $estimatedGrossProfit;
        return $this;
    }
    /**
     * Get estimatedGrossProfitPercent value
     * @return float|null
     */
    public function getEstimatedGrossProfitPercent()
    {
        return $this->estimatedGrossProfitPercent;
    }
    /**
     * Set estimatedGrossProfitPercent value
     * @param float $estimatedGrossProfitPercent
     * @return \StructType\Job
     */
    public function setEstimatedGrossProfitPercent($estimatedGrossProfitPercent = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedGrossProfitPercent) && !(is_float($estimatedGrossProfitPercent) || is_numeric($estimatedGrossProfitPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedGrossProfitPercent, true), gettype($estimatedGrossProfitPercent)), __LINE__);
        }
        $this->estimatedGrossProfitPercent = $estimatedGrossProfitPercent;
        return $this;
    }
    /**
     * Get projectExpenseType value
     * @return \StructType\RecordRef|null
     */
    public function getProjectExpenseType()
    {
        return $this->projectExpenseType;
    }
    /**
     * Set projectExpenseType value
     * @param \StructType\RecordRef $projectExpenseType
     * @return \StructType\Job
     */
    public function setProjectExpenseType(\StructType\RecordRef $projectExpenseType = null)
    {
        $this->projectExpenseType = $projectExpenseType;
        return $this;
    }
    /**
     * Get applyProjectExpenseTypeToAll value
     * @return bool|null
     */
    public function getApplyProjectExpenseTypeToAll()
    {
        return $this->applyProjectExpenseTypeToAll;
    }
    /**
     * Set applyProjectExpenseTypeToAll value
     * @param bool $applyProjectExpenseTypeToAll
     * @return \StructType\Job
     */
    public function setApplyProjectExpenseTypeToAll($applyProjectExpenseTypeToAll = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyProjectExpenseTypeToAll) && !is_bool($applyProjectExpenseTypeToAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyProjectExpenseTypeToAll, true), gettype($applyProjectExpenseTypeToAll)), __LINE__);
        }
        $this->applyProjectExpenseTypeToAll = $applyProjectExpenseTypeToAll;
        return $this;
    }
    /**
     * Get allowAllResourcesForTasks value
     * @return bool|null
     */
    public function getAllowAllResourcesForTasks()
    {
        return $this->allowAllResourcesForTasks;
    }
    /**
     * Set allowAllResourcesForTasks value
     * @param bool $allowAllResourcesForTasks
     * @return \StructType\Job
     */
    public function setAllowAllResourcesForTasks($allowAllResourcesForTasks = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAllResourcesForTasks) && !is_bool($allowAllResourcesForTasks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowAllResourcesForTasks, true), gettype($allowAllResourcesForTasks)), __LINE__);
        }
        $this->allowAllResourcesForTasks = $allowAllResourcesForTasks;
        return $this;
    }
    /**
     * Get jobPrice value
     * @return float|null
     */
    public function getJobPrice()
    {
        return $this->jobPrice;
    }
    /**
     * Set jobPrice value
     * @param float $jobPrice
     * @return \StructType\Job
     */
    public function setJobPrice($jobPrice = null)
    {
        // validation for constraint: float
        if (!is_null($jobPrice) && !(is_float($jobPrice) || is_numeric($jobPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($jobPrice, true), gettype($jobPrice)), __LINE__);
        }
        $this->jobPrice = $jobPrice;
        return $this;
    }
    /**
     * Get isUtilizedTime value
     * @return bool|null
     */
    public function getIsUtilizedTime()
    {
        return $this->isUtilizedTime;
    }
    /**
     * Set isUtilizedTime value
     * @param bool $isUtilizedTime
     * @return \StructType\Job
     */
    public function setIsUtilizedTime($isUtilizedTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUtilizedTime) && !is_bool($isUtilizedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUtilizedTime, true), gettype($isUtilizedTime)), __LINE__);
        }
        $this->isUtilizedTime = $isUtilizedTime;
        return $this;
    }
    /**
     * Get isProductiveTime value
     * @return bool|null
     */
    public function getIsProductiveTime()
    {
        return $this->isProductiveTime;
    }
    /**
     * Set isProductiveTime value
     * @param bool $isProductiveTime
     * @return \StructType\Job
     */
    public function setIsProductiveTime($isProductiveTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProductiveTime) && !is_bool($isProductiveTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProductiveTime, true), gettype($isProductiveTime)), __LINE__);
        }
        $this->isProductiveTime = $isProductiveTime;
        return $this;
    }
    /**
     * Get isExemptTime value
     * @return bool|null
     */
    public function getIsExemptTime()
    {
        return $this->isExemptTime;
    }
    /**
     * Set isExemptTime value
     * @param bool $isExemptTime
     * @return \StructType\Job
     */
    public function setIsExemptTime($isExemptTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExemptTime) && !is_bool($isExemptTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExemptTime, true), gettype($isExemptTime)), __LINE__);
        }
        $this->isExemptTime = $isExemptTime;
        return $this;
    }
    /**
     * Get materializeTime value
     * @return bool|null
     */
    public function getMaterializeTime()
    {
        return $this->materializeTime;
    }
    /**
     * Set materializeTime value
     * @param bool $materializeTime
     * @return \StructType\Job
     */
    public function setMaterializeTime($materializeTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($materializeTime) && !is_bool($materializeTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($materializeTime, true), gettype($materializeTime)), __LINE__);
        }
        $this->materializeTime = $materializeTime;
        return $this;
    }
    /**
     * Get allowExpenses value
     * @return bool|null
     */
    public function getAllowExpenses()
    {
        return $this->allowExpenses;
    }
    /**
     * Set allowExpenses value
     * @param bool $allowExpenses
     * @return \StructType\Job
     */
    public function setAllowExpenses($allowExpenses = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowExpenses) && !is_bool($allowExpenses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowExpenses, true), gettype($allowExpenses)), __LINE__);
        }
        $this->allowExpenses = $allowExpenses;
        return $this;
    }
    /**
     * Get allocatePayrollExpenses value
     * @return bool|null
     */
    public function getAllocatePayrollExpenses()
    {
        return $this->allocatePayrollExpenses;
    }
    /**
     * Set allocatePayrollExpenses value
     * @param bool $allocatePayrollExpenses
     * @return \StructType\Job
     */
    public function setAllocatePayrollExpenses($allocatePayrollExpenses = null)
    {
        // validation for constraint: boolean
        if (!is_null($allocatePayrollExpenses) && !is_bool($allocatePayrollExpenses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allocatePayrollExpenses, true), gettype($allocatePayrollExpenses)), __LINE__);
        }
        $this->allocatePayrollExpenses = $allocatePayrollExpenses;
        return $this;
    }
    /**
     * Get includeCrmTasksInTotals value
     * @return bool|null
     */
    public function getIncludeCrmTasksInTotals()
    {
        return $this->includeCrmTasksInTotals;
    }
    /**
     * Set includeCrmTasksInTotals value
     * @param bool $includeCrmTasksInTotals
     * @return \StructType\Job
     */
    public function setIncludeCrmTasksInTotals($includeCrmTasksInTotals = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCrmTasksInTotals) && !is_bool($includeCrmTasksInTotals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCrmTasksInTotals, true), gettype($includeCrmTasksInTotals)), __LINE__);
        }
        $this->includeCrmTasksInTotals = $includeCrmTasksInTotals;
        return $this;
    }
    /**
     * Get globalSubscriptionStatus value
     * @return string|null
     */
    public function getGlobalSubscriptionStatus()
    {
        return $this->globalSubscriptionStatus;
    }
    /**
     * Set globalSubscriptionStatus value
     * @uses \EnumType\GlobalSubscriptionStatus::valueIsValid()
     * @uses \EnumType\GlobalSubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $globalSubscriptionStatus
     * @return \StructType\Job
     */
    public function setGlobalSubscriptionStatus($globalSubscriptionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GlobalSubscriptionStatus::valueIsValid($globalSubscriptionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GlobalSubscriptionStatus', is_array($globalSubscriptionStatus) ? implode(', ', $globalSubscriptionStatus) : var_export($globalSubscriptionStatus, true), implode(', ', \EnumType\GlobalSubscriptionStatus::getValidValues())), __LINE__);
        }
        $this->globalSubscriptionStatus = $globalSubscriptionStatus;
        return $this;
    }
    /**
     * Get jobResourcesList value
     * @return \StructType\JobResourcesList|null
     */
    public function getJobResourcesList()
    {
        return $this->jobResourcesList;
    }
    /**
     * Set jobResourcesList value
     * @param \StructType\JobResourcesList $jobResourcesList
     * @return \StructType\Job
     */
    public function setJobResourcesList(\StructType\JobResourcesList $jobResourcesList = null)
    {
        $this->jobResourcesList = $jobResourcesList;
        return $this;
    }
    /**
     * Get plStatementList value
     * @return \StructType\JobPlStatementList|null
     */
    public function getPlStatementList()
    {
        return $this->plStatementList;
    }
    /**
     * Set plStatementList value
     * @param \StructType\JobPlStatementList $plStatementList
     * @return \StructType\Job
     */
    public function setPlStatementList(\StructType\JobPlStatementList $plStatementList = null)
    {
        $this->plStatementList = $plStatementList;
        return $this;
    }
    /**
     * Get addressbookList value
     * @return \StructType\JobAddressbookList|null
     */
    public function getAddressbookList()
    {
        return $this->addressbookList;
    }
    /**
     * Set addressbookList value
     * @param \StructType\JobAddressbookList $addressbookList
     * @return \StructType\Job
     */
    public function setAddressbookList(\StructType\JobAddressbookList $addressbookList = null)
    {
        $this->addressbookList = $addressbookList;
        return $this;
    }
    /**
     * Get milestonesList value
     * @return \StructType\JobMilestonesList|null
     */
    public function getMilestonesList()
    {
        return $this->milestonesList;
    }
    /**
     * Set milestonesList value
     * @param \StructType\JobMilestonesList $milestonesList
     * @return \StructType\Job
     */
    public function setMilestonesList(\StructType\JobMilestonesList $milestonesList = null)
    {
        $this->milestonesList = $milestonesList;
        return $this;
    }
    /**
     * Get creditCardsList value
     * @return \StructType\JobCreditCardsList|null
     */
    public function getCreditCardsList()
    {
        return $this->creditCardsList;
    }
    /**
     * Set creditCardsList value
     * @param \StructType\JobCreditCardsList $creditCardsList
     * @return \StructType\Job
     */
    public function setCreditCardsList(\StructType\JobCreditCardsList $creditCardsList = null)
    {
        $this->creditCardsList = $creditCardsList;
        return $this;
    }
    /**
     * Get timeApproval value
     * @return \StructType\RecordRef|null
     */
    public function getTimeApproval()
    {
        return $this->timeApproval;
    }
    /**
     * Set timeApproval value
     * @param \StructType\RecordRef $timeApproval
     * @return \StructType\Job
     */
    public function setTimeApproval(\StructType\RecordRef $timeApproval = null)
    {
        $this->timeApproval = $timeApproval;
        return $this;
    }
    /**
     * Get plannedWork value
     * @return \StructType\Duration|null
     */
    public function getPlannedWork()
    {
        return $this->plannedWork;
    }
    /**
     * Set plannedWork value
     * @param \StructType\Duration $plannedWork
     * @return \StructType\Job
     */
    public function setPlannedWork(\StructType\Duration $plannedWork = null)
    {
        $this->plannedWork = $plannedWork;
        return $this;
    }
    /**
     * Get plannedWorkBaseline value
     * @return \StructType\Duration|null
     */
    public function getPlannedWorkBaseline()
    {
        return $this->plannedWorkBaseline;
    }
    /**
     * Set plannedWorkBaseline value
     * @param \StructType\Duration $plannedWorkBaseline
     * @return \StructType\Job
     */
    public function setPlannedWorkBaseline(\StructType\Duration $plannedWorkBaseline = null)
    {
        $this->plannedWorkBaseline = $plannedWorkBaseline;
        return $this;
    }
    /**
     * Get billingRateCard value
     * @return \StructType\RecordRef|null
     */
    public function getBillingRateCard()
    {
        return $this->billingRateCard;
    }
    /**
     * Set billingRateCard value
     * @param \StructType\RecordRef $billingRateCard
     * @return \StructType\Job
     */
    public function setBillingRateCard(\StructType\RecordRef $billingRateCard = null)
    {
        $this->billingRateCard = $billingRateCard;
        return $this;
    }
    /**
     * Get createChargeRule value
     * @return bool|null
     */
    public function getCreateChargeRule()
    {
        return $this->createChargeRule;
    }
    /**
     * Set createChargeRule value
     * @param bool $createChargeRule
     * @return \StructType\Job
     */
    public function setCreateChargeRule($createChargeRule = null)
    {
        // validation for constraint: boolean
        if (!is_null($createChargeRule) && !is_bool($createChargeRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createChargeRule, true), gettype($createChargeRule)), __LINE__);
        }
        $this->createChargeRule = $createChargeRule;
        return $this;
    }
    /**
     * Get sourceServiceItemFromRateCard value
     * @return bool|null
     */
    public function getSourceServiceItemFromRateCard()
    {
        return $this->sourceServiceItemFromRateCard;
    }
    /**
     * Set sourceServiceItemFromRateCard value
     * @param bool $sourceServiceItemFromRateCard
     * @return \StructType\Job
     */
    public function setSourceServiceItemFromRateCard($sourceServiceItemFromRateCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($sourceServiceItemFromRateCard) && !is_bool($sourceServiceItemFromRateCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sourceServiceItemFromRateCard, true), gettype($sourceServiceItemFromRateCard)), __LINE__);
        }
        $this->sourceServiceItemFromRateCard = $sourceServiceItemFromRateCard;
        return $this;
    }
    /**
     * Get projectManager value
     * @return \StructType\RecordRef|null
     */
    public function getProjectManager()
    {
        return $this->projectManager;
    }
    /**
     * Set projectManager value
     * @param \StructType\RecordRef $projectManager
     * @return \StructType\Job
     */
    public function setProjectManager(\StructType\RecordRef $projectManager = null)
    {
        $this->projectManager = $projectManager;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Job
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Job
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Job
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
