<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemsList StructType
 * @subpackage Structs
 */
class ItemsList extends AbstractStructBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RecordRef[]
     */
    public $items;
    /**
     * Constructor method for ItemsList
     * @uses ItemsList::setItems()
     * @param \StructType\RecordRef[] $items
     */
    public function __construct(array $items = array())
    {
        $this
            ->setItems($items);
    }
    /**
     * Get items value
     * @return \StructType\RecordRef[]|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemsListItemsItem) {
            // validation for constraint: itemType
            if (!$itemsListItemsItem instanceof \StructType\RecordRef) {
                $invalidValues[] = is_object($itemsListItemsItem) ? get_class($itemsListItemsItem) : sprintf('%s(%s)', gettype($itemsListItemsItem), var_export($itemsListItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \StructType\RecordRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef[] $items
     * @return \StructType\ItemsList
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef $item
     * @return \StructType\ItemsList
     */
    public function addToItems(\StructType\RecordRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecordRef) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \StructType\RecordRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
}
