<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemVendorList StructType
 * @subpackage Structs
 */
class ItemVendorList extends AbstractStructBase
{
    /**
     * The itemVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemVendor[]
     */
    public $itemVendor;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemVendorList
     * @uses ItemVendorList::setItemVendor()
     * @uses ItemVendorList::setReplaceAll()
     * @param \StructType\ItemVendor[] $itemVendor
     * @param bool $replaceAll
     */
    public function __construct(array $itemVendor = array(), $replaceAll = true)
    {
        $this
            ->setItemVendor($itemVendor)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get itemVendor value
     * @return \StructType\ItemVendor[]|null
     */
    public function getItemVendor()
    {
        return $this->itemVendor;
    }
    /**
     * This method is responsible for validating the values passed to the setItemVendor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemVendor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemVendorForArrayConstraintsFromSetItemVendor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemVendorListItemVendorItem) {
            // validation for constraint: itemType
            if (!$itemVendorListItemVendorItem instanceof \StructType\ItemVendor) {
                $invalidValues[] = is_object($itemVendorListItemVendorItem) ? get_class($itemVendorListItemVendorItem) : sprintf('%s(%s)', gettype($itemVendorListItemVendorItem), var_export($itemVendorListItemVendorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemVendor property can only contain items of type \StructType\ItemVendor, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemVendor value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemVendor[] $itemVendor
     * @return \StructType\ItemVendorList
     */
    public function setItemVendor(array $itemVendor = array())
    {
        // validation for constraint: array
        if ('' !== ($itemVendorArrayErrorMessage = self::validateItemVendorForArrayConstraintsFromSetItemVendor($itemVendor))) {
            throw new \InvalidArgumentException($itemVendorArrayErrorMessage, __LINE__);
        }
        $this->itemVendor = $itemVendor;
        return $this;
    }
    /**
     * Add item to itemVendor value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemVendor $item
     * @return \StructType\ItemVendorList
     */
    public function addToItemVendor(\StructType\ItemVendor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemVendor) {
            throw new \InvalidArgumentException(sprintf('The itemVendor property can only contain items of type \StructType\ItemVendor, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemVendor[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemVendorList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
