<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSupplyPlanSearchRowBasic StructType
 * @subpackage Structs
 */
class ItemSupplyPlanSearchRowBasic extends SearchRowBasic
{
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $item;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $lastModifiedDate;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $location;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $memo;
    /**
     * The orderCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $orderCreated;
    /**
     * The orderDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $orderDate;
    /**
     * The orderType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $orderType;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantity;
    /**
     * The quantityUom
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityUom;
    /**
     * The receiptDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $receiptDate;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiary;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $units;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ItemSupplyPlanSearchRowBasic
     * @uses ItemSupplyPlanSearchRowBasic::setExternalId()
     * @uses ItemSupplyPlanSearchRowBasic::setInternalId()
     * @uses ItemSupplyPlanSearchRowBasic::setItem()
     * @uses ItemSupplyPlanSearchRowBasic::setLastModifiedDate()
     * @uses ItemSupplyPlanSearchRowBasic::setLocation()
     * @uses ItemSupplyPlanSearchRowBasic::setMemo()
     * @uses ItemSupplyPlanSearchRowBasic::setOrderCreated()
     * @uses ItemSupplyPlanSearchRowBasic::setOrderDate()
     * @uses ItemSupplyPlanSearchRowBasic::setOrderType()
     * @uses ItemSupplyPlanSearchRowBasic::setQuantity()
     * @uses ItemSupplyPlanSearchRowBasic::setQuantityUom()
     * @uses ItemSupplyPlanSearchRowBasic::setReceiptDate()
     * @uses ItemSupplyPlanSearchRowBasic::setSubsidiary()
     * @uses ItemSupplyPlanSearchRowBasic::setUnits()
     * @uses ItemSupplyPlanSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $item
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @param \StructType\SearchColumnSelectField[] $location
     * @param \StructType\SearchColumnStringField[] $memo
     * @param \StructType\SearchColumnBooleanField[] $orderCreated
     * @param \StructType\SearchColumnDateField[] $orderDate
     * @param \StructType\SearchColumnSelectField[] $orderType
     * @param \StructType\SearchColumnDoubleField[] $quantity
     * @param \StructType\SearchColumnDoubleField[] $quantityUom
     * @param \StructType\SearchColumnDateField[] $receiptDate
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @param \StructType\SearchColumnSelectField[] $units
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $externalId = array(), array $internalId = array(), array $item = array(), array $lastModifiedDate = array(), array $location = array(), array $memo = array(), array $orderCreated = array(), array $orderDate = array(), array $orderType = array(), array $quantity = array(), array $quantityUom = array(), array $receiptDate = array(), array $subsidiary = array(), array $units = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setItem($item)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLocation($location)
            ->setMemo($memo)
            ->setOrderCreated($orderCreated)
            ->setOrderDate($orderDate)
            ->setOrderType($orderType)
            ->setQuantity($quantity)
            ->setQuantityUom($quantityUom)
            ->setReceiptDate($receiptDate)
            ->setSubsidiary($subsidiary)
            ->setUnits($units)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicExternalIdItem) ? get_class($itemSupplyPlanSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicExternalIdItem), var_export($itemSupplyPlanSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicInternalIdItem) ? get_class($itemSupplyPlanSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicInternalIdItem), var_export($itemSupplyPlanSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicItemItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicItemItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicItemItem) ? get_class($itemSupplyPlanSearchRowBasicItemItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicItemItem), var_export($itemSupplyPlanSearchRowBasicItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToItem(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * This method is responsible for validating the values passed to the setLastModifiedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastModifiedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicLastModifiedDateItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicLastModifiedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicLastModifiedDateItem) ? get_class($itemSupplyPlanSearchRowBasicLastModifiedDateItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicLastModifiedDateItem), var_export($itemSupplyPlanSearchRowBasicLastModifiedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setLastModifiedDate(array $lastModifiedDate = array())
    {
        // validation for constraint: array
        if ('' !== ($lastModifiedDateArrayErrorMessage = self::validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate($lastModifiedDate))) {
            throw new \InvalidArgumentException($lastModifiedDateArrayErrorMessage, __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Add item to lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToLastModifiedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lastModifiedDate[] = $item;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicLocationItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicLocationItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicLocationItem) ? get_class($itemSupplyPlanSearchRowBasicLocationItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicLocationItem), var_export($itemSupplyPlanSearchRowBasicLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $location
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Add item to location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToLocation(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->location[] = $item;
        return $this;
    }
    /**
     * Get memo value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * This method is responsible for validating the values passed to the setMemo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMemo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMemoForArrayConstraintsFromSetMemo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicMemoItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicMemoItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicMemoItem) ? get_class($itemSupplyPlanSearchRowBasicMemoItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicMemoItem), var_export($itemSupplyPlanSearchRowBasicMemoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The memo property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set memo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $memo
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setMemo(array $memo = array())
    {
        // validation for constraint: array
        if ('' !== ($memoArrayErrorMessage = self::validateMemoForArrayConstraintsFromSetMemo($memo))) {
            throw new \InvalidArgumentException($memoArrayErrorMessage, __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Add item to memo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToMemo(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The memo property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->memo[] = $item;
        return $this;
    }
    /**
     * Get orderCreated value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getOrderCreated()
    {
        return $this->orderCreated;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderCreated method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderCreated method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderCreatedForArrayConstraintsFromSetOrderCreated(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicOrderCreatedItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicOrderCreatedItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicOrderCreatedItem) ? get_class($itemSupplyPlanSearchRowBasicOrderCreatedItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicOrderCreatedItem), var_export($itemSupplyPlanSearchRowBasicOrderCreatedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderCreated property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderCreated value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $orderCreated
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setOrderCreated(array $orderCreated = array())
    {
        // validation for constraint: array
        if ('' !== ($orderCreatedArrayErrorMessage = self::validateOrderCreatedForArrayConstraintsFromSetOrderCreated($orderCreated))) {
            throw new \InvalidArgumentException($orderCreatedArrayErrorMessage, __LINE__);
        }
        $this->orderCreated = $orderCreated;
        return $this;
    }
    /**
     * Add item to orderCreated value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToOrderCreated(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The orderCreated property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderCreated[] = $item;
        return $this;
    }
    /**
     * Get orderDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderDateForArrayConstraintsFromSetOrderDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicOrderDateItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicOrderDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicOrderDateItem) ? get_class($itemSupplyPlanSearchRowBasicOrderDateItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicOrderDateItem), var_export($itemSupplyPlanSearchRowBasicOrderDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $orderDate
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setOrderDate(array $orderDate = array())
    {
        // validation for constraint: array
        if ('' !== ($orderDateArrayErrorMessage = self::validateOrderDateForArrayConstraintsFromSetOrderDate($orderDate))) {
            throw new \InvalidArgumentException($orderDateArrayErrorMessage, __LINE__);
        }
        $this->orderDate = $orderDate;
        return $this;
    }
    /**
     * Add item to orderDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToOrderDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The orderDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderDate[] = $item;
        return $this;
    }
    /**
     * Get orderType value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderTypeForArrayConstraintsFromSetOrderType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicOrderTypeItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicOrderTypeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicOrderTypeItem) ? get_class($itemSupplyPlanSearchRowBasicOrderTypeItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicOrderTypeItem), var_export($itemSupplyPlanSearchRowBasicOrderTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $orderType
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setOrderType(array $orderType = array())
    {
        // validation for constraint: array
        if ('' !== ($orderTypeArrayErrorMessage = self::validateOrderTypeForArrayConstraintsFromSetOrderType($orderType))) {
            throw new \InvalidArgumentException($orderTypeArrayErrorMessage, __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Add item to orderType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToOrderType(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The orderType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderType[] = $item;
        return $this;
    }
    /**
     * Get quantity value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityForArrayConstraintsFromSetQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicQuantityItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicQuantityItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicQuantityItem) ? get_class($itemSupplyPlanSearchRowBasicQuantityItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicQuantityItem), var_export($itemSupplyPlanSearchRowBasicQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantity property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantity
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setQuantity(array $quantity = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityArrayErrorMessage = self::validateQuantityForArrayConstraintsFromSetQuantity($quantity))) {
            throw new \InvalidArgumentException($quantityArrayErrorMessage, __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Add item to quantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToQuantity(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantity property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantity[] = $item;
        return $this;
    }
    /**
     * Get quantityUom value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityUom()
    {
        return $this->quantityUom;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityUom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityUom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityUomForArrayConstraintsFromSetQuantityUom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicQuantityUomItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicQuantityUomItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicQuantityUomItem) ? get_class($itemSupplyPlanSearchRowBasicQuantityUomItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicQuantityUomItem), var_export($itemSupplyPlanSearchRowBasicQuantityUomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityUom property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityUom value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityUom
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setQuantityUom(array $quantityUom = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityUomArrayErrorMessage = self::validateQuantityUomForArrayConstraintsFromSetQuantityUom($quantityUom))) {
            throw new \InvalidArgumentException($quantityUomArrayErrorMessage, __LINE__);
        }
        $this->quantityUom = $quantityUom;
        return $this;
    }
    /**
     * Add item to quantityUom value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToQuantityUom(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityUom property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityUom[] = $item;
        return $this;
    }
    /**
     * Get receiptDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getReceiptDate()
    {
        return $this->receiptDate;
    }
    /**
     * This method is responsible for validating the values passed to the setReceiptDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiptDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptDateForArrayConstraintsFromSetReceiptDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicReceiptDateItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicReceiptDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicReceiptDateItem) ? get_class($itemSupplyPlanSearchRowBasicReceiptDateItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicReceiptDateItem), var_export($itemSupplyPlanSearchRowBasicReceiptDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The receiptDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set receiptDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $receiptDate
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setReceiptDate(array $receiptDate = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptDateArrayErrorMessage = self::validateReceiptDateForArrayConstraintsFromSetReceiptDate($receiptDate))) {
            throw new \InvalidArgumentException($receiptDateArrayErrorMessage, __LINE__);
        }
        $this->receiptDate = $receiptDate;
        return $this;
    }
    /**
     * Add item to receiptDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToReceiptDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The receiptDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->receiptDate[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicSubsidiaryItem) ? get_class($itemSupplyPlanSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicSubsidiaryItem), var_export($itemSupplyPlanSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * This method is responsible for validating the values passed to the setUnits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitsForArrayConstraintsFromSetUnits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchRowBasicUnitsItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchRowBasicUnitsItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemSupplyPlanSearchRowBasicUnitsItem) ? get_class($itemSupplyPlanSearchRowBasicUnitsItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchRowBasicUnitsItem), var_export($itemSupplyPlanSearchRowBasicUnitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The units property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set units value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $units
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setUnits(array $units = array())
    {
        // validation for constraint: array
        if ('' !== ($unitsArrayErrorMessage = self::validateUnitsForArrayConstraintsFromSetUnits($units))) {
            throw new \InvalidArgumentException($unitsArrayErrorMessage, __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Add item to units value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function addToUnits(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The units property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->units[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\ItemSupplyPlanSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
