<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSupplyPlanOrderList StructType
 * @subpackage Structs
 */
class ItemSupplyPlanOrderList extends AbstractStructBase
{
    /**
     * The itemSupplyPlanOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemSupplyPlanOrder[]
     */
    public $itemSupplyPlanOrder;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemSupplyPlanOrderList
     * @uses ItemSupplyPlanOrderList::setItemSupplyPlanOrder()
     * @uses ItemSupplyPlanOrderList::setReplaceAll()
     * @param \StructType\ItemSupplyPlanOrder[] $itemSupplyPlanOrder
     * @param bool $replaceAll
     */
    public function __construct(array $itemSupplyPlanOrder = array(), $replaceAll = true)
    {
        $this
            ->setItemSupplyPlanOrder($itemSupplyPlanOrder)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get itemSupplyPlanOrder value
     * @return \StructType\ItemSupplyPlanOrder[]|null
     */
    public function getItemSupplyPlanOrder()
    {
        return $this->itemSupplyPlanOrder;
    }
    /**
     * This method is responsible for validating the values passed to the setItemSupplyPlanOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemSupplyPlanOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemSupplyPlanOrderForArrayConstraintsFromSetItemSupplyPlanOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanOrderListItemSupplyPlanOrderItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanOrderListItemSupplyPlanOrderItem instanceof \StructType\ItemSupplyPlanOrder) {
                $invalidValues[] = is_object($itemSupplyPlanOrderListItemSupplyPlanOrderItem) ? get_class($itemSupplyPlanOrderListItemSupplyPlanOrderItem) : sprintf('%s(%s)', gettype($itemSupplyPlanOrderListItemSupplyPlanOrderItem), var_export($itemSupplyPlanOrderListItemSupplyPlanOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemSupplyPlanOrder property can only contain items of type \StructType\ItemSupplyPlanOrder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemSupplyPlanOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemSupplyPlanOrder[] $itemSupplyPlanOrder
     * @return \StructType\ItemSupplyPlanOrderList
     */
    public function setItemSupplyPlanOrder(array $itemSupplyPlanOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($itemSupplyPlanOrderArrayErrorMessage = self::validateItemSupplyPlanOrderForArrayConstraintsFromSetItemSupplyPlanOrder($itemSupplyPlanOrder))) {
            throw new \InvalidArgumentException($itemSupplyPlanOrderArrayErrorMessage, __LINE__);
        }
        $this->itemSupplyPlanOrder = $itemSupplyPlanOrder;
        return $this;
    }
    /**
     * Add item to itemSupplyPlanOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemSupplyPlanOrder $item
     * @return \StructType\ItemSupplyPlanOrderList
     */
    public function addToItemSupplyPlanOrder(\StructType\ItemSupplyPlanOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemSupplyPlanOrder) {
            throw new \InvalidArgumentException(sprintf('The itemSupplyPlanOrder property can only contain items of type \StructType\ItemSupplyPlanOrder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemSupplyPlanOrder[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemSupplyPlanOrderList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
