<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSearch StructType
 * @subpackage Structs
 */
class ItemSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchBasic
     */
    public $basic;
    /**
     * The accountingBookRevRecScheduleJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RevRecTemplateSearchBasic
     */
    public $accountingBookRevRecScheduleJoin;
    /**
     * The assemblyItemBillOfMaterialsJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AssemblyItemBomSearchBasic
     */
    public $assemblyItemBillOfMaterialsJoin;
    /**
     * The binNumberJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BinSearchBasic
     */
    public $binNumberJoin;
    /**
     * The binOnHandJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemBinNumberSearchBasic
     */
    public $binOnHandJoin;
    /**
     * The correlatedItemJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchBasic
     */
    public $correlatedItemJoin;
    /**
     * The effectiveRevisionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemRevisionSearchBasic
     */
    public $effectiveRevisionJoin;
    /**
     * The fileJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FileSearchBasic
     */
    public $fileJoin;
    /**
     * The inventoryDetailJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetailSearchBasic
     */
    public $inventoryDetailJoin;
    /**
     * The inventoryLocationJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationSearchBasic
     */
    public $inventoryLocationJoin;
    /**
     * The inventoryNumberJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryNumberSearchBasic
     */
    public $inventoryNumberJoin;
    /**
     * The inventoryNumberBinOnHandJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryNumberBinSearchBasic
     */
    public $inventoryNumberBinOnHandJoin;
    /**
     * The memberItemJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchBasic
     */
    public $memberItemJoin;
    /**
     * The obsoleteRevisionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemRevisionSearchBasic
     */
    public $obsoleteRevisionJoin;
    /**
     * The parentJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchBasic
     */
    public $parentJoin;
    /**
     * The preferredLocationJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationSearchBasic
     */
    public $preferredLocationJoin;
    /**
     * The preferredVendorJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorSearchBasic
     */
    public $preferredVendorJoin;
    /**
     * The pricingJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingSearchBasic
     */
    public $pricingJoin;
    /**
     * The shopperJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerSearchBasic
     */
    public $shopperJoin;
    /**
     * The transactionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $transactionJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The userNotesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoteSearchBasic
     */
    public $userNotesJoin;
    /**
     * The vendorJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorSearchBasic
     */
    public $vendorJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for ItemSearch
     * @uses ItemSearch::setBasic()
     * @uses ItemSearch::setAccountingBookRevRecScheduleJoin()
     * @uses ItemSearch::setAssemblyItemBillOfMaterialsJoin()
     * @uses ItemSearch::setBinNumberJoin()
     * @uses ItemSearch::setBinOnHandJoin()
     * @uses ItemSearch::setCorrelatedItemJoin()
     * @uses ItemSearch::setEffectiveRevisionJoin()
     * @uses ItemSearch::setFileJoin()
     * @uses ItemSearch::setInventoryDetailJoin()
     * @uses ItemSearch::setInventoryLocationJoin()
     * @uses ItemSearch::setInventoryNumberJoin()
     * @uses ItemSearch::setInventoryNumberBinOnHandJoin()
     * @uses ItemSearch::setMemberItemJoin()
     * @uses ItemSearch::setObsoleteRevisionJoin()
     * @uses ItemSearch::setParentJoin()
     * @uses ItemSearch::setPreferredLocationJoin()
     * @uses ItemSearch::setPreferredVendorJoin()
     * @uses ItemSearch::setPricingJoin()
     * @uses ItemSearch::setShopperJoin()
     * @uses ItemSearch::setTransactionJoin()
     * @uses ItemSearch::setUserJoin()
     * @uses ItemSearch::setUserNotesJoin()
     * @uses ItemSearch::setVendorJoin()
     * @uses ItemSearch::setCustomSearchJoin()
     * @param \StructType\ItemSearchBasic $basic
     * @param \StructType\RevRecTemplateSearchBasic $accountingBookRevRecScheduleJoin
     * @param \StructType\AssemblyItemBomSearchBasic $assemblyItemBillOfMaterialsJoin
     * @param \StructType\BinSearchBasic $binNumberJoin
     * @param \StructType\ItemBinNumberSearchBasic $binOnHandJoin
     * @param \StructType\ItemSearchBasic $correlatedItemJoin
     * @param \StructType\ItemRevisionSearchBasic $effectiveRevisionJoin
     * @param \StructType\FileSearchBasic $fileJoin
     * @param \StructType\InventoryDetailSearchBasic $inventoryDetailJoin
     * @param \StructType\LocationSearchBasic $inventoryLocationJoin
     * @param \StructType\InventoryNumberSearchBasic $inventoryNumberJoin
     * @param \StructType\InventoryNumberBinSearchBasic $inventoryNumberBinOnHandJoin
     * @param \StructType\ItemSearchBasic $memberItemJoin
     * @param \StructType\ItemRevisionSearchBasic $obsoleteRevisionJoin
     * @param \StructType\ItemSearchBasic $parentJoin
     * @param \StructType\LocationSearchBasic $preferredLocationJoin
     * @param \StructType\VendorSearchBasic $preferredVendorJoin
     * @param \StructType\PricingSearchBasic $pricingJoin
     * @param \StructType\CustomerSearchBasic $shopperJoin
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @param \StructType\VendorSearchBasic $vendorJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\ItemSearchBasic $basic = null, \StructType\RevRecTemplateSearchBasic $accountingBookRevRecScheduleJoin = null, \StructType\AssemblyItemBomSearchBasic $assemblyItemBillOfMaterialsJoin = null, \StructType\BinSearchBasic $binNumberJoin = null, \StructType\ItemBinNumberSearchBasic $binOnHandJoin = null, \StructType\ItemSearchBasic $correlatedItemJoin = null, \StructType\ItemRevisionSearchBasic $effectiveRevisionJoin = null, \StructType\FileSearchBasic $fileJoin = null, \StructType\InventoryDetailSearchBasic $inventoryDetailJoin = null, \StructType\LocationSearchBasic $inventoryLocationJoin = null, \StructType\InventoryNumberSearchBasic $inventoryNumberJoin = null, \StructType\InventoryNumberBinSearchBasic $inventoryNumberBinOnHandJoin = null, \StructType\ItemSearchBasic $memberItemJoin = null, \StructType\ItemRevisionSearchBasic $obsoleteRevisionJoin = null, \StructType\ItemSearchBasic $parentJoin = null, \StructType\LocationSearchBasic $preferredLocationJoin = null, \StructType\VendorSearchBasic $preferredVendorJoin = null, \StructType\PricingSearchBasic $pricingJoin = null, \StructType\CustomerSearchBasic $shopperJoin = null, \StructType\TransactionSearchBasic $transactionJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, \StructType\NoteSearchBasic $userNotesJoin = null, \StructType\VendorSearchBasic $vendorJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setAccountingBookRevRecScheduleJoin($accountingBookRevRecScheduleJoin)
            ->setAssemblyItemBillOfMaterialsJoin($assemblyItemBillOfMaterialsJoin)
            ->setBinNumberJoin($binNumberJoin)
            ->setBinOnHandJoin($binOnHandJoin)
            ->setCorrelatedItemJoin($correlatedItemJoin)
            ->setEffectiveRevisionJoin($effectiveRevisionJoin)
            ->setFileJoin($fileJoin)
            ->setInventoryDetailJoin($inventoryDetailJoin)
            ->setInventoryLocationJoin($inventoryLocationJoin)
            ->setInventoryNumberJoin($inventoryNumberJoin)
            ->setInventoryNumberBinOnHandJoin($inventoryNumberBinOnHandJoin)
            ->setMemberItemJoin($memberItemJoin)
            ->setObsoleteRevisionJoin($obsoleteRevisionJoin)
            ->setParentJoin($parentJoin)
            ->setPreferredLocationJoin($preferredLocationJoin)
            ->setPreferredVendorJoin($preferredVendorJoin)
            ->setPricingJoin($pricingJoin)
            ->setShopperJoin($shopperJoin)
            ->setTransactionJoin($transactionJoin)
            ->setUserJoin($userJoin)
            ->setUserNotesJoin($userNotesJoin)
            ->setVendorJoin($vendorJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\ItemSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\ItemSearchBasic $basic
     * @return \StructType\ItemSearch
     */
    public function setBasic(\StructType\ItemSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get accountingBookRevRecScheduleJoin value
     * @return \StructType\RevRecTemplateSearchBasic|null
     */
    public function getAccountingBookRevRecScheduleJoin()
    {
        return $this->accountingBookRevRecScheduleJoin;
    }
    /**
     * Set accountingBookRevRecScheduleJoin value
     * @param \StructType\RevRecTemplateSearchBasic $accountingBookRevRecScheduleJoin
     * @return \StructType\ItemSearch
     */
    public function setAccountingBookRevRecScheduleJoin(\StructType\RevRecTemplateSearchBasic $accountingBookRevRecScheduleJoin = null)
    {
        $this->accountingBookRevRecScheduleJoin = $accountingBookRevRecScheduleJoin;
        return $this;
    }
    /**
     * Get assemblyItemBillOfMaterialsJoin value
     * @return \StructType\AssemblyItemBomSearchBasic|null
     */
    public function getAssemblyItemBillOfMaterialsJoin()
    {
        return $this->assemblyItemBillOfMaterialsJoin;
    }
    /**
     * Set assemblyItemBillOfMaterialsJoin value
     * @param \StructType\AssemblyItemBomSearchBasic $assemblyItemBillOfMaterialsJoin
     * @return \StructType\ItemSearch
     */
    public function setAssemblyItemBillOfMaterialsJoin(\StructType\AssemblyItemBomSearchBasic $assemblyItemBillOfMaterialsJoin = null)
    {
        $this->assemblyItemBillOfMaterialsJoin = $assemblyItemBillOfMaterialsJoin;
        return $this;
    }
    /**
     * Get binNumberJoin value
     * @return \StructType\BinSearchBasic|null
     */
    public function getBinNumberJoin()
    {
        return $this->binNumberJoin;
    }
    /**
     * Set binNumberJoin value
     * @param \StructType\BinSearchBasic $binNumberJoin
     * @return \StructType\ItemSearch
     */
    public function setBinNumberJoin(\StructType\BinSearchBasic $binNumberJoin = null)
    {
        $this->binNumberJoin = $binNumberJoin;
        return $this;
    }
    /**
     * Get binOnHandJoin value
     * @return \StructType\ItemBinNumberSearchBasic|null
     */
    public function getBinOnHandJoin()
    {
        return $this->binOnHandJoin;
    }
    /**
     * Set binOnHandJoin value
     * @param \StructType\ItemBinNumberSearchBasic $binOnHandJoin
     * @return \StructType\ItemSearch
     */
    public function setBinOnHandJoin(\StructType\ItemBinNumberSearchBasic $binOnHandJoin = null)
    {
        $this->binOnHandJoin = $binOnHandJoin;
        return $this;
    }
    /**
     * Get correlatedItemJoin value
     * @return \StructType\ItemSearchBasic|null
     */
    public function getCorrelatedItemJoin()
    {
        return $this->correlatedItemJoin;
    }
    /**
     * Set correlatedItemJoin value
     * @param \StructType\ItemSearchBasic $correlatedItemJoin
     * @return \StructType\ItemSearch
     */
    public function setCorrelatedItemJoin(\StructType\ItemSearchBasic $correlatedItemJoin = null)
    {
        $this->correlatedItemJoin = $correlatedItemJoin;
        return $this;
    }
    /**
     * Get effectiveRevisionJoin value
     * @return \StructType\ItemRevisionSearchBasic|null
     */
    public function getEffectiveRevisionJoin()
    {
        return $this->effectiveRevisionJoin;
    }
    /**
     * Set effectiveRevisionJoin value
     * @param \StructType\ItemRevisionSearchBasic $effectiveRevisionJoin
     * @return \StructType\ItemSearch
     */
    public function setEffectiveRevisionJoin(\StructType\ItemRevisionSearchBasic $effectiveRevisionJoin = null)
    {
        $this->effectiveRevisionJoin = $effectiveRevisionJoin;
        return $this;
    }
    /**
     * Get fileJoin value
     * @return \StructType\FileSearchBasic|null
     */
    public function getFileJoin()
    {
        return $this->fileJoin;
    }
    /**
     * Set fileJoin value
     * @param \StructType\FileSearchBasic $fileJoin
     * @return \StructType\ItemSearch
     */
    public function setFileJoin(\StructType\FileSearchBasic $fileJoin = null)
    {
        $this->fileJoin = $fileJoin;
        return $this;
    }
    /**
     * Get inventoryDetailJoin value
     * @return \StructType\InventoryDetailSearchBasic|null
     */
    public function getInventoryDetailJoin()
    {
        return $this->inventoryDetailJoin;
    }
    /**
     * Set inventoryDetailJoin value
     * @param \StructType\InventoryDetailSearchBasic $inventoryDetailJoin
     * @return \StructType\ItemSearch
     */
    public function setInventoryDetailJoin(\StructType\InventoryDetailSearchBasic $inventoryDetailJoin = null)
    {
        $this->inventoryDetailJoin = $inventoryDetailJoin;
        return $this;
    }
    /**
     * Get inventoryLocationJoin value
     * @return \StructType\LocationSearchBasic|null
     */
    public function getInventoryLocationJoin()
    {
        return $this->inventoryLocationJoin;
    }
    /**
     * Set inventoryLocationJoin value
     * @param \StructType\LocationSearchBasic $inventoryLocationJoin
     * @return \StructType\ItemSearch
     */
    public function setInventoryLocationJoin(\StructType\LocationSearchBasic $inventoryLocationJoin = null)
    {
        $this->inventoryLocationJoin = $inventoryLocationJoin;
        return $this;
    }
    /**
     * Get inventoryNumberJoin value
     * @return \StructType\InventoryNumberSearchBasic|null
     */
    public function getInventoryNumberJoin()
    {
        return $this->inventoryNumberJoin;
    }
    /**
     * Set inventoryNumberJoin value
     * @param \StructType\InventoryNumberSearchBasic $inventoryNumberJoin
     * @return \StructType\ItemSearch
     */
    public function setInventoryNumberJoin(\StructType\InventoryNumberSearchBasic $inventoryNumberJoin = null)
    {
        $this->inventoryNumberJoin = $inventoryNumberJoin;
        return $this;
    }
    /**
     * Get inventoryNumberBinOnHandJoin value
     * @return \StructType\InventoryNumberBinSearchBasic|null
     */
    public function getInventoryNumberBinOnHandJoin()
    {
        return $this->inventoryNumberBinOnHandJoin;
    }
    /**
     * Set inventoryNumberBinOnHandJoin value
     * @param \StructType\InventoryNumberBinSearchBasic $inventoryNumberBinOnHandJoin
     * @return \StructType\ItemSearch
     */
    public function setInventoryNumberBinOnHandJoin(\StructType\InventoryNumberBinSearchBasic $inventoryNumberBinOnHandJoin = null)
    {
        $this->inventoryNumberBinOnHandJoin = $inventoryNumberBinOnHandJoin;
        return $this;
    }
    /**
     * Get memberItemJoin value
     * @return \StructType\ItemSearchBasic|null
     */
    public function getMemberItemJoin()
    {
        return $this->memberItemJoin;
    }
    /**
     * Set memberItemJoin value
     * @param \StructType\ItemSearchBasic $memberItemJoin
     * @return \StructType\ItemSearch
     */
    public function setMemberItemJoin(\StructType\ItemSearchBasic $memberItemJoin = null)
    {
        $this->memberItemJoin = $memberItemJoin;
        return $this;
    }
    /**
     * Get obsoleteRevisionJoin value
     * @return \StructType\ItemRevisionSearchBasic|null
     */
    public function getObsoleteRevisionJoin()
    {
        return $this->obsoleteRevisionJoin;
    }
    /**
     * Set obsoleteRevisionJoin value
     * @param \StructType\ItemRevisionSearchBasic $obsoleteRevisionJoin
     * @return \StructType\ItemSearch
     */
    public function setObsoleteRevisionJoin(\StructType\ItemRevisionSearchBasic $obsoleteRevisionJoin = null)
    {
        $this->obsoleteRevisionJoin = $obsoleteRevisionJoin;
        return $this;
    }
    /**
     * Get parentJoin value
     * @return \StructType\ItemSearchBasic|null
     */
    public function getParentJoin()
    {
        return $this->parentJoin;
    }
    /**
     * Set parentJoin value
     * @param \StructType\ItemSearchBasic $parentJoin
     * @return \StructType\ItemSearch
     */
    public function setParentJoin(\StructType\ItemSearchBasic $parentJoin = null)
    {
        $this->parentJoin = $parentJoin;
        return $this;
    }
    /**
     * Get preferredLocationJoin value
     * @return \StructType\LocationSearchBasic|null
     */
    public function getPreferredLocationJoin()
    {
        return $this->preferredLocationJoin;
    }
    /**
     * Set preferredLocationJoin value
     * @param \StructType\LocationSearchBasic $preferredLocationJoin
     * @return \StructType\ItemSearch
     */
    public function setPreferredLocationJoin(\StructType\LocationSearchBasic $preferredLocationJoin = null)
    {
        $this->preferredLocationJoin = $preferredLocationJoin;
        return $this;
    }
    /**
     * Get preferredVendorJoin value
     * @return \StructType\VendorSearchBasic|null
     */
    public function getPreferredVendorJoin()
    {
        return $this->preferredVendorJoin;
    }
    /**
     * Set preferredVendorJoin value
     * @param \StructType\VendorSearchBasic $preferredVendorJoin
     * @return \StructType\ItemSearch
     */
    public function setPreferredVendorJoin(\StructType\VendorSearchBasic $preferredVendorJoin = null)
    {
        $this->preferredVendorJoin = $preferredVendorJoin;
        return $this;
    }
    /**
     * Get pricingJoin value
     * @return \StructType\PricingSearchBasic|null
     */
    public function getPricingJoin()
    {
        return $this->pricingJoin;
    }
    /**
     * Set pricingJoin value
     * @param \StructType\PricingSearchBasic $pricingJoin
     * @return \StructType\ItemSearch
     */
    public function setPricingJoin(\StructType\PricingSearchBasic $pricingJoin = null)
    {
        $this->pricingJoin = $pricingJoin;
        return $this;
    }
    /**
     * Get shopperJoin value
     * @return \StructType\CustomerSearchBasic|null
     */
    public function getShopperJoin()
    {
        return $this->shopperJoin;
    }
    /**
     * Set shopperJoin value
     * @param \StructType\CustomerSearchBasic $shopperJoin
     * @return \StructType\ItemSearch
     */
    public function setShopperJoin(\StructType\CustomerSearchBasic $shopperJoin = null)
    {
        $this->shopperJoin = $shopperJoin;
        return $this;
    }
    /**
     * Get transactionJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getTransactionJoin()
    {
        return $this->transactionJoin;
    }
    /**
     * Set transactionJoin value
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @return \StructType\ItemSearch
     */
    public function setTransactionJoin(\StructType\TransactionSearchBasic $transactionJoin = null)
    {
        $this->transactionJoin = $transactionJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\ItemSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get userNotesJoin value
     * @return \StructType\NoteSearchBasic|null
     */
    public function getUserNotesJoin()
    {
        return $this->userNotesJoin;
    }
    /**
     * Set userNotesJoin value
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @return \StructType\ItemSearch
     */
    public function setUserNotesJoin(\StructType\NoteSearchBasic $userNotesJoin = null)
    {
        $this->userNotesJoin = $userNotesJoin;
        return $this;
    }
    /**
     * Get vendorJoin value
     * @return \StructType\VendorSearchBasic|null
     */
    public function getVendorJoin()
    {
        return $this->vendorJoin;
    }
    /**
     * Set vendorJoin value
     * @param \StructType\VendorSearchBasic $vendorJoin
     * @return \StructType\ItemSearch
     */
    public function setVendorJoin(\StructType\VendorSearchBasic $vendorJoin = null)
    {
        $this->vendorJoin = $vendorJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$itemSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($itemSearchCustomSearchJoinItem) ? get_class($itemSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($itemSearchCustomSearchJoinItem), var_export($itemSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\ItemSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\ItemSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
