<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemRevision StructType
 * @subpackage Structs
 */
class ItemRevision extends Record
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effectiveDate;
    /**
     * The obsoleteDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $obsoleteDate;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The inactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inactive;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ItemRevision
     * @uses ItemRevision::setItem()
     * @uses ItemRevision::setName()
     * @uses ItemRevision::setEffectiveDate()
     * @uses ItemRevision::setObsoleteDate()
     * @uses ItemRevision::setMemo()
     * @uses ItemRevision::setInactive()
     * @uses ItemRevision::setInternalId()
     * @uses ItemRevision::setExternalId()
     * @param \StructType\RecordRef $item
     * @param string $name
     * @param string $effectiveDate
     * @param string $obsoleteDate
     * @param string $memo
     * @param bool $inactive
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $item = null, $name = null, $effectiveDate = null, $obsoleteDate = null, $memo = null, $inactive = null, $internalId = null, $externalId = null)
    {
        $this
            ->setItem($item)
            ->setName($name)
            ->setEffectiveDate($effectiveDate)
            ->setObsoleteDate($obsoleteDate)
            ->setMemo($memo)
            ->setInactive($inactive)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\ItemRevision
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ItemRevision
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\ItemRevision
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get obsoleteDate value
     * @return string|null
     */
    public function getObsoleteDate()
    {
        return $this->obsoleteDate;
    }
    /**
     * Set obsoleteDate value
     * @param string $obsoleteDate
     * @return \StructType\ItemRevision
     */
    public function setObsoleteDate($obsoleteDate = null)
    {
        // validation for constraint: string
        if (!is_null($obsoleteDate) && !is_string($obsoleteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obsoleteDate, true), gettype($obsoleteDate)), __LINE__);
        }
        $this->obsoleteDate = $obsoleteDate;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\ItemRevision
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->inactive;
    }
    /**
     * Set inactive value
     * @param bool $inactive
     * @return \StructType\ItemRevision
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->inactive = $inactive;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ItemRevision
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ItemRevision
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
