<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemReceiptExpenseList StructType
 * @subpackage Structs
 */
class ItemReceiptExpenseList extends AbstractStructBase
{
    /**
     * The expense
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemReceiptExpense[]
     */
    public $expense;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemReceiptExpenseList
     * @uses ItemReceiptExpenseList::setExpense()
     * @uses ItemReceiptExpenseList::setReplaceAll()
     * @param \StructType\ItemReceiptExpense[] $expense
     * @param bool $replaceAll
     */
    public function __construct(array $expense = array(), $replaceAll = true)
    {
        $this
            ->setExpense($expense)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get expense value
     * @return \StructType\ItemReceiptExpense[]|null
     */
    public function getExpense()
    {
        return $this->expense;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpenseForArrayConstraintsFromSetExpense(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemReceiptExpenseListExpenseItem) {
            // validation for constraint: itemType
            if (!$itemReceiptExpenseListExpenseItem instanceof \StructType\ItemReceiptExpense) {
                $invalidValues[] = is_object($itemReceiptExpenseListExpenseItem) ? get_class($itemReceiptExpenseListExpenseItem) : sprintf('%s(%s)', gettype($itemReceiptExpenseListExpenseItem), var_export($itemReceiptExpenseListExpenseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expense property can only contain items of type \StructType\ItemReceiptExpense, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expense value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemReceiptExpense[] $expense
     * @return \StructType\ItemReceiptExpenseList
     */
    public function setExpense(array $expense = array())
    {
        // validation for constraint: array
        if ('' !== ($expenseArrayErrorMessage = self::validateExpenseForArrayConstraintsFromSetExpense($expense))) {
            throw new \InvalidArgumentException($expenseArrayErrorMessage, __LINE__);
        }
        $this->expense = $expense;
        return $this;
    }
    /**
     * Add item to expense value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemReceiptExpense $item
     * @return \StructType\ItemReceiptExpenseList
     */
    public function addToExpense(\StructType\ItemReceiptExpense $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemReceiptExpense) {
            throw new \InvalidArgumentException(sprintf('The expense property can only contain items of type \StructType\ItemReceiptExpense, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expense[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemReceiptExpenseList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
