<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemReceiptExpense StructType
 * @subpackage Structs
 */
class ItemReceiptExpense extends AbstractStructBase
{
    /**
     * The markReceived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $markReceived;
    /**
     * The orderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderLine;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $account;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ItemReceiptExpense
     * @uses ItemReceiptExpense::setMarkReceived()
     * @uses ItemReceiptExpense::setOrderLine()
     * @uses ItemReceiptExpense::setLine()
     * @uses ItemReceiptExpense::setAccount()
     * @uses ItemReceiptExpense::setMemo()
     * @uses ItemReceiptExpense::setAmount()
     * @uses ItemReceiptExpense::setCustomFieldList()
     * @param bool $markReceived
     * @param int $orderLine
     * @param int $line
     * @param string $account
     * @param string $memo
     * @param float $amount
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($markReceived = null, $orderLine = null, $line = null, $account = null, $memo = null, $amount = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setMarkReceived($markReceived)
            ->setOrderLine($orderLine)
            ->setLine($line)
            ->setAccount($account)
            ->setMemo($memo)
            ->setAmount($amount)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get markReceived value
     * @return bool|null
     */
    public function getMarkReceived()
    {
        return $this->markReceived;
    }
    /**
     * Set markReceived value
     * @param bool $markReceived
     * @return \StructType\ItemReceiptExpense
     */
    public function setMarkReceived($markReceived = null)
    {
        // validation for constraint: boolean
        if (!is_null($markReceived) && !is_bool($markReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($markReceived, true), gettype($markReceived)), __LINE__);
        }
        $this->markReceived = $markReceived;
        return $this;
    }
    /**
     * Get orderLine value
     * @return int|null
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }
    /**
     * Set orderLine value
     * @param int $orderLine
     * @return \StructType\ItemReceiptExpense
     */
    public function setOrderLine($orderLine = null)
    {
        // validation for constraint: int
        if (!is_null($orderLine) && !(is_int($orderLine) || ctype_digit($orderLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLine, true), gettype($orderLine)), __LINE__);
        }
        $this->orderLine = $orderLine;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\ItemReceiptExpense
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param string $account
     * @return \StructType\ItemReceiptExpense
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\ItemReceiptExpense
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\ItemReceiptExpense
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ItemReceiptExpense
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
