<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemMember StructType
 * @subpackage Structs
 */
class ItemMember extends AbstractStructBase
{
    /**
     * The memberDescr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memberDescr;
    /**
     * The componentYield
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $componentYield;
    /**
     * The bomQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $bomQuantity;
    /**
     * The itemSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemSource;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The memberUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $memberUnit;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The taxSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxSchedule;
    /**
     * The taxcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxcode;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The taxrate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxrate;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effectiveDate;
    /**
     * The obsoleteDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $obsoleteDate;
    /**
     * The effectiveRevision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $effectiveRevision;
    /**
     * The obsoleteRevision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $obsoleteRevision;
    /**
     * The lineNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lineNumber;
    /**
     * The memberKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memberKey;
    /**
     * Constructor method for ItemMember
     * @uses ItemMember::setMemberDescr()
     * @uses ItemMember::setComponentYield()
     * @uses ItemMember::setBomQuantity()
     * @uses ItemMember::setItemSource()
     * @uses ItemMember::setQuantity()
     * @uses ItemMember::setMemberUnit()
     * @uses ItemMember::setVsoeDeferral()
     * @uses ItemMember::setVsoePermitDiscount()
     * @uses ItemMember::setVsoeDelivered()
     * @uses ItemMember::setTaxSchedule()
     * @uses ItemMember::setTaxcode()
     * @uses ItemMember::setItem()
     * @uses ItemMember::setTaxrate()
     * @uses ItemMember::setEffectiveDate()
     * @uses ItemMember::setObsoleteDate()
     * @uses ItemMember::setEffectiveRevision()
     * @uses ItemMember::setObsoleteRevision()
     * @uses ItemMember::setLineNumber()
     * @uses ItemMember::setMemberKey()
     * @param string $memberDescr
     * @param float $componentYield
     * @param float $bomQuantity
     * @param string $itemSource
     * @param float $quantity
     * @param \StructType\RecordRef $memberUnit
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param \StructType\RecordRef $taxSchedule
     * @param string $taxcode
     * @param \StructType\RecordRef $item
     * @param float $taxrate
     * @param string $effectiveDate
     * @param string $obsoleteDate
     * @param \StructType\RecordRef $effectiveRevision
     * @param \StructType\RecordRef $obsoleteRevision
     * @param int $lineNumber
     * @param string $memberKey
     */
    public function __construct($memberDescr = null, $componentYield = null, $bomQuantity = null, $itemSource = null, $quantity = null, \StructType\RecordRef $memberUnit = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, \StructType\RecordRef $taxSchedule = null, $taxcode = null, \StructType\RecordRef $item = null, $taxrate = null, $effectiveDate = null, $obsoleteDate = null, \StructType\RecordRef $effectiveRevision = null, \StructType\RecordRef $obsoleteRevision = null, $lineNumber = null, $memberKey = null)
    {
        $this
            ->setMemberDescr($memberDescr)
            ->setComponentYield($componentYield)
            ->setBomQuantity($bomQuantity)
            ->setItemSource($itemSource)
            ->setQuantity($quantity)
            ->setMemberUnit($memberUnit)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setTaxSchedule($taxSchedule)
            ->setTaxcode($taxcode)
            ->setItem($item)
            ->setTaxrate($taxrate)
            ->setEffectiveDate($effectiveDate)
            ->setObsoleteDate($obsoleteDate)
            ->setEffectiveRevision($effectiveRevision)
            ->setObsoleteRevision($obsoleteRevision)
            ->setLineNumber($lineNumber)
            ->setMemberKey($memberKey);
    }
    /**
     * Get memberDescr value
     * @return string|null
     */
    public function getMemberDescr()
    {
        return $this->memberDescr;
    }
    /**
     * Set memberDescr value
     * @param string $memberDescr
     * @return \StructType\ItemMember
     */
    public function setMemberDescr($memberDescr = null)
    {
        // validation for constraint: string
        if (!is_null($memberDescr) && !is_string($memberDescr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberDescr, true), gettype($memberDescr)), __LINE__);
        }
        $this->memberDescr = $memberDescr;
        return $this;
    }
    /**
     * Get componentYield value
     * @return float|null
     */
    public function getComponentYield()
    {
        return $this->componentYield;
    }
    /**
     * Set componentYield value
     * @param float $componentYield
     * @return \StructType\ItemMember
     */
    public function setComponentYield($componentYield = null)
    {
        // validation for constraint: float
        if (!is_null($componentYield) && !(is_float($componentYield) || is_numeric($componentYield))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($componentYield, true), gettype($componentYield)), __LINE__);
        }
        $this->componentYield = $componentYield;
        return $this;
    }
    /**
     * Get bomQuantity value
     * @return float|null
     */
    public function getBomQuantity()
    {
        return $this->bomQuantity;
    }
    /**
     * Set bomQuantity value
     * @param float $bomQuantity
     * @return \StructType\ItemMember
     */
    public function setBomQuantity($bomQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($bomQuantity) && !(is_float($bomQuantity) || is_numeric($bomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bomQuantity, true), gettype($bomQuantity)), __LINE__);
        }
        $this->bomQuantity = $bomQuantity;
        return $this;
    }
    /**
     * Get itemSource value
     * @return string|null
     */
    public function getItemSource()
    {
        return $this->itemSource;
    }
    /**
     * Set itemSource value
     * @uses \EnumType\ItemSource::valueIsValid()
     * @uses \EnumType\ItemSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemSource
     * @return \StructType\ItemMember
     */
    public function setItemSource($itemSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemSource::valueIsValid($itemSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemSource', is_array($itemSource) ? implode(', ', $itemSource) : var_export($itemSource, true), implode(', ', \EnumType\ItemSource::getValidValues())), __LINE__);
        }
        $this->itemSource = $itemSource;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\ItemMember
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get memberUnit value
     * @return \StructType\RecordRef|null
     */
    public function getMemberUnit()
    {
        return $this->memberUnit;
    }
    /**
     * Set memberUnit value
     * @param \StructType\RecordRef $memberUnit
     * @return \StructType\ItemMember
     */
    public function setMemberUnit(\StructType\RecordRef $memberUnit = null)
    {
        $this->memberUnit = $memberUnit;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\ItemMember
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\ItemMember
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\ItemMember
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get taxSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getTaxSchedule()
    {
        return $this->taxSchedule;
    }
    /**
     * Set taxSchedule value
     * @param \StructType\RecordRef $taxSchedule
     * @return \StructType\ItemMember
     */
    public function setTaxSchedule(\StructType\RecordRef $taxSchedule = null)
    {
        $this->taxSchedule = $taxSchedule;
        return $this;
    }
    /**
     * Get taxcode value
     * @return string|null
     */
    public function getTaxcode()
    {
        return $this->taxcode;
    }
    /**
     * Set taxcode value
     * @param string $taxcode
     * @return \StructType\ItemMember
     */
    public function setTaxcode($taxcode = null)
    {
        // validation for constraint: string
        if (!is_null($taxcode) && !is_string($taxcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxcode, true), gettype($taxcode)), __LINE__);
        }
        $this->taxcode = $taxcode;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\ItemMember
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get taxrate value
     * @return float|null
     */
    public function getTaxrate()
    {
        return $this->taxrate;
    }
    /**
     * Set taxrate value
     * @param float $taxrate
     * @return \StructType\ItemMember
     */
    public function setTaxrate($taxrate = null)
    {
        // validation for constraint: float
        if (!is_null($taxrate) && !(is_float($taxrate) || is_numeric($taxrate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxrate, true), gettype($taxrate)), __LINE__);
        }
        $this->taxrate = $taxrate;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\ItemMember
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get obsoleteDate value
     * @return string|null
     */
    public function getObsoleteDate()
    {
        return $this->obsoleteDate;
    }
    /**
     * Set obsoleteDate value
     * @param string $obsoleteDate
     * @return \StructType\ItemMember
     */
    public function setObsoleteDate($obsoleteDate = null)
    {
        // validation for constraint: string
        if (!is_null($obsoleteDate) && !is_string($obsoleteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obsoleteDate, true), gettype($obsoleteDate)), __LINE__);
        }
        $this->obsoleteDate = $obsoleteDate;
        return $this;
    }
    /**
     * Get effectiveRevision value
     * @return \StructType\RecordRef|null
     */
    public function getEffectiveRevision()
    {
        return $this->effectiveRevision;
    }
    /**
     * Set effectiveRevision value
     * @param \StructType\RecordRef $effectiveRevision
     * @return \StructType\ItemMember
     */
    public function setEffectiveRevision(\StructType\RecordRef $effectiveRevision = null)
    {
        $this->effectiveRevision = $effectiveRevision;
        return $this;
    }
    /**
     * Get obsoleteRevision value
     * @return \StructType\RecordRef|null
     */
    public function getObsoleteRevision()
    {
        return $this->obsoleteRevision;
    }
    /**
     * Set obsoleteRevision value
     * @param \StructType\RecordRef $obsoleteRevision
     * @return \StructType\ItemMember
     */
    public function setObsoleteRevision(\StructType\RecordRef $obsoleteRevision = null)
    {
        $this->obsoleteRevision = $obsoleteRevision;
        return $this;
    }
    /**
     * Get lineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param int $lineNumber
     * @return \StructType\ItemMember
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get memberKey value
     * @return string|null
     */
    public function getMemberKey()
    {
        return $this->memberKey;
    }
    /**
     * Set memberKey value
     * @param string $memberKey
     * @return \StructType\ItemMember
     */
    public function setMemberKey($memberKey = null)
    {
        // validation for constraint: string
        if (!is_null($memberKey) && !is_string($memberKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberKey, true), gettype($memberKey)), __LINE__);
        }
        $this->memberKey = $memberKey;
        return $this;
    }
}
