<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemGroupHierarchyVersionsList StructType
 * @subpackage Structs
 */
class ItemGroupHierarchyVersionsList extends AbstractStructBase
{
    /**
     * The itemGroupHierarchyVersions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemGroupHierarchyVersions[]
     */
    public $itemGroupHierarchyVersions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemGroupHierarchyVersionsList
     * @uses ItemGroupHierarchyVersionsList::setItemGroupHierarchyVersions()
     * @uses ItemGroupHierarchyVersionsList::setReplaceAll()
     * @param \StructType\ItemGroupHierarchyVersions[] $itemGroupHierarchyVersions
     * @param bool $replaceAll
     */
    public function __construct(array $itemGroupHierarchyVersions = array(), $replaceAll = true)
    {
        $this
            ->setItemGroupHierarchyVersions($itemGroupHierarchyVersions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get itemGroupHierarchyVersions value
     * @return \StructType\ItemGroupHierarchyVersions[]|null
     */
    public function getItemGroupHierarchyVersions()
    {
        return $this->itemGroupHierarchyVersions;
    }
    /**
     * This method is responsible for validating the values passed to the setItemGroupHierarchyVersions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemGroupHierarchyVersions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemGroupHierarchyVersionsForArrayConstraintsFromSetItemGroupHierarchyVersions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemGroupHierarchyVersionsListItemGroupHierarchyVersionsItem) {
            // validation for constraint: itemType
            if (!$itemGroupHierarchyVersionsListItemGroupHierarchyVersionsItem instanceof \StructType\ItemGroupHierarchyVersions) {
                $invalidValues[] = is_object($itemGroupHierarchyVersionsListItemGroupHierarchyVersionsItem) ? get_class($itemGroupHierarchyVersionsListItemGroupHierarchyVersionsItem) : sprintf('%s(%s)', gettype($itemGroupHierarchyVersionsListItemGroupHierarchyVersionsItem), var_export($itemGroupHierarchyVersionsListItemGroupHierarchyVersionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemGroupHierarchyVersions property can only contain items of type \StructType\ItemGroupHierarchyVersions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemGroupHierarchyVersions value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemGroupHierarchyVersions[] $itemGroupHierarchyVersions
     * @return \StructType\ItemGroupHierarchyVersionsList
     */
    public function setItemGroupHierarchyVersions(array $itemGroupHierarchyVersions = array())
    {
        // validation for constraint: array
        if ('' !== ($itemGroupHierarchyVersionsArrayErrorMessage = self::validateItemGroupHierarchyVersionsForArrayConstraintsFromSetItemGroupHierarchyVersions($itemGroupHierarchyVersions))) {
            throw new \InvalidArgumentException($itemGroupHierarchyVersionsArrayErrorMessage, __LINE__);
        }
        $this->itemGroupHierarchyVersions = $itemGroupHierarchyVersions;
        return $this;
    }
    /**
     * Add item to itemGroupHierarchyVersions value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemGroupHierarchyVersions $item
     * @return \StructType\ItemGroupHierarchyVersionsList
     */
    public function addToItemGroupHierarchyVersions(\StructType\ItemGroupHierarchyVersions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemGroupHierarchyVersions) {
            throw new \InvalidArgumentException(sprintf('The itemGroupHierarchyVersions property can only contain items of type \StructType\ItemGroupHierarchyVersions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemGroupHierarchyVersions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemGroupHierarchyVersionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
