<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemGroup StructType
 * @subpackage Structs
 */
class ItemGroup extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The includeStartEndLines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeStartEndLines;
    /**
     * The isVsoeBundle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isVsoeBundle;
    /**
     * The defaultItemShipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $defaultItemShipMethod;
    /**
     * The availableToPartners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableToPartners;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The upcCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upcCode;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The vendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorName;
    /**
     * The issueProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueProduct;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The itemCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemCarrier;
    /**
     * The itemShipMethodList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $itemShipMethodList;
    /**
     * The printItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $printItems;
    /**
     * The memberList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemMemberList
     */
    public $memberList;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TranslationList
     */
    public $translationsList;
    /**
     * The hierarchyVersionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemGroupHierarchyVersionsList
     */
    public $hierarchyVersionsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ItemGroup
     * @uses ItemGroup::setCreatedDate()
     * @uses ItemGroup::setLastModifiedDate()
     * @uses ItemGroup::setCustomForm()
     * @uses ItemGroup::setIncludeStartEndLines()
     * @uses ItemGroup::setIsVsoeBundle()
     * @uses ItemGroup::setDefaultItemShipMethod()
     * @uses ItemGroup::setAvailableToPartners()
     * @uses ItemGroup::setIsInactive()
     * @uses ItemGroup::setItemId()
     * @uses ItemGroup::setUpcCode()
     * @uses ItemGroup::setDisplayName()
     * @uses ItemGroup::setVendorName()
     * @uses ItemGroup::setIssueProduct()
     * @uses ItemGroup::setParent()
     * @uses ItemGroup::setDescription()
     * @uses ItemGroup::setSubsidiaryList()
     * @uses ItemGroup::setIncludeChildren()
     * @uses ItemGroup::setDepartment()
     * @uses ItemGroup::setClass()
     * @uses ItemGroup::setLocation()
     * @uses ItemGroup::setItemCarrier()
     * @uses ItemGroup::setItemShipMethodList()
     * @uses ItemGroup::setPrintItems()
     * @uses ItemGroup::setMemberList()
     * @uses ItemGroup::setTranslationsList()
     * @uses ItemGroup::setHierarchyVersionsList()
     * @uses ItemGroup::setCustomFieldList()
     * @uses ItemGroup::setInternalId()
     * @uses ItemGroup::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param bool $includeStartEndLines
     * @param bool $isVsoeBundle
     * @param \StructType\RecordRef $defaultItemShipMethod
     * @param bool $availableToPartners
     * @param bool $isInactive
     * @param string $itemId
     * @param string $upcCode
     * @param string $displayName
     * @param string $vendorName
     * @param \StructType\RecordRef $issueProduct
     * @param \StructType\RecordRef $parent
     * @param string $description
     * @param \StructType\RecordRefList $subsidiaryList
     * @param bool $includeChildren
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param string $itemCarrier
     * @param \StructType\RecordRefList $itemShipMethodList
     * @param bool $printItems
     * @param \StructType\ItemMemberList $memberList
     * @param \StructType\TranslationList $translationsList
     * @param \StructType\ItemGroupHierarchyVersionsList $hierarchyVersionsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, $includeStartEndLines = null, $isVsoeBundle = null, \StructType\RecordRef $defaultItemShipMethod = null, $availableToPartners = null, $isInactive = null, $itemId = null, $upcCode = null, $displayName = null, $vendorName = null, \StructType\RecordRef $issueProduct = null, \StructType\RecordRef $parent = null, $description = null, \StructType\RecordRefList $subsidiaryList = null, $includeChildren = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, $itemCarrier = null, \StructType\RecordRefList $itemShipMethodList = null, $printItems = null, \StructType\ItemMemberList $memberList = null, \StructType\TranslationList $translationsList = null, \StructType\ItemGroupHierarchyVersionsList $hierarchyVersionsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setIncludeStartEndLines($includeStartEndLines)
            ->setIsVsoeBundle($isVsoeBundle)
            ->setDefaultItemShipMethod($defaultItemShipMethod)
            ->setAvailableToPartners($availableToPartners)
            ->setIsInactive($isInactive)
            ->setItemId($itemId)
            ->setUpcCode($upcCode)
            ->setDisplayName($displayName)
            ->setVendorName($vendorName)
            ->setIssueProduct($issueProduct)
            ->setParent($parent)
            ->setDescription($description)
            ->setSubsidiaryList($subsidiaryList)
            ->setIncludeChildren($includeChildren)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setItemCarrier($itemCarrier)
            ->setItemShipMethodList($itemShipMethodList)
            ->setPrintItems($printItems)
            ->setMemberList($memberList)
            ->setTranslationsList($translationsList)
            ->setHierarchyVersionsList($hierarchyVersionsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\ItemGroup
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\ItemGroup
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ItemGroup
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get includeStartEndLines value
     * @return bool|null
     */
    public function getIncludeStartEndLines()
    {
        return $this->includeStartEndLines;
    }
    /**
     * Set includeStartEndLines value
     * @param bool $includeStartEndLines
     * @return \StructType\ItemGroup
     */
    public function setIncludeStartEndLines($includeStartEndLines = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeStartEndLines) && !is_bool($includeStartEndLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeStartEndLines, true), gettype($includeStartEndLines)), __LINE__);
        }
        $this->includeStartEndLines = $includeStartEndLines;
        return $this;
    }
    /**
     * Get isVsoeBundle value
     * @return bool|null
     */
    public function getIsVsoeBundle()
    {
        return $this->isVsoeBundle;
    }
    /**
     * Set isVsoeBundle value
     * @param bool $isVsoeBundle
     * @return \StructType\ItemGroup
     */
    public function setIsVsoeBundle($isVsoeBundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVsoeBundle) && !is_bool($isVsoeBundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVsoeBundle, true), gettype($isVsoeBundle)), __LINE__);
        }
        $this->isVsoeBundle = $isVsoeBundle;
        return $this;
    }
    /**
     * Get defaultItemShipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getDefaultItemShipMethod()
    {
        return $this->defaultItemShipMethod;
    }
    /**
     * Set defaultItemShipMethod value
     * @param \StructType\RecordRef $defaultItemShipMethod
     * @return \StructType\ItemGroup
     */
    public function setDefaultItemShipMethod(\StructType\RecordRef $defaultItemShipMethod = null)
    {
        $this->defaultItemShipMethod = $defaultItemShipMethod;
        return $this;
    }
    /**
     * Get availableToPartners value
     * @return bool|null
     */
    public function getAvailableToPartners()
    {
        return $this->availableToPartners;
    }
    /**
     * Set availableToPartners value
     * @param bool $availableToPartners
     * @return \StructType\ItemGroup
     */
    public function setAvailableToPartners($availableToPartners = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToPartners) && !is_bool($availableToPartners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToPartners, true), gettype($availableToPartners)), __LINE__);
        }
        $this->availableToPartners = $availableToPartners;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\ItemGroup
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\ItemGroup
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get upcCode value
     * @return string|null
     */
    public function getUpcCode()
    {
        return $this->upcCode;
    }
    /**
     * Set upcCode value
     * @param string $upcCode
     * @return \StructType\ItemGroup
     */
    public function setUpcCode($upcCode = null)
    {
        // validation for constraint: string
        if (!is_null($upcCode) && !is_string($upcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upcCode, true), gettype($upcCode)), __LINE__);
        }
        $this->upcCode = $upcCode;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\ItemGroup
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get vendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->vendorName;
    }
    /**
     * Set vendorName value
     * @param string $vendorName
     * @return \StructType\ItemGroup
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->vendorName = $vendorName;
        return $this;
    }
    /**
     * Get issueProduct value
     * @return \StructType\RecordRef|null
     */
    public function getIssueProduct()
    {
        return $this->issueProduct;
    }
    /**
     * Set issueProduct value
     * @param \StructType\RecordRef $issueProduct
     * @return \StructType\ItemGroup
     */
    public function setIssueProduct(\StructType\RecordRef $issueProduct = null)
    {
        $this->issueProduct = $issueProduct;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\ItemGroup
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ItemGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\ItemGroup
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\ItemGroup
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\ItemGroup
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\ItemGroup
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\ItemGroup
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get itemCarrier value
     * @return string|null
     */
    public function getItemCarrier()
    {
        return $this->itemCarrier;
    }
    /**
     * Set itemCarrier value
     * @uses \EnumType\ShippingCarrier::valueIsValid()
     * @uses \EnumType\ShippingCarrier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemCarrier
     * @return \StructType\ItemGroup
     */
    public function setItemCarrier($itemCarrier = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ShippingCarrier::valueIsValid($itemCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ShippingCarrier', is_array($itemCarrier) ? implode(', ', $itemCarrier) : var_export($itemCarrier, true), implode(', ', \EnumType\ShippingCarrier::getValidValues())), __LINE__);
        }
        $this->itemCarrier = $itemCarrier;
        return $this;
    }
    /**
     * Get itemShipMethodList value
     * @return \StructType\RecordRefList|null
     */
    public function getItemShipMethodList()
    {
        return $this->itemShipMethodList;
    }
    /**
     * Set itemShipMethodList value
     * @param \StructType\RecordRefList $itemShipMethodList
     * @return \StructType\ItemGroup
     */
    public function setItemShipMethodList(\StructType\RecordRefList $itemShipMethodList = null)
    {
        $this->itemShipMethodList = $itemShipMethodList;
        return $this;
    }
    /**
     * Get printItems value
     * @return bool|null
     */
    public function getPrintItems()
    {
        return $this->printItems;
    }
    /**
     * Set printItems value
     * @param bool $printItems
     * @return \StructType\ItemGroup
     */
    public function setPrintItems($printItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($printItems) && !is_bool($printItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printItems, true), gettype($printItems)), __LINE__);
        }
        $this->printItems = $printItems;
        return $this;
    }
    /**
     * Get memberList value
     * @return \StructType\ItemMemberList|null
     */
    public function getMemberList()
    {
        return $this->memberList;
    }
    /**
     * Set memberList value
     * @param \StructType\ItemMemberList $memberList
     * @return \StructType\ItemGroup
     */
    public function setMemberList(\StructType\ItemMemberList $memberList = null)
    {
        $this->memberList = $memberList;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\TranslationList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\TranslationList $translationsList
     * @return \StructType\ItemGroup
     */
    public function setTranslationsList(\StructType\TranslationList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get hierarchyVersionsList value
     * @return \StructType\ItemGroupHierarchyVersionsList|null
     */
    public function getHierarchyVersionsList()
    {
        return $this->hierarchyVersionsList;
    }
    /**
     * Set hierarchyVersionsList value
     * @param \StructType\ItemGroupHierarchyVersionsList $hierarchyVersionsList
     * @return \StructType\ItemGroup
     */
    public function setHierarchyVersionsList(\StructType\ItemGroupHierarchyVersionsList $hierarchyVersionsList = null)
    {
        $this->hierarchyVersionsList = $hierarchyVersionsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ItemGroup
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ItemGroup
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ItemGroup
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
