<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemFulfillmentPackageList StructType
 * @subpackage Structs
 */
class ItemFulfillmentPackageList extends AbstractStructBase
{
    /**
     * The package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemFulfillmentPackage[]
     */
    public $package;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemFulfillmentPackageList
     * @uses ItemFulfillmentPackageList::setPackage()
     * @uses ItemFulfillmentPackageList::setReplaceAll()
     * @param \StructType\ItemFulfillmentPackage[] $package
     * @param bool $replaceAll
     */
    public function __construct(array $package = array(), $replaceAll = true)
    {
        $this
            ->setPackage($package)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get package value
     * @return \StructType\ItemFulfillmentPackage[]|null
     */
    public function getPackage()
    {
        return $this->package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemFulfillmentPackageListPackageItem) {
            // validation for constraint: itemType
            if (!$itemFulfillmentPackageListPackageItem instanceof \StructType\ItemFulfillmentPackage) {
                $invalidValues[] = is_object($itemFulfillmentPackageListPackageItem) ? get_class($itemFulfillmentPackageListPackageItem) : sprintf('%s(%s)', gettype($itemFulfillmentPackageListPackageItem), var_export($itemFulfillmentPackageListPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The package property can only contain items of type \StructType\ItemFulfillmentPackage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set package value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemFulfillmentPackage[] $package
     * @return \StructType\ItemFulfillmentPackageList
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->package = $package;
        return $this;
    }
    /**
     * Add item to package value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemFulfillmentPackage $item
     * @return \StructType\ItemFulfillmentPackageList
     */
    public function addToPackage(\StructType\ItemFulfillmentPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemFulfillmentPackage) {
            throw new \InvalidArgumentException(sprintf('The package property can only contain items of type \StructType\ItemFulfillmentPackage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->package[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemFulfillmentPackageList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
