<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemFulfillmentPackageFedExList StructType
 * @subpackage Structs
 */
class ItemFulfillmentPackageFedExList extends AbstractStructBase
{
    /**
     * The packageFedEx
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemFulfillmentPackageFedEx[]
     */
    public $packageFedEx;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemFulfillmentPackageFedExList
     * @uses ItemFulfillmentPackageFedExList::setPackageFedEx()
     * @uses ItemFulfillmentPackageFedExList::setReplaceAll()
     * @param \StructType\ItemFulfillmentPackageFedEx[] $packageFedEx
     * @param bool $replaceAll
     */
    public function __construct(array $packageFedEx = array(), $replaceAll = true)
    {
        $this
            ->setPackageFedEx($packageFedEx)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get packageFedEx value
     * @return \StructType\ItemFulfillmentPackageFedEx[]|null
     */
    public function getPackageFedEx()
    {
        return $this->packageFedEx;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageFedEx method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageFedEx method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageFedExForArrayConstraintsFromSetPackageFedEx(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemFulfillmentPackageFedExListPackageFedExItem) {
            // validation for constraint: itemType
            if (!$itemFulfillmentPackageFedExListPackageFedExItem instanceof \StructType\ItemFulfillmentPackageFedEx) {
                $invalidValues[] = is_object($itemFulfillmentPackageFedExListPackageFedExItem) ? get_class($itemFulfillmentPackageFedExListPackageFedExItem) : sprintf('%s(%s)', gettype($itemFulfillmentPackageFedExListPackageFedExItem), var_export($itemFulfillmentPackageFedExListPackageFedExItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packageFedEx property can only contain items of type \StructType\ItemFulfillmentPackageFedEx, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packageFedEx value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemFulfillmentPackageFedEx[] $packageFedEx
     * @return \StructType\ItemFulfillmentPackageFedExList
     */
    public function setPackageFedEx(array $packageFedEx = array())
    {
        // validation for constraint: array
        if ('' !== ($packageFedExArrayErrorMessage = self::validatePackageFedExForArrayConstraintsFromSetPackageFedEx($packageFedEx))) {
            throw new \InvalidArgumentException($packageFedExArrayErrorMessage, __LINE__);
        }
        $this->packageFedEx = $packageFedEx;
        return $this;
    }
    /**
     * Add item to packageFedEx value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemFulfillmentPackageFedEx $item
     * @return \StructType\ItemFulfillmentPackageFedExList
     */
    public function addToPackageFedEx(\StructType\ItemFulfillmentPackageFedEx $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemFulfillmentPackageFedEx) {
            throw new \InvalidArgumentException(sprintf('The packageFedEx property can only contain items of type \StructType\ItemFulfillmentPackageFedEx, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packageFedEx[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemFulfillmentPackageFedExList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
