<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemFulfillmentPackage StructType
 * @subpackage Structs
 */
class ItemFulfillmentPackage extends AbstractStructBase
{
    /**
     * The packageWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $packageWeight;
    /**
     * The packageDescr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packageDescr;
    /**
     * The packageTrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packageTrackingNumber;
    /**
     * Constructor method for ItemFulfillmentPackage
     * @uses ItemFulfillmentPackage::setPackageWeight()
     * @uses ItemFulfillmentPackage::setPackageDescr()
     * @uses ItemFulfillmentPackage::setPackageTrackingNumber()
     * @param float $packageWeight
     * @param string $packageDescr
     * @param string $packageTrackingNumber
     */
    public function __construct($packageWeight = null, $packageDescr = null, $packageTrackingNumber = null)
    {
        $this
            ->setPackageWeight($packageWeight)
            ->setPackageDescr($packageDescr)
            ->setPackageTrackingNumber($packageTrackingNumber);
    }
    /**
     * Get packageWeight value
     * @return float|null
     */
    public function getPackageWeight()
    {
        return $this->packageWeight;
    }
    /**
     * Set packageWeight value
     * @param float $packageWeight
     * @return \StructType\ItemFulfillmentPackage
     */
    public function setPackageWeight($packageWeight = null)
    {
        // validation for constraint: float
        if (!is_null($packageWeight) && !(is_float($packageWeight) || is_numeric($packageWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($packageWeight, true), gettype($packageWeight)), __LINE__);
        }
        $this->packageWeight = $packageWeight;
        return $this;
    }
    /**
     * Get packageDescr value
     * @return string|null
     */
    public function getPackageDescr()
    {
        return $this->packageDescr;
    }
    /**
     * Set packageDescr value
     * @param string $packageDescr
     * @return \StructType\ItemFulfillmentPackage
     */
    public function setPackageDescr($packageDescr = null)
    {
        // validation for constraint: string
        if (!is_null($packageDescr) && !is_string($packageDescr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageDescr, true), gettype($packageDescr)), __LINE__);
        }
        $this->packageDescr = $packageDescr;
        return $this;
    }
    /**
     * Get packageTrackingNumber value
     * @return string|null
     */
    public function getPackageTrackingNumber()
    {
        return $this->packageTrackingNumber;
    }
    /**
     * Set packageTrackingNumber value
     * @param string $packageTrackingNumber
     * @return \StructType\ItemFulfillmentPackage
     */
    public function setPackageTrackingNumber($packageTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($packageTrackingNumber) && !is_string($packageTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageTrackingNumber, true), gettype($packageTrackingNumber)), __LINE__);
        }
        $this->packageTrackingNumber = $packageTrackingNumber;
        return $this;
    }
}
